/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Map;
import java.util.Optional;

public class SaveElementStep
extends AbstractExecutionStep {
    private final OIdentifier cluster;

    public SaveElementStep(OCommandContext ctx, OIdentifier cluster, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.cluster = cluster;
    }

    public SaveElementStep(OCommandContext ctx, boolean profilingEnabled) {
        this(ctx, null, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                OResult result = upstream.next();
                if (result.isElement()) {
                    if (SaveElementStep.this.cluster == null) {
                        ctx.getDatabase().save(result.getElement().orElse(null));
                    } else {
                        ctx.getDatabase().save(result.getElement().orElse(null), SaveElementStep.this.cluster.getStringValue());
                    }
                }
                return result;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ SAVE RECORD");
        if (this.cluster != null) {
            result.append("\n");
            result.append(spaces);
            result.append("  on cluster " + this.cluster);
        }
        return result.toString();
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new SaveElementStep(ctx, this.cluster == null ? null : this.cluster.copy(), this.profilingEnabled);
    }
}

