/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.AggregateProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.CountFromClassStep;
import com.orientechnologies.orient.core.sql.executor.CountFromIndexStep;
import com.orientechnologies.orient.core.sql.executor.DistinctExecutionStep;
import com.orientechnologies.orient.core.sql.executor.DistributedExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EmptyDataGeneratorStep;
import com.orientechnologies.orient.core.sql.executor.EmptyStep;
import com.orientechnologies.orient.core.sql.executor.ExpandStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClassExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClusterExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClustersExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromDatabaseMetadataStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromIndexStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromIndexValuesStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromIndexedFunctionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromRidsStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromStorageMetadataStep;
import com.orientechnologies.orient.core.sql.executor.FilterByClassStep;
import com.orientechnologies.orient.core.sql.executor.FilterByClustersStep;
import com.orientechnologies.orient.core.sql.executor.FilterStep;
import com.orientechnologies.orient.core.sql.executor.GetValueFromIndexEntryStep;
import com.orientechnologies.orient.core.sql.executor.GlobalLetExpressionStep;
import com.orientechnologies.orient.core.sql.executor.GlobalLetQueryStep;
import com.orientechnologies.orient.core.sql.executor.GuaranteeEmptyCountStep;
import com.orientechnologies.orient.core.sql.executor.IndexCondPair;
import com.orientechnologies.orient.core.sql.executor.IndexSearchDescriptor;
import com.orientechnologies.orient.core.sql.executor.LetExpressionStep;
import com.orientechnologies.orient.core.sql.executor.LetQueryStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.LockRecordStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OrderByStep;
import com.orientechnologies.orient.core.sql.executor.ParallelExecStep;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.QueryPlanningInfo;
import com.orientechnologies.orient.core.sql.executor.SkipExecutionStep;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.executor.UnwindStep;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OContainsAnyCondition;
import com.orientechnologies.orient.core.sql.parser.OContainsKeyOperator;
import com.orientechnologies.orient.core.sql.parser.OContainsValueCondition;
import com.orientechnologies.orient.core.sql.parser.OContainsValueOperator;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExecutionPlanCache;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInCondition;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLetClause;
import com.orientechnologies.orient.core.sql.parser.OLetItem;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import com.orientechnologies.orient.core.sql.parser.OMetadataIdentifier;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OOrderByItem;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class OSelectExecutionPlanner {
    QueryPlanningInfo info;
    OSelectStatement statement;

    public OSelectExecutionPlanner(OSelectStatement oSelectStatement) {
        this.statement = oSelectStatement;
    }

    private void init() {
        this.info = new QueryPlanningInfo();
        this.info.projection = this.statement.getProjection() == null ? null : this.statement.getProjection().copy();
        this.info.projection = OSelectExecutionPlanner.translateDistinct(this.info.projection);
        boolean bl = this.info.distinct = this.info.projection == null ? false : this.info.projection.isDistinct();
        if (this.info.projection != null) {
            this.info.projection.setDistinct(false);
        }
        this.info.target = this.statement.getTarget();
        this.info.whereClause = this.statement.getWhereClause() == null ? null : this.statement.getWhereClause().copy();
        this.info.whereClause = this.translateLucene(this.info.whereClause);
        this.info.perRecordLetClause = this.statement.getLetClause() == null ? null : this.statement.getLetClause().copy();
        this.info.groupBy = this.statement.getGroupBy() == null ? null : this.statement.getGroupBy().copy();
        this.info.orderBy = this.statement.getOrderBy() == null ? null : this.statement.getOrderBy().copy();
        this.info.unwind = this.statement.getUnwind() == null ? null : this.statement.getUnwind().copy();
        this.info.skip = this.statement.getSkip();
        this.info.limit = this.statement.getLimit();
        this.info.lockRecord = this.statement.getLockRecord();
    }

    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling, boolean useCache) {
        OExecutionPlan plan;
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        if (useCache && !enableProfiling && this.statement.executinPlanCanBeCached() && (plan = OExecutionPlanCache.get(this.statement.getOriginalStatement(), ctx, db)) != null) {
            return (OInternalExecutionPlan)plan;
        }
        long planningStart = System.currentTimeMillis();
        this.init();
        OSelectExecutionPlan result = new OSelectExecutionPlan(ctx);
        if (this.info.expand && this.info.distinct) {
            throw new OCommandExecutionException("Cannot execute a statement with DISTINCT expand(), please use a subquery");
        }
        OSelectExecutionPlanner.optimizeQuery(this.info, ctx);
        if (this.handleHardwiredOptimizations(result, ctx, enableProfiling)) {
            return result;
        }
        this.handleGlobalLet(result, this.info, ctx, enableProfiling);
        this.calculateShardingStrategy(this.info, ctx);
        this.handleFetchFromTarger(result, this.info, ctx, enableProfiling);
        if (this.info.globalLetPresent) {
            this.buildDistributedExecutionPlan(result, this.info, ctx, enableProfiling);
        }
        this.handleLet(result, this.info, ctx, enableProfiling);
        this.handleWhere(result, this.info, ctx, enableProfiling);
        this.buildDistributedExecutionPlan(result, this.info, ctx, enableProfiling);
        this.handleLockRecord(result, this.info, ctx, enableProfiling);
        OSelectExecutionPlanner.handleProjectionsBlock(result, this.info, ctx, enableProfiling);
        if (useCache && !enableProfiling && this.statement.executinPlanCanBeCached() && result.canBeCached() && OExecutionPlanCache.getLastInvalidation(db) < planningStart) {
            OExecutionPlanCache.put(this.statement.getOriginalStatement(), result, (ODatabaseDocumentInternal)ctx.getDatabase());
        }
        return result;
    }

    private void handleLockRecord(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean enableProfiling) {
        if (info.lockRecord != null) {
            result.chain(new LockRecordStep(info.lockRecord, ctx, enableProfiling));
        }
    }

    public static void handleProjectionsBlock(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean enableProfiling) {
        OSelectExecutionPlanner.handleProjectionsBeforeOrderBy(result, info, ctx, enableProfiling);
        if (info.expand || info.unwind != null || info.groupBy != null) {
            OSelectExecutionPlanner.handleProjections(result, info, ctx, enableProfiling);
            OSelectExecutionPlanner.handleExpand(result, info, ctx, enableProfiling);
            OSelectExecutionPlanner.handleUnwind(result, info, ctx, enableProfiling);
            OSelectExecutionPlanner.handleOrderBy(result, info, ctx, enableProfiling);
            if (info.skip != null) {
                result.chain(new SkipExecutionStep(info.skip, ctx, enableProfiling));
            }
            if (info.limit != null) {
                result.chain(new LimitExecutionStep(info.limit, ctx, enableProfiling));
            }
        } else {
            OSelectExecutionPlanner.handleOrderBy(result, info, ctx, enableProfiling);
            if (info.distinct || info.groupBy != null) {
                OSelectExecutionPlanner.handleProjections(result, info, ctx, enableProfiling);
                OSelectExecutionPlanner.handleDistinct(result, info, ctx, enableProfiling);
                if (info.skip != null) {
                    result.chain(new SkipExecutionStep(info.skip, ctx, enableProfiling));
                }
                if (info.limit != null) {
                    result.chain(new LimitExecutionStep(info.limit, ctx, enableProfiling));
                }
            } else {
                if (info.skip != null) {
                    result.chain(new SkipExecutionStep(info.skip, ctx, enableProfiling));
                }
                if (info.limit != null) {
                    result.chain(new LimitExecutionStep(info.limit, ctx, enableProfiling));
                }
                OSelectExecutionPlanner.handleProjections(result, info, ctx, enableProfiling);
            }
        }
    }

    private void buildDistributedExecutionPlan(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean enableProfiling) {
        if (info.distributedFetchExecutionPlans == null) {
            return;
        }
        String currentNode = ((ODatabaseDocumentInternal)ctx.getDatabase()).getLocalNodeName();
        if (info.distributedFetchExecutionPlans.size() == 1) {
            if (info.distributedFetchExecutionPlans.get(currentNode) != null) {
                OSelectExecutionPlan localSteps = info.distributedFetchExecutionPlans.get(currentNode);
                for (OExecutionStep step : localSteps.getSteps()) {
                    result.chain((OExecutionStepInternal)step);
                }
            } else {
                String node = info.distributedFetchExecutionPlans.keySet().iterator().next();
                OSelectExecutionPlan subPlan = info.distributedFetchExecutionPlans.get(node);
                DistributedExecutionStep step = new DistributedExecutionStep(subPlan, node, ctx, enableProfiling);
                result.chain(step);
            }
            info.distributedFetchExecutionPlans = null;
        } else {
            ArrayList<OInternalExecutionPlan> subPlans = new ArrayList<OInternalExecutionPlan>();
            for (Map.Entry<String, OSelectExecutionPlan> entry : info.distributedFetchExecutionPlans.entrySet()) {
                if (entry.getKey().equals(currentNode)) {
                    subPlans.add(entry.getValue());
                    continue;
                }
                DistributedExecutionStep step = new DistributedExecutionStep(entry.getValue(), entry.getKey(), ctx, enableProfiling);
                OSelectExecutionPlan subPlan = new OSelectExecutionPlan(ctx);
                subPlan.chain(step);
                subPlans.add(subPlan);
            }
            result.chain(new ParallelExecStep(subPlans, ctx, enableProfiling));
        }
        info.distributedPlanCreated = true;
    }

    private void calculateShardingStrategy(QueryPlanningInfo info, OCommandContext ctx) {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        info.distributedFetchExecutionPlans = new LinkedHashMap<String, OSelectExecutionPlan>();
        Map<String, Set<String>> clusterMap = db.getActiveClusterMap();
        Set<String> queryClusters = this.calculateTargetClusters(info, ctx);
        if (queryClusters == null || queryClusters.size() == 0) {
            String localNode = db.getLocalNodeName();
            info.serverToClusters = new LinkedHashMap<String, Set<String>>();
            info.serverToClusters.put(localNode, clusterMap.get(localNode));
            info.distributedFetchExecutionPlans.put(localNode, new OSelectExecutionPlan(ctx));
            return;
        }
        Map<String, Set<String>> minimalSetOfNodes = this.getMinimalSetOfNodesForShardedQuery(db.getLocalNodeName(), clusterMap, queryClusters);
        if (minimalSetOfNodes == null) {
            throw new OCommandExecutionException("Cannot execute sharded query");
        }
        info.serverToClusters = minimalSetOfNodes;
        for (String node : info.serverToClusters.keySet()) {
            info.distributedFetchExecutionPlans.put(node, new OSelectExecutionPlan(ctx));
        }
    }

    private Map<String, Set<String>> getMinimalSetOfNodesForShardedQuery(String localNode, Map<String, Set<String>> clusterMap, Set<String> queryClusters) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        Set<Object> uncovered = new HashSet<String>();
        uncovered.addAll(queryClusters);
        uncovered = uncovered.stream().map(x -> x.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        HashSet<String> nextNodeClusters = new HashSet<String>();
        Set<String> clustersForNode = clusterMap.get(localNode);
        if (clustersForNode != null) {
            nextNodeClusters.addAll(clustersForNode);
        }
        nextNodeClusters.retainAll(uncovered);
        if (nextNodeClusters.size() > 0) {
            result.put(localNode, nextNodeClusters);
            uncovered.removeAll(nextNodeClusters);
        }
        while (uncovered.size() > 0) {
            String nextNode = this.findItemThatCoversMore(uncovered, clusterMap);
            nextNodeClusters = new HashSet();
            nextNodeClusters.addAll((Collection)clusterMap.get(nextNode));
            nextNodeClusters.retainAll(uncovered);
            if (nextNodeClusters.size() == 0) {
                throw new OCommandExecutionException("Cannot execute a sharded query: clusters [" + uncovered.stream().collect(Collectors.joining(", ")) + "] are not present on any node\n [" + clusterMap.entrySet().stream().map(x -> "" + (String)x.getKey() + ":(" + ((Set)x.getValue()).stream().collect(Collectors.joining(",")) + ")").collect(Collectors.joining(", ")) + "]");
            }
            result.put(nextNode, nextNodeClusters);
            uncovered.removeAll(nextNodeClusters);
        }
        return result;
    }

    private String findItemThatCoversMore(Set<String> uncovered, Map<String, Set<String>> clusterMap) {
        String lastFound = null;
        int lastSize = -1;
        for (Map.Entry<String, Set<String>> nodeConfig : clusterMap.entrySet()) {
            HashSet current = new HashSet();
            current.addAll(nodeConfig.getValue());
            current.retainAll(uncovered);
            int thisSize = current.size();
            if (lastFound != null && thisSize <= lastSize) continue;
            lastFound = nodeConfig.getKey();
            lastSize = thisSize;
        }
        return lastFound;
    }

    private Set<String> getServersThatHasAllClusters(Map<String, Set<String>> clusterMap, Set<String> queryClusters) {
        Set<String> remainingServers = clusterMap.keySet();
        for (String cluster : queryClusters) {
            for (Map.Entry<String, Set<String>> serverConfig : clusterMap.entrySet()) {
                if (serverConfig.getValue().contains(cluster)) continue;
                remainingServers.remove(serverConfig.getKey());
            }
        }
        return remainingServers;
    }

    private Set<String> calculateTargetClusters(QueryPlanningInfo info, OCommandContext ctx) {
        if (info.target == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        ODatabase db = ctx.getDatabase();
        OFromItem item = info.target.getItem();
        if (item.getRids() != null && item.getRids().size() > 0) {
            if (item.getRids().size() == 1) {
                OInteger cluster = item.getRids().get(0).getCluster();
                result.add(db.getClusterNameById(cluster.getValue().intValue()));
            } else {
                for (ORid rid : item.getRids()) {
                    OInteger cluster = rid.getCluster();
                    result.add(db.getClusterNameById(cluster.getValue().intValue()));
                }
            }
            return result;
        }
        if (item.getInputParams() != null && item.getInputParams().size() > 0) {
            if (((ODatabaseInternal)ctx.getDatabase()).isSharded()) {
                throw new UnsupportedOperationException("Sharded query with input parameter as a target is not supported yet");
            }
            return null;
        }
        if (item.getCluster() != null) {
            String name = item.getCluster().getClusterName();
            if (name == null) {
                name = db.getClusterNameById(item.getCluster().getClusterNumber());
            }
            if (name != null) {
                result.add(name);
                return result;
            }
            return null;
        }
        if (item.getClusterList() != null) {
            for (OCluster cluster : item.getClusterList().toListOfClusters()) {
                String name = cluster.getClusterName();
                if (name == null) {
                    name = db.getClusterNameById(cluster.getClusterNumber());
                }
                if (name == null) continue;
                result.add(name);
            }
            return result;
        }
        if (item.getIndex() != null) {
            String indexName = item.getIndex().getIndexName();
            OIndex<?> idx = db.getMetadata().getIndexManager().getIndex(indexName);
            if (idx == null) {
                throw new OCommandExecutionException("Index " + indexName + " does not exist");
            }
            result.addAll(idx.getClusters());
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        if (item.getInputParam() != null) {
            if (((ODatabaseInternal)ctx.getDatabase()).isSharded()) {
                throw new UnsupportedOperationException("Sharded query with input parameter as a target is not supported yet");
            }
            return null;
        }
        if (item.getIdentifier() != null) {
            int[] clusterIds;
            String className = item.getIdentifier().getStringValue();
            OClass clazz = db.getMetadata().getSchema().getClass(className);
            if (clazz == null) {
                return null;
            }
            for (int clusterId : clusterIds = clazz.getPolymorphicClusterIds()) {
                String clusterName = db.getClusterNameById(clusterId);
                if (clusterName == null) continue;
                result.add(clusterName);
            }
            return result;
        }
        return null;
    }

    private OWhereClause translateLucene(OWhereClause whereClause) {
        if (whereClause == null) {
            return null;
        }
        if (whereClause.getBaseExpression() != null) {
            whereClause.getBaseExpression().translateLuceneOperator();
        }
        return whereClause;
    }

    protected static OProjection translateDistinct(OProjection projection) {
        if (projection != null && projection.getItems().size() == 1 && OSelectExecutionPlanner.isDistinct(projection.getItems().get(0))) {
            projection = projection.copy();
            OProjectionItem item = projection.getItems().get(0);
            OFunctionCall function = ((OBaseExpression)item.getExpression().getMathExpression()).getIdentifier().getLevelZero().getFunctionCall();
            OExpression exp = function.getParams().get(0);
            OProjectionItem resultItem = new OProjectionItem(-1);
            resultItem.setAlias(item.getAlias());
            resultItem.setExpression(exp.copy());
            OProjection result = new OProjection(-1);
            result.setItems(new ArrayList<OProjectionItem>());
            result.setDistinct(true);
            result.getItems().add(resultItem);
            return result;
        }
        return projection;
    }

    private static boolean isDistinct(OProjectionItem item) {
        if (item.getExpression() == null) {
            return false;
        }
        if (item.getExpression().getMathExpression() == null) {
            return false;
        }
        if (!(item.getExpression().getMathExpression() instanceof OBaseExpression)) {
            return false;
        }
        OBaseExpression base = (OBaseExpression)item.getExpression().getMathExpression();
        if (base.getIdentifier() == null) {
            return false;
        }
        if (base.getModifier() != null) {
            return false;
        }
        if (base.getIdentifier().getLevelZero() == null) {
            return false;
        }
        OFunctionCall function = base.getIdentifier().getLevelZero().getFunctionCall();
        if (function == null) {
            return false;
        }
        return function.getName().getStringValue().equalsIgnoreCase("distinct");
    }

    private boolean handleHardwiredOptimizations(OSelectExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        return this.handleHardwiredCountOnIndex(result, this.info, ctx, profilingEnabled) || this.handleHardwiredCountOnClass(result, this.info, ctx, profilingEnabled);
    }

    private boolean handleHardwiredCountOnClass(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        OIdentifier targetClass;
        OIdentifier oIdentifier = targetClass = info.target == null ? null : info.target.getItem().getIdentifier();
        if (targetClass == null) {
            return false;
        }
        if (info.distinct || info.expand) {
            return false;
        }
        if (info.preAggregateProjection != null) {
            return false;
        }
        if (!OSelectExecutionPlanner.isCountStar(info)) {
            return false;
        }
        if (!this.isMinimalQuery(info)) {
            return false;
        }
        result.chain(new CountFromClassStep(targetClass, info.projection.getAllAliases().iterator().next(), ctx, profilingEnabled));
        return true;
    }

    private boolean handleHardwiredCountOnIndex(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        OIndexIdentifier targetIndex;
        OIndexIdentifier oIndexIdentifier = targetIndex = info.target == null ? null : info.target.getItem().getIndex();
        if (targetIndex == null) {
            return false;
        }
        if (info.distinct || info.expand) {
            return false;
        }
        if (info.preAggregateProjection != null) {
            return false;
        }
        if (!OSelectExecutionPlanner.isCountStar(info)) {
            return false;
        }
        if (!this.isMinimalQuery(info)) {
            return false;
        }
        result.chain(new CountFromIndexStep(targetIndex, info.projection.getAllAliases().iterator().next(), ctx, profilingEnabled));
        return true;
    }

    private boolean isMinimalQuery(QueryPlanningInfo info) {
        return info.projectionAfterOrderBy == null && info.globalLetClause == null && info.perRecordLetClause == null && info.whereClause == null && info.flattenedWhereClause == null && info.groupBy == null && info.orderBy == null && info.unwind == null && info.skip == null;
    }

    private static boolean isCountStar(QueryPlanningInfo info) {
        if (info.aggregateProjection == null || info.projection == null || info.aggregateProjection.getItems().size() != 1 || info.projection.getItems().size() != 1) {
            return false;
        }
        OProjectionItem item = info.aggregateProjection.getItems().get(0);
        return item.getExpression().toString().equalsIgnoreCase("count(*)");
    }

    private boolean isCount(OProjection aggregateProjection, OProjection projection) {
        if (aggregateProjection == null || projection == null || aggregateProjection.getItems().size() != 1 || projection.getItems().size() != 1) {
            return false;
        }
        OProjectionItem item = aggregateProjection.getItems().get(0);
        return item.getExpression().isCount();
    }

    public static void handleUnwind(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.unwind != null) {
            result.chain(new UnwindStep(info.unwind, ctx, profilingEnabled));
        }
    }

    private static void handleDistinct(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.distinct) {
            result.chain(new DistinctExecutionStep(ctx, profilingEnabled));
        }
    }

    private static void handleProjectionsBeforeOrderBy(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.orderBy != null) {
            OSelectExecutionPlanner.handleProjections(result, info, ctx, profilingEnabled);
        }
    }

    private static void handleProjections(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (!info.projectionsCalculated && info.projection != null) {
            if (info.preAggregateProjection != null) {
                result.chain(new ProjectionCalculationStep(info.preAggregateProjection, ctx, profilingEnabled));
            }
            if (info.aggregateProjection != null) {
                result.chain(new AggregateProjectionCalculationStep(info.aggregateProjection, info.groupBy, ctx, profilingEnabled));
                if (OSelectExecutionPlanner.isCountStar(info) && info.groupBy == null) {
                    result.chain(new GuaranteeEmptyCountStep(info.aggregateProjection.getItems().get(0), ctx, profilingEnabled));
                }
            }
            result.chain(new ProjectionCalculationStep(info.projection, ctx, profilingEnabled));
            info.projectionsCalculated = true;
        }
    }

    protected static void optimizeQuery(QueryPlanningInfo info, OCommandContext ctx) {
        OSelectExecutionPlanner.splitLet(info, ctx);
        OSelectExecutionPlanner.rewriteIndexChainsAsSubqueries(info, ctx);
        OSelectExecutionPlanner.extractSubQueries(info);
        if (info.projection != null && info.projection.isExpand()) {
            info.expand = true;
            info.projection = info.projection.getExpandContent();
        }
        if (info.whereClause != null) {
            info.flattenedWhereClause = info.whereClause.flatten();
            info.flattenedWhereClause = OSelectExecutionPlanner.moveFlattededEqualitiesLeft(info.flattenedWhereClause);
        }
        OSelectExecutionPlanner.splitProjectionsForGroupBy(info, ctx);
        OSelectExecutionPlanner.addOrderByProjections(info);
    }

    private static void rewriteIndexChainsAsSubqueries(QueryPlanningInfo info, OCommandContext ctx) {
        OClass clazz;
        if (ctx == null || ctx.getDatabase() == null) {
            return;
        }
        if (info.whereClause != null && info.target != null && info.target.getItem().getIdentifier() != null && (clazz = ctx.getDatabase().getMetadata().getSchema().getClass(info.target.getItem().getIdentifier().getStringValue())) != null) {
            info.whereClause.getBaseExpression().rewriteIndexChainsAsSubqueries(ctx, clazz);
        }
    }

    private static void splitLet(QueryPlanningInfo info, OCommandContext ctx) {
        if (info.perRecordLetClause != null && info.perRecordLetClause.getItems() != null) {
            Iterator<OLetItem> iterator = info.perRecordLetClause.getItems().iterator();
            while (iterator.hasNext()) {
                OLetItem item = iterator.next();
                if (item.getExpression() != null && item.getExpression().isEarlyCalculated(ctx)) {
                    iterator.remove();
                    OSelectExecutionPlanner.addGlobalLet(info, item.getVarName(), item.getExpression());
                    continue;
                }
                if (item.getQuery() == null || item.getQuery().refersToParent()) continue;
                iterator.remove();
                OSelectExecutionPlanner.addGlobalLet(info, item.getVarName(), item.getQuery());
            }
        }
    }

    private static List<OAndBlock> moveFlattededEqualitiesLeft(List<OAndBlock> flattenedWhereClause) {
        if (flattenedWhereClause == null) {
            return null;
        }
        ArrayList<OAndBlock> result = new ArrayList<OAndBlock>();
        for (OAndBlock block : flattenedWhereClause) {
            ArrayList<OBooleanExpression> equalityExpressions = new ArrayList<OBooleanExpression>();
            ArrayList<OBooleanExpression> nonEqualityExpressions = new ArrayList<OBooleanExpression>();
            OAndBlock newBlock = block.copy();
            for (OBooleanExpression exp : newBlock.getSubBlocks()) {
                if (exp instanceof OBinaryCondition) {
                    if (((OBinaryCondition)exp).getOperator() instanceof OEqualsCompareOperator) {
                        equalityExpressions.add(exp);
                        continue;
                    }
                    nonEqualityExpressions.add(exp);
                    continue;
                }
                nonEqualityExpressions.add(exp);
            }
            OAndBlock newAnd = new OAndBlock(-1);
            newAnd.getSubBlocks().addAll(equalityExpressions);
            newAnd.getSubBlocks().addAll(nonEqualityExpressions);
            result.add(newAnd);
        }
        return result;
    }

    private static void addOrderByProjections(QueryPlanningInfo info) {
        if (info.orderApplied || info.expand || info.unwind != null || info.orderBy == null || info.orderBy.getItems().size() == 0 || info.projection == null || info.projection.getItems() == null || info.projection.getItems().size() == 1 && info.projection.getItems().get(0).isAll()) {
            return;
        }
        OOrderBy newOrderBy = info.orderBy == null ? null : info.orderBy.copy();
        List<OProjectionItem> additionalOrderByProjections = OSelectExecutionPlanner.calculateAdditionalOrderByProjections(info.projection.getAllAliases(), newOrderBy);
        if (additionalOrderByProjections.size() > 0) {
            info.orderBy = newOrderBy;
        }
        if (additionalOrderByProjections.size() > 0) {
            info.projectionAfterOrderBy = new OProjection(-1);
            info.projectionAfterOrderBy.setItems(new ArrayList<OProjectionItem>());
            for (String alias : info.projection.getAllAliases()) {
                info.projectionAfterOrderBy.getItems().add(OSelectExecutionPlanner.projectionFromAlias(new OIdentifier(alias)));
            }
            for (OProjectionItem item : additionalOrderByProjections) {
                if (info.preAggregateProjection != null) {
                    info.preAggregateProjection.getItems().add(item);
                    info.aggregateProjection.getItems().add(OSelectExecutionPlanner.projectionFromAlias(item.getAlias()));
                    info.projection.getItems().add(OSelectExecutionPlanner.projectionFromAlias(item.getAlias()));
                    continue;
                }
                info.projection.getItems().add(item);
            }
        }
    }

    private static List<OProjectionItem> calculateAdditionalOrderByProjections(Set<String> allAliases, OOrderBy orderBy) {
        ArrayList<OProjectionItem> result = new ArrayList<OProjectionItem>();
        int nextAliasCount = 0;
        if (orderBy != null && orderBy.getItems() != null || !orderBy.getItems().isEmpty()) {
            for (OOrderByItem item : orderBy.getItems()) {
                if (allAliases.contains(item.getAlias())) continue;
                OProjectionItem newProj = new OProjectionItem(-1);
                if (item.getAlias() != null) {
                    newProj.setExpression(new OExpression(new OIdentifier(item.getAlias()), item.getModifier()));
                } else if (item.getRecordAttr() != null) {
                    ORecordAttribute attr = new ORecordAttribute(-1);
                    attr.setName(item.getRecordAttr());
                    newProj.setExpression(new OExpression(attr, item.getModifier()));
                } else if (item.getRid() != null) {
                    OExpression exp = new OExpression(-1);
                    exp.setRid(item.getRid().copy());
                    newProj.setExpression(exp);
                }
                OIdentifier newAlias = new OIdentifier("_$$$ORDER_BY_ALIAS$$$_" + nextAliasCount++);
                newProj.setAlias(newAlias);
                item.setAlias(newAlias.getStringValue());
                result.add(newProj);
            }
        }
        return result;
    }

    private static void splitProjectionsForGroupBy(QueryPlanningInfo info, OCommandContext ctx) {
        if (info.projection == null) {
            return;
        }
        OProjection preAggregate = new OProjection(-1);
        preAggregate.setItems(new ArrayList<OProjectionItem>());
        OProjection aggregate = new OProjection(-1);
        aggregate.setItems(new ArrayList<OProjectionItem>());
        OProjection postAggregate = new OProjection(-1);
        postAggregate.setItems(new ArrayList<OProjectionItem>());
        boolean isSplitted = false;
        AggregateProjectionSplit result = new AggregateProjectionSplit();
        for (OProjectionItem item : info.projection.getItems()) {
            result.reset();
            if (OSelectExecutionPlanner.isAggregate(item)) {
                isSplitted = true;
                OProjectionItem post = item.splitForAggregation(result, ctx);
                OIdentifier postAlias = item.getProjectionAlias();
                postAlias = new OIdentifier(postAlias, true);
                post.setAlias(postAlias);
                postAggregate.getItems().add(post);
                aggregate.getItems().addAll(result.getAggregate());
                preAggregate.getItems().addAll(result.getPreAggregate());
                continue;
            }
            preAggregate.getItems().add(item);
            OProjectionItem aggItem = new OProjectionItem(-1);
            aggItem.setExpression(new OExpression(item.getProjectionAlias()));
            aggregate.getItems().add(aggItem);
            postAggregate.getItems().add(aggItem);
        }
        if (isSplitted) {
            info.preAggregateProjection = preAggregate;
            if (info.preAggregateProjection.getItems() == null || info.preAggregateProjection.getItems().size() == 0) {
                info.preAggregateProjection = null;
            }
            info.aggregateProjection = aggregate;
            if (info.aggregateProjection.getItems() == null || info.aggregateProjection.getItems().size() == 0) {
                info.aggregateProjection = null;
            }
            info.projection = postAggregate;
            OSelectExecutionPlanner.addGroupByExpressionsToProjections(info);
        }
    }

    private static boolean isAggregate(OProjectionItem item) {
        return item.isAggregate();
    }

    private static OProjectionItem projectionFromAlias(OIdentifier oIdentifier) {
        OProjectionItem result = new OProjectionItem(-1);
        result.setExpression(new OExpression(oIdentifier));
        return result;
    }

    private static void addGroupByExpressionsToProjections(QueryPlanningInfo info) {
        if (info.groupBy == null || info.groupBy.getItems() == null || info.groupBy.getItems().size() == 0) {
            return;
        }
        OGroupBy newGroupBy = new OGroupBy(-1);
        int i = 0;
        for (OExpression exp : info.groupBy.getItems()) {
            if (exp.isAggregate()) {
                throw new OCommandExecutionException("Cannot group by an aggregate function");
            }
            boolean found = false;
            if (info.preAggregateProjection != null) {
                for (String alias : info.preAggregateProjection.getAllAliases()) {
                    if (!alias.equals(exp.getDefaultAlias().getStringValue()) || !exp.isBaseIdentifier()) continue;
                    found = true;
                    newGroupBy.getItems().add(exp);
                    break;
                }
            }
            if (!found) {
                OProjectionItem newItem = new OProjectionItem(-1);
                newItem.setExpression(exp);
                OIdentifier groupByAlias = new OIdentifier("_$$$GROUP_BY_ALIAS$$$_" + i);
                newItem.setAlias(groupByAlias);
                if (info.preAggregateProjection == null) {
                    info.preAggregateProjection = new OProjection(-1);
                }
                if (info.preAggregateProjection.getItems() == null) {
                    info.preAggregateProjection.setItems(new ArrayList<OProjectionItem>());
                }
                info.preAggregateProjection.getItems().add(newItem);
                newGroupBy.getItems().add(new OExpression(groupByAlias));
            }
            info.groupBy = newGroupBy;
        }
    }

    private static void extractSubQueries(QueryPlanningInfo info) {
        OStatement query;
        OIdentifier alias;
        SubQueryCollector collector = new SubQueryCollector();
        if (info.perRecordLetClause != null) {
            info.perRecordLetClause.extractSubQueries(collector);
        }
        int i = 0;
        int j = 0;
        for (Map.Entry<OIdentifier, OStatement> entry : collector.getSubQueries().entrySet()) {
            alias = entry.getKey();
            query = entry.getValue();
            if (query.refersToParent()) {
                OSelectExecutionPlanner.addRecordLevelLet(info, alias, query, j++);
                continue;
            }
            OSelectExecutionPlanner.addGlobalLet(info, alias, query, i++);
        }
        collector.reset();
        if (info.whereClause != null) {
            info.whereClause.extractSubQueries(collector);
        }
        if (info.projection != null) {
            info.projection.extractSubQueries(collector);
        }
        if (info.orderBy != null) {
            info.orderBy.extractSubQueries(collector);
        }
        if (info.groupBy != null) {
            info.groupBy.extractSubQueries(collector);
        }
        for (Map.Entry<OIdentifier, OStatement> entry : collector.getSubQueries().entrySet()) {
            alias = entry.getKey();
            query = entry.getValue();
            if (query.refersToParent()) {
                OSelectExecutionPlanner.addRecordLevelLet(info, alias, query);
                continue;
            }
            OSelectExecutionPlanner.addGlobalLet(info, alias, query);
        }
    }

    private static void addGlobalLet(QueryPlanningInfo info, OIdentifier alias, OExpression exp) {
        if (info.globalLetClause == null) {
            info.globalLetClause = new OLetClause(-1);
        }
        OLetItem item = new OLetItem(-1);
        item.setVarName(alias);
        item.setExpression(exp);
        info.globalLetClause.addItem(item);
    }

    private static void addGlobalLet(QueryPlanningInfo info, OIdentifier alias, OStatement stm) {
        if (info.globalLetClause == null) {
            info.globalLetClause = new OLetClause(-1);
        }
        OLetItem item = new OLetItem(-1);
        item.setVarName(alias);
        item.setQuery(stm);
        info.globalLetClause.addItem(item);
    }

    private static void addGlobalLet(QueryPlanningInfo info, OIdentifier alias, OStatement stm, int pos) {
        if (info.globalLetClause == null) {
            info.globalLetClause = new OLetClause(-1);
        }
        OLetItem item = new OLetItem(-1);
        item.setVarName(alias);
        item.setQuery(stm);
        info.globalLetClause.getItems().add(pos, item);
    }

    private static void addRecordLevelLet(QueryPlanningInfo info, OIdentifier alias, OStatement stm) {
        if (info.perRecordLetClause == null) {
            info.perRecordLetClause = new OLetClause(-1);
        }
        OLetItem item = new OLetItem(-1);
        item.setVarName(alias);
        item.setQuery(stm);
        info.perRecordLetClause.addItem(item);
    }

    private static void addRecordLevelLet(QueryPlanningInfo info, OIdentifier alias, OStatement stm, int pos) {
        if (info.perRecordLetClause == null) {
            info.perRecordLetClause = new OLetClause(-1);
        }
        OLetItem item = new OLetItem(-1);
        item.setVarName(alias);
        item.setQuery(stm);
        info.perRecordLetClause.getItems().add(pos, item);
    }

    private void handleFetchFromTarger(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        OFromItem target = info.target == null ? null : info.target.getItem();
        for (Map.Entry<String, OSelectExecutionPlan> shardedPlan : info.distributedFetchExecutionPlans.entrySet()) {
            Set<String> filterClusters;
            if (target == null) {
                this.handleNoTarget(shardedPlan.getValue(), ctx, profilingEnabled);
                continue;
            }
            if (target.getIdentifier() != null) {
                filterClusters = info.serverToClusters.get(shardedPlan.getKey());
                OAndBlock ridRangeConditions = this.extractRidRanges(info.flattenedWhereClause, ctx);
                if (ridRangeConditions != null && !ridRangeConditions.isEmpty()) {
                    info.ridRangeConditions = ridRangeConditions;
                    filterClusters = filterClusters.stream().filter(x -> this.clusterMatchesRidRange((String)x, ridRangeConditions, ctx.getDatabase(), ctx)).collect(Collectors.toSet());
                }
                this.handleClassAsTarget(shardedPlan.getValue(), filterClusters, info, ctx, profilingEnabled);
                continue;
            }
            if (target.getCluster() != null) {
                this.handleClustersAsTarget(shardedPlan.getValue(), info, Collections.singletonList(target.getCluster()), ctx, profilingEnabled);
                continue;
            }
            if (target.getClusterList() != null) {
                List<OCluster> allClusters = target.getClusterList().toListOfClusters();
                ArrayList<OCluster> clustersForShard = new ArrayList<OCluster>();
                for (OCluster cluster : allClusters) {
                    String name = cluster.getClusterName();
                    if (name == null) {
                        name = ctx.getDatabase().getClusterNameById(cluster.getClusterNumber());
                    }
                    if (name == null || !info.serverToClusters.get(shardedPlan.getKey()).contains(name)) continue;
                    clustersForShard.add(cluster);
                }
                this.handleClustersAsTarget(shardedPlan.getValue(), info, clustersForShard, ctx, profilingEnabled);
                continue;
            }
            if (target.getStatement() != null) {
                this.handleSubqueryAsTarget(shardedPlan.getValue(), target.getStatement(), ctx, profilingEnabled);
                continue;
            }
            if (target.getFunctionCall() != null) {
                throw new OCommandExecutionException("function call as target is not supported yet");
            }
            if (target.getInputParam() != null) {
                this.handleInputParamAsTarget(shardedPlan.getValue(), info.serverToClusters.get(shardedPlan.getKey()), info, target.getInputParam(), ctx, profilingEnabled);
                continue;
            }
            if (target.getInputParams() != null && target.getInputParams().size() > 0) {
                ArrayList<OInternalExecutionPlan> plans = new ArrayList<OInternalExecutionPlan>();
                for (OInputParameter param : target.getInputParams()) {
                    OSelectExecutionPlan subPlan = new OSelectExecutionPlan(ctx);
                    this.handleInputParamAsTarget(subPlan, info.serverToClusters.get(shardedPlan.getKey()), info, param, ctx, profilingEnabled);
                    plans.add(subPlan);
                }
                shardedPlan.getValue().chain(new ParallelExecStep(plans, ctx, profilingEnabled));
                continue;
            }
            if (target.getIndex() != null) {
                this.handleIndexAsTarget(shardedPlan.getValue(), info, target.getIndex(), null, ctx, profilingEnabled);
                if (info.serverToClusters.size() <= 1) continue;
                shardedPlan.getValue().chain(new FilterByClustersStep(info.serverToClusters.get(shardedPlan.getKey()), ctx, profilingEnabled));
                continue;
            }
            if (target.getMetadata() != null) {
                this.handleMetadataAsTarget(shardedPlan.getValue(), target.getMetadata(), ctx, profilingEnabled);
                continue;
            }
            if (target.getRids() != null && target.getRids().size() > 0) {
                filterClusters = info.serverToClusters.get(shardedPlan.getKey());
                ArrayList<ORid> rids = new ArrayList<ORid>();
                for (ORid rid : target.getRids()) {
                    if (filterClusters != null && !this.isFromClusters(rid, filterClusters, ctx.getDatabase())) continue;
                    rids.add(rid);
                }
                if (rids.size() > 0) {
                    this.handleRidsAsTarget(shardedPlan.getValue(), rids, ctx, profilingEnabled);
                    continue;
                }
                result.chain(new EmptyStep(ctx, profilingEnabled));
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private boolean clusterMatchesRidRange(String clusterName, OAndBlock ridRangeConditions, ODatabase database, OCommandContext ctx) {
        int thisClusterId = database.getClusterIdByName(clusterName);
        for (OBooleanExpression ridRangeCondition : ridRangeConditions.getSubBlocks()) {
            if (!(ridRangeCondition instanceof OBinaryCondition)) continue;
            OBinaryCompareOperator operator = ((OBinaryCondition)ridRangeCondition).getOperator();
            Object obj = ((OBinaryCondition)ridRangeCondition).getRight().getRid() != null ? ((OBinaryCondition)ridRangeCondition).getRight().getRid().toRecordId((OResult)null, ctx) : ((OBinaryCondition)ridRangeCondition).getRight().execute((OResult)null, ctx);
            ORID conditionRid = ((OIdentifiable)obj).getIdentity();
            if (conditionRid == null) continue;
            int conditionClusterId = conditionRid.getClusterId();
            if (!(operator instanceof OGtOperator || operator instanceof OGeOperator ? thisClusterId < conditionClusterId : (operator instanceof OLtOperator || operator instanceof OLeOperator) && thisClusterId > conditionClusterId)) continue;
            return false;
        }
        return true;
    }

    private OAndBlock extractRidRanges(List<OAndBlock> flattenedWhereClause, OCommandContext ctx) {
        OAndBlock result = new OAndBlock(-1);
        if (flattenedWhereClause == null || flattenedWhereClause.size() != 1) {
            return result;
        }
        for (OBooleanExpression booleanExpression : flattenedWhereClause.get(0).getSubBlocks()) {
            if (!this.isRidRange(booleanExpression, ctx)) continue;
            result.getSubBlocks().add(booleanExpression.copy());
        }
        return result;
    }

    private boolean isRidRange(OBooleanExpression booleanExpression, OCommandContext ctx) {
        OBinaryCondition cond;
        OBinaryCompareOperator operator;
        if (booleanExpression instanceof OBinaryCondition && this.isRangeOperator(operator = (cond = (OBinaryCondition)booleanExpression).getOperator()) && cond.getLeft().toString().equalsIgnoreCase("@rid")) {
            Object obj = cond.getRight().getRid() != null ? cond.getRight().getRid().toRecordId((OResult)null, ctx) : cond.getRight().execute((OResult)null, ctx);
            return obj instanceof OIdentifiable;
        }
        return false;
    }

    private boolean isRangeOperator(OBinaryCompareOperator operator) {
        return operator instanceof OLtOperator || operator instanceof OLeOperator || operator instanceof OGtOperator || operator instanceof OGeOperator;
    }

    private void handleInputParamAsTarget(OSelectExecutionPlan result, Set<String> filterClusters, QueryPlanningInfo info, OInputParameter inputParam, OCommandContext ctx, boolean profilingEnabled) {
        Object paramValue = inputParam.getValue(ctx.getInputParameters());
        if (paramValue == null) {
            result.chain(new EmptyStep(ctx, profilingEnabled));
        } else if (paramValue instanceof OClass) {
            OFromClause from = new OFromClause(-1);
            OFromItem item = new OFromItem(-1);
            from.setItem(item);
            item.setIdentifier(new OIdentifier(((OClass)paramValue).getName()));
            this.handleClassAsTarget(result, filterClusters, from, info, ctx, profilingEnabled);
        } else if (paramValue instanceof String) {
            OFromClause from = new OFromClause(-1);
            OFromItem item = new OFromItem(-1);
            from.setItem(item);
            item.setIdentifier(new OIdentifier((String)paramValue));
            this.handleClassAsTarget(result, filterClusters, from, info, ctx, profilingEnabled);
        } else if (paramValue instanceof OIdentifiable) {
            ORID orid = ((OIdentifiable)paramValue).getIdentity();
            ORid rid = new ORid(-1);
            OInteger cluster = new OInteger(-1);
            cluster.setValue(orid.getClusterId());
            OInteger position = new OInteger(-1);
            position.setValue(orid.getClusterPosition());
            rid.setLegacy(true);
            rid.setCluster(cluster);
            rid.setPosition(position);
            if (filterClusters == null || this.isFromClusters(rid, filterClusters, ctx.getDatabase())) {
                this.handleRidsAsTarget(result, Collections.singletonList(rid), ctx, profilingEnabled);
            } else {
                result.chain(new EmptyStep(ctx, profilingEnabled));
            }
        } else if (paramValue instanceof Iterable) {
            ArrayList<ORid> rids = new ArrayList<ORid>();
            for (Object x : (Iterable)paramValue) {
                if (!(x instanceof OIdentifiable)) {
                    throw new OCommandExecutionException("Cannot use colleciton as target: " + paramValue);
                }
                ORID orid = ((OIdentifiable)x).getIdentity();
                ORid rid = new ORid(-1);
                OInteger cluster = new OInteger(-1);
                cluster.setValue(orid.getClusterId());
                OInteger position = new OInteger(-1);
                position.setValue(orid.getClusterPosition());
                rid.setCluster(cluster);
                rid.setPosition(position);
                if (filterClusters != null && !this.isFromClusters(rid, filterClusters, ctx.getDatabase())) continue;
                rids.add(rid);
            }
            if (rids.size() > 0) {
                this.handleRidsAsTarget(result, rids, ctx, profilingEnabled);
            } else {
                result.chain(new EmptyStep(ctx, profilingEnabled));
            }
        } else {
            throw new OCommandExecutionException("Invalid target: " + paramValue);
        }
    }

    private boolean isFromClusters(ORid rid, Set<String> filterClusters, ODatabase database) {
        if (filterClusters == null) {
            throw new IllegalArgumentException();
        }
        String clusterName = database.getClusterNameById(rid.getCluster().getValue().intValue());
        return filterClusters.contains(clusterName);
    }

    private void handleNoTarget(OSelectExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new EmptyDataGeneratorStep(1, ctx, profilingEnabled));
    }

    private void handleIndexAsTarget(OSelectExecutionPlan result, QueryPlanningInfo info, OIndexIdentifier indexIdentifier, Set<String> filterClusters, OCommandContext ctx, boolean profilingEnabled) {
        String indexName = indexIdentifier.getIndexName();
        OIndex<?> index = ctx.getDatabase().getMetadata().getIndexManager().getIndex(indexName);
        if (index == null) {
            throw new OCommandExecutionException("Index not found: " + indexName);
        }
        int[] filterClusterIds = null;
        if (filterClusters != null) {
            filterClusterIds = filterClusters.stream().map(name -> ctx.getDatabase().getClusterIdByName((String)name)).mapToInt(i -> i).toArray();
        }
        switch (indexIdentifier.getType()) {
            case INDEX: {
                OBooleanExpression keyCondition = null;
                OBooleanExpression ridCondition = null;
                if (info.flattenedWhereClause == null || info.flattenedWhereClause.size() == 0) {
                    if (!index.supportsOrderedIterations()) {
                        throw new OCommandExecutionException("Index " + indexName + " does not allow iteration without a condition");
                    }
                } else {
                    if (info.flattenedWhereClause.size() > 1) {
                        throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + info.whereClause);
                    }
                    OAndBlock andBlock = info.flattenedWhereClause.get(0);
                    if (andBlock.getSubBlocks().size() == 1) {
                        info.whereClause = null;
                        info.flattenedWhereClause = null;
                        keyCondition = this.getKeyCondition(andBlock);
                        if (keyCondition == null) {
                            throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + info.whereClause);
                        }
                    } else if (andBlock.getSubBlocks().size() == 2) {
                        info.whereClause = null;
                        info.flattenedWhereClause = null;
                        keyCondition = this.getKeyCondition(andBlock);
                        ridCondition = this.getRidCondition(andBlock);
                        if (keyCondition == null || ridCondition == null) {
                            throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + info.whereClause);
                        }
                    } else {
                        throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + info.whereClause);
                    }
                }
                result.chain(new FetchFromIndexStep(index, keyCondition, null, ctx, profilingEnabled));
                if (ridCondition == null) break;
                OWhereClause where = new OWhereClause(-1);
                where.setBaseExpression(ridCondition);
                result.chain(new FilterStep(where, ctx, profilingEnabled));
                break;
            }
            case VALUES: 
            case VALUESASC: {
                if (!index.supportsOrderedIterations()) {
                    throw new OCommandExecutionException("Index " + indexName + " does not allow iteration on values");
                }
                result.chain(new FetchFromIndexValuesStep(index, true, ctx, profilingEnabled));
                result.chain(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
                break;
            }
            case VALUESDESC: {
                if (!index.supportsOrderedIterations()) {
                    throw new OCommandExecutionException("Index " + indexName + " does not allow iteration on values");
                }
                result.chain(new FetchFromIndexValuesStep(index, false, ctx, profilingEnabled));
                result.chain(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
            }
        }
    }

    private OBooleanExpression getKeyCondition(OAndBlock andBlock) {
        for (OBooleanExpression exp : andBlock.getSubBlocks()) {
            String str = exp.toString();
            if (str.length() < 5 || !str.substring(0, 4).equalsIgnoreCase("key ")) continue;
            return exp;
        }
        return null;
    }

    private OBooleanExpression getRidCondition(OAndBlock andBlock) {
        for (OBooleanExpression exp : andBlock.getSubBlocks()) {
            String str = exp.toString();
            if (str.length() < 5 || !str.substring(0, 4).equalsIgnoreCase("rid ")) continue;
            return exp;
        }
        return null;
    }

    private void handleMetadataAsTarget(OSelectExecutionPlan plan, OMetadataIdentifier metadata, OCommandContext ctx, boolean profilingEnabled) {
        ODatabaseInternal db = (ODatabaseInternal)ctx.getDatabase();
        String schemaRecordIdAsString = null;
        if (metadata.getName().equalsIgnoreCase("SCHEMA")) {
            schemaRecordIdAsString = db.getStorage().getConfiguration().getSchemaRecordId();
            ORecordId schemaRid = new ORecordId(schemaRecordIdAsString);
            plan.chain(new FetchFromRidsStep(Collections.singleton(schemaRid), ctx, profilingEnabled));
        } else if (metadata.getName().equalsIgnoreCase("INDEXMANAGER")) {
            schemaRecordIdAsString = db.getStorage().getConfiguration().getIndexMgrRecordId();
            ORecordId schemaRid = new ORecordId(schemaRecordIdAsString);
            plan.chain(new FetchFromRidsStep(Collections.singleton(schemaRid), ctx, profilingEnabled));
        } else if (metadata.getName().equalsIgnoreCase("STORAGE")) {
            plan.chain(new FetchFromStorageMetadataStep(ctx, profilingEnabled));
        } else if (metadata.getName().equalsIgnoreCase("DATABASE")) {
            plan.chain(new FetchFromDatabaseMetadataStep(ctx, profilingEnabled));
        } else {
            throw new UnsupportedOperationException("Invalid metadata: " + metadata.getName());
        }
    }

    private void handleRidsAsTarget(OSelectExecutionPlan plan, List<ORid> rids, OCommandContext ctx, boolean profilingEnabled) {
        ArrayList<ORecordId> actualRids = new ArrayList<ORecordId>();
        for (ORid rid : rids) {
            actualRids.add(rid.toRecordId((OResult)null, ctx));
        }
        plan.chain(new FetchFromRidsStep(actualRids, ctx, profilingEnabled));
    }

    private static void handleExpand(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.expand) {
            result.chain(new ExpandStep(ctx, profilingEnabled));
        }
    }

    private void handleGlobalLet(OSelectExecutionPlan result, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.globalLetClause != null) {
            List<OLetItem> items = info.globalLetClause.getItems();
            for (OLetItem item : items) {
                if (item.getExpression() != null) {
                    result.chain(new GlobalLetExpressionStep(item.getVarName(), item.getExpression(), ctx, profilingEnabled));
                } else {
                    result.chain(new GlobalLetQueryStep(item.getVarName(), item.getQuery(), ctx, profilingEnabled));
                }
                info.globalLetPresent = true;
            }
        }
    }

    private void handleLet(OSelectExecutionPlan plan, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        block7: {
            if (info.perRecordLetClause == null) break block7;
            List<OLetItem> items = info.perRecordLetClause.getItems();
            if (info.distributedPlanCreated) {
                for (OLetItem item : items) {
                    if (item.getExpression() != null) {
                        plan.chain(new LetExpressionStep(item.getVarName(), item.getExpression(), ctx, profilingEnabled));
                        continue;
                    }
                    plan.chain(new LetQueryStep(item.getVarName(), item.getQuery(), ctx, profilingEnabled));
                }
            } else {
                for (OSelectExecutionPlan shardedPlan : info.distributedFetchExecutionPlans.values()) {
                    for (OLetItem item : items) {
                        if (item.getExpression() != null) {
                            shardedPlan.chain(new LetExpressionStep(item.getVarName().copy(), item.getExpression().copy(), ctx, profilingEnabled));
                            continue;
                        }
                        shardedPlan.chain(new LetQueryStep(item.getVarName().copy(), item.getQuery().copy(), ctx, profilingEnabled));
                    }
                }
            }
        }
    }

    private void handleWhere(OSelectExecutionPlan plan, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.whereClause != null) {
            if (info.distributedPlanCreated) {
                plan.chain(new FilterStep(info.whereClause, ctx, profilingEnabled));
            } else {
                for (OSelectExecutionPlan shardedPlan : info.distributedFetchExecutionPlans.values()) {
                    shardedPlan.chain(new FilterStep(info.whereClause.copy(), ctx, profilingEnabled));
                }
            }
        }
    }

    public static void handleOrderBy(OSelectExecutionPlan plan, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        int skipSize;
        int n = skipSize = info.skip == null ? 0 : info.skip.getValue(ctx);
        if (skipSize < 0) {
            throw new OCommandExecutionException("Cannot execute a query with a negative SKIP");
        }
        int limitSize = info.limit == null ? -1 : info.limit.getValue(ctx);
        Integer maxResults = null;
        if (limitSize >= 0) {
            maxResults = skipSize + limitSize;
        }
        if (info.expand || info.unwind != null) {
            maxResults = null;
        }
        if (!info.orderApplied && info.orderBy != null && info.orderBy.getItems() != null && info.orderBy.getItems().size() > 0) {
            plan.chain(new OrderByStep(info.orderBy, maxResults, ctx, profilingEnabled));
            if (info.projectionAfterOrderBy != null) {
                plan.chain(new ProjectionCalculationStep(info.projectionAfterOrderBy, ctx, profilingEnabled));
            }
        }
    }

    private void handleClassAsTarget(OSelectExecutionPlan plan, Set<String> filterClusters, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        this.handleClassAsTarget(plan, filterClusters, info.target, info, ctx, profilingEnabled);
    }

    private void handleClassAsTarget(OSelectExecutionPlan plan, Set<String> filterClusters, OFromClause from, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        OIdentifier identifier = from.getItem().getIdentifier();
        if (this.handleClassAsTargetWithIndexedFunction(plan, filterClusters, identifier, info, ctx, profilingEnabled)) {
            plan.chain(new FilterByClassStep(identifier, ctx, profilingEnabled));
            return;
        }
        if (this.handleClassAsTargetWithIndex(plan, identifier, filterClusters, info, ctx, profilingEnabled)) {
            plan.chain(new FilterByClassStep(identifier, ctx, profilingEnabled));
            return;
        }
        if (info.orderBy != null && this.handleClassWithIndexForSortOnly(plan, identifier, filterClusters, info, ctx, profilingEnabled)) {
            plan.chain(new FilterByClassStep(identifier, ctx, profilingEnabled));
            return;
        }
        Boolean orderByRidAsc = null;
        if (this.isOrderByRidAsc(info)) {
            orderByRidAsc = true;
        } else if (this.isOrderByRidDesc(info)) {
            orderByRidAsc = false;
        }
        FetchFromClassExecutionStep fetcher = new FetchFromClassExecutionStep(identifier.getStringValue(), filterClusters, info, ctx, orderByRidAsc, profilingEnabled);
        if (orderByRidAsc != null && info.serverToClusters.size() == 1) {
            info.orderApplied = true;
        }
        plan.chain(fetcher);
    }

    private boolean handleClassAsTargetWithIndexedFunction(OSelectExecutionPlan plan, Set<String> filterClusters, OIdentifier queryTarget, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (queryTarget == null) {
            return false;
        }
        OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(queryTarget.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Class not found: " + queryTarget);
        }
        if (info.flattenedWhereClause == null || info.flattenedWhereClause.size() == 0) {
            return false;
        }
        ArrayList<OInternalExecutionPlan> resultSubPlans = new ArrayList<OInternalExecutionPlan>();
        boolean indexedFunctionsFound = false;
        for (OAndBlock block : info.flattenedWhereClause) {
            OSelectExecutionPlan subPlan;
            Object step;
            List<OBinaryCondition> indexedFunctionConditions = block.getIndexedFunctionConditions(clazz, (ODatabaseDocumentInternal)ctx.getDatabase());
            if ((indexedFunctionConditions = this.filterIndexedFunctionsWithoutIndex(indexedFunctionConditions, info.target, ctx)) == null || indexedFunctionConditions.size() == 0) {
                IndexSearchDescriptor bestIndex = this.findBestIndexFor(ctx, clazz.getIndexes(), block, clazz);
                if (bestIndex != null) {
                    step = new FetchFromIndexStep(bestIndex.idx, (OBooleanExpression)bestIndex.keyCondition, bestIndex.additionalRangeCondition, true, ctx, profilingEnabled);
                    subPlan = new OSelectExecutionPlan(ctx);
                    subPlan.chain((OExecutionStepInternal)step);
                    int[] filterClusterIds = null;
                    if (filterClusters != null) {
                        filterClusterIds = filterClusters.stream().map(name -> ctx.getDatabase().getClusterIdByName((String)name)).mapToInt(i -> i).toArray();
                    }
                    subPlan.chain(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
                    if (this.requiresMultipleIndexLookups(bestIndex.keyCondition)) {
                        subPlan.chain(new DistinctExecutionStep(ctx, profilingEnabled));
                    }
                    if (!block.getSubBlocks().isEmpty()) {
                        subPlan.chain(new FilterStep(this.createWhereFrom(block), ctx, profilingEnabled));
                    }
                    resultSubPlans.add(subPlan);
                    continue;
                }
                step = new FetchFromClassExecutionStep(clazz.getName(), filterClusters, ctx, true, profilingEnabled);
                subPlan = new OSelectExecutionPlan(ctx);
                subPlan.chain((OExecutionStepInternal)step);
                if (!block.getSubBlocks().isEmpty()) {
                    subPlan.chain(new FilterStep(this.createWhereFrom(block), ctx, profilingEnabled));
                }
                resultSubPlans.add(subPlan);
                continue;
            }
            OBinaryCondition blockCandidateFunction = null;
            for (OBinaryCondition cond : indexedFunctionConditions) {
                if (!cond.allowsIndexedFunctionExecutionOnTarget(info.target, ctx) && !cond.canExecuteIndexedFunctionWithoutIndex(info.target, ctx)) {
                    throw new OCommandExecutionException("Cannot execute " + block + " on " + queryTarget);
                }
                if (blockCandidateFunction == null) {
                    blockCandidateFunction = cond;
                    continue;
                }
                boolean thisAllowsNoIndex = cond.canExecuteIndexedFunctionWithoutIndex(info.target, ctx);
                boolean prevAllowsNoIndex = blockCandidateFunction.canExecuteIndexedFunctionWithoutIndex(info.target, ctx);
                if (!thisAllowsNoIndex && !prevAllowsNoIndex) {
                    throw new OCommandExecutionException("Cannot choose indexed function between " + cond + " and " + blockCandidateFunction + ". Both require indexed execution");
                }
                if (thisAllowsNoIndex && prevAllowsNoIndex) {
                    long thisEstimate = cond.estimateIndexed(info.target, ctx);
                    long lastEstimate = blockCandidateFunction.estimateIndexed(info.target, ctx);
                    if (thisEstimate <= -1L || thisEstimate >= lastEstimate) continue;
                    blockCandidateFunction = cond;
                    continue;
                }
                if (!prevAllowsNoIndex) continue;
                blockCandidateFunction = cond;
            }
            step = new FetchFromIndexedFunctionStep(blockCandidateFunction, info.target, ctx, profilingEnabled);
            if (!blockCandidateFunction.executeIndexedFunctionAfterIndexSearch(info.target, ctx)) {
                block = block.copy();
                block.getSubBlocks().remove(blockCandidateFunction);
            }
            if (info.flattenedWhereClause.size() == 1) {
                plan.chain((OExecutionStepInternal)step);
                plan.chain(new FilterByClustersStep(filterClusters, ctx, profilingEnabled));
                if (!block.getSubBlocks().isEmpty()) {
                    plan.chain(new FilterStep(this.createWhereFrom(block), ctx, profilingEnabled));
                }
            } else {
                subPlan = new OSelectExecutionPlan(ctx);
                subPlan.chain((OExecutionStepInternal)step);
                if (!block.getSubBlocks().isEmpty()) {
                    subPlan.chain(new FilterStep(this.createWhereFrom(block), ctx, profilingEnabled));
                }
                resultSubPlans.add(subPlan);
            }
            indexedFunctionsFound = true;
        }
        if (indexedFunctionsFound) {
            if (resultSubPlans.size() > 1) {
                plan.chain(new ParallelExecStep(resultSubPlans, ctx, profilingEnabled));
                plan.chain(new FilterByClustersStep(filterClusters, ctx, profilingEnabled));
                plan.chain(new DistinctExecutionStep(ctx, profilingEnabled));
            }
            info.whereClause = null;
            info.flattenedWhereClause = null;
            return true;
        }
        return false;
    }

    private List<OBinaryCondition> filterIndexedFunctionsWithoutIndex(List<OBinaryCondition> indexedFunctionConditions, OFromClause fromClause, OCommandContext ctx) {
        if (indexedFunctionConditions == null) {
            return null;
        }
        ArrayList<OBinaryCondition> result = new ArrayList<OBinaryCondition>();
        for (OBinaryCondition cond : indexedFunctionConditions) {
            if (cond.allowsIndexedFunctionExecutionOnTarget(fromClause, ctx)) {
                result.add(cond);
                continue;
            }
            if (cond.canExecuteIndexedFunctionWithoutIndex(fromClause, ctx)) continue;
            throw new OCommandExecutionException("Cannot evaluate " + cond + ": no index defined");
        }
        return result;
    }

    private boolean handleClassWithIndexForSortOnly(OSelectExecutionPlan plan, OIdentifier queryTarget, Set<String> filterClusters, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(queryTarget.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Class not found: " + queryTarget.getStringValue());
        }
        for (OIndex idx : clazz.getIndexes().stream().filter(i -> i.supportsOrderedIterations()).filter(i -> i.getDefinition() != null).collect(Collectors.toList())) {
            List<String> indexFields = idx.getDefinition().getFields();
            if (indexFields.size() < info.orderBy.getItems().size()) continue;
            boolean indexFound = true;
            String orderType = null;
            for (int i2 = 0; i2 < info.orderBy.getItems().size(); ++i2) {
                OOrderByItem orderItem = info.orderBy.getItems().get(i2);
                String indexField = indexFields.get(i2);
                if (i2 == 0) {
                    orderType = orderItem.getType();
                } else if (orderType == null || !orderType.equals(orderItem.getType())) {
                    indexFound = false;
                    break;
                }
                if (indexField.equals(orderItem.getAlias())) continue;
                indexFound = false;
                break;
            }
            if (!indexFound || orderType == null) continue;
            plan.chain(new FetchFromIndexValuesStep(idx, orderType.equals("ASC"), ctx, profilingEnabled));
            int[] filterClusterIds = null;
            if (filterClusters != null) {
                filterClusterIds = filterClusters.stream().map(name -> ctx.getDatabase().getClusterIdByName((String)name)).mapToInt(i -> i).toArray();
            }
            plan.chain(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
            if (info.serverToClusters.size() == 1) {
                info.orderApplied = true;
            }
            return true;
        }
        return false;
    }

    private boolean handleClassAsTargetWithIndex(OSelectExecutionPlan plan, OIdentifier targetClass, Set<String> filterClusters, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        List<OExecutionStepInternal> result = this.handleClassAsTargetWithIndex(targetClass.getStringValue(), filterClusters, info, ctx, profilingEnabled);
        if (result != null) {
            result.stream().forEach(x -> plan.chain((OExecutionStepInternal)x));
            info.whereClause = null;
            info.flattenedWhereClause = null;
            return true;
        }
        OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(targetClass.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Cannot find class " + targetClass);
        }
        if (clazz.count(false) != 0L || clazz.getSubclasses().size() == 0 || this.isDiamondHierarchy(clazz)) {
            return false;
        }
        Collection<OClass> subclasses = clazz.getSubclasses();
        ArrayList<OInternalExecutionPlan> subclassPlans = new ArrayList<OInternalExecutionPlan>();
        for (OClass subClass : subclasses) {
            List<OExecutionStepInternal> subSteps = this.handleClassAsTargetWithIndexRecursive(subClass.getName(), filterClusters, info, ctx, profilingEnabled);
            if (subSteps == null || subSteps.size() == 0) {
                return false;
            }
            OSelectExecutionPlan subPlan = new OSelectExecutionPlan(ctx);
            subSteps.stream().forEach(x -> subPlan.chain((OExecutionStepInternal)x));
            subclassPlans.add(subPlan);
        }
        if (subclassPlans.size() > 0) {
            plan.chain(new ParallelExecStep(subclassPlans, ctx, profilingEnabled));
            return true;
        }
        return false;
    }

    private boolean isDiamondHierarchy(OClass clazz) {
        HashSet<OClass> traversed = new HashSet<OClass>();
        ArrayList<OClass> stack = new ArrayList<OClass>();
        stack.add(clazz);
        while (!stack.isEmpty()) {
            OClass current = (OClass)stack.remove(0);
            traversed.add(current);
            for (OClass sub : current.getSubclasses()) {
                if (traversed.contains(sub)) {
                    return true;
                }
                stack.add(sub);
                traversed.add(sub);
            }
        }
        return false;
    }

    private List<OExecutionStepInternal> handleClassAsTargetWithIndexRecursive(String targetClass, Set<String> filterClusters, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        List<OExecutionStepInternal> result = this.handleClassAsTargetWithIndex(targetClass, filterClusters, info, ctx, profilingEnabled);
        if (result == null) {
            result = new ArrayList<OExecutionStepInternal>();
            OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(targetClass);
            if (clazz == null) {
                throw new OCommandExecutionException("Cannot find class " + targetClass);
            }
            if (clazz.count(false) != 0L || clazz.getSubclasses().size() == 0 || this.isDiamondHierarchy(clazz)) {
                return null;
            }
            Collection<OClass> subclasses = clazz.getSubclasses();
            ArrayList<OInternalExecutionPlan> subclassPlans = new ArrayList<OInternalExecutionPlan>();
            for (OClass subClass : subclasses) {
                List<OExecutionStepInternal> subSteps = this.handleClassAsTargetWithIndexRecursive(subClass.getName(), filterClusters, info, ctx, profilingEnabled);
                if (subSteps == null || subSteps.size() == 0) {
                    return null;
                }
                OSelectExecutionPlan subPlan = new OSelectExecutionPlan(ctx);
                subSteps.stream().forEach(x -> subPlan.chain((OExecutionStepInternal)x));
                subclassPlans.add(subPlan);
            }
            if (subclassPlans.size() > 0) {
                result.add(new ParallelExecStep(subclassPlans, ctx, profilingEnabled));
            }
        }
        return result.size() == 0 ? null : result;
    }

    private List<OExecutionStepInternal> handleClassAsTargetWithIndex(String targetClass, Set<String> filterClusters, QueryPlanningInfo info, OCommandContext ctx, boolean profilingEnabled) {
        if (info.flattenedWhereClause == null || info.flattenedWhereClause.size() == 0) {
            return null;
        }
        OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(targetClass);
        if (clazz == null) {
            throw new OCommandExecutionException("Cannot find class " + targetClass);
        }
        Set<OIndex<?>> indexes = clazz.getIndexes();
        List<IndexSearchDescriptor> indexSearchDescriptors = info.flattenedWhereClause.stream().map(x -> this.findBestIndexFor(ctx, indexes, (OAndBlock)x, clazz)).filter(Objects::nonNull).collect(Collectors.toList());
        if (indexSearchDescriptors.size() != info.flattenedWhereClause.size()) {
            return null;
        }
        ArrayList<OExecutionStepInternal> result = null;
        List<IndexSearchDescriptor> optimumIndexSearchDescriptors = this.commonFactor(indexSearchDescriptors);
        if (indexSearchDescriptors.size() == 1) {
            IndexSearchDescriptor desc = indexSearchDescriptors.get(0);
            result = new ArrayList();
            Boolean orderAsc = this.getOrderDirection(info);
            result.add(new FetchFromIndexStep(desc.idx, (OBooleanExpression)desc.keyCondition, desc.additionalRangeCondition, !Boolean.FALSE.equals(orderAsc), ctx, profilingEnabled));
            int[] filterClusterIds = null;
            if (filterClusters != null) {
                filterClusterIds = filterClusters.stream().map(name -> ctx.getDatabase().getClusterIdByName((String)name)).mapToInt(i -> i).toArray();
            }
            result.add(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
            if (this.requiresMultipleIndexLookups(desc.keyCondition)) {
                result.add(new DistinctExecutionStep(ctx, profilingEnabled));
            }
            if (orderAsc != null && info.orderBy != null && this.fullySorted(info.orderBy, desc.keyCondition, desc.idx) && info.serverToClusters.size() == 1) {
                info.orderApplied = true;
            }
            if (desc.remainingCondition != null && !desc.remainingCondition.isEmpty()) {
                result.add(new FilterStep(this.createWhereFrom(desc.remainingCondition), ctx, profilingEnabled));
            }
        } else {
            result = new ArrayList<OExecutionStepInternal>();
            result.add(this.createParallelIndexFetch(optimumIndexSearchDescriptors, filterClusters, ctx, profilingEnabled));
        }
        return result;
    }

    private boolean fullySorted(OOrderBy orderBy, OAndBlock conditions, OIndex idx) {
        if (!idx.supportsOrderedIterations()) {
            return false;
        }
        ArrayList<String> orderItems = new ArrayList<String>();
        String order = null;
        for (OOrderByItem item : orderBy.getItems()) {
            if (order == null) {
                order = item.getType();
            } else if (!order.equals(item.getType())) {
                return false;
            }
            orderItems.add(item.getAlias() != null ? item.getAlias() : item.getRecordAttr());
        }
        ArrayList<String> conditionItems = new ArrayList<String>();
        for (int i = 0; i < conditions.getSubBlocks().size(); ++i) {
            OBooleanExpression item = conditions.getSubBlocks().get(i);
            if (item instanceof OBinaryCondition) {
                if (((OBinaryCondition)item).getOperator() instanceof OEqualsCompareOperator) {
                    conditionItems.add(((OBinaryCondition)item).getLeft().toString());
                    continue;
                }
                if (i == conditions.getSubBlocks().size() - 1) continue;
                return false;
            }
            if (i == conditions.getSubBlocks().size() - 1) continue;
            return false;
        }
        ArrayList<String> orderedFields = new ArrayList<String>();
        boolean overlapping = false;
        for (String s : conditionItems) {
            if (orderItems.isEmpty()) {
                return true;
            }
            if (s.equals(orderItems.get(0))) {
                orderItems.remove(0);
                overlapping = true;
            } else if (overlapping) {
                return false;
            }
            orderedFields.add(s);
        }
        orderedFields.addAll(orderItems);
        OIndexDefinition definition = idx.getDefinition();
        List<String> fields = definition.getFields();
        if (fields.size() < orderedFields.size()) {
            return false;
        }
        for (int i = 0; i < orderedFields.size(); ++i) {
            String indexFieldName;
            String orderFieldName = (String)orderedFields.get(i);
            if (orderFieldName.equals(indexFieldName = fields.get(i))) continue;
            return false;
        }
        return true;
    }

    private Boolean getOrderDirection(QueryPlanningInfo info) {
        if (info.orderBy == null) {
            return null;
        }
        String result = null;
        for (OOrderByItem item : info.orderBy.getItems()) {
            if (result == null) {
                result = item.getType() == null ? "ASC" : item.getType();
                continue;
            }
            String newType = item.getType() == null ? "ASC" : item.getType();
            if (newType.equals(result)) continue;
            return null;
        }
        return result == null || result.equals("ASC");
    }

    private OExecutionStepInternal createParallelIndexFetch(List<IndexSearchDescriptor> indexSearchDescriptors, Set<String> filterClusters, OCommandContext ctx, boolean profilingEnabled) {
        ArrayList<OInternalExecutionPlan> subPlans = new ArrayList<OInternalExecutionPlan>();
        for (IndexSearchDescriptor desc : indexSearchDescriptors) {
            OSelectExecutionPlan subPlan = new OSelectExecutionPlan(ctx);
            subPlan.chain(new FetchFromIndexStep(desc.idx, desc.keyCondition, desc.additionalRangeCondition, ctx, profilingEnabled));
            int[] filterClusterIds = null;
            if (filterClusters != null) {
                filterClusterIds = filterClusters.stream().map(name -> ctx.getDatabase().getClusterIdByName((String)name)).mapToInt(i -> i).toArray();
            }
            subPlan.chain(new GetValueFromIndexEntryStep(ctx, filterClusterIds, profilingEnabled));
            if (this.requiresMultipleIndexLookups(desc.keyCondition)) {
                subPlan.chain(new DistinctExecutionStep(ctx, profilingEnabled));
            }
            if (desc.remainingCondition != null && !desc.remainingCondition.isEmpty()) {
                subPlan.chain(new FilterStep(this.createWhereFrom(desc.remainingCondition), ctx, profilingEnabled));
            }
            subPlans.add(subPlan);
        }
        return new ParallelExecStep(subPlans, ctx, profilingEnabled);
    }

    private boolean requiresMultipleIndexLookups(OAndBlock keyCondition) {
        for (OBooleanExpression oBooleanExpression : keyCondition.getSubBlocks()) {
            if (oBooleanExpression instanceof OBinaryCondition) continue;
            return true;
        }
        return false;
    }

    private OWhereClause createWhereFrom(OBooleanExpression remainingCondition) {
        OWhereClause result = new OWhereClause(-1);
        result.setBaseExpression(remainingCondition);
        return result;
    }

    private IndexSearchDescriptor findBestIndexFor(OCommandContext ctx, Set<OIndex<?>> indexes, OAndBlock block, OClass clazz) {
        List<IndexSearchDescriptor> descriptors = indexes.stream().filter(x -> x.getInternal().canBeUsedInEqualityOperators()).map(index -> this.buildIndexSearchDescriptor(ctx, (OIndex<?>)index, block, clazz)).filter(Objects::nonNull).filter(x -> x.keyCondition != null).filter(x -> x.keyCondition.getSubBlocks().size() > 0).collect(Collectors.toList());
        List sortedDescriptors = (descriptors = this.removePrefixIndexes(descriptors)).stream().map(x -> new OPair<Integer, IndexSearchDescriptor>(x.cost(ctx), (IndexSearchDescriptor)x)).sorted().collect(Collectors.toList());
        descriptors = sortedDescriptors.isEmpty() ? Collections.emptyList() : sortedDescriptors.stream().filter(x -> ((Integer)x.key).equals(((OPair)sortedDescriptors.get((int)0)).key)).map(x -> (IndexSearchDescriptor)x.value).collect(Collectors.toList());
        descriptors = descriptors.stream().sorted(Comparator.comparingInt(x -> x.keyCondition.getSubBlocks().size())).collect(Collectors.toList());
        return descriptors.isEmpty() ? null : descriptors.get(descriptors.size() - 1);
    }

    private List<IndexSearchDescriptor> removePrefixIndexes(List<IndexSearchDescriptor> descriptors) {
        ArrayList<IndexSearchDescriptor> result = new ArrayList<IndexSearchDescriptor>();
        for (IndexSearchDescriptor desc : descriptors) {
            if (result.isEmpty()) {
                result.add(desc);
                continue;
            }
            List<IndexSearchDescriptor> prefixes = this.findPrefixes(desc, result);
            if (prefixes.isEmpty()) {
                if (this.isPrefixOfAny(desc, result)) continue;
                result.add(desc);
                continue;
            }
            result.removeAll(prefixes);
            result.add(desc);
        }
        return result;
    }

    private boolean isPrefixOfAny(IndexSearchDescriptor desc, List<IndexSearchDescriptor> result) {
        for (IndexSearchDescriptor item : result) {
            if (!this.isPrefixOf(desc, item)) continue;
            return true;
        }
        return false;
    }

    private List<IndexSearchDescriptor> findPrefixes(IndexSearchDescriptor desc, List<IndexSearchDescriptor> descriptors) {
        ArrayList<IndexSearchDescriptor> result = new ArrayList<IndexSearchDescriptor>();
        for (IndexSearchDescriptor item : descriptors) {
            if (!this.isPrefixOf(item, desc)) continue;
            result.add(item);
        }
        return result;
    }

    private boolean isPrefixOf(IndexSearchDescriptor item, IndexSearchDescriptor desc) {
        List<OBooleanExpression> left = item.keyCondition.getSubBlocks();
        List<OBooleanExpression> right = desc.keyCondition.getSubBlocks();
        if (left.size() > right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i).equals(right.get(i))) continue;
            return false;
        }
        return true;
    }

    private IndexSearchDescriptor buildIndexSearchDescriptor(OCommandContext ctx, OIndex<?> index, OAndBlock block, OClass clazz) {
        List<String> indexFields = index.getDefinition().getFields();
        OBinaryCondition keyCondition = new OBinaryCondition(-1);
        OIdentifier key = new OIdentifier("key");
        keyCondition.setLeft(new OExpression(key));
        boolean allowsRange = this.allowsRangeQueries(index);
        boolean found = false;
        OAndBlock blockCopy = block.copy();
        OAndBlock indexKeyValue = new OAndBlock(-1);
        IndexSearchDescriptor result = new IndexSearchDescriptor();
        result.idx = index;
        result.keyCondition = indexKeyValue;
        for (String indexField : indexFields) {
            Iterator<OBooleanExpression> blockIterator = blockCopy.getSubBlocks().iterator();
            boolean breakHere = false;
            boolean indexFieldFound = false;
            block1: while (blockIterator.hasNext()) {
                OBooleanExpression condition;
                String fieldName;
                OExpression left;
                OBooleanExpression singleExp = blockIterator.next();
                if (singleExp instanceof OBinaryCondition) {
                    OBinaryCondition condition2;
                    left = ((OBinaryCondition)singleExp).getLeft();
                    if (!left.isBaseIdentifier() || !indexField.equals(fieldName = left.getDefaultAlias().getStringValue())) continue;
                    OBinaryCompareOperator operator = ((OBinaryCondition)singleExp).getOperator();
                    if (!((OBinaryCondition)singleExp).getRight().isEarlyCalculated(ctx)) continue;
                    if (operator instanceof OEqualsCompareOperator) {
                        found = true;
                        indexFieldFound = true;
                        condition2 = new OBinaryCondition(-1);
                        condition2.setLeft(left);
                        condition2.setOperator(operator);
                        condition2.setRight(((OBinaryCondition)singleExp).getRight().copy());
                        indexKeyValue.getSubBlocks().add(condition2);
                        blockIterator.remove();
                        break;
                    }
                    if (operator instanceof OContainsKeyOperator && this.isMap(clazz, indexField) && this.isIndexByKey(index, indexField)) {
                        found = true;
                        indexFieldFound = true;
                        condition2 = new OBinaryCondition(-1);
                        condition2.setLeft(left);
                        condition2.setOperator(operator);
                        condition2.setRight(((OBinaryCondition)singleExp).getRight().copy());
                        indexKeyValue.getSubBlocks().add(condition2);
                        blockIterator.remove();
                        break;
                    }
                    if (!allowsRange || !operator.isRangeOperator()) continue;
                    found = true;
                    indexFieldFound = true;
                    breakHere = true;
                    condition2 = new OBinaryCondition(-1);
                    condition2.setLeft(left);
                    condition2.setOperator(operator);
                    condition2.setRight(((OBinaryCondition)singleExp).getRight().copy());
                    indexKeyValue.getSubBlocks().add(condition2);
                    blockIterator.remove();
                    while (blockIterator.hasNext()) {
                        OBooleanExpression next = blockIterator.next();
                        if (!this.createsRangeWith((OBinaryCondition)singleExp, next)) continue;
                        result.additionalRangeCondition = (OBinaryCondition)next;
                        blockIterator.remove();
                        break block1;
                    }
                    break;
                }
                if (singleExp instanceof OContainsValueCondition && ((OContainsValueCondition)singleExp).getExpression() != null && this.isMap(clazz, indexField) && this.isIndexByValue(index, indexField)) {
                    left = ((OContainsValueCondition)singleExp).getLeft();
                    if (!left.isBaseIdentifier() || !indexField.equals(fieldName = left.getDefaultAlias().getStringValue())) continue;
                    found = true;
                    indexFieldFound = true;
                    condition = new OBinaryCondition(-1);
                    ((OBinaryCondition)condition).setLeft(left);
                    ((OBinaryCondition)condition).setOperator(new OContainsValueOperator(-1));
                    ((OBinaryCondition)condition).setRight(((OContainsValueCondition)singleExp).getExpression().copy());
                    indexKeyValue.getSubBlocks().add(condition);
                    blockIterator.remove();
                    break;
                }
                if (singleExp instanceof OContainsAnyCondition) {
                    left = ((OContainsAnyCondition)singleExp).getLeft();
                    if (!left.isBaseIdentifier() || !indexField.equals(fieldName = left.getDefaultAlias().getStringValue()) || !((OContainsAnyCondition)singleExp).getRight().isEarlyCalculated(ctx)) continue;
                    found = true;
                    indexFieldFound = true;
                    condition = new OContainsAnyCondition(-1);
                    ((OContainsAnyCondition)condition).setLeft(left);
                    ((OContainsAnyCondition)condition).setRight(((OContainsAnyCondition)singleExp).getRight().copy());
                    indexKeyValue.getSubBlocks().add(condition);
                    blockIterator.remove();
                    break;
                }
                if (!(singleExp instanceof OInCondition) || !(left = ((OInCondition)singleExp).getLeft()).isBaseIdentifier() || !indexField.equals(fieldName = left.getDefaultAlias().getStringValue())) continue;
                if (((OInCondition)singleExp).getRightMathExpression() != null) {
                    if (!((OInCondition)singleExp).getRightMathExpression().isEarlyCalculated(ctx)) continue;
                    found = true;
                    indexFieldFound = true;
                    condition = new OInCondition(-1);
                    ((OInCondition)condition).setLeft(left);
                    ((OInCondition)condition).setRightMathExpression(((OInCondition)singleExp).getRightMathExpression().copy());
                    indexKeyValue.getSubBlocks().add(condition);
                    blockIterator.remove();
                    break;
                }
                if (((OInCondition)singleExp).getRightParam() == null) continue;
                found = true;
                indexFieldFound = true;
                condition = new OInCondition(-1);
                ((OInCondition)condition).setLeft(left);
                ((OInCondition)condition).setRightParam(((OInCondition)singleExp).getRightParam().copy());
                indexKeyValue.getSubBlocks().add(condition);
                blockIterator.remove();
                break;
            }
            if (!breakHere && indexFieldFound) continue;
            break;
        }
        if (result.keyCondition.getSubBlocks().size() < index.getDefinition().getFields().size() && !index.supportsOrderedIterations()) {
            return null;
        }
        if (found) {
            result.remainingCondition = blockCopy;
            return result;
        }
        return null;
    }

    private boolean isIndexByKey(OIndex<?> index, String field) {
        OIndexDefinition def = index.getDefinition();
        for (String o : def.getFieldsToIndex()) {
            if (!o.equalsIgnoreCase(field + " by key")) continue;
            return true;
        }
        return false;
    }

    private boolean isIndexByValue(OIndex<?> index, String field) {
        OIndexDefinition def = index.getDefinition();
        for (String o : def.getFieldsToIndex()) {
            if (!o.equalsIgnoreCase(field + " by value")) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(OClass clazz, String indexField) {
        OProperty prop = clazz.getProperty(indexField);
        if (prop == null) {
            return false;
        }
        return prop.getType() == OType.EMBEDDEDMAP;
    }

    private boolean createsRangeWith(OBinaryCondition left, OBooleanExpression next) {
        if (!(next instanceof OBinaryCondition)) {
            return false;
        }
        OBinaryCondition right = (OBinaryCondition)next;
        if (!left.getLeft().equals(right.getLeft())) {
            return false;
        }
        OBinaryCompareOperator leftOperator = left.getOperator();
        OBinaryCompareOperator rightOperator = right.getOperator();
        if (leftOperator instanceof OGeOperator || leftOperator instanceof OGtOperator) {
            return rightOperator instanceof OLeOperator || rightOperator instanceof OLtOperator;
        }
        if (leftOperator instanceof OLeOperator || leftOperator instanceof OLtOperator) {
            return rightOperator instanceof OGeOperator || rightOperator instanceof OGtOperator;
        }
        return false;
    }

    private boolean allowsRangeQueries(OIndex<?> index) {
        return index.supportsOrderedIterations();
    }

    private List<IndexSearchDescriptor> commonFactor(List<IndexSearchDescriptor> indexSearchDescriptors) {
        HashMap aggregation = new HashMap();
        for (IndexSearchDescriptor item : indexSearchDescriptors) {
            IndexCondPair extendedCond;
            OOrBlock existingAdditionalConditions;
            HashMap<IndexCondPair, OOrBlock> filtersForIndex = (HashMap<IndexCondPair, OOrBlock>)aggregation.get(item.idx);
            if (filtersForIndex == null) {
                filtersForIndex = new HashMap<IndexCondPair, OOrBlock>();
                aggregation.put(item.idx, filtersForIndex);
            }
            if ((existingAdditionalConditions = (OOrBlock)filtersForIndex.get(extendedCond = new IndexCondPair(item.keyCondition, item.additionalRangeCondition))) == null) {
                existingAdditionalConditions = new OOrBlock(-1);
                filtersForIndex.put(extendedCond, existingAdditionalConditions);
            }
            existingAdditionalConditions.getSubBlocks().add(item.remainingCondition);
        }
        ArrayList<IndexSearchDescriptor> result = new ArrayList<IndexSearchDescriptor>();
        for (Map.Entry item : aggregation.entrySet()) {
            for (Map.Entry filters : ((Map)item.getValue()).entrySet()) {
                result.add(new IndexSearchDescriptor((OIndex)item.getKey(), ((IndexCondPair)filters.getKey()).mainCondition, ((IndexCondPair)filters.getKey()).additionalRange, (OBooleanExpression)filters.getValue()));
            }
        }
        return result;
    }

    private void handleClustersAsTarget(OSelectExecutionPlan plan, QueryPlanningInfo info, List<OCluster> clusters, OCommandContext ctx, boolean profilingEnabled) {
        ODatabase db = ctx.getDatabase();
        OClass candidateClass = null;
        boolean tryByIndex = true;
        HashSet<String> clusterNames = new HashSet<String>();
        for (OCluster cluster : clusters) {
            String name = cluster.getClusterName();
            Integer clusterId = cluster.getClusterNumber();
            if (name == null) {
                name = db.getClusterNameById(clusterId);
            }
            if (clusterId == null) {
                clusterId = db.getClusterIdByName(name);
            }
            if (name != null) {
                clusterNames.add(name);
                OClass clazz = db.getMetadata().getSchema().getClassByClusterId(clusterId);
                if (clazz == null) {
                    tryByIndex = false;
                    break;
                }
                if (candidateClass == null) {
                    candidateClass = clazz;
                    continue;
                }
                if (candidateClass.equals(clazz)) continue;
                candidateClass = null;
                tryByIndex = false;
                break;
            }
            tryByIndex = false;
            break;
        }
        if (tryByIndex) {
            OIdentifier clazz = new OIdentifier(candidateClass.getName());
            if (this.handleClassAsTargetWithIndexedFunction(plan, clusterNames, clazz, info, ctx, profilingEnabled)) {
                return;
            }
            if (this.handleClassAsTargetWithIndex(plan, clazz, clusterNames, info, ctx, profilingEnabled)) {
                return;
            }
            if (info.orderBy != null && this.handleClassWithIndexForSortOnly(plan, clazz, clusterNames, info, ctx, profilingEnabled)) {
                return;
            }
        }
        Boolean orderByRidAsc = null;
        if (this.isOrderByRidAsc(info)) {
            orderByRidAsc = true;
        } else if (this.isOrderByRidDesc(info)) {
            orderByRidAsc = false;
        }
        if (orderByRidAsc != null && info.serverToClusters.size() == 1) {
            info.orderApplied = true;
        }
        if (clusters.size() == 1) {
            OCluster cluster;
            cluster = clusters.get(0);
            Integer clusterId = cluster.getClusterNumber();
            if (clusterId == null) {
                clusterId = db.getClusterIdByName(cluster.getClusterName());
            }
            if (clusterId == null) {
                throw new OCommandExecutionException("Cluster " + cluster + " does not exist");
            }
            FetchFromClusterExecutionStep step = new FetchFromClusterExecutionStep(clusterId, ctx, profilingEnabled);
            if (Boolean.TRUE.equals(orderByRidAsc)) {
                step.setOrder(FetchFromClusterExecutionStep.ORDER_ASC);
            } else if (Boolean.FALSE.equals(orderByRidAsc)) {
                step.setOrder(FetchFromClusterExecutionStep.ORDER_DESC);
            }
            plan.chain(step);
        } else {
            int[] clusterIds = new int[clusters.size()];
            for (int i = 0; i < clusters.size(); ++i) {
                OCluster cluster = clusters.get(i);
                Integer clusterId = cluster.getClusterNumber();
                if (clusterId == null) {
                    clusterId = db.getClusterIdByName(cluster.getClusterName());
                }
                if (clusterId == null) {
                    throw new OCommandExecutionException("Cluster " + cluster + " does not exist");
                }
                clusterIds[i] = clusterId;
            }
            FetchFromClustersExecutionStep step = new FetchFromClustersExecutionStep(clusterIds, ctx, orderByRidAsc, profilingEnabled);
            plan.chain(step);
        }
    }

    private void handleSubqueryAsTarget(OSelectExecutionPlan plan, OStatement subQuery, OCommandContext ctx, boolean profilingEnabled) {
        OBasicCommandContext subCtx = new OBasicCommandContext();
        subCtx.setDatabase(ctx.getDatabase());
        subCtx.setParent(ctx);
        OInternalExecutionPlan subExecutionPlan = subQuery.createExecutionPlan(subCtx, profilingEnabled);
        plan.chain(new SubQueryStep(subExecutionPlan, ctx, subCtx, profilingEnabled));
    }

    private boolean isOrderByRidDesc(QueryPlanningInfo info) {
        OOrderByItem item;
        String recordAttr;
        if (!this.hasTargetWithSortedRids(info)) {
            return false;
        }
        if (info.orderBy == null) {
            return false;
        }
        return info.orderBy.getItems().size() == 1 && (recordAttr = (item = info.orderBy.getItems().get(0)).getRecordAttr()) != null && recordAttr.equalsIgnoreCase("@rid") && "DESC".equals(item.getType());
    }

    private boolean isOrderByRidAsc(QueryPlanningInfo info) {
        OOrderByItem item;
        String recordAttr;
        if (!this.hasTargetWithSortedRids(info)) {
            return false;
        }
        if (info.orderBy == null) {
            return false;
        }
        return info.orderBy.getItems().size() == 1 && (recordAttr = (item = info.orderBy.getItems().get(0)).getRecordAttr()) != null && recordAttr.equalsIgnoreCase("@rid") && (item.getType() == null || "ASC".equals(item.getType()));
    }

    private boolean hasTargetWithSortedRids(QueryPlanningInfo info) {
        if (info.target == null) {
            return false;
        }
        if (info.target.getItem() == null) {
            return false;
        }
        if (info.target.getItem().getIdentifier() != null) {
            return true;
        }
        if (info.target.getItem().getCluster() != null) {
            return true;
        }
        return info.target.getItem().getClusterList() != null;
    }
}

