/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.executor.CheckSafeDeleteStep;
import com.orientechnologies.orient.core.sql.executor.CountStep;
import com.orientechnologies.orient.core.sql.executor.DeleteFromIndexStep;
import com.orientechnologies.orient.core.sql.executor.DeleteStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromIndexValuesStep;
import com.orientechnologies.orient.core.sql.executor.FilterStep;
import com.orientechnologies.orient.core.sql.executor.GetValueFromIndexEntryStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.ODeleteStatement;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.List;

public class ODeleteExecutionPlanner {
    private final OFromClause fromClause;
    private final OWhereClause whereClause;
    private final boolean returnBefore;
    private final OLimit limit;
    private final boolean unsafe;

    public ODeleteExecutionPlanner(ODeleteStatement stm) {
        this.fromClause = stm.getFromClause() == null ? null : stm.getFromClause().copy();
        this.whereClause = stm.getWhereClause() == null ? null : stm.getWhereClause().copy();
        this.returnBefore = stm.isReturnBefore();
        this.limit = stm.getLimit() == null ? null : stm.getLimit();
        this.unsafe = stm.isUnsafe();
    }

    public ODeleteExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        ODeleteExecutionPlan result = new ODeleteExecutionPlan(ctx);
        if (this.handleIndexAsTarget(result, this.fromClause.getItem().getIndex(), this.whereClause, ctx, enableProfiling)) {
            if (this.limit != null) {
                throw new OCommandExecutionException("Cannot apply a LIMIT on a delete from index");
            }
            if (this.unsafe) {
                throw new OCommandExecutionException("Cannot apply a UNSAFE on a delete from index");
            }
            if (this.returnBefore) {
                throw new OCommandExecutionException("Cannot apply a RETURN BEFORE on a delete from index");
            }
            this.handleReturn(result, ctx, this.returnBefore, enableProfiling);
        } else {
            this.handleTarget(result, ctx, this.fromClause, this.whereClause, enableProfiling);
            this.handleUnsafe(result, ctx, this.unsafe, enableProfiling);
            this.handleLimit(result, ctx, this.limit, enableProfiling);
            this.handleDelete(result, ctx, enableProfiling);
            this.handleReturn(result, ctx, this.returnBefore, enableProfiling);
        }
        return result;
    }

    private boolean handleIndexAsTarget(ODeleteExecutionPlan result, OIndexIdentifier indexIdentifier, OWhereClause whereClause, OCommandContext ctx, boolean profilingEnabled) {
        if (indexIdentifier == null) {
            return false;
        }
        String indexName = indexIdentifier.getIndexName();
        OIndex<?> index = ctx.getDatabase().getMetadata().getIndexManager().getIndex(indexName);
        if (index == null) {
            throw new OCommandExecutionException("Index not found: " + indexName);
        }
        List<OAndBlock> flattenedWhereClause = whereClause == null ? null : whereClause.flatten();
        switch (indexIdentifier.getType()) {
            case INDEX: {
                OBooleanExpression keyCondition = null;
                OBooleanExpression ridCondition = null;
                if (flattenedWhereClause == null || flattenedWhereClause.size() == 0) {
                    if (!index.supportsOrderedIterations()) {
                        throw new OCommandExecutionException("Index " + indexName + " does not allow iteration without a condition");
                    }
                } else {
                    if (flattenedWhereClause.size() > 1) {
                        throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + whereClause);
                    }
                    OAndBlock andBlock = flattenedWhereClause.get(0);
                    if (andBlock.getSubBlocks().size() == 1) {
                        whereClause = null;
                        flattenedWhereClause = null;
                        keyCondition = this.getKeyCondition(andBlock);
                        if (keyCondition == null) {
                            throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + whereClause);
                        }
                    } else if (andBlock.getSubBlocks().size() == 2) {
                        whereClause = null;
                        flattenedWhereClause = null;
                        keyCondition = this.getKeyCondition(andBlock);
                        ridCondition = this.getRidCondition(andBlock);
                        if (keyCondition == null || ridCondition == null) {
                            throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + whereClause);
                        }
                    } else {
                        throw new OCommandExecutionException("Index queries with this kind of condition are not supported yet: " + whereClause);
                    }
                }
                result.chain(new DeleteFromIndexStep(index, keyCondition, null, ridCondition, ctx, profilingEnabled));
                if (ridCondition != null) {
                    OWhereClause where = new OWhereClause(-1);
                    where.setBaseExpression(ridCondition);
                    result.chain(new FilterStep(where, ctx, profilingEnabled));
                }
                return true;
            }
            case VALUES: 
            case VALUESASC: {
                if (!index.supportsOrderedIterations()) {
                    throw new OCommandExecutionException("Index " + indexName + " does not allow iteration on values");
                }
                result.chain(new FetchFromIndexValuesStep(index, true, ctx, profilingEnabled));
                result.chain(new GetValueFromIndexEntryStep(ctx, null, profilingEnabled));
                break;
            }
            case VALUESDESC: {
                if (!index.supportsOrderedIterations()) {
                    throw new OCommandExecutionException("Index " + indexName + " does not allow iteration on values");
                }
                result.chain(new FetchFromIndexValuesStep(index, false, ctx, profilingEnabled));
                result.chain(new GetValueFromIndexEntryStep(ctx, null, profilingEnabled));
            }
        }
        return false;
    }

    private void handleDelete(ODeleteExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new DeleteStep(ctx, profilingEnabled));
    }

    private void handleUnsafe(ODeleteExecutionPlan result, OCommandContext ctx, boolean unsafe, boolean profilingEnabled) {
        if (!unsafe) {
            result.chain(new CheckSafeDeleteStep(ctx, profilingEnabled));
        }
    }

    private void handleReturn(ODeleteExecutionPlan result, OCommandContext ctx, boolean returnBefore, boolean profilingEnabled) {
        if (!returnBefore) {
            result.chain(new CountStep(ctx, profilingEnabled));
        }
    }

    private void handleLimit(OUpdateExecutionPlan plan, OCommandContext ctx, OLimit limit, boolean profilingEnabled) {
        if (limit != null) {
            plan.chain(new LimitExecutionStep(limit, ctx, profilingEnabled));
        }
    }

    private void handleTarget(OUpdateExecutionPlan result, OCommandContext ctx, OFromClause target, OWhereClause whereClause, boolean profilingEnabled) {
        OSelectStatement sourceStatement = new OSelectStatement(-1);
        sourceStatement.setTarget(target);
        sourceStatement.setWhereClause(whereClause);
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(sourceStatement);
        result.chain(new SubQueryStep(planner.createExecutionPlan(ctx, profilingEnabled, true), ctx, ctx, profilingEnabled));
    }

    private OBooleanExpression getKeyCondition(OAndBlock andBlock) {
        for (OBooleanExpression exp : andBlock.getSubBlocks()) {
            String str = exp.toString();
            if (str.length() < 5 || !str.substring(0, 4).equalsIgnoreCase("key ")) continue;
            return exp;
        }
        return null;
    }

    private OBooleanExpression getRidCondition(OAndBlock andBlock) {
        for (OBooleanExpression exp : andBlock.getSubBlocks()) {
            String str = exp.toString();
            if (str.length() < 5 || !str.substring(0, 4).equalsIgnoreCase("rid ")) continue;
            return exp;
        }
        return null;
    }
}

