/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;

public class MatchPrefetchStep
extends AbstractExecutionStep {
    public static final String PREFETCHED_MATCH_ALIAS_PREFIX = "__$$OrientDB_Prefetched_Alias_Prefix__";
    private final String alias;
    private final OInternalExecutionPlan prefetchExecutionPlan;
    boolean executed = false;

    public MatchPrefetchStep(OCommandContext ctx, OInternalExecutionPlan prefetchExecPlan, String alias, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.prefetchExecutionPlan = prefetchExecPlan;
        this.alias = alias;
    }

    @Override
    public void reset() {
        this.executed = false;
        this.prefetchExecutionPlan.reset(this.ctx);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (!this.executed) {
            this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
            OResultSet nextBlock = this.prefetchExecutionPlan.fetchNext(nRecords);
            ArrayList<OResult> prefetched = new ArrayList<OResult>();
            while (nextBlock.hasNext()) {
                while (nextBlock.hasNext()) {
                    prefetched.add(nextBlock.next());
                }
                nextBlock = this.prefetchExecutionPlan.fetchNext(nRecords);
            }
            this.prefetchExecutionPlan.close();
            ctx.setVariable(PREFETCHED_MATCH_ALIAS_PREFIX + this.alias, prefetched);
            this.executed = true;
        }
        return new OInternalResultSet();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ PREFETCH " + this.alias + "\n");
        result.append(this.prefetchExecutionPlan.prettyPrint(depth + 1, indent));
        return result.toString();
    }
}

