/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Map;
import java.util.Optional;

public class LetExpressionStep
extends AbstractExecutionStep {
    private OIdentifier varname;
    private OExpression expression;

    public LetExpressionStep(OIdentifier varName, OExpression expression, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.varname = varName;
        this.expression = expression;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.getPrev().isPresent()) {
            throw new OCommandExecutionException("Cannot execute a local LET on a query without a target");
        }
        return new OResultSet(){
            OResultSet source;
            {
                this.source = LetExpressionStep.this.getPrev().get().syncPull(ctx, nRecords);
            }

            @Override
            public boolean hasNext() {
                return this.source.hasNext();
            }

            @Override
            public OResult next() {
                OResultInternal result = (OResultInternal)this.source.next();
                Object value = LetExpressionStep.this.expression.execute(result, ctx);
                result.setMetadata(LetExpressionStep.this.varname.getStringValue(), value);
                return result;
            }

            @Override
            public void close() {
                this.source.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ LET (for each record)\n" + spaces + "  " + this.varname + " = " + this.expression;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        if (this.varname != null) {
            result.setProperty("varname", this.varname.serialize());
        }
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            if (fromResult.getProperty("varname") != null) {
                this.varname = OIdentifier.deserialize((OResult)fromResult.getProperty("varname"));
            }
            if (fromResult.getProperty("expression") != null) {
                this.expression = new OExpression(-1);
                this.expression.deserialize((OResult)fromResult.getProperty("expression"));
            }
            this.reset();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

