/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Map;
import java.util.Optional;

public class CountFromClassStep
extends AbstractExecutionStep {
    private final OIdentifier target;
    private final String alias;
    private long cost = 0L;
    private boolean executed = false;

    public CountFromClassStep(OIdentifier targetClass, String alias, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.target = targetClass;
        this.alias = alias;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return !CountFromClassStep.this.executed;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (CountFromClassStep.this.executed) {
                    throw new IllegalStateException();
                }
                long begin = CountFromClassStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    OClass clazz = ctx.getDatabase().getClass(CountFromClassStep.this.target.getStringValue());
                    if (clazz == null) {
                        throw new OCommandExecutionException("Class " + CountFromClassStep.this.target.getStringValue() + " does not exist in the database schema");
                    }
                    long size = clazz.count();
                    CountFromClassStep.this.executed = true;
                    OResultInternal result = new OResultInternal();
                    result.setProperty(CountFromClassStep.this.alias, size);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (CountFromClassStep.this.profilingEnabled) {
                        CountFromClassStep.this.cost = CountFromClassStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }

            @Override
            public void reset() {
                CountFromClassStep.this.reset();
            }
        };
    }

    @Override
    public void reset() {
        this.executed = false;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ CALCULATE CLASS SIZE: " + this.target;
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

