/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import java.util.Map;
import java.util.Optional;

public class CopyDocumentStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public CopyDocumentStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult toCopy = upstream.next();
                long begin = CopyDocumentStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    ODocument resultDoc = null;
                    if (toCopy.isElement()) {
                        Object docToCopy = toCopy.getElement().get().getRecord();
                        if (docToCopy instanceof ODocument) {
                            resultDoc = ((ODocument)docToCopy).copy();
                            resultDoc.getIdentity().reset();
                            resultDoc.setClassName(null);
                            resultDoc.setDirty();
                        } else if (docToCopy instanceof OBlob) {
                            ORecordBytes newBlob = ((ORecordBytes)docToCopy).copy();
                            OResultInternal result = new OResultInternal();
                            result.setElement(newBlob);
                            OResultInternal oResultInternal = result;
                            return oResultInternal;
                        }
                    } else {
                        resultDoc = (ODocument)toCopy.toElement().getRecord();
                    }
                    OUpdatableResult oUpdatableResult = new OUpdatableResult(resultDoc);
                    return oUpdatableResult;
                }
                finally {
                    if (CopyDocumentStep.this.profilingEnabled) {
                        CopyDocumentStep.this.cost = CopyDocumentStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ COPY DOCUMENT");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

