/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClassDescendentOrder;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OIterableRecordSource;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class OCommandExecutorSQLResultsetAbstract
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest,
Iterable<OIdentifiable>,
OIterableRecordSource {
    protected static final String KEYWORD_FROM_2FIND = " FROM ";
    protected static final String KEYWORD_LET_2FIND = " LET ";
    protected OSQLAsynchQuery<ODocument> request;
    protected OSQLTarget parsedTarget;
    protected OSQLFilter compiledFilter;
    protected Map<String, Object> let = null;
    protected Iterator<? extends OIdentifiable> target;
    protected Iterable<OIdentifiable> tempResult;
    protected int resultCount;
    protected AtomicInteger serialTempRID = new AtomicInteger(0);
    protected int skip = 0;
    protected boolean lazyIteration = true;

    public OCommandExecutorSQLResultsetAbstract parse(OCommandRequest iRequest) {
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        this.init(textRequest);
        if (iRequest instanceof OSQLSynchQuery) {
            this.request = (OSQLSynchQuery)iRequest;
        } else if (iRequest instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iRequest;
        } else {
            this.request = new OSQLSynchQuery<ODocument>(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                this.request.setResultListener(textRequest.getResultListener());
            }
        }
        return this;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    public boolean isLazyIteration() {
        return this.lazyIteration;
    }

    public void setLazyIteration(boolean lazyIteration) {
        this.lazyIteration = lazyIteration;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    protected boolean assignTarget(Map<Object, Object> iArgs) {
        this.parameters = iArgs;
        if (this.parsedTarget == null) {
            return true;
        }
        if (iArgs != null && iArgs.size() > 0 && this.compiledFilter != null) {
            this.compiledFilter.bindParameters(iArgs);
        }
        if (this.target == null) {
            if (this.parsedTarget.getTargetClasses() != null) {
                this.searchInClasses();
            } else if (this.parsedTarget.getTargetIndexValues() != null) {
                this.target = new IndexValuesIterator(this.parsedTarget.getTargetIndexValues(), this.parsedTarget.isTargetIndexValuesAsc());
            } else if (this.parsedTarget.getTargetClusters() != null) {
                this.searchInClusters();
            } else if (this.parsedTarget.getTargetRecords() != null) {
                this.target = !this.lazyIteration && this.parsedTarget.getTargetQuery() != null ? ((Iterable)OCommandExecutorSQLResultsetAbstract.getDatabase().command(new OCommandSQL(this.parsedTarget.getTargetQuery())).execute(iArgs)).iterator() : (this.parsedTarget.getTargetRecords() instanceof OIterableRecordSource ? ((OIterableRecordSource)((Object)this.parsedTarget.getTargetRecords())).iterator(iArgs) : this.parsedTarget.getTargetRecords().iterator());
            } else if (this.parsedTarget.getTargetVariable() != null) {
                Object var = this.getContext().getVariable(this.parsedTarget.getTargetVariable());
                if (var == null) {
                    this.target = Collections.EMPTY_LIST.iterator();
                    return true;
                }
                if (var instanceof OIdentifiable) {
                    ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                    list.add((OIdentifiable)var);
                    this.target = list.iterator();
                } else if (var instanceof Iterable) {
                    this.target = ((Iterable)var).iterator();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected Object getResultInstance() {
        if (this.request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)this.request).getResult();
        }
        return this.request.getResultListener().getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getResult() {
        try {
            if (this.tempResult != null) {
                int fetched = 0;
                for (OIdentifiable d : this.tempResult) {
                    if (d == null) continue;
                    d = !(d instanceof OIdentifiable) ? new ODocument().field("value", d) : d.getRecord();
                    if (this.limit > -1 && fetched >= this.limit || !this.pushResult(d)) break;
                    ++fetched;
                }
            }
            Object object = this.getResultInstance();
            return object;
        }
        finally {
            this.request.getResultListener().end();
        }
    }

    protected boolean pushResult(Object rec) {
        ODatabaseDocumentInternal db;
        if (rec instanceof ORecord && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
            db.getLocalCache().updateRecord((ORecord)rec);
        }
        return this.request.getResultListener().result(rec);
    }

    protected boolean handleResult(OIdentifiable iRecord, OCommandContext iContext) {
        if (iRecord != null) {
            boolean result;
            OIdentifiable identifiable;
            ++this.resultCount;
            OIdentifiable oIdentifiable = identifiable = iRecord instanceof ORecord ? (ORecord)iRecord : iRecord.getIdentity();
            if (identifiable != null && this.request.getResultListener() != null && !(result = this.pushResult(identifiable))) {
                return false;
            }
            if (this.limit > -1 && this.resultCount >= this.limit) {
                return false;
            }
        }
        return true;
    }

    protected void parseLet() {
        this.let = new LinkedHashMap<String, Object>();
        boolean stop = false;
        while (!stop) {
            String letName = this.parserNextWord(false);
            this.parserOptionalKeyword("=");
            this.parserNextWord(false, " =><,\r\n", true);
            String letValueAsString = this.parserGetLastWord();
            OSQLFunctionRuntime func = OSQLHelper.getFunction(this.parsedTarget, letValueAsString);
            Object letValue = func != null ? func : (letValueAsString.startsWith("(") ? new OSQLSynchQuery(letValueAsString.substring(1, letValueAsString.length() - 1)) : letValueAsString);
            this.let.put(letName, letValue);
            stop = this.parserGetLastSeparator() == ' ';
        }
    }

    protected int parseLimit(String w) throws OCommandSQLParsingException {
        if (!w.equals("LIMIT")) {
            return -1;
        }
        String word = this.parserNextWord(true);
        try {
            this.limit = Integer.parseInt(word);
        }
        catch (NumberFormatException ignore) {
            this.throwParsingException("Invalid LIMIT value setted to '" + word + "' but it should be a valid integer. Example: LIMIT 10");
        }
        if (this.limit == 0) {
            this.throwParsingException("Invalid LIMIT value setted to ZERO. Use -1 to ignore the limit or use a positive number. Example: LIMIT 10");
        }
        return this.limit;
    }

    protected int parseSkip(String w) throws OCommandSQLParsingException {
        if (!w.equals("SKIP") && !w.equals("OFFSET")) {
            return -1;
        }
        String word = this.parserNextWord(true);
        try {
            this.skip = Integer.parseInt(word);
        }
        catch (NumberFormatException ignore) {
            this.throwParsingException("Invalid SKIP value setted to '" + word + "' but it should be a valid positive integer. Example: SKIP 10");
        }
        if (this.skip < 0) {
            this.throwParsingException("Invalid SKIP value setted to the negative number '" + word + "'. Only positive numbers are valid. Example: SKIP 10");
        }
        return this.skip;
    }

    protected boolean filter(ORecord iRecord, OCommandContext iContext) {
        if (iRecord instanceof ODocument) {
            ODocument recordSchemaAware = (ODocument)iRecord;
            Map<String, String> targetClasses = this.parsedTarget.getTargetClasses();
            if (targetClasses != null && !targetClasses.isEmpty()) {
                for (String targetClass : targetClasses.keySet()) {
                    if (((OMetadataDefault)OCommandExecutorSQLResultsetAbstract.getDatabase().getMetadata()).getImmutableSchemaSnapshot().getClass(targetClass).isSuperClassOf(ODocumentInternal.getImmutableSchemaClass(recordSchemaAware))) continue;
                    return false;
                }
                iContext.updateMetric("documentAnalyzedCompatibleClass", 1L);
            }
        }
        return this.evaluateRecord(iRecord, iContext);
    }

    protected boolean evaluateRecord(ORecord iRecord, OCommandContext iContext) {
        iContext.setVariable("current", iRecord);
        iContext.updateMetric("evaluated", 1L);
        this.assignLetClauses(iRecord);
        if (this.compiledFilter == null) {
            return true;
        }
        Boolean evaluate = (Boolean)this.compiledFilter.evaluate(iRecord, null, iContext);
        return evaluate == null ? false : evaluate;
    }

    protected void assignLetClauses(ORecord iRecord) {
        if (this.let != null && !this.let.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.let.entrySet()) {
                OLegacyResultSet varValue;
                Object letValue;
                String varName = entry.getKey();
                if (varName.startsWith("$")) {
                    varName = varName.substring(1);
                }
                if ((letValue = entry.getValue()) instanceof OSQLSynchQuery) {
                    OSQLSynchQuery subQuery = (OSQLSynchQuery)letValue;
                    subQuery.reset();
                    subQuery.resetPagination();
                    subQuery.getContext().setParent(this.context);
                    subQuery.getContext().setVariable("parentQuery", this);
                    subQuery.getContext().setVariable("current", iRecord);
                    varValue = ODatabaseRecordThreadLocal.instance().get().query(subQuery, new Object[0]);
                    if (varValue instanceof OLegacyResultSet) {
                        varValue = ((OLegacyResultSet)varValue).copy();
                    }
                } else if (letValue instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)letValue;
                    if (f.getFunction().aggregateResults()) {
                        f.execute(iRecord, iRecord, null, this.context);
                        varValue = f.getFunction().getResult();
                    } else {
                        varValue = f.execute(iRecord, iRecord, null, this.context);
                    }
                } else if (letValue instanceof String) {
                    OSQLPredicate pred = new OSQLPredicate(((String)letValue).trim());
                    varValue = pred.evaluate(iRecord, (ODocument)iRecord, this.context);
                } else {
                    varValue = letValue;
                }
                this.context.setVariable(varName, varValue);
            }
        }
    }

    protected void searchInClasses() {
        this.searchInClasses(true);
    }

    protected void searchInClasses(boolean iAscendentOrder) {
        String cls = this.parsedTarget.getTargetClasses().keySet().iterator().next();
        this.target = this.searchInClasses(OCommandExecutorSQLResultsetAbstract.getDatabase().getMetadata().getSchema().getClass(cls), true, iAscendentOrder);
    }

    protected Iterator<? extends OIdentifiable> searchInClasses(OClass iCls, boolean iPolymorphic, boolean iAscendentOrder) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iCls.getName().toLowerCase(Locale.ENGLISH));
        ORID[] range = this.getRange();
        if (iAscendentOrder) {
            return new ORecordIteratorClass(database, iCls.getName(), iPolymorphic, false).setRange(range[0], range[1]);
        }
        return new ORecordIteratorClassDescendentOrder(database, database, iCls.getName(), iPolymorphic).setRange(range[0], range[1]);
    }

    protected boolean isUseCache() {
        return this.request.isUseCache();
    }

    protected void searchInClusters() {
        ODatabaseDocumentInternal database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        HashSet<Integer> clusterIds = new HashSet<Integer>();
        for (String clusterName : this.parsedTarget.getTargetClusters().keySet()) {
            if (clusterName == null || clusterName.length() == 0) {
                throw new OCommandExecutionException("No cluster or schema class selected in query");
            }
            database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)clusterName.toLowerCase(Locale.ENGLISH));
            if (Character.isDigit(clusterName.charAt(0))) {
                for (int clusterId : OStringSerializerHelper.splitIntArray(clusterName)) {
                    if (clusterId == -1) {
                        throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
                    }
                    clusterIds.add(clusterId);
                }
                continue;
            }
            int clusterId = database.getClusterIdByName(clusterName.toLowerCase(Locale.ENGLISH));
            if (clusterId == -1) {
                throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
            }
            clusterIds.add(clusterId);
        }
        int[] clIds = new int[clusterIds.size()];
        int i = 0;
        Iterator clusterId = clusterIds.iterator();
        while (clusterId.hasNext()) {
            int c = (Integer)clusterId.next();
            clIds[i++] = c;
        }
        ORID[] range = this.getRange();
        this.target = new ORecordIteratorClusters(database, clIds).setRange(range[0], range[1]);
    }

    protected void applyLimitAndSkip() {
        if (this.tempResult != null && (this.limit > 0 || this.skip > 0)) {
            ArrayList<OIdentifiable> newList = new ArrayList<OIdentifiable>();
            if (this.tempResult instanceof List) {
                List t = (List)this.tempResult;
                int start = Math.min(this.skip, t.size());
                int tot = t.size();
                if (this.limit > -1) {
                    tot = Math.min(this.limit + start, tot);
                }
                for (int i = start; i < tot; ++i) {
                    newList.add((OIdentifiable)t.get(i));
                }
                t.clear();
                this.tempResult = newList;
            }
        }
    }

    protected void optimize() {
        if (this.compiledFilter != null) {
            this.optimizeBranch(null, this.compiledFilter.getRootCondition());
        }
    }

    protected Object optimizeFunction(OSQLFunctionRuntime function) {
        return function;
    }

    protected void optimizeBranch(OSQLFilterCondition iParentCondition, OSQLFilterCondition iCondition) {
        if (iCondition == null) {
            return;
        }
        Object left = iCondition.getLeft();
        if (left instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)left);
        } else if (left instanceof OSQLFunctionRuntime) {
            left = this.optimizeFunction((OSQLFunctionRuntime)left);
            iCondition.setLeft(left);
        }
        Object right = iCondition.getRight();
        if (right instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)right);
        } else if (right instanceof OSQLFunctionRuntime) {
            right = this.optimizeFunction((OSQLFunctionRuntime)right);
            iCondition.setRight(right);
        }
        OQueryOperator oper = iCondition.getOperator();
        Boolean result = null;
        if (left instanceof OSQLFilterItemField && right instanceof OSQLFilterItemField && ((OSQLFilterItemField)left).getRoot().equals(((OSQLFilterItemField)right).getRoot())) {
            if (oper instanceof OQueryOperatorEquals) {
                result = Boolean.TRUE;
            } else if (oper instanceof OQueryOperatorNotEquals) {
                result = Boolean.FALSE;
            }
        }
        if (result != null) {
            if (iParentCondition != null) {
                if (iCondition == iParentCondition.getLeft()) {
                    iCondition.setLeft(result);
                } else {
                    iCondition.setRight(result);
                }
            } else if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                this.compiledFilter.setRootCondition(null);
            }
        }
    }

    protected ORID[] getRange() {
        ORID endRange;
        ORID beginRange;
        OSQLFilterCondition rootCondition;
        OSQLFilterCondition oSQLFilterCondition = rootCondition = this.compiledFilter == null ? null : this.compiledFilter.getRootCondition();
        if (this.compiledFilter == null || rootCondition == null) {
            beginRange = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            endRange = null;
        } else {
            ORID conditionBeginRange = rootCondition.getBeginRidRange();
            ORID conditionEndRange = rootCondition.getEndRidRange();
            ORID nextPageRid = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            beginRange = conditionBeginRange != null && nextPageRid != null ? (conditionBeginRange.compareTo(nextPageRid) > 0 ? conditionBeginRange : nextPageRid) : (conditionBeginRange != null ? conditionBeginRange : nextPageRid);
            endRange = conditionEndRange;
        }
        return new ORID[]{beginRange, endRange};
    }

    public Iterator<? extends OIdentifiable> getTarget() {
        return this.target;
    }

    public void setTarget(Iterator<? extends OIdentifiable> target) {
        this.target = target;
    }

    public void setRequest(OSQLAsynchQuery<ODocument> request) {
        this.request = request;
    }

    public void setParsedTarget(OSQLTarget parsedTarget) {
        this.parsedTarget = parsedTarget;
    }

    public void setCompiledFilter(OSQLFilter compiledFilter) {
        this.compiledFilter = compiledFilter;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public Object mergeResults(Map<String, Object> results) throws Exception {
        if (results.isEmpty()) {
            return null;
        }
        ArrayList<Object> mergedResult = new ArrayList<Object>();
        Object firstResult = results.values().iterator().next();
        for (Map.Entry<String, Object> entry : results.entrySet()) {
            String nodeName = entry.getKey();
            Object nodeResult = entry.getValue();
            if (nodeResult instanceof Collection) {
                mergedResult.addAll((Collection)nodeResult);
                continue;
            }
            if (nodeResult instanceof Exception) {
                throw (Exception)nodeResult;
            }
            mergedResult.add(nodeResult);
        }
        Object result = null;
        if (firstResult instanceof OLegacyResultSet) {
            ((OLegacyResultSet)firstResult).clear();
            ((OLegacyResultSet)firstResult).addAll(mergedResult);
            result = firstResult;
        } else {
            result = new ArrayList(mergedResult);
        }
        return result;
    }

    private static final class IndexValuesIterator
    implements Iterator<OIdentifiable> {
        private OIndexCursor indexCursor;
        private OIdentifiable nextValue;
        private boolean noItems;

        private IndexValuesIterator(String indexName, boolean ascOrder) {
            this.indexCursor = ascOrder ? OCommandExecutorAbstract.getDatabase().getMetadata().getIndexManager().getIndex(indexName).cursor() : OCommandExecutorAbstract.getDatabase().getMetadata().getIndexManager().getIndex(indexName).descCursor();
        }

        @Override
        public boolean hasNext() {
            if (this.noItems) {
                return false;
            }
            if (this.nextValue == null) {
                Map.Entry<Object, OIdentifiable> entry = this.indexCursor.nextEntry();
                if (entry == null) {
                    this.noItems = true;
                    return false;
                }
                this.nextValue = entry.getValue();
            }
            return true;
        }

        @Override
        public OIdentifiable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            OIdentifiable value = this.nextValue;
            this.nextValue = null;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

