/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCompactedLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class OMixedIndexRIDContainerSerializer
implements OBinarySerializer<OMixedIndexRIDContainer> {
    public static final OMixedIndexRIDContainerSerializer INSTANCE = new OMixedIndexRIDContainerSerializer();
    public static final byte ID = 23;

    @Override
    public int getObjectSize(OMixedIndexRIDContainer object, Object ... hints) {
        int size = 16;
        size += 12;
        Set<ORID> embedded = object.getEmbeddedSet();
        for (ORID orid : embedded) {
            size += OCompactedLinkSerializer.INSTANCE.getObjectSize(orid, new Object[0]);
        }
        return size;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
    }

    @Override
    public void serialize(OMixedIndexRIDContainer object, byte[] stream, int startPosition, Object ... hints) {
        int size = 16;
        size += 12;
        Set<ORID> embedded = object.getEmbeddedSet();
        for (ORID orid : embedded) {
            size += OCompactedLinkSerializer.INSTANCE.getObjectSize(orid, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serialize(size, stream, startPosition, new Object[0]);
        OLongSerializer.INSTANCE.serialize(object.getFileId(), stream, startPosition += 4, new Object[0]);
        OIntegerSerializer.INSTANCE.serialize(embedded.size(), stream, startPosition += 8, new Object[0]);
        startPosition += 4;
        for (ORID orid : embedded) {
            OCompactedLinkSerializer.INSTANCE.serialize(orid, stream, startPosition, new Object[0]);
            startPosition += OCompactedLinkSerializer.INSTANCE.getObjectSize(stream, startPosition);
        }
        OIndexRIDContainerSBTree tree = object.getTree();
        if (tree == null) {
            OLongSerializer.INSTANCE.serialize(-1L, stream, startPosition, new Object[0]);
            OIntegerSerializer.INSTANCE.serialize(-1, stream, startPosition += 8, new Object[0]);
        } else {
            OBonsaiBucketPointer rootPointer = tree.getRootPointer();
            OLongSerializer.INSTANCE.serialize(rootPointer.getPageIndex(), stream, startPosition, new Object[0]);
            OIntegerSerializer.INSTANCE.serialize(rootPointer.getPageOffset(), stream, startPosition += 8, new Object[0]);
        }
    }

    @Override
    public OMixedIndexRIDContainer deserialize(byte[] stream, int startPosition) {
        OIndexRIDContainerSBTree tree;
        long fileId = OLongSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        int embeddedSize = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition += 8);
        startPosition += 4;
        HashSet<ORID> hashSet = new HashSet<ORID>();
        for (int i = 0; i < embeddedSize; ++i) {
            ORID orid = OCompactedLinkSerializer.INSTANCE.deserialize(stream, startPosition).getIdentity();
            startPosition += OCompactedLinkSerializer.INSTANCE.getObjectSize(stream, startPosition);
            hashSet.add(orid);
        }
        long pageIndex = OLongSerializer.INSTANCE.deserialize(stream, startPosition);
        int offset = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition += 8);
        if (pageIndex == -1L) {
            tree = null;
        } else {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            tree = new OIndexRIDContainerSBTree(fileId, new OBonsaiBucketPointer(pageIndex, offset), true, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        }
        return new OMixedIndexRIDContainer(fileId, hashSet, tree);
    }

    @Override
    public byte getId() {
        return 23;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public void serializeNativeObject(OMixedIndexRIDContainer object, byte[] stream, int startPosition, Object ... hints) {
        int size = 16;
        size += 12;
        Set<ORID> embedded = object.getEmbeddedSet();
        for (ORID orid : embedded) {
            size += OCompactedLinkSerializer.INSTANCE.getObjectSize(orid, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serializeNative(size, stream, startPosition, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(object.getFileId(), stream, startPosition += 4, new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(embedded.size(), stream, startPosition += 8, new Object[0]);
        startPosition += 4;
        for (ORID orid : embedded) {
            OCompactedLinkSerializer.INSTANCE.serializeNativeObject(orid, stream, startPosition, new Object[0]);
            startPosition += OCompactedLinkSerializer.INSTANCE.getObjectSizeNative(stream, startPosition);
        }
        OIndexRIDContainerSBTree tree = object.getTree();
        if (tree == null) {
            OLongSerializer.INSTANCE.serializeNative(-1L, stream, startPosition, new Object[0]);
            OIntegerSerializer.INSTANCE.serializeNative(-1, stream, startPosition += 8, new Object[0]);
        } else {
            OBonsaiBucketPointer rootPointer = tree.getRootPointer();
            OLongSerializer.INSTANCE.serializeNative(rootPointer.getPageIndex(), stream, startPosition, new Object[0]);
            OIntegerSerializer.INSTANCE.serializeNative(rootPointer.getPageOffset(), stream, startPosition += 8, new Object[0]);
        }
    }

    @Override
    public OMixedIndexRIDContainer deserializeNativeObject(byte[] stream, int startPosition) {
        OIndexRIDContainerSBTree tree;
        long fileId = OLongSerializer.INSTANCE.deserializeNative(stream, startPosition += 4);
        int embeddedSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition += 8);
        startPosition += 4;
        HashSet<ORID> hashSet = new HashSet<ORID>();
        for (int i = 0; i < embeddedSize; ++i) {
            ORID orid = OCompactedLinkSerializer.INSTANCE.deserializeNativeObject(stream, startPosition).getIdentity();
            startPosition += OCompactedLinkSerializer.INSTANCE.getObjectSizeNative(stream, startPosition);
            hashSet.add(orid);
        }
        long pageIndex = OLongSerializer.INSTANCE.deserializeNative(stream, startPosition);
        int offset = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition += 8);
        if (pageIndex == -1L) {
            tree = null;
        } else {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            tree = new OIndexRIDContainerSBTree(fileId, new OBonsaiBucketPointer(pageIndex, offset), true, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        }
        return new OMixedIndexRIDContainer(fileId, hashSet, tree);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    @Override
    public OMixedIndexRIDContainer preprocess(OMixedIndexRIDContainer value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(OMixedIndexRIDContainer object, ByteBuffer buffer, Object ... hints) {
        int size = 16;
        size += 12;
        Set<ORID> embedded = object.getEmbeddedSet();
        for (ORID orid : embedded) {
            size += OCompactedLinkSerializer.INSTANCE.getObjectSize(orid, new Object[0]);
        }
        buffer.putInt(size);
        buffer.putLong(object.getFileId());
        buffer.putInt(embedded.size());
        for (ORID orid : embedded) {
            OCompactedLinkSerializer.INSTANCE.serializeInByteBufferObject(orid, buffer, new Object[0]);
        }
        OIndexRIDContainerSBTree tree = object.getTree();
        if (tree == null) {
            buffer.putLong(-1L);
            buffer.putInt(-1);
        } else {
            OBonsaiBucketPointer rootPointer = tree.getRootPointer();
            buffer.putLong(rootPointer.getPageIndex());
            buffer.putInt(rootPointer.getPageOffset());
        }
    }

    @Override
    public OMixedIndexRIDContainer deserializeFromByteBufferObject(ByteBuffer buffer) {
        OIndexRIDContainerSBTree tree;
        buffer.position(buffer.position() + 4);
        long fileId = buffer.getLong();
        int embeddedSize = buffer.getInt();
        HashSet<ORID> hashSet = new HashSet<ORID>();
        for (int i = 0; i < embeddedSize; ++i) {
            ORID orid = OCompactedLinkSerializer.INSTANCE.deserializeFromByteBufferObject(buffer).getIdentity();
            hashSet.add(orid);
        }
        long pageIndex = buffer.getLong();
        int offset = buffer.getInt();
        if (pageIndex == -1L) {
            tree = null;
        } else {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            tree = new OIndexRIDContainerSBTree(fileId, new OBonsaiBucketPointer(pageIndex, offset), true, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        }
        return new OMixedIndexRIDContainer(fileId, hashSet, tree);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public OMixedIndexRIDContainer deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        OIndexRIDContainerSBTree tree;
        long fileId = walChanges.getLongValue(buffer, offset += 4);
        int embeddedSize = walChanges.getIntValue(buffer, offset += 8);
        offset += 4;
        HashSet<ORID> hashSet = new HashSet<ORID>();
        for (int i = 0; i < embeddedSize; ++i) {
            ORID orid = OCompactedLinkSerializer.INSTANCE.deserializeFromByteBufferObject(buffer, walChanges, offset).getIdentity();
            offset += OCompactedLinkSerializer.INSTANCE.getObjectSizeInByteBuffer(buffer, walChanges, offset);
            hashSet.add(orid);
        }
        long pageIndex = walChanges.getLongValue(buffer, offset);
        int pageOffset = walChanges.getIntValue(buffer, offset += 8);
        if (pageIndex == -1L) {
            tree = null;
        } else {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            tree = new OIndexRIDContainerSBTree(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset), true, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        }
        return new OMixedIndexRIDContainer(fileId, hashSet, tree);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset);
    }
}

