/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class OSequenceLibraryImpl {
    private final Map<String, OSequence> sequences = new ConcurrentHashMap<String, OSequence>();
    private final AtomicBoolean reloadNeeded = new AtomicBoolean(false);

    public void create(ODatabaseDocumentInternal database) {
        this.init(database);
    }

    public synchronized void load(ODatabaseDocumentInternal db) {
        this.sequences.clear();
        if (db.getMetadata().getImmutableSchemaSnapshot().existsClass("OSequence")) {
            try (OResultSet result = db.query("SELECT FROM OSequence", new Object[0]);){
                while (result.hasNext()) {
                    OResult res = result.next();
                    OSequence sequence = OSequenceHelper.createSequence((ODocument)res.getElement().get());
                    this.sequences.put(sequence.getName().toUpperCase(Locale.ENGLISH), sequence);
                }
            }
        }
    }

    public void close() {
        this.sequences.clear();
    }

    public synchronized Set<String> getSequenceNames(ODatabaseDocumentInternal database) {
        this.reloadIfNeeded(database);
        return this.sequences.keySet();
    }

    public synchronized int getSequenceCount(ODatabaseDocumentInternal database) {
        this.reloadIfNeeded(database);
        return this.sequences.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSequence getSequence(ODatabaseDocumentInternal database, String iName) {
        OSequence seq;
        String name = iName.toUpperCase(Locale.ENGLISH);
        this.reloadIfNeeded(database);
        OSequenceLibraryImpl oSequenceLibraryImpl = this;
        synchronized (oSequenceLibraryImpl) {
            seq = this.sequences.get(name);
            if (seq == null) {
                this.load(database);
                seq = this.sequences.get(name);
            }
        }
        if (seq != null) {
            seq.bindOnLocalThread();
        }
        return seq;
    }

    public synchronized OSequence createSequence(ODatabaseDocumentInternal database, String iName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params) {
        this.init(database);
        this.reloadIfNeeded(database);
        String key = iName.toUpperCase(Locale.ENGLISH);
        this.validateSequenceNoExists(key);
        OSequence sequence = OSequenceHelper.createSequence(sequenceType, params, null).setName(iName);
        sequence.save(database);
        this.sequences.put(key, sequence);
        return sequence;
    }

    public synchronized void dropSequence(ODatabaseDocumentInternal database, String iName) {
        OSequence seq = this.getSequence(database, iName);
        if (seq != null) {
            database.delete(seq.getDocument().getIdentity());
            this.sequences.remove(iName.toUpperCase(Locale.ENGLISH));
        }
    }

    public OSequence onSequenceCreated(ODatabaseDocumentInternal database, ODocument iDocument) {
        this.init(database);
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence seq = this.getSequence(database, name = name.toUpperCase(Locale.ENGLISH));
        if (seq != null) {
            return seq;
        }
        OSequence sequence = OSequenceHelper.createSequence(iDocument);
        this.sequences.put(name, sequence);
        this.onSequenceLibraryUpdate(database);
        return sequence;
    }

    public OSequence onSequenceUpdated(ODatabaseDocumentInternal database, ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence sequence = this.sequences.get(name = name.toUpperCase(Locale.ENGLISH));
        if (sequence == null) {
            return null;
        }
        sequence.onUpdate(iDocument);
        return sequence;
    }

    public void onSequenceDropped(ODatabaseDocumentInternal database, ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return;
        }
        name = name.toUpperCase(Locale.ENGLISH);
        this.sequences.remove(name);
        this.onSequenceLibraryUpdate(database);
    }

    private void init(ODatabaseDocumentInternal database) {
        if (database.getMetadata().getSchema().existsClass("OSequence")) {
            return;
        }
        OClassImpl sequenceClass = (OClassImpl)database.getMetadata().getSchema().createClass("OSequence");
        OSequence.initClass(sequenceClass);
    }

    private void validateSequenceNoExists(String iName) {
        if (this.sequences.containsKey(iName)) {
            throw new OSequenceException("Sequence '" + iName + "' already exists");
        }
    }

    private void onSequenceLibraryUpdate(ODatabaseDocumentInternal database) {
        for (OMetadataUpdateListener one : database.getSharedContext().browseListeners()) {
            one.onSequenceLibraryUpdate(database.getName());
        }
    }

    private void reloadIfNeeded(ODatabaseDocumentInternal database) {
        if (this.reloadNeeded.get()) {
            this.load(database);
            this.reloadNeeded.set(false);
        }
    }

    public void update() {
        this.reloadNeeded.set(true);
    }
}

