/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.ONullOutputListener;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OSecurityShared
implements OSecurity,
OCloseable {
    private final AtomicLong version = new AtomicLong();
    public static final String RESTRICTED_CLASSNAME = "ORestricted";
    public static final String IDENTITY_CLASSNAME = "OIdentity";
    @Deprecated
    public static final String ALLOW_ALL_FIELD = ORestrictedOperation.ALLOW_ALL.getFieldName();
    @Deprecated
    public static final String ALLOW_READ_FIELD = ORestrictedOperation.ALLOW_READ.getFieldName();
    @Deprecated
    public static final String ALLOW_UPDATE_FIELD = ORestrictedOperation.ALLOW_UPDATE.getFieldName();
    @Deprecated
    public static final String ALLOW_DELETE_FIELD = ORestrictedOperation.ALLOW_DELETE.getFieldName();
    public static final String ONCREATE_IDENTITY_TYPE = "onCreate.identityType";
    public static final String ONCREATE_FIELD = "onCreate.fields";
    public static final Set<String> ALLOW_FIELDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(ORestrictedOperation.ALLOW_ALL.getFieldName());
            this.add(ORestrictedOperation.ALLOW_READ.getFieldName());
            this.add(ORestrictedOperation.ALLOW_UPDATE.getFieldName());
            this.add(ORestrictedOperation.ALLOW_DELETE.getFieldName());
        }
    });

    @Override
    public OIdentifiable allowRole(ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(iDocument, iOperation.getFieldName(), role);
    }

    @Override
    public OIdentifiable allowUser(ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(iDocument, iOperation.getFieldName(), user);
    }

    @Override
    public OIdentifiable allowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, user);
    }

    @Override
    public OIdentifiable allowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, role);
    }

    @Override
    public OIdentifiable allowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field == null) {
            field = new ORecordLazySet(iDocument);
            iDocument.field(iAllowFieldName, field);
        }
        field.add(iId);
        return iId;
    }

    @Override
    public OIdentifiable denyUser(ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(iDocument, iOperation.getFieldName(), user);
    }

    @Override
    public OIdentifiable denyRole(ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(iDocument, iOperation.getFieldName(), role);
    }

    @Override
    public OIdentifiable disallowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, user);
    }

    @Override
    public OIdentifiable disallowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, role);
    }

    @Override
    public OIdentifiable disallowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field != null) {
            field.remove(iId);
        }
        return iId;
    }

    @Override
    public boolean isAllowed(Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        if ((iAllowAll == null || iAllowAll.isEmpty()) && (iAllowOperation == null || iAllowOperation.isEmpty())) {
            return false;
        }
        OSecurityUser currentUser = ODatabaseRecordThreadLocal.instance().get().getUser();
        if (currentUser != null && (iAllowAll == null || iAllowAll != null && !iAllowAll.contains(currentUser.getIdentity()))) {
            if (iAllowOperation != null && iAllowOperation.contains(currentUser.getIdentity())) {
                return true;
            }
            for (OSecurityRole oSecurityRole : currentUser.getRoles()) {
                if (iAllowAll != null && iAllowAll.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                if (iAllowOperation != null && iAllowOperation.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                for (OSecurityRole parentRole = oSecurityRole.getParentRole(); parentRole != null; parentRole = parentRole.getParentRole()) {
                    if (iAllowAll != null && iAllowAll.contains(parentRole.getIdentity())) {
                        return true;
                    }
                    if (iAllowOperation == null || !iAllowOperation.contains(parentRole.getIdentity())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        String dbName = this.getDatabase().getName();
        OUser user = this.getUser(iUserName);
        if (user == null) {
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
        }
        if (!(this.getDatabase().getStorage() instanceof OStorageProxy) && !user.checkPassword(iUserPassword)) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        return user;
    }

    @Override
    public OUser authenticate(OToken authToken) {
        String dbName = this.getDatabase().getName();
        if (!authToken.getIsValid()) {
            throw new OSecurityAccessException(dbName, "Token not valid");
        }
        OUser user = authToken.getUser(this.getDatabase());
        if (user == null && authToken.getUserName() != null) {
            user = this.getUser(authToken.getUserName());
        }
        if (user == null) {
            throw new OSecurityAccessException(dbName, "Authentication failed, could not load user from token");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + user.getName() + "' is not active");
        }
        return user;
    }

    @Override
    public OUser getUser(ORID iRecordId) {
        if (iRecordId == null) {
            return null;
        }
        ODocument result = (ODocument)this.getDatabase().load(iRecordId, "roles:1");
        if (!result.getClassName().equals("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, String ... iRoles) {
        OUser user = new OUser(iUserName, iUserPassword);
        if (iRoles != null) {
            for (String r : iRoles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public OUser createUser(String userName, String userPassword, ORole ... roles) {
        OUser user = new OUser(userName, userPassword);
        if (roles != null) {
            for (ORole r : roles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public boolean dropUser(String iUserName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from OUser where name = ?")).execute(iUserName);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public ORole getRole(OIdentifiable iRole) {
        OClass clazz;
        ODocument doc = (ODocument)iRole.getRecord();
        if (doc != null && (clazz = doc.getSchemaClass()) != null && clazz.isSubClassOf("ORole")) {
            return new ORole(doc);
        }
        return null;
    }

    @Override
    public ORole getRole(String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = ? limit 1")).execute(iRoleName);
        if (result != null && !result.isEmpty()) {
            return new ORole((ODocument)result.get(0));
        }
        return null;
    }

    public ORID getRoleRID(String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select rid from index:ORole.name where key = ? limit 1")).execute(iRoleName);
        if (result != null && !result.isEmpty()) {
            return (ORID)((ODocument)result.get(0)).rawField("rid");
        }
        return null;
    }

    @Override
    public ORole createRole(String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    @Override
    public ORole createRole(String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        ORole role = new ORole(iRoleName, iParent, iAllowMode);
        return role.save();
    }

    @Override
    public boolean dropRole(String iRoleName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from ORole where name = '" + iRoleName + "'")).execute(new Object[0]);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public List<ODocument> getAllUsers() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
    }

    @Override
    public List<ODocument> getAllRoles() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
    }

    @Override
    public OUser create() {
        if (!this.getDatabase().getMetadata().getSchema().getClasses().isEmpty()) {
            return null;
        }
        OUser adminUser = this.createMetadata();
        ORole readerRole = this.createRole("reader", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        readerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
        readerRole.save();
        boolean createDefUsers = this.getDatabase().getStorage().getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.CREATE_DEFAULT_USERS);
        if (createDefUsers) {
            this.createUser("reader", "reader", readerRole.getName());
        }
        ORole writerRole = this.createRole("writer", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        writerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSequence", ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, "OTriggered", ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSchedule", ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
        writerRole.save();
        if (createDefUsers) {
            this.createUser("writer", "writer", writerRole.getName());
        }
        return adminUser;
    }

    public OUser createMetadata() {
        boolean createDefUsers;
        OUser adminUser;
        ODatabaseDocumentInternal database = this.getDatabase();
        OClass identityClass = database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME);
        if (identityClass == null) {
            identityClass = database.getMetadata().getSchema().createAbstractClass(IDENTITY_CLASSNAME);
        }
        OClass roleClass = this.createOrUpdateORoleClass(database, identityClass);
        this.createOrUpdateOUserClass(database, identityClass, roleClass);
        ORole adminRole = this.getRole("admin");
        if (adminRole == null) {
            adminRole = this.createRole("admin", OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT);
            adminRole.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_ALL).save();
        }
        if ((adminUser = this.getUser("admin")) == null && (createDefUsers = this.getDatabase().getStorage().getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.CREATE_DEFAULT_USERS))) {
            adminUser = this.createUser("admin", "admin", adminRole);
        }
        this.createOrUpdateORestrictedClass(database);
        return adminUser;
    }

    private void createOrUpdateORestrictedClass(ODatabaseDocument database) {
        OClass restrictedClass = database.getMetadata().getSchema().getClass(RESTRICTED_CLASSNAME);
        boolean unsafe = false;
        if (restrictedClass == null) {
            restrictedClass = database.getMetadata().getSchema().createAbstractClass(RESTRICTED_CLASSNAME);
            unsafe = true;
        }
        if (!restrictedClass.existsProperty(ALLOW_ALL_FIELD)) {
            restrictedClass.createProperty(ALLOW_ALL_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_READ_FIELD)) {
            restrictedClass.createProperty(ALLOW_READ_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_UPDATE_FIELD)) {
            restrictedClass.createProperty(ALLOW_UPDATE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_DELETE_FIELD)) {
            restrictedClass.createProperty(ALLOW_DELETE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
    }

    private void createOrUpdateOUserClass(ODatabaseDocument database, OClass identityClass, OClass roleClass) {
        boolean unsafe = false;
        OClass userClass = database.getMetadata().getSchema().getClass("OUser");
        if (userClass == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser", identityClass);
            unsafe = true;
        } else if (!userClass.getSuperClasses().contains(identityClass)) {
            userClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!userClass.existsProperty("name")) {
            ((OClassImpl)userClass).createProperty("name", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true).setCollate("ci").setMin("1").setRegexp("\\S+(.*\\S+)*");
            userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = userClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!userClass.existsProperty("password")) {
            userClass.createProperty("password", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            userClass.createProperty("roles", OType.LINKSET, roleClass, unsafe);
        }
        if (!userClass.existsProperty("status")) {
            userClass.createProperty("status", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true);
        }
    }

    private OClass createOrUpdateORoleClass(ODatabaseDocument database, OClass identityClass) {
        OClass roleClass = database.getMetadata().getSchema().getClass("ORole");
        boolean unsafe = false;
        if (roleClass == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole", identityClass);
            unsafe = true;
        } else if (!roleClass.getSuperClasses().contains(identityClass)) {
            roleClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!roleClass.existsProperty("name")) {
            roleClass.createProperty("name", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true).setCollate("ci");
            roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = roleClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!roleClass.existsProperty("mode")) {
            roleClass.createProperty("mode", OType.BYTE, (OType)null, unsafe);
        }
        if (!roleClass.existsProperty("rules")) {
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE, unsafe);
        }
        if (!roleClass.existsProperty("inheritedRole")) {
            roleClass.createProperty("inheritedRole", OType.LINK, roleClass, unsafe);
        }
        return roleClass;
    }

    @Override
    public void close() {
    }

    @Override
    public void close(boolean onDelete) {
    }

    @Override
    public void load() {
        OClass userClass = this.getDatabase().getMetadata().getSchema().getClass("OUser");
        if (userClass != null) {
            OClass roleClass;
            OProperty rules;
            OProperty p;
            if (!userClass.existsProperty("status")) {
                userClass.createProperty("status", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if ((p = userClass.getProperty("name")) == null) {
                p = userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true).setMin("1").setRegexp("\\S+(.*\\S+)*");
            }
            if (userClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
            if ((rules = (roleClass = this.getDatabase().getMetadata().getSchema().getClass("ORole")).getProperty("rules")) != null && !OType.EMBEDDEDMAP.equals((Object)rules.getType())) {
                roleClass.dropProperty("rules");
            }
            if (!roleClass.existsProperty("inheritedRole")) {
                roleClass.createProperty("inheritedRole", OType.LINK, roleClass);
            }
            if ((p = roleClass.getProperty("name")) == null) {
                p = roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (roleClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
        }
    }

    @Override
    public void createClassTrigger() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OClass classTrigger = db.getMetadata().getSchema().getClass("OTriggered");
        if (classTrigger == null) {
            classTrigger = db.getMetadata().getSchema().createAbstractClass("OTriggered");
        }
    }

    @Override
    public OSecurity getUnderlying() {
        return this;
    }

    @Override
    public OUser getUser(String iUserName) {
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = ? limit 1").setFetchPlan("roles:1")).execute(iUserName);
        if (result != null && !result.isEmpty()) {
            return new OUser((ODocument)result.get(0));
        }
        return null;
    }

    public ORID getUserRID(String iUserName) {
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select rid from index:OUser.name where key = ? limit 1")).execute(iUserName);
        if (result != null && !result.isEmpty()) {
            return (ORID)((ODocument)result.get(0)).rawField("rid");
        }
        return null;
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void incrementVersion() {
        this.version.incrementAndGet();
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }
}

