/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryProxy;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityProxy;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.schedule.OSchedulerProxy;
import java.io.IOException;

public class OMetadataDefault
implements OMetadataInternal {
    public static final String CLUSTER_INTERNAL_NAME = "internal";
    public static final String CLUSTER_INDEX_NAME = "index";
    public static final String CLUSTER_MANUAL_INDEX_NAME = "manindex";
    protected int schemaClusterId;
    protected OSchemaProxy schema;
    protected OSecurity security;
    protected OIndexManagerProxy indexManager;
    protected OFunctionLibraryProxy functionLibrary;
    protected OSchedulerProxy scheduler;
    protected OSequenceLibraryProxy sequenceLibrary;
    protected OCommandCache commandCache;
    protected static final OProfiler PROFILER = Orient.instance().getProfiler();
    private OImmutableSchema immutableSchema = null;
    private int immutableCount = 0;
    private ODatabaseDocumentInternal database;

    public OMetadataDefault() {
    }

    public OMetadataDefault(ODatabaseDocumentInternal databaseDocument) {
        this.database = databaseDocument;
    }

    @Override
    @Deprecated
    public void load() {
    }

    @Override
    @Deprecated
    public void create() throws IOException {
    }

    @Override
    public OSchemaProxy getSchema() {
        return this.schema;
    }

    @Override
    public OCommandCache getCommandCache() {
        return this.commandCache;
    }

    @Override
    public void makeThreadLocalSchemaSnapshot() {
        if (this.immutableCount == 0 && this.schema != null) {
            this.immutableSchema = this.schema.makeSnapshot();
        }
        ++this.immutableCount;
    }

    @Override
    public void clearThreadLocalSchemaSnapshot() {
        --this.immutableCount;
        if (this.immutableCount == 0) {
            this.immutableSchema = null;
        }
    }

    @Override
    public OImmutableSchema getImmutableSchemaSnapshot() {
        if (this.immutableSchema == null) {
            if (this.schema == null) {
                return null;
            }
            return this.schema.makeSnapshot();
        }
        return this.immutableSchema;
    }

    @Override
    public OSecurity getSecurity() {
        return this.security;
    }

    @Override
    public OIndexManagerProxy getIndexManager() {
        return this.indexManager;
    }

    @Override
    public int getSchemaClusterId() {
        return this.schemaClusterId;
    }

    public OSharedContext init(OSharedContext shared) {
        this.schemaClusterId = this.database.getClusterIdByName(CLUSTER_INTERNAL_NAME);
        this.schema = new OSchemaProxy(shared.getSchema(), this.database);
        this.indexManager = new OIndexManagerProxy(shared.getIndexManager(), this.database);
        this.security = new OSecurityProxy(shared.getSecurity(), this.database);
        this.commandCache = shared.getCommandCache();
        this.functionLibrary = new OFunctionLibraryProxy(shared.getFunctionLibrary(), this.database);
        this.sequenceLibrary = new OSequenceLibraryProxy(shared.getSequenceLibrary(), this.database);
        this.scheduler = new OSchedulerProxy(shared.getScheduler(), this.database);
        return shared;
    }

    @Override
    public void reload() {
        this.database.getSharedContext().reload(this.database);
    }

    @Override
    @Deprecated
    public void close() {
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return this.database;
    }

    @Override
    public OFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public OSequenceLibrary getSequenceLibrary() {
        return this.sequenceLibrary;
    }

    @Override
    public OScheduler getScheduler() {
        return this.scheduler;
    }
}

