/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OPropertyListIndexDefinition
extends OAbstractIndexDefinitionMultiValue {
    private static final long serialVersionUID = -6499782365051906190L;

    public OPropertyListIndexDefinition(String iClassName, String iField, OType iType) {
        super(iClassName, iField, iType);
    }

    public OPropertyListIndexDefinition() {
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        return this.createValue(iDocument.field(this.field));
    }

    @Override
    public Object createValue(List<?> params) {
        if (!(params.get(0) instanceof Collection)) {
            params = Collections.singletonList(params);
        }
        Collection multiValueCollection = (Collection)params.get(0);
        ArrayList<Object> values = new ArrayList<Object>(multiValueCollection.size());
        for (Object item : multiValueCollection) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public Object createValue(Object ... params) {
        Object param = params[0];
        if (!(param instanceof Collection)) {
            try {
                return OType.convert(param, this.keyType.getDefaultJavaType());
            }
            catch (Exception e) {
                return null;
            }
        }
        Collection multiValueCollection = (Collection)param;
        ArrayList<Object> values = new ArrayList<Object>(multiValueCollection.size());
        for (Object item : multiValueCollection) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public Object createSingleValue(Object ... param) {
        try {
            return OType.convert(param[0], this.keyType.getDefaultJavaType());
        }
        catch (Exception e) {
            OException ex = OException.wrapException(new OIndexException("Invalid key for index: " + param[0] + " cannot be converted to " + (Object)((Object)this.keyType)), e);
            throw ex;
        }
    }

    @Override
    public void processChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        switch (changeEvent.getChangeType()) {
            case ADD: {
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                break;
            }
            case REMOVE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                break;
            }
            case UPDATE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)changeEvent.getChangeType()));
            }
        }
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType, String engine) {
        return this.createIndexDDLWithoutFieldType(indexName, indexType, engine).toString();
    }
}

