/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;

public class OIndexUnique
extends OIndexOneValue {
    private final OIndexEngine.Validator<Object, OIdentifiable> UNIQUE_VALIDATOR = new OIndexEngine.Validator<Object, OIdentifiable>(){

        @Override
        public Object validate(Object key, OIdentifiable oldValue, OIdentifiable newValue) {
            if (oldValue != null) {
                if (!oldValue.equals(newValue)) {
                    Boolean mergeSameKey;
                    Boolean bl = mergeSameKey = OIndexUnique.this.metadata != null ? (Boolean)OIndexUnique.this.metadata.field("mergeKeys") : Boolean.FALSE;
                    if (mergeSameKey == null || !mergeSameKey.booleanValue()) {
                        throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue.getIdentity(), key, OIndexUnique.this.getName(), oldValue.getIdentity()), OIndexUnique.this.getName(), oldValue.getIdentity(), key);
                    }
                } else {
                    return OIndexEngine.Validator.IGNORE;
                }
            }
            if (!newValue.getIdentity().isPersistent()) {
                newValue = newValue.getRecord();
            }
            return newValue.getIdentity();
        }
    };

    public OIndexUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            while (true) {
                try {
                    this.storage.validatedPutIndexValue(this.indexId, key, iSingleValue, this.UNIQUE_VALIDATOR);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            OIndexUnique oIndexUnique = this;
            return oIndexUnique;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        while (true) {
            try {
                return this.storage.hasIndexRangeQuerySupport(this.indexId);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.Unique);
    }
}

