/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values;
            while (true) {
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            if (values == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            Set<OIdentifiable> set = Collections.unmodifiableSet(values);
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values;
            while (true) {
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            if (values == null) {
                long l = 0L;
                return l;
            }
            long l = values.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexMultiValues put(Object key, OIdentifiable singleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            if (!singleValue.getIdentity().isValid()) {
                singleValue.getRecord().save();
            }
            ORID identity = singleValue.getIdentity();
            boolean durable = this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"));
            OIndexKeyUpdater<Object> creator = (oldValue, bonsayFileId) -> {
                Set toUpdate = (Set)oldValue;
                if (toUpdate == null) {
                    if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                        toUpdate = new OMixedIndexRIDContainer(this.getName(), bonsayFileId);
                    } else {
                        throw new IllegalStateException("MVRBTree is not supported any more");
                    }
                }
                if (toUpdate instanceof OIndexRIDContainer) {
                    boolean isTree = !((OIndexRIDContainer)toUpdate).isEmbedded();
                    toUpdate.add(identity);
                    if (isTree) {
                        return OIndexUpdateAction.nothing();
                    }
                    return OIndexUpdateAction.changed(toUpdate);
                }
                if (toUpdate instanceof OMixedIndexRIDContainer) {
                    OMixedIndexRIDContainer ridContainer = (OMixedIndexRIDContainer)toUpdate;
                    boolean embeddedWasUpdated = ridContainer.addEntry(identity);
                    if (!embeddedWasUpdated) {
                        return OIndexUpdateAction.nothing();
                    }
                    return OIndexUpdateAction.changed(toUpdate);
                }
                if (toUpdate.add(identity)) {
                    return OIndexUpdateAction.changed(toUpdate);
                }
                return OIndexUpdateAction.nothing();
            };
            while (true) {
                try {
                    this.storage.updateIndexEntry(this.indexId, key, creator);
                    OIndexMultiValues oIndexMultiValues = this;
                    return oIndexMultiValues;
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values = null;
            while (true) {
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            if (values == null) {
                boolean ignore = false;
                return ignore;
            }
            OModifiableBoolean removed = new OModifiableBoolean(false);
            EntityRemover creator = new EntityRemover(value, removed);
            while (true) {
                try {
                    this.storage.updateIndexEntry(this.indexId, key, creator);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            boolean bl = removed.getValue();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)23);
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            private Iterator<OIdentifiable> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    block5: while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            while (true) {
                                try {
                                    result = (Collection)OIndexMultiValues.this.storage.getIndexValue(OIndexMultiValues.this.indexId, key);
                                    continue block5;
                                }
                                catch (OInvalidIndexEngineIdException ignore) {
                                    OIndexMultiValues.this.doReloadIndexEngine();
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, MultiValuesTransformer.INSTANCE);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, null);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexDescCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static class EntityRemover
    implements OIndexKeyUpdater<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;

        public EntityRemover(OIdentifiable value, OModifiableBoolean removed) {
            this.value = value;
            this.removed = removed;
        }

        @Override
        public OIndexUpdateAction<Object> update(Object persistentValue, AtomicLong bonsayFileId) {
            Set values = (Set)persistentValue;
            if (this.value == null) {
                this.removed.setValue(true);
                return OIndexUpdateAction.remove();
            }
            if (values.remove(this.value)) {
                this.removed.setValue(true);
                if (values.isEmpty()) {
                    return OIndexUpdateAction.remove();
                }
                return OIndexUpdateAction.changed(values);
            }
            return OIndexUpdateAction.changed(values);
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Object value) {
            return (Collection)value;
        }
    }
}

