/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OProxedResource;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class OIndexManagerProxy
extends OProxedResource<OIndexManagerAbstract>
implements OIndexManager {
    public OIndexManagerProxy(OIndexManagerAbstract iDelegate, ODatabaseDocumentInternal iDatabase) {
        super(iDelegate, iDatabase);
    }

    @Override
    public OIndexManager load() {
        return this;
    }

    @Override
    public OIndexManagerProxy reload() {
        ((OIndexManagerAbstract)this.delegate).load(this.database);
        return this;
    }

    @Override
    public void create() {
        ((OIndexManagerAbstract)this.delegate).create(this.database);
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        return ((OIndexManagerAbstract)this.delegate).getIndexes(this.database);
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        return ((OIndexManagerAbstract)this.delegate).getIndex(iName);
    }

    @Override
    public boolean existsIndex(String iName) {
        return ((OIndexManagerAbstract)this.delegate).existsIndex(iName);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        if (this.isDistributedCommand()) {
            return this.distributedCreateIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
        }
        return ((OIndexManagerAbstract)this.delegate).createIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String algorithm) {
        if (this.isDistributedCommand()) {
            return this.distributedCreateIndex(iName, iType, iIndexDefinition, iClusterIdsToIndex, progressListener, metadata, algorithm);
        }
        return ((OIndexManagerAbstract)this.delegate).createIndex(iName, iType, iIndexDefinition, iClusterIdsToIndex, progressListener, metadata, algorithm);
    }

    public OIndex<?> distributedCreateIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String engine) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType, engine) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType, engine);
        if (metadata != null) {
            createIndexDDL = createIndexDDL + " METADATA " + metadata.toJSON();
        }
        if (progressListener != null) {
            progressListener.onBegin(this, 0L, false);
        }
        OIndexManagerAbstract.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
        ORecordInternal.setIdentity(((OIndexManagerAbstract)this.delegate).getDocument(), new ORecordId(OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().getIndexMgrRecordId()));
        if (progressListener != null) {
            progressListener.onCompletition(this, true);
        }
        this.reload();
        Locale locale = ((OIndexManagerAbstract)this.delegate).getServerLocale();
        return ((OIndexManagerAbstract)this.delegate).preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), ((OIndexManagerAbstract)this.delegate).getIndex(iName));
    }

    @Override
    public ODocument getConfiguration() {
        return ((OIndexManagerAbstract)this.delegate).getConfiguration();
    }

    @Override
    public OIndexManager dropIndex(String iIndexName) {
        if (this.isDistributedCommand()) {
            this.distributedDropIndex(iIndexName);
            return this;
        }
        return ((OIndexManagerAbstract)this.delegate).dropIndex(iIndexName);
    }

    public void distributedDropIndex(String iName) {
        String dropIndexDDL = "DROP INDEX `" + iName + "`";
        OIndexManagerAbstract.getDatabase().command(new OCommandSQL(dropIndexDDL)).execute(new Object[0]);
        ORecordInternal.setIdentity(((OIndexManagerAbstract)this.delegate).getDocument(), new ORecordId(OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().getIndexMgrRecordId()));
        this.reload();
    }

    @Override
    public String getDefaultClusterName() {
        return ((OIndexManagerAbstract)this.delegate).getDefaultClusterName();
    }

    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        ((OIndexManagerAbstract)this.delegate).setDefaultClusterName(defaultClusterName);
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        return ((OIndexManagerAbstract)this.delegate).getDictionary();
    }

    @Override
    public void flush() {
        if (this.delegate != null) {
            ((OIndexManagerAbstract)this.delegate).flush();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        return ((OIndexManagerAbstract)this.delegate).getClassInvolvedIndexes(className, fields);
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return ((OIndexManagerAbstract)this.delegate).getClassInvolvedIndexes(className, fields);
    }

    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        return ((OIndexManagerAbstract)this.delegate).areIndexed(className, fields);
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return ((OIndexManagerAbstract)this.delegate).areIndexed(className, fields);
    }

    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        return ((OIndexManagerAbstract)this.delegate).getClassIndexes(className);
    }

    @Override
    public void getClassIndexes(String className, Collection<OIndex<?>> indexes) {
        ((OIndexManagerAbstract)this.delegate).getClassIndexes(className, indexes);
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        return ((OIndexManagerAbstract)this.delegate).getClassIndex(className, indexName);
    }

    @Override
    public OIndexUnique getClassUniqueIndex(String className) {
        return ((OIndexManagerAbstract)this.delegate).getClassUniqueIndex(className);
    }

    @Override
    public OIndex<?> getClassAutoShardingIndex(String className) {
        return ((OIndexManagerAbstract)this.delegate).getClassAutoShardingIndex(className);
    }

    @Override
    public void recreateIndexes() {
        ((OIndexManagerAbstract)this.delegate).recreateIndexes(this.database);
    }

    @Override
    public void waitTillIndexRestore() {
        ((OIndexManagerAbstract)this.delegate).waitTillIndexRestore();
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        return ((OIndexManagerAbstract)this.delegate).autoRecreateIndexesAfterCrash(this.database);
    }

    @Override
    public void addClusterToIndex(String clusterName, String indexName) {
        ((OIndexManagerAbstract)this.delegate).addClusterToIndex(clusterName, indexName);
    }

    @Override
    public void removeClusterFromIndex(String clusterName, String indexName) {
        ((OIndexManagerAbstract)this.delegate).removeClusterFromIndex(clusterName, indexName);
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        return ((OIndexManagerAbstract)this.delegate).save();
    }

    @Override
    public void removeClassPropertyIndex(OIndex<?> idx) {
        ((OIndexManagerAbstract)this.delegate).removeClassPropertyIndex(idx);
    }

    private boolean isDistributedCommand() {
        return this.database.getStorage().isDistributed() && !((OAutoshardedStorage)((Object)this.database.getStorage())).isLocalEnv();
    }

    public void getClassRawIndexes(String name, Collection<OIndex<?>> indexes) {
        ((OIndexManagerAbstract)this.delegate).getClassRawIndexes(name, indexes);
    }

    public OIndex<?> preProcessBeforeReturn(ODatabaseDocumentInternal database, OIndex<?> index) {
        return ((OIndexManagerAbstract)this.delegate).preProcessBeforeReturn(database, index);
    }
}

