/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.local.twoq.O2QCache;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.util.Map;

public class OEngineLocalPaginated
extends OEngineAbstract {
    public static final String NAME = "plocal";
    private volatile O2QCache readCache;
    protected final OClosableLinkedContainer<Long, OFileClassic> files = new OClosableLinkedContainer(OEngineLocalPaginated.getOpenFilesLimit());

    private static int getOpenFilesLimit() {
        if (OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger() > 0) {
            OLogManager.instance().infoNoDb(OEngineLocalPaginated.class, "Limit of open files for disk cache will be set to %d.", OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger());
            return OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger();
        }
        int defaultLimit = 512;
        int recommendedLimit = 262144;
        return ONative.instance().getOpenFilesLimit(true, 262144, 512);
    }

    @Override
    public void startup() {
        String userName = System.getProperty("user.name", "unknown");
        OLogManager.instance().infoNoDb(this, "System is started under an effective user : `%s`", userName);
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        super.startup();
        this.readCache = new O2QCache(this.calculateReadCacheMaxMemory(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L), OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, true, OGlobalConfiguration.DISK_CACHE_PINNED_PAGES.getValueAsInteger(), OGlobalConfiguration.DISK_CACHE_PRINT_CACHE_STATISTICS.getValueAsBoolean(), OGlobalConfiguration.DISK_CACHE_STATISTICS_INTERVAL.getValueAsInteger());
    }

    private long calculateReadCacheMaxMemory(long cacheSize) {
        return (long)((double)cacheSize * ((double)(100 - OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger()) / 100.0));
    }

    public void changeCacheSize(long cacheSize) {
        if (this.readCache != null) {
            this.readCache.changeMaximumAmountOfMemory(this.calculateReadCacheMaxMemory(cacheSize));
        }
    }

    @Override
    public OStorage createStorage(String dbName, Map<String, String> configuration) {
        try {
            return new OLocalPaginatedStorage(dbName, dbName, this.getMode(configuration), this.generateStorageId(), this.readCache, this.files);
        }
        catch (Exception e) {
            String message = "Error on opening database: " + dbName + ". Current location is: " + new File(".").getAbsolutePath();
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new ODatabaseException(message), e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public O2QCache getReadCache() {
        return this.readCache;
    }

    @Override
    public String getNameFromPath(String dbPath) {
        return OIOUtils.getRelativePathIfAny(dbPath, null);
    }

    @Override
    public void shutdown() {
        try {
            this.readCache.clear();
            this.files.clear();
        }
        finally {
            super.shutdown();
        }
    }
}

