/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.concurrent.ConcurrentMap;

public class ODatabaseDocumentTxInternal {
    private ODatabaseDocumentTxInternal() {
    }

    public static ODatabaseDocumentInternal getInternal(ODatabaseDocumentInternal db) {
        if (db instanceof ODatabaseDocumentTx) {
            db = ((ODatabaseDocumentTx)db).internal;
        }
        return db;
    }

    public static ODatabaseDocumentTx wrap(ODatabaseDocumentInternal database) {
        return new ODatabaseDocumentTx(database, null);
    }

    public static OrientDBInternal getOrCreateEmbeddedFactory(String databaseDirectory, OrientDBConfig config) {
        return ODatabaseDocumentTx.getOrCreateEmbeddedFactory(databaseDirectory, config);
    }

    public static OrientDBInternal getOrCreateRemoteFactory(String url) {
        return ODatabaseDocumentTx.getOrCreateRemoteFactory(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllOnShutdown() {
        ConcurrentMap<String, OrientDBInternal> concurrentMap = ODatabaseDocumentTx.embedded;
        synchronized (concurrentMap) {
            for (OrientDBInternal factory : ODatabaseDocumentTx.embedded.values()) {
                factory.internalClose();
            }
            ODatabaseDocumentTx.embedded.clear();
        }
        concurrentMap = ODatabaseDocumentTx.remote;
        synchronized (concurrentMap) {
            for (OrientDBInternal factory : ODatabaseDocumentTx.remote.values()) {
                factory.internalClose();
            }
            ODatabaseDocumentTx.remote.clear();
        }
    }
}

