/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageExistsException;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class OPartitionedDatabasePool
extends OOrientListenerAbstract {
    private static final int HASH_INCREMENT = 1640531527;
    private static final int MIN_POOL_SIZE = 2;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    private final String url;
    private final String userName;
    private final String password;
    private final int maxPartitonSize;
    private final AtomicBoolean poolBusy = new AtomicBoolean();
    private int maxPartitions = Runtime.getRuntime().availableProcessors();
    private final Semaphore connectionsCounter;
    private volatile ThreadLocal<PoolData> poolData = new ThreadPoolData();
    private volatile PoolPartition[] partitions;
    private volatile boolean closed = false;
    private boolean autoCreate = false;

    public OPartitionedDatabasePool(String url, String userName, String password) {
        this(url, userName, password, Runtime.getRuntime().availableProcessors(), -1);
    }

    public OPartitionedDatabasePool(String url, String userName, String password, int maxPartitionSize, int maxPoolSize) {
        this.url = url;
        this.userName = userName;
        this.password = password;
        if (maxPoolSize > 0) {
            this.connectionsCounter = new Semaphore(maxPoolSize);
            this.maxPartitions = 1;
            this.maxPartitonSize = maxPoolSize;
        } else {
            this.maxPartitonSize = maxPartitionSize;
            this.connectionsCounter = null;
        }
        PoolPartition[] pts = new PoolPartition[this.maxPartitions];
        for (int i = 0; i < pts.length; ++i) {
            PoolPartition partition;
            pts[i] = partition = new PoolPartition();
            this.initQueue(url, partition);
        }
        this.partitions = pts;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getMaxPartitonSize() {
        return this.maxPartitonSize;
    }

    public int getAvailableConnections() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get() - partition.acquiredConnections.get();
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getCreatedInstances() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get();
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseDocumentTx acquire() {
        this.checkForClose();
        PoolData data = this.poolData.get();
        if (data.acquireCount > 0) {
            data.acquireCount++;
            assert (data.acquiredDatabase != null);
            DatabaseDocumentTxPooled db = data.acquiredDatabase;
            db.activateOnCurrentThread();
            this.properties.entrySet().forEach(p -> db.setProperty((String)p.getKey(), p.getValue()));
            return db;
        }
        try {
            if (this.connectionsCounter != null) {
                this.connectionsCounter.acquire();
            }
        }
        catch (InterruptedException ie) {
            throw OException.wrapException(new OInterruptedException("Acquiring of new connection was interrupted"), ie);
        }
        boolean acquired = false;
        try {
            DatabaseDocumentTxPooled db;
            PoolPartition partition;
            block15: {
                while (true) {
                    int index;
                    PoolPartition[] pts;
                    if ((partition = (pts = this.partitions)[index = pts.length - 1 & data.hashCode]) == null) {
                        if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                        if (pts == this.partitions && (partition = pts[index]) == null) {
                            partition = new PoolPartition();
                            this.initQueue(this.url, partition);
                            pts[index] = partition;
                        }
                        this.poolBusy.set(false);
                        continue;
                    }
                    db = (DatabaseDocumentTxPooled)partition.queue.poll();
                    if (db != null) break block15;
                    if (pts.length >= this.maxPartitions) break;
                    if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                    if (pts == this.partitions) {
                        PoolPartition[] newPartitions = new PoolPartition[this.partitions.length << 1];
                        System.arraycopy(this.partitions, 0, newPartitions, 0, this.partitions.length);
                        this.partitions = newPartitions;
                    }
                    this.poolBusy.set(false);
                }
                if (partition.currentSize.get() >= this.maxPartitonSize) {
                    throw new IllegalStateException("You have reached maximum pool size for given partition");
                }
                DatabaseDocumentTxPooled newDb = new DatabaseDocumentTxPooled(this.url);
                this.properties.entrySet().forEach(p -> newDb.setProperty((String)p.getKey(), p.getValue()));
                this.openDatabase(newDb);
                newDb.partition = partition;
                data.acquireCount = 1;
                data.acquiredDatabase = newDb;
                partition.acquiredConnections.incrementAndGet();
                partition.currentSize.incrementAndGet();
                acquired = true;
                DatabaseDocumentTxPooled databaseDocumentTxPooled = newDb;
                return databaseDocumentTxPooled;
            }
            this.properties.entrySet().forEach(p -> db.setProperty((String)p.getKey(), p.getValue()));
            this.openDatabase(db);
            db.partition = partition;
            partition.acquiredConnections.incrementAndGet();
            data.acquireCount = 1;
            data.acquiredDatabase = db;
            acquired = true;
            DatabaseDocumentTxPooled databaseDocumentTxPooled = db;
            return databaseDocumentTxPooled;
        }
        finally {
            if (!acquired && this.connectionsCounter != null) {
                this.connectionsCounter.release();
            }
        }
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public OPartitionedDatabasePool setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
        return this;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void openDatabase(DatabaseDocumentTxPooled db) {
        if (this.autoCreate) {
            if (!db.getURL().startsWith("remote:") && !db.exists()) {
                try {
                    db.create();
                }
                catch (OStorageExistsException ex) {
                    OLogManager.instance().debug((Object)this, "Can not create storage " + db.getStorage() + " because it already exists.", ex, new Object[0]);
                    db.internalOpen();
                }
            } else {
                db.internalOpen();
            }
        } else {
            db.internalOpen();
        }
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    @Override
    public void onStartup() {
        if (this.poolData == null) {
            this.poolData = new ThreadPoolData();
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            ConcurrentLinkedQueue queue = partition.queue;
            while (!queue.isEmpty()) {
                DatabaseDocumentTxPooled db = (DatabaseDocumentTxPooled)queue.poll();
                if (db.isClosed()) continue;
                db.activateOnCurrentThread();
                db.close();
            }
        }
        this.partitions = null;
        this.poolData = null;
    }

    private void initQueue(String url, PoolPartition partition) {
        ConcurrentLinkedQueue queue = partition.queue;
        for (int n = 0; n < 2; ++n) {
            DatabaseDocumentTxPooled db = new DatabaseDocumentTxPooled(url);
            this.properties.entrySet().forEach(p -> db.setProperty((String)p.getKey(), p.getValue()));
            queue.add(db);
        }
        partition.currentSize.addAndGet(2);
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Pool is closed");
        }
    }

    public Object setProperty(String iName, Object iValue) {
        if (iValue != null) {
            return this.properties.put(iName.toLowerCase(Locale.ENGLISH), iValue);
        }
        return this.properties.remove(iName.toLowerCase(Locale.ENGLISH));
    }

    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase(Locale.ENGLISH));
    }

    static /* synthetic */ int access$1000() {
        return OPartitionedDatabasePool.nextHashCode();
    }

    private final class DatabaseDocumentTxPooled
    extends ODatabaseDocumentTx {
        private PoolPartition partition;

        private DatabaseDocumentTxPooled(String iURL) {
            super(iURL, false);
        }

        @Override
        public <DB extends ODatabase> DB open(OToken iToken) {
            throw new ODatabaseException("Impossible to open a database managed by a pool ");
        }

        @Override
        public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
            throw new ODatabaseException("Impossible to open a database managed by a pool ");
        }

        @Override
        public boolean isPooled() {
            return true;
        }

        protected void internalOpen() {
            if (this.internal == null) {
                super.open(OPartitionedDatabasePool.this.userName, OPartitionedDatabasePool.this.password);
            } else {
                this.internal.activateOnCurrentThread();
                this.internal.setStatus(ODatabase.STATUS.OPEN);
            }
            if (this.getMetadata().getSchema().countClasses() == 0) {
                this.getMetadata().reload();
            }
        }

        @Override
        public void close() {
            if (OPartitionedDatabasePool.this.poolData != null) {
                PoolData data = (PoolData)OPartitionedDatabasePool.this.poolData.get();
                if (data.acquireCount == 0) {
                    return;
                }
                data.acquireCount--;
                if (data.acquireCount > 0) {
                    return;
                }
                PoolPartition p = this.partition;
                this.partition = null;
                OStorage storage = this.getStorage();
                if (storage == null) {
                    return;
                }
                if (!storage.isClosed()) {
                    this.activateOnCurrentThread();
                    this.internal.internalClose(true);
                    data.acquiredDatabase = null;
                    p.queue.offer(this);
                } else {
                    try {
                        super.close();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during closing of database % when storage %s was already closed", e, OPartitionedDatabasePool.this.getUrl(), storage.getName());
                    }
                    data.acquiredDatabase = null;
                    DatabaseDocumentTxPooled db = new DatabaseDocumentTxPooled(OPartitionedDatabasePool.this.url);
                    p.queue.offer(db);
                }
                if (OPartitionedDatabasePool.this.connectionsCounter != null) {
                    OPartitionedDatabasePool.this.connectionsCounter.release();
                }
                p.acquiredConnections.decrementAndGet();
            } else {
                super.close();
            }
        }
    }

    private static class ThreadPoolData
    extends ThreadLocal<PoolData> {
        private ThreadPoolData() {
        }

        @Override
        protected PoolData initialValue() {
            return new PoolData();
        }
    }

    private static final class PoolPartition {
        private final AtomicInteger currentSize = new AtomicInteger();
        private final AtomicInteger acquiredConnections = new AtomicInteger();
        private final ConcurrentLinkedQueue<DatabaseDocumentTxPooled> queue = new ConcurrentLinkedQueue();

        private PoolPartition() {
        }
    }

    private static final class PoolData {
        private final int hashCode = OPartitionedDatabasePool.access$1000();
        private int acquireCount;
        private DatabaseDocumentTxPooled acquiredDatabase;

        private PoolData() {
        }
    }
}

