/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;

public class OMemory {
    public static long getCappedRuntimeMaxMemory(long unlimitedCap) {
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        return jvmMaxMemory == Long.MAX_VALUE ? unlimitedCap : jvmMaxMemory;
    }

    private static long getMaxCacheMemorySize() {
        return OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
    }

    public static void checkCacheMemoryConfiguration() {
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        long maxCacheSize = OMemory.getMaxCacheMemorySize();
        ONative.MemoryLimitResult physicalMemory = ONative.instance().getMemoryLimit(false);
        if (maxHeapSize != Long.MAX_VALUE && physicalMemory != null && maxHeapSize + maxCacheSize > physicalMemory.memoryLimit) {
            OLogManager.instance().warnNoDb(OMemory.class, "The sum of the configured JVM maximum heap size (" + maxHeapSize + " bytes) and the OrientDB maximum cache size (" + maxCacheSize + " bytes) is larger than the available physical memory size (" + physicalMemory + " bytes). That may cause out of memory errors, please tune the configuration up. Use the -Xmx JVM option to lower the JVM maximum heap memory size or storage.diskCache.bufferSize OrientDB option to lower memory requirements of the cache.", new Object[0]);
        }
    }

    public static void fixCommonConfigurationProblems() {
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong();
        int max32BitCacheSize = 512;
        if (OMemory.getJavaBitWidth() == 32 && diskCacheSize > 512L) {
            OLogManager.instance().infoNoDb(OGlobalConfiguration.class, "32 bit JVM is detected. Lowering disk cache size from %,dMB to %,dMB.", diskCacheSize, 512);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(512);
        }
    }

    private static int getJavaBitWidth() {
        String dataModel = System.getProperty("sun.arch.data.model", "64");
        int size = 64;
        try {
            size = Integer.parseInt(dataModel);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    private static long parseVmArgsSize(String text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("text can't be null");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("text can't be empty");
        }
        char unit = text.charAt(text.length() - 1);
        if (Character.isDigit(unit)) {
            return Long.parseLong(text);
        }
        long value = Long.parseLong(text.substring(0, text.length() - 1));
        switch (Character.toLowerCase(unit)) {
            case 'g': {
                return value * 1024L * 1024L * 1024L;
            }
            case 'm': {
                return value * 1024L * 1024L;
            }
            case 'k': {
                return value * 1024L;
            }
        }
        throw new IllegalArgumentException("text '" + text + "' is not a size specifier.");
    }

    private OMemory() {
    }
}

