/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class OUTF8Serializer
implements OBinarySerializer<String> {
    public static final OUTF8Serializer INSTANCE = new OUTF8Serializer();
    public static final byte ID = 25;

    @Override
    public int getObjectSize(String object, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        return 4 + encoded.length;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition) + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        OIntegerSerializer.INSTANCE.serialize(encoded.length, stream, startPosition, new Object[0]);
        System.arraycopy(encoded, 0, stream, startPosition += 4, encoded.length);
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        int encodedSize = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        byte[] encoded = new byte[encodedSize];
        System.arraycopy(stream, startPosition += 4, encoded, 0, encodedSize);
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte getId() {
        return 25;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public void serializeNativeObject(String object, byte[] stream, int startPosition, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        OIntegerSerializer.INSTANCE.serializeNative(encoded.length, stream, startPosition, new Object[0]);
        System.arraycopy(encoded, 0, stream, startPosition += 4, encoded.length);
    }

    @Override
    public String deserializeNativeObject(byte[] stream, int startPosition) {
        int encodedSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        byte[] encoded = new byte[encodedSize];
        System.arraycopy(stream, startPosition += 4, encoded, 0, encodedSize);
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) + 4;
    }

    @Override
    public String preprocess(String value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(String object, ByteBuffer buffer, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        buffer.putInt(encoded.length);
        buffer.put(encoded);
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer) {
        int encodedSize = buffer.getInt();
        byte[] encoded = new byte[encodedSize];
        buffer.get(encoded);
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt() + 4;
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int encodedSize = walChanges.getIntValue(buffer, offset);
        byte[] encoded = walChanges.getBinaryValue(buffer, offset += 4, encodedSize);
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset) + 4;
    }

    @Override
    public byte[] serializeNativeAsWhole(String object, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        byte[] result = new byte[encoded.length + 4];
        OIntegerSerializer.INSTANCE.serializeNative(encoded.length, result, 0, new Object[0]);
        System.arraycopy(encoded, 0, result, 4, encoded.length);
        return result;
    }
}

