/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class OPointer {
    private final Pointer pointer;
    private final int size;

    public OPointer(Pointer pointer, int size) {
        this.pointer = pointer;
        this.size = size;
    }

    public void clear() {
        this.pointer.setMemory(0L, (long)this.size, (byte)0);
    }

    public ByteBuffer getNativeByteBuffer() {
        return this.pointer.getByteBuffer(0L, (long)this.size);
    }

    Pointer getNativePointer() {
        return this.pointer;
    }

    int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OPointer other = (OPointer)o;
        return this.size == other.size && Objects.equals(this.pointer, other.pointer);
    }

    public int hashCode() {
        return Objects.hash(this.pointer, this.size);
    }
}

