/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.serialization.OStreamable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODistributedRequestId
implements Comparable,
OStreamable,
Externalizable {
    private int nodeId;
    private long messageId;

    public ODistributedRequestId() {
    }

    public ODistributedRequestId(int iNodeId, long iMessageId) {
        this.nodeId = iNodeId;
        this.messageId = iMessageId;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ODistributedRequestId)) {
            return false;
        }
        ODistributedRequestId other = (ODistributedRequestId)obj;
        return this.nodeId == other.nodeId && this.messageId == other.messageId;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ODistributedRequestId)) {
            return -1;
        }
        ODistributedRequestId other = (ODistributedRequestId)obj;
        return Integer.compare(this.hashCode(), other.hashCode());
    }

    public int hashCode() {
        return 31 * this.nodeId + 103 * (int)this.messageId;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.nodeId);
        out.writeLong(this.messageId);
    }

    public void fromStream(DataInput in) throws IOException {
        this.nodeId = in.readInt();
        this.messageId = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nodeId);
        out.writeLong(this.messageId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = in.readInt();
        this.messageId = in.readLong();
    }

    public String toString() {
        return this.nodeId + "." + this.messageId;
    }
}

