/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.NoneSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.ComputePlanAction;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;

public class AutoAddReplicasPlanAction
extends ComputePlanAction {
    @Override
    protected Suggester getSuggester(Policy.Session session, TriggerEvent event, ActionContext context, SolrCloudManager cloudManager) throws IOException {
        ClusterState clusterState;
        ClusterStateProvider stateProvider = cloudManager.getClusterStateProvider();
        String autoAddReplicas = (String)stateProvider.getClusterProperty("autoAddReplicas", (Object)null);
        if (autoAddReplicas != null && autoAddReplicas.equals("false")) {
            return NoneSuggester.get((Policy.Session)session);
        }
        Suggester suggester = super.getSuggester(session, event, context, cloudManager);
        try {
            clusterState = stateProvider.getClusterState();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception getting cluster state", (Throwable)e);
        }
        boolean anyCollections = false;
        for (DocCollection collection : clusterState.getCollectionsMap().values()) {
            if (!collection.getAutoAddReplicas()) continue;
            anyCollections = true;
            suggester.hint(Suggester.Hint.COLL, (Object)collection.getName());
        }
        if (!anyCollections) {
            return NoneSuggester.get((Policy.Session)session);
        }
        return suggester;
    }
}

