/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdMemoryBackendFactory;
import org.rrd4j.core.RrdNioBackendFactory;
import org.rrd4j.core.RrdRandomAccessFileBackendFactory;
import org.rrd4j.core.RrdSafeFileBackendFactory;

public abstract class RrdBackendFactory {
    public static final String DEFAULTFACTORY = "NIO";
    private static final Map<String, RrdBackendFactory> factories = new ConcurrentHashMap<String, RrdBackendFactory>();
    private static final List<RrdBackendFactory> activeFactories = new ArrayList<RrdBackendFactory>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Pattern URIPATTERN;

    public static RrdBackendFactory getFactory(String name) {
        lock.readLock().lock();
        try {
            RrdBackendFactory factory = factories.get(name);
            if (factory != null) {
                RrdBackendFactory rrdBackendFactory = factory;
                return rrdBackendFactory;
            }
            throw new IllegalArgumentException("No backend factory found with the name specified [" + name + "]");
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void registerFactory(RrdBackendFactory factory) {
        block4: {
            lock.writeLock().lock();
            try {
                String name = factory.getName();
                if (!factories.containsKey(name)) {
                    factories.put(name, factory);
                    break block4;
                }
                throw new IllegalArgumentException("Backend factory '" + name + "' cannot be registered twice");
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    public static void registerAndSetAsDefaultFactory(RrdBackendFactory factory) {
        lock.writeLock().lock();
        try {
            RrdBackendFactory.registerFactory(factory);
            RrdBackendFactory.setDefaultFactory(factory.getName());
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static RrdBackendFactory getDefaultFactory() {
        lock.readLock().lock();
        try {
            RrdBackendFactory rrdBackendFactory = activeFactories.get(0);
            return rrdBackendFactory;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void setDefaultFactory(String factoryName) {
        block4: {
            lock.writeLock().lock();
            try {
                if (!RrdBackend.isInstanceCreated()) {
                    activeFactories.clear();
                    activeFactories.add(RrdBackendFactory.getFactory(factoryName));
                    break block4;
                }
                throw new IllegalStateException("Could not change the default backend factory. This method must be called before the first RRD gets created");
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    public static void setActiveFactories(RrdBackendFactory ... newFactories) {
        lock.writeLock().lock();
        try {
            activeFactories.clear();
            activeFactories.addAll(Arrays.asList(newFactories));
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void addFactories(RrdBackendFactory ... newFactories) {
        lock.writeLock().lock();
        try {
            activeFactories.addAll(Arrays.asList(newFactories));
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static RrdBackendFactory findFactory(URI uri) {
        lock.readLock().lock();
        try {
            for (RrdBackendFactory tryfactory : activeFactories) {
                if (!tryfactory.canStore(uri)) continue;
                RrdBackendFactory rrdBackendFactory = tryfactory;
                return rrdBackendFactory;
            }
            throw new IllegalArgumentException("no matching backend factory for " + uri);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static URI buildGenericUri(String rrdpath) {
        Matcher urimatcher = URIPATTERN.matcher(rrdpath);
        if (urimatcher.matches()) {
            String scheme = urimatcher.group("scheme");
            String authority = urimatcher.group("authority");
            String path = urimatcher.group("path");
            String query = urimatcher.group("query");
            String fragment = urimatcher.group("fragment");
            try {
                if (scheme != null && scheme.length() == 1) {
                    return new File(rrdpath).toURI();
                }
                if (scheme != null && path.charAt(0) != '/') {
                    return new URI(scheme, path, query);
                }
                if (File.separatorChar != '/' && scheme == null) {
                    path = path.replace(File.separatorChar, '/');
                }
                return new URI(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
        throw new IllegalArgumentException("Not an URI pattern");
    }

    public String getScheme() {
        return this.getName().toLowerCase();
    }

    protected URI getRootUri() {
        try {
            return new URI(this.getScheme(), null, "/", null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid scheme " + this.getScheme());
        }
    }

    public boolean canStore(URI uri) {
        return false;
    }

    protected URI resolve(URI rootUri, URI uri, boolean relative) {
        String path;
        String authority;
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals(rootUri.getScheme())) {
            return null;
        }
        if (scheme == null) {
            scheme = rootUri.getScheme();
        }
        if ((authority = uri.getAuthority()) != null && !authority.equals(rootUri.getAuthority())) {
            return null;
        }
        if (authority == null) {
            authority = rootUri.getAuthority();
        }
        if (!(path = uri.isOpaque() ? uri.getSchemeSpecificPart() : (!uri.isAbsolute() ? rootUri.resolve(uri).normalize().getPath() : uri.normalize().getPath())).startsWith(rootUri.getPath())) {
            return null;
        }
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        String newUriString = String.format("%s://%s%s%s%s", scheme, authority, path, query != null ? "?" + query : "", fragment != null ? "#" + fragment : "");
        URI newURI = URI.create(newUriString);
        if (relative) {
            return rootUri.relativize(newURI);
        }
        return newURI;
    }

    public URI getCanonicalUri(URI uri) {
        return this.resolve(this.getRootUri(), uri, false);
    }

    public URI getUri(String path) {
        URI rootUri = this.getRootUri();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            return new URI(this.getScheme(), rootUri.getAuthority(), rootUri.getPath() + path, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public String getPath(URI uri) {
        URI rootUri = this.getRootUri();
        uri = this.resolve(rootUri, uri, true);
        if (uri == null) {
            return null;
        }
        return "/" + uri.getPath();
    }

    protected abstract RrdBackend open(String var1, boolean var2) throws IOException;

    protected RrdBackend open(URI uri, boolean readOnly) throws IOException {
        return this.open(this.getPath(uri), readOnly);
    }

    protected abstract boolean exists(String var1) throws IOException;

    protected boolean exists(URI uri) throws IOException {
        return this.exists(this.getPath(uri));
    }

    protected abstract boolean shouldValidateHeader(String var1) throws IOException;

    protected boolean shouldValidateHeader(URI uri) throws IOException {
        return this.shouldValidateHeader(this.getPath(uri));
    }

    public abstract String getName();

    static {
        RrdRandomAccessFileBackendFactory fileFactory = new RrdRandomAccessFileBackendFactory();
        RrdBackendFactory.registerFactory(fileFactory);
        RrdMemoryBackendFactory memoryFactory = new RrdMemoryBackendFactory();
        RrdBackendFactory.registerFactory(memoryFactory);
        RrdNioBackendFactory nioFactory = new RrdNioBackendFactory();
        RrdBackendFactory.registerFactory(nioFactory);
        RrdSafeFileBackendFactory safeFactory = new RrdSafeFileBackendFactory();
        RrdBackendFactory.registerFactory(safeFactory);
        RrdBackendFactory.setActiveFactories(RrdBackendFactory.getFactory(DEFAULTFACTORY));
        URIPATTERN = Pattern.compile("^(?:(?<scheme>[a-zA-Z][a-zA-Z0-9+-\\.]*):)?(?://(?<authority>[^/\\?#]*))?(?<path>[^\\?#]*)(?:\\?(?<query>[^#]*))?(?:#(?<fragment>.*))?$");
    }
}

