/*!
 * jQuery plugin
 * Component for search view
 */
;
(function(factory) {
	var getDependencyMissingMsg = function(dependency) {
		return "cvSearchView depends on " + dependency + " and seems to be missing. Please include necessary files.";
	};
	if (!jQuery) {
		throw getDependencyMissingMsg('jQuery');
	} else if (!$.fn.cvSearchBox) {
		throw getDependencyMissingMsg('cvSearchBox');
	} else if (!$.fn.cvFacetsView) {
		throw getDependencyMissingMsg('cvFacetsView');
	} else if (!$.fn.cvSearchResultsView) {
		throw getDependencyMissingMsg('cvSearchResultsView');
	} else if (typeof (cvUtil) === "undefined") {
		throw getDependencyMissingMsg('cvUtil');
	} else {
		factory(jQuery);
	}

}(function($) {
	"use strict";
	/*
	 * schema - optional
	 */
	$.fn.cvSearchView = function(qbId, viewConfig, schema) {
		return this.each(function() {
			var $this = $(this), data = $this.data('cvSearchView');
			if (!data) {
				$this.data('cvSearchView', new SearchView(this, qbId, viewConfig, schema));
			}
		});
	};
	$.fn.cvSearchView.id = 0;
}));
function SearchView(element, qbId, config, schema) {
	this.$element = $(element);	
	this._qbId = qbId;
	this._origConfig = $.extend({}, config);
	this._origSchema = $.extend({}, schema);
	this._config = $.extend({}, this.defaults, this.getMergedConfig(config, schema));
	this.searchReq = $.extend({}, this.defaults.searchReq, this._config.searchReq);
	this._id = $.fn.cvSearchView.id++;
	this.initUrls();
	this.initDefaultSettings();
	this.render();

	this.latestSearchParams = null;
};

SearchView.prototype.Constants = {
	ID_PREFIX : "cvSearchViewHolder_",

	HOLDER_CLASS : "cvSearchViewHolder",
	FACETS_HOLDER_CLASS : "cvSearchViewFacetsHolder",
	RESULTS_PANE_CLASS : "cvSearchViewPane",
	RESULTS_HOLDER_CLASS : "cvSearchViewResultsHolder",
	SEARCH_BOX_HOLDER_CLASS : "cvSearchBoxHolder",
	ADD_FACET_OPTION_CLASS : "cvAddFacetOption",
	ADD_FACET_DROPDOWN_CLASS : "cvAddFacetDropdown",
	REST_API_SNIPPET_CLASS : "cvRestApiSnippet",

	holderStlyeWithFacet : "col-xl-10 col-lg-9 col-md-9 col-sm-8 col-xs-12 ",
	holderStlyeWithoutFacet : "first-child col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 ",

	FACET_PANE_SWITCH_CLASS : "col-xl-2 col-lg-3 col-md-3 col-sm-4",
	CUSTOM_COLLAPSE_CLASS : "cvCustomCollapse",
	cvSearchBox_Name : "cvSearchBox",
	EXPORT_RUNNING_STATUS : "running",
	EXPORT_FINISH_STATUS : "finished",
	EXPORT_STARTING_STATUS : "starting"
};
SearchView.prototype.templates = {
	holderTmpl : function(id, className) {
		return "<div class='row " + className + "' id='" + id + "'></div>";
	},
	facetsHolderTmpl : function(className) {
		return "<div class='first-child " + SearchView.prototype.Constants.FACET_PANE_SWITCH_CLASS + " hidden-xs " +
				className + "'></div>";
	},
	resultsPaneTmpl : function(className) {
		return "<div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 " + className + "'></div>";
	},
	resultsHolderTmpl : function(className, isFacetsEnabled) {
		var addClass = SearchView.prototype.Constants.holderStlyeWithoutFacet;
		if (isFacetsEnabled) {
			addClass = SearchView.prototype.Constants.holderStlyeWithFacet;
		}
		return "<div class='" + addClass + className + "'></div>";
	},
	searchBoxHolderTmpl : function(className) {
		return "<div class='col-lg-12 col-md-12 col-sm-12 col-xs-12'><div class='col-lg-3 col-md-2'></div><div class='col-lg-6 col-md-8 " +
				className + "'></div><div class='col-lg-3 col-md-2'></div></div>";
	},
	toolbarHolderTmpl : function(id) {
		return "<div class='col-lg-12 col-md-12 col-sm-12 col-xs-12' id='" + id + "'></div>";
	},
	addFacetBtnHtml : function() {
		var htm = "<button type='button' class='btn btn-primary'>" + cvSearchMessages.AddFilter + "</button>";
		return htm;
	},
	addFacetBtnGroupHtml : function(fieldsList, className) {
		var htm = "";
		$.each(fieldsList, function(i, fieldName) {
			htm += "<li><a class='" + className + "' href='#'>" + fieldName + "</a></li>";
		});
		return htm;
	},
	restApiSnippetHtml : function(text) {
		var elm = $("<textarea rows='5' readonly class='" + SearchView.prototype.Constants.REST_API_SNIPPET_CLASS +
				"' onclick='this.select();'>" + text + "</textarea>");
		elm.val(text);
		var outerElm = $("<div class='form-group'><label>" + cvSearchMessages.CopySnippetLabel + "</label></div>");
		outerElm.append(elm);
		return outerElm;
	}
};

SearchView.prototype.defaults = {
	isEditable : true,
	enableFacets : true,
	enableHighlighting : true,
};
SearchView.prototype.getMergedConfig = function(viewConfig, schemaConfig) {
	if (!$.isEmptyObject(viewConfig)) {
		var configToReturn = $.extend({}, viewConfig);
		configToReturn.columnConfig = this.setSchemaPropsInConfig(configToReturn.columnConfig, schemaConfig);
		configToReturn.facetConfig = this.setSchemaPropsInConfig(configToReturn.facetConfig, schemaConfig);
		return configToReturn;
	}
};
SearchView.prototype.setSchemaPropsInConfig = function(configArr, schemaConfig) {	
	if (!$.isEmptyObject(schemaConfig) && !$.isEmptyObject(configArr)) {
		var newConfigArr = [];
		$.each(configArr, function(index, eachConfig) {
			var configFromSchema = $.grep(schemaConfig, function(o) {
				return o.fieldName === eachConfig.fieldName;
			})[0];
			if (!qb.sv.isFieldToBeExcluded(eachConfig.fieldName) && !$.isEmptyObject(configFromSchema)) {
				eachConfig.schema = $.extend({}, configFromSchema);
				newConfigArr.push(eachConfig);
			}
		});
		return newConfigArr;
	}
	return configArr;
};
SearchView.prototype.getFacetableFields = function() {
	var fieldsList = [];	
	$.each(this._config.columnConfig, function(i, eachConfig) {
		if (qb.sv.isFacetingAllowed(eachConfig.schema.type)) {
			fieldsList.push(eachConfig.fieldName);
		}
	});

	return fieldsList;
};
SearchView.prototype.initUrls = function() {
	try {
		this.restApiPrefix = window.location.origin;
		if (!this.restApiPrefix) {
			this.restApiPrefix = window.location.protocol + "//" + window.location.hostname +
					(window.location.port ? ':' + window.location.port : '');
		}
	} catch (e) {
		console.error(e);
	}
};
SearchView.prototype.initDefaultSettings = function() {	
	if (!$.isEmptyObject(this._config.columnConfig)) {
		$.each(this._config.columnConfig, function(i, eachConfig) {
			qb.sv.setDefaultRenderer(eachConfig);
		});
	}
	if (!$.isEmptyObject(this._config.facetConfig)) {
		$.each(this._config.facetConfig, function(i, eachConfig) {
			qb.sv.setDefaultRenderer(eachConfig);
		});
	}
};
SearchView.prototype.render = function() {
	var holderId = this.Constants.ID_PREFIX + this._id;
	var holderDiv = $(this.templates.holderTmpl(holderId, this.Constants.HOLDER_CLASS));
	this.$element.append(holderDiv);
	var resultsPaneDiv = $(this.templates.resultsPaneTmpl(this.Constants.RESULTS_PANE_CLASS));
	var $svHeaderContainer = $("#svHeaderContainer",$("#seaContainer"));
	var searchBoxHolderDiv = $(this.templates.searchBoxHolderTmpl(this.Constants.SEARCH_BOX_HOLDER_CLASS));
	var resultsHolderDiv = $(this.templates.resultsHolderTmpl(this.Constants.RESULTS_HOLDER_CLASS,
			this._config.enableFacets));
	resultsPaneDiv.append(searchBoxHolderDiv);
	holderDiv.append($svHeaderContainer);
	var $svActionBtns = $("<div class='col-sm-6 actionBtnWrapper' style='text-align:right'> </div>");
	$svHeaderContainer.append($svActionBtns);
	if (this._config.disableAddFilter === undefined || !this._config.disableAddFilter === true) {
		this.addFacetBtnElm = $(this.templates.addFacetBtnHtml());
		$svActionBtns.append(this.addFacetBtnElm);
	}

	if (sea.isDcubeExportEnabled) {
		$svActionBtns.append(this.getExportButton());
	}

	//TODO: Enable and fix the issue once 9456 gets checked-in
	//toolBar.addButton(this.getRestApiButton());
	if (sea.isCustomReportsEnabled) {
		$svActionBtns.append(this.getBuildMyReportButton());
	}
	

	if (this._config.enableFacets) {
		var facetsHolderDiv = $(this.templates.facetsHolderTmpl(this.Constants.FACETS_HOLDER_CLASS));
		resultsPaneDiv.append(facetsHolderDiv);
		// initialize the widgets after appending
		facetsHolderDiv.cvFacetsView(this._qbId, this._config, this._origSchema);
		this.facetsElm = facetsHolderDiv;
	}
	resultsPaneDiv.append(resultsHolderDiv);
	//holderDiv.append(searchBoxHolderDiv);
	holderDiv.append(resultsPaneDiv);
	// initialize the widgets after appending
	searchBoxHolderDiv.find("." + this.Constants.SEARCH_BOX_HOLDER_CLASS).cvSearchBox(this._qbId, this._config);

	//For the sake of export. The latest search params are used to create the content of the export file
	resultsHolderDiv.cvSearchResultsView(this._qbId, this._config, this._origSchema);

	// assign the elements to instance as we need for event handling
	this.searchBoxElm = searchBoxHolderDiv;
	this.resultsViewElm = resultsHolderDiv;
	if (this.addFacetBtnElm) {
		this.checkAndUpdateFacetableList();
	}
	this.attachListeners();
	this.postRender();
};
SearchView.prototype.clear = function() {
	$("#" + this.getIdStr()).remove();
};
SearchView.prototype.getIdStr = function() {
	return this.Constants.ID_PREFIX + this._id;
};
SearchView.prototype.mask = function() {
	$("#" + this.getIdStr()).mask("");
};
SearchView.prototype.unmask = function() {
	$("#" + this.getIdStr()).unmask();
};
SearchView.prototype.postRender = function() {
	var facetConfig = {};
	if (this.facetsElm) {
		var facetViewObj = this.facetsElm.data(FacetsView.prototype.Constants.cvFacetView_Name);
		facetConfig = facetViewObj.getConfig();
		if (facetViewObj.fnIsToBeHidden()) {
			this.hideFacets();
		}
	}
	this.onSubmitSearch();
};
SearchView.prototype.hideFacets = function() {
	this.resultsViewElm.removeClass(this.Constants.holderStlyeWithFacet)
			.addClass(this.Constants.holderStlyeWithoutFacet);
};
SearchView.prototype.showFacets = function() {
	this.resultsViewElm.removeClass(this.Constants.holderStlyeWithoutFacet)
			.addClass(this.Constants.holderStlyeWithFacet);
};
SearchView.prototype.attachListeners = function() {
	var self = this;
	this.$element.on(cvSearchConstants.EventConstants.RELOAD_SEARCH_VIEW, function(event) {
		self.onSubmitSearch();
	});

	this.$element.on(cvSearchConstants.EventConstants.CACHE_SEARCH_PARAMS, function(event, params) {
		self.latestSearchParams = params;
	});

	if (this.facetsElm) {
		this.facetsElm.on(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, function(event, facetConfig,
				facetReq, isRefreshRequired) {
			self.onFacetRequestChange(facetConfig, facetReq, isRefreshRequired);
			self.postAddRemoveFacetOption();
		});
		this.facetsElm.on(cvSearchConstants.EventConstants.ON_FACETS_VIEW_REPAINT, function(event, isExpand) {
			if (isExpand) //isExpand = false when facets pane collapsed
			{
				self.facetsElm.removeClass(self.Constants.CUSTOM_COLLAPSE_CLASS)
						.addClass(self.Constants.FACET_PANE_SWITCH_CLASS);
				self.showFacets();
			} else {
				self.facetsElm.addClass(self.Constants.CUSTOM_COLLAPSE_CLASS)
						.removeClass(self.Constants.FACET_PANE_SWITCH_CLASS);
				self.hideFacets();
			}
		});
	}
	if (this.addFacetBtnElm) {
		this.addFacetBtnElm.on("click", function(event, eventData) {
			self.facetsElm.trigger(cvSearchConstants.EventConstants.ON_FACET_ADD_CLICK, [ self.facetableFieldsList ]);
		});
	}

};
SearchView.prototype.postAddRemoveFacetOption = function() {
	var facetViewObj = this.facetsElm.data(FacetsView.prototype.Constants.cvFacetView_Name);
	if (facetViewObj.fnIsToBeHidden()) {
		this.facetsElm.removeClass(this.Constants.CUSTOM_COLLAPSE_CLASS);
		this.hideFacets();
	} else {
		this.showFacets();
	}
	if (this.addFacetBtnElm) {
		this.checkAndUpdateFacetableList();
	}
};

SearchView.prototype.onFacetRequestChange = function(facetConfig, facetReq, isRefreshRequired) {
	qb.sv.setFilter(this._qbId, facetConfig, facetReq);
	if (isRefreshRequired) {
		this.resultsViewElm.trigger(cvSearchConstants.EventConstants.RELOAD_SEARCH_RESULTS_VIEW);
	}
	this.facetsElm.trigger(cvSearchConstants.EventConstants.RELOAD_FACETS_VIEW);
};

SearchView.prototype.onSubmitSearch = function() {
	//trigger refresh of the sub components
	this.resultsViewElm.trigger(cvSearchConstants.EventConstants.RELOAD_SEARCH_RESULTS_VIEW);
	if (this.facetsElm) {
		this.facetsElm.trigger(cvSearchConstants.EventConstants.RELOAD_FACETS_VIEW);
	}
};
SearchView.prototype.checkAndUpdateFacetableList = function() {
	this.facetableFieldsList = this.getFacetableFields();
	var facetViewObj = this.facetsElm.data(FacetsView.prototype.Constants.cvFacetView_Name);
	facetsShownList = facetViewObj.getFieldsListFromConfig();
	// get the fields that are not shown
	this.facetableFieldsList = this.facetableFieldsList.filter(function(f) {
		return facetsShownList.indexOf(f) == -1;
	});
	if ($.isEmptyObject(this.facetableFieldsList)) {
		this.addFacetBtnElm.hide();
	} else {
		this.addFacetBtnElm.show();
	}
};
SearchView.prototype.getSaveSettingsButton = function(isEditable) {
	var self = this;
	var btn = $("<button class='btn btn-success'/>");
	var btnHandler = function() {
		var facetViewObj = self.facetsElm.data(FacetsView.prototype.Constants.cvFacetView_Name);
		var resultsViewObj = self.resultsViewElm.data(SearchResultsView.prototype.Constants.cvSearchResultsView_Name);
		var configToSave = $.extend(true, {}, self._origConfig);
		var modifiedFacetConfig = facetViewObj.getConfigToSave();
		var modifiedGridConfig = resultsViewObj.getConfigToSave();
		configToSave.tableConfig = modifiedGridConfig.tableConfig;
		configToSave.columnConfig = modifiedGridConfig.columnConfig;
		configToSave.facetConfig = modifiedFacetConfig;
		self.$element
				.trigger(cvSearchConstants.EventConstants.ON_SEARCH_SETTINGS_CHANGED, [ configToSave, isEditable ]);
	};
	if (isEditable) {
		$(btn).text(cvSearchMessages.SaveSettings);
	} else {
		$(btn).text(cvSearchMessages.SaveAsBtnText);
	}
	$(btn).click(btnHandler);
	return btn;
};

SearchView.prototype.getRestApiButton = function() {
	var self = this;
	var btn = $("<button class='btn btn-primary'/>");
	var btnHanlder = function() {
		var dlgId = self.getIdStr() + "_modal";
		$("#" + dlgId).remove(); // remove previous instances
		// of dialog
		var dlg = $("<div id='" + dlgId + "'/>");
		dlg.appendTo("body").cvModal();
		$(".modal-title", dlg).text(cvSearchMessages.RestApiTitle);
		$(".modal-body", dlg).append(self.templates.restApiSnippetHtml(self.restApiPrefix + self.searchReqUrlStr));
		$(".modal", dlg).modal('show').on('shown.bs.modal', function() {
			$("." + self.Constants.REST_API_SNIPPET_CLASS, dlg).select();
		});
	};
	$(btn).text(cvSearchMessages.GetRestApiBtnText);
	$(btn).click(btnHanlder);
	return btn;
};
SearchView.prototype.getBuildMyReportButton = function() {
	var self = this;
	var btn = $("<a class='btn btn-warning newreport' style='margin-left: 5px;color:white !important'/>");
	var btnHanlder = function() {
		self.$element.trigger(cvSearchConstants.EventConstants.ON_BUILD_MY_REPORT_CLICKED, []);
	};
	$(btn).text(cvSearchMessages.BuildMyReportBtnText);
	$(btn).click(btnHanlder);
	return btn;
};

SearchView.prototype.normalizeSearchParams = function(params) {
	var flList = "";
	//normalize just 'fl' for the time being
	for (var i = 0; i < params.length; i++) {
		var param = params[i];
		if (param.key === "fl") {
			flList += param.value + ",";
			params.splice(i, 1);
			i--;
		}
	}

	//remove trailing comma
	flList = flList.replace(/(^,)|(,$)/g, "");

	params.push({
		key : "fl",
		value : flList
	});

	return params;
};

SearchView.prototype.getExportButton = function() {
	var self = this;
	var spinner = "<span class='glyphicon glyphicon-refresh glyphicon-spin'></span><span style='margin-left: 5px;'>" +
			cvSearchMessages.ExportBtnText + "</span>";
	var btn = $("<a class='btn btn-info export' style='margin-left: 5px'/>");
	btn.attr("data-loading-text", spinner);

	/* To-Do: replace doPoll() with cvUtil.setOneTimeCall() */
	var doPoll = function(handlerId, token) {
		sea.services.getExportStatus(handlerId, token, function(resp) {
			var statusObject = JSON.parse(resp.error.customMap.value);
			if (statusObject.response.status == self.Constants.EXPORT_RUNNING_STATUS ||
					statusObject.response.status == self.Constants.EXPORT_STARTING_STATUS) {
				setTimeout(function() {
					doPoll(handlerId, token);
				}, 3000);
			} else if (statusObject.response.status == self.Constants.EXPORT_FINISH_STATUS) {
				var downloadGuid = statusObject.response.downloadGuid;
				$(btn).button('reset');
				var $iFrame = $("<iframe class='hidden' src='" + cvUtil.getContextPath() +
						"/server/reports/doExportDownload.do?downloadGuid=" + downloadGuid + "'></iframe>");
				$("#seaContainer").append($iFrame);
				
			} else {
				$(btn).button('reset');
				cvUtil.errorToast(localMsg.DownloadFailed);
			}
		}, function(resp, message) {
			cvUtil.errorToast(message);
			$(btn).button('reset');
		});
	};

	var btnHandler = function() {
		var reqObj = JSON.parse(self.latestSearchParams);
		reqObj.searchParams = self.normalizeSearchParams(reqObj.searchParams);
		var handlerId = self._origConfig.handlerInfo.handlerId;
		$(btn).button('loading');
		sea.services.exportSearchView(handlerId, reqObj, function(resp) {
			var token = resp.error.customMap.name;
			doPoll(handlerId, token);
		}, function(resp, message) {
			cvUtil.errorToast(message);
			$(btn).button('reset');
		});
	};

	$(btn).text(cvSearchMessages.ExportBtnText);
	$(btn).click(btnHandler);
	return btn;
};