/*!
 * jQuery plugin
 * Component for all the facets
 * Responsible for creating holder for all the facets
 */
;
(function(factory) {
	var getDependencyMissingMsg = function(dependency) {
		return "cvFacetsView depends on " + dependency + " and seems to be missing. Please include necessary files.";
	};
	if (!jQuery)
		throw getDependencyMissingMsg('jQuery');
	else if (!$.fn.collapse)
		throw getDependencyMissingMsg('bootstrap collapse');
	else if (!$.fn.cvFacetWidget)
		throw getDependencyMissingMsg('cvFacetWidget');
	else if (typeof (cvSearchUtil) === "undefined")
		throw getDependencyMissingMsg('cvSearchUtil');
	else if (typeof (cvFormatters) === "undefined")
		throw getDependencyMissingMsg('cvFormatters');
	else
		factory(jQuery);

}(function($) {
	"use strict";

	$.fn.cvFacetsView = function(qbId, facetsConfig, schema, facetReq) {
		return this.each(function() {
			var $this = $(this), data = $this.data('cvFacetsView');
			if (!data)
				$this.data('cvFacetsView', new FacetsView(this, qbId, facetsConfig, schema, facetReq));
		});
	};
	$.fn.cvFacetsView.id = 0;
}));
/*
 * schema, facetReq - optional
 */
function FacetsView(element, qbId, config, schema, facetReq) {
	this.$element = $(element);
	this._qbId = qbId;
	this._origConfig = $.extend({}, config);
	this._origSchema = $.extend({}, schema);
	this._config = $.extend({}, this.defaults, this.getFacetConfig());
	this._id = $.fn.cvFacetsView.id++;
	this.widgetsMap = {};
	if (facetReq)
		this.facetReq = facetReq;
	else
		this.facetReq = {};
	var contextPath = config.contextPath;
	this.contextPath = contextPath ? (contextPath.lastIndexOf("/") > 0 ? contextPath : contextPath + "/") : "";
	this.buildTs = config.buildTs ? config.buildTs : "";
	this.facetSettingsTmplPath = this.contextPath + this.Constants.SETTINGS_TMPL_PATH + "?" + this.buildTs;
	// dev
	// this.facetSettingsTmplPath = this.contextPath
	// + this.Constants.SETTINGS_TMPL_PATH + "?" + new Date().getTime();
	this.state = {};
	this.render();
	this.attachListeners();
};

FacetsView.prototype.Constants = {
	FACETS_ID_PREFIX : "cvFacetsViewHolder_",
	EACH_FACET_ID_PREFIX : "cvEachFacetContainerHolder_",

	FACETS_HOLDER_CLASS : "cvFacetsViewHolder",
	FACETS_EMPTY_MSG_CLASS : "cvFacetsViewEmptyMsg",
	EACH_FACET_HOLDER_CLASS : "cvEachFacetContainerHolder",
	FACET_BODY_CLASS : "cvFacetContainerBody",
	EACH_FACET_BODY_CLASS : "cvEachFacetContainerBody",
	EACH_FACET_HEADING_CLASS : "cvEachFacetContainerHeading",
	FACET_TOOLBAR_CLASS : "cvFacetToolbar",
	EACH_FACET_TOOLBAR_CLASS : "cvEachFacetToolbar",

	RESET_BTN_CLASS : "cvFacetResetBtn",
	REMOVE_BTN_CLASS : "cvFacetRemoveBtn",
	SETTINGS_BTN_CLASS : "cvFacetSettingsBtn",
	SETTINGS_MODAL_CLASS : "cvFacetSettingsModal",

	DATA_ATTR_FIELD_NAME : "fieldname",

	cvFacetWidget_Name : "cvFacetWidget",
	cvFacetView_Name : "cvFacetsView",

	SETTINGS_TMPL_PATH : "searchcomponents/templatehtml/cvFacetWidgetSettings.html"
};
FacetsView.prototype.templates = {
	facetHolderTmpl : function(id, className, isCollapsible) {
		var classes = className;
		if (isCollapsible)
			classes += " panel panel-default";
		return "<div id='" + id + "' class='" + classes + "'></div>";
	},
	eachFacetHolderTmpl : function(className) {
		return "<div class='" + className + "'></div>";
	},
	eachFacetHeadingTmpl : function(id, title, className, fieldName, facetWidgetSettings) {
		if ($.isEmptyObject(facetWidgetSettings))
			facetWidgetSettings = {};

		var tmpl = "<div class='container-fluid panel-heading row-no-padding " + className + "' data-toggle='collapse'" + " href='#" + id + "'>" +
				"<span class='glyphicon-toggle glyphicon sqlAccessText col-lg-1'></span>" +
				"<h4 class='panel-title col-lg-11'>" + "<a>" + "<div><span class='col-lg-9'>" + title + "</span><span class='col-lg-3 ";
		if (fieldName)
			tmpl += FacetsView.prototype.Constants.EACH_FACET_TOOLBAR_CLASS + "' data-" +
					FacetsView.prototype.Constants.DATA_ATTR_FIELD_NAME + "='" + fieldName + "'";
		else
			tmpl += FacetsView.prototype.Constants.FACET_TOOLBAR_CLASS + "'";

		tmpl += ">";

		if (facetWidgetSettings.hasTrash !== false) 
			tmpl += "<span title='Remove' class='pull-right glyphicon-trash glyphicon " +
					FacetsView.prototype.Constants.REMOVE_BTN_CLASS + "'></span>";

		if (fieldName && facetWidgetSettings.hasSettings !== false)
			tmpl += "<span title='Settings' class='pull-right glyphicon-wrench glyphicon " +
					FacetsView.prototype.Constants.SETTINGS_BTN_CLASS + "'></span>";


		tmpl += "<span title='Reset' class='pull-right glyphicon-refresh glyphicon " +
				FacetsView.prototype.Constants.RESET_BTN_CLASS + "'></span>";

		tmpl += "</span>" + "</div>" + "</a>" + "</h4>" + "</div>";
		return tmpl;
	},
	facetBodyTmpl : function(id, className) {
		var tmpl = "<div id='" + id + "' class='panel-collapse collapse in'>" + "<div class='" + className +
				"'></div></div>";
		return tmpl;
	},
	eachFacetBodyTmpl : function(id, className) {
		var tmpl = "<div id='" + id + "' class='panel-collapse collapse in'>" + "<div class='panel-body " + className +
				"'></div></div>";
		return tmpl;
	},
	emptyMsgTmpl : function(className) {
		return "<div class='" + className + "'>" + cvSearchMessages.NoFacetsMsg + "</div>";
	}
};
FacetsView.prototype.defaults = {
	isCollapsible : true
};
FacetsView.prototype.getFacetConfig = function() {
	var self = this;
	var facetConfig = [];
	if (!$.isEmptyObject(this._origConfig.facetConfig))
		$.each(this._origConfig.facetConfig, function(i, eachConfig) {
			var flag = true;
			if (typeof self._origSchema !== "undefined") {
				var schemaObj = cvSearchUtil.getObjectByKeyValue(self._origSchema, {
					fieldName : eachConfig.fieldName
				});
				if (!$.isEmptyObject(schemaObj) && !qb.sv.isFacetingAllowed(eachConfig.schema.type))
					flag = false;
			}
			if (flag)
				facetConfig.push(eachConfig);
		});
	var configToReturn = {
		title : this._origConfig.facetPanelTitle,
		facetConfig : facetConfig
	};
	return configToReturn;
};
FacetsView.prototype.render = function() {
	try {
		var self = this;
		if ($.isEmptyObject(self._config.facetConfig)) {
			this.state.isToBeHidden = true;
			return;
		}
		var facetHolder = null;
		var facetHolderId = self.Constants.FACETS_ID_PREFIX + self._id;
		var facetsDiv = $(self.templates.facetHolderTmpl(facetHolderId,
				self.Constants.FACETS_HOLDER_CLASS,
				self._config.isCollapsible));
		if (self._config.isCollapsible) {
			// create collapsible holder for all facets
			var facetHeadingDiv = $(self.templates.eachFacetHeadingTmpl(facetHolderId + "_Body",
					self._config.title,
					self.Constants.EACH_FACET_HEADING_CLASS,
					null,
					self._origConfig.facetWidgetSettings));
			var facetBodyDiv = $(self.templates.facetBodyTmpl(facetHolderId + "_Body", self.Constants.FACET_BODY_CLASS));
			facetsDiv.append(facetHeadingDiv);
			facetsDiv.append(facetBodyDiv);
			facetHolder = facetBodyDiv.find("." + self.Constants.FACET_BODY_CLASS);
		} else
			facetHolder = facetsDiv;
		var eachFacetHolderId, eachFacetHolderDiv, eachFacetHeadingDiv, eachFacetBodyDiv;
		self._config.facetConfig = cvSearchUtil.sortArrayByKey(self._config.facetConfig, "dispOrder");
		var modifiedConfigArr = [];
		$.each(self._config.facetConfig, function(index, eachFacet) {
			eachFacet.dispName = eachFacet.dispName || eachFacet.fieldName;
			eachFacetHolderId = self.Constants.EACH_FACET_ID_PREFIX + self._id + "_" + index;
			eachFacetHolderDiv = $(self.templates.eachFacetHolderTmpl(self.Constants.EACH_FACET_HOLDER_CLASS));
			// heading
			eachFacetHeadingDiv = $(self.templates.eachFacetHeadingTmpl(eachFacetHolderId,
					eachFacet.dispName,
					self.Constants.EACH_FACET_HEADING_CLASS,
					eachFacet.fieldName,
					eachFacet.facetWidgetSettings));
			// body
			eachFacetBodyDiv = $(self.templates.eachFacetBodyTmpl(eachFacetHolderId,
					self.Constants.EACH_FACET_BODY_CLASS));
			var widgetElm = eachFacetBodyDiv.find("." + self.Constants.EACH_FACET_BODY_CLASS);
			widgetElm.cvFacetWidget(self._qbId, eachFacet);
			self.widgetsMap[eachFacet.fieldName] = widgetElm;
			// get the modified config and save it for future
			// reference
			modifiedConfigArr.push(self.widgetsMap[eachFacet.fieldName].data(self.Constants.cvFacetWidget_Name)
					.getConfig());
			// append heading + body to the each facet holder
			eachFacetHolderDiv.append(eachFacetHeadingDiv);
			eachFacetHolderDiv.append(eachFacetBodyDiv);
			eachFacetBodyDiv.collapse({
				toggle : false
			});
			// append each facet holder to all facets holder
			facetHolder.append(eachFacetHolderDiv);
		});
		facetHolder.append($(self.templates.emptyMsgTmpl(self.Constants.FACETS_EMPTY_MSG_CLASS)).hide());
		self._config.facetConfig = modifiedConfigArr;
		// append the facets holder to the element

		/* Irrespective of whether the filters are minimized or not, adding a new filter should expand it. */
		this.onExpandCollapse(true, this.$element);

		// this.$element.addClass(SearchView.prototype.Constants.FACET_PANE_SWITCH_CLASS);
		this.$element.append(facetsDiv);
	} catch (e) {
		console.error(e);
	}
};
FacetsView.prototype.getConfig = function() {
	return this._config.facetConfig;
};
FacetsView.prototype.getConfigToSave = function() {
	var self = this;
	var config = [];
	if (!$.isEmptyObject(this.widgetsMap))
		$.each(this.widgetsMap, function(i, eachWidget) {
			var eachConfig = eachWidget.data(self.Constants.cvFacetWidget_Name).getConfigToSave();
			// remove the schema properties from the config
			delete eachConfig.schema;
			config.push(eachConfig);
		});
	return config;
};
FacetsView.prototype.getFacetReqToSave = function() {
	var fReq = {}, selArr;
	if (!$.isEmptyObject(this.facetReq)) {
		$.each(this.facetReq, function(fName, fObj) {
			selArr = [];
			for (var i = 0; i < fObj.selectedValues.length; i++)
				selArr.push(fObj.selectedValues[i].value);
			fReq[fName] = selArr;
		});
	}
	console.log("to save", fReq);
	return fReq;
};
FacetsView.prototype.getFieldsListFromConfig = function() {
	var fieldsList = [];
	if (!$.isEmptyObject(this._config.facetConfig))
		$.each(this._config.facetConfig, function(i, obj) {
			fieldsList.push(obj.fieldName);
		});
	return fieldsList;
};
FacetsView.prototype.clear = function() {
	$("#" + this.getIdStr()).remove();
	this.state.isToBeHidden = false;
};
FacetsView.prototype.fnIsToBeHidden = function() {
	return this.state.isToBeHidden;
};
FacetsView.prototype.getIdStr = function() {
	return this.Constants.FACETS_ID_PREFIX + this._id;
};
FacetsView.prototype.mask = function() {
	$("#" + this.getIdStr()).mask("");
};
FacetsView.prototype.unmask = function() {
	$("#" + this.getIdStr()).unmask();
};
FacetsView.prototype.showEmptyMsg = function() {
	$("#" + this.getIdStr()).find("." + this.Constants.FACETS_EMPTY_MSG_CLASS).show();
};
FacetsView.prototype.hideEmptyMsg = function() {
	$("#" + this.getIdStr()).find("." + this.Constants.FACETS_EMPTY_MSG_CLASS).hide();
};
FacetsView.prototype.setFacetResp = function(facetResp) {
	var self = this;
	// show all the facet widgets
	this.$element.find("." + this.Constants.EACH_FACET_HOLDER_CLASS).show();
	if (!$.isEmptyObject(facetResp)) {
		$.each(facetResp, function(eachFacetName, facetValues) {
			self.widgetsMap[eachFacetName].data(self.Constants.cvFacetWidget_Name).setFacetResp(facetValues);
			self.checkAndHideEachFacet(eachFacetName);
			self.checkAndShowResetBtn(eachFacetName);
		});
	} else {
		this.checkIfFacetsPaneEmpty(true);
	}
	this.checkIfFacetsPaneEmpty();
	this.checkAndShowResetBtn();
};
FacetsView.prototype.checkAndHideEachFacet = function(facetName) {
	if (this.widgetsMap[facetName].data(this.Constants.cvFacetWidget_Name).fnIsToBeHidden()) {
		var elm = this.widgetsMap[facetName];
		$(elm.closest("." + this.Constants.EACH_FACET_HOLDER_CLASS)).hide();
	}
};
FacetsView.prototype.checkIfFacetsPaneEmpty = function(isEmptyResp) {
	var self = this;
	var isAllHidden = true;
	$.each(self.widgetsMap, function(i, eachWidget) {
		if (isEmptyResp || eachWidget.data(self.Constants.cvFacetWidget_Name).fnIsToBeHidden()) {
			$(eachWidget.closest("." + self.Constants.EACH_FACET_HOLDER_CLASS)).hide();
		} else
			isAllHidden = false;
	});
	if (isAllHidden)
		this.showEmptyMsg();
	else
		this.hideEmptyMsg();
};
FacetsView.prototype.attachListeners = function() {
	var self = this;

	this.$element.on(cvSearchConstants.EventConstants.ON_FACET_SELECTED, function(event, eventData) {
		self.onFacetSelected(eventData);
	});
	this.$element.on(cvSearchConstants.EventConstants.ON_FACET_ADD_CLICK, function(event, eventData) {
		self.onAddFacetSettings(eventData);
	});
	this.$element.on(cvSearchConstants.EventConstants.RELOAD_FACETS_VIEW, function(event) {
		if (!$.isEmptyObject(self._config.facetConfig)) {
			self.mask();
			qb.sv.doFacet(self._qbId, self._config.facetConfig, self.facetReq, false, function(facetResp) {
				self.unmask();
				self.setFacetResp(facetResp);
			});
		}
	});
	//TODO: remove this method; this is for web analytics to work
	this.$element.on(cvSearchConstants.EventConstants.ON_SEARCH_RESPONSE_RECEIVED, function(event, eventData) {
		self.setFacetResp(qb.sv.processFacetResponse(self._qbId, self._config.facetConfig, self.facetReq, true, eventData));
	});
	this.$element.on("click", "." + this.Constants.RESET_BTN_CLASS, function(event) {
		event.stopPropagation();
		$(this).hide();
		var fieldName = $(this).closest("." + self.Constants.EACH_FACET_TOOLBAR_CLASS)
				.data(self.Constants.DATA_ATTR_FIELD_NAME);
		if (fieldName)
			self.onEachFacetReset(fieldName);
		else
			self.onFacetReset();
	});
	this.$element.on("click", "." + this.Constants.REMOVE_BTN_CLASS, function(event) {
		event.stopPropagation();
		var fieldName = $(this).closest("." + self.Constants.EACH_FACET_TOOLBAR_CLASS)
				.data(self.Constants.DATA_ATTR_FIELD_NAME);
		if (fieldName)
			self.onFacetRemoved(fieldName);
		else
			self.onAllFacetRemoved();
	});
	this.$element.on("click", "." + this.Constants.SETTINGS_BTN_CLASS, function(event) {
		event.stopPropagation();
		var fieldName = $(this).closest("." + self.Constants.EACH_FACET_TOOLBAR_CLASS)
				.data(self.Constants.DATA_ATTR_FIELD_NAME);
		if (fieldName)
			self
					.onEditEachFacetSettings(self.widgetsMap[fieldName].data(self.Constants.cvFacetWidget_Name)
							.getConfig());
		else
			self.onEditFacetSettings();
	});
	if (this._config.isCollapsible) {
		this.$element.on('hidden.bs.collapse', "." + this.Constants.FACETS_HOLDER_CLASS, function(e) {
			self.onExpandCollapse(false, $(this));
		}).on('show.bs.collapse', "." + this.Constants.FACETS_HOLDER_CLASS, function(e) {
			self.onExpandCollapse(true, $(this));
		});
		this.$element.on('hidden.bs.collapse', "." + this.Constants.EACH_FACET_HOLDER_CLASS, function(e) {
			e.stopPropagation();
		}).on('show.bs.collapse', "." + this.Constants.EACH_FACET_HOLDER_CLASS, function(e) {
			e.stopPropagation();
		});
	}
};
FacetsView.prototype.onFacetReset = function() {
	this.$element.find("." + this.Constants.RESET_BTN_CLASS).hide();
	this.facetReq = {};
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			true ]);
};
FacetsView.prototype.onEachFacetReset = function(fieldName) {
	this.facetReq[fieldName].selectedValues = [];
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			true ]);
};
FacetsView.prototype.onFacetSelected = function(selectedFacet) {
	var facetName = selectedFacet.fieldName;
	this.facetReq[facetName] = {};
	this.facetReq[facetName].selectedValues = selectedFacet.params;
	this.checkAndShowResetBtn(facetName);
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			true ]);
	this.getFacetReqToSave();
};
FacetsView.prototype.onFacetAdded = function(dlg, fName) {
	var facetObj = this.getEachFacetSettings(dlg, this.getDefaultFacetObjByFieldName(fName));
	qb.sv.setDefaultRenderer(facetObj);
	facetObj.dispOrder = this._config.facetConfig.length;
	this._config.facetConfig.push(facetObj);
	this.clear();
	this.render();
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			false ]);
};
FacetsView.prototype.onExpandCollapse = function(isExpand, elm) {
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACETS_VIEW_REPAINT, [ isExpand ]);
};

FacetsView.prototype.getDefaultFacetObjByFieldName = function(fName) {
	var self = this;
	var facetObj = cvSearchUtil.getObjectByKeyValue(this._config.facetConfig, {
		fieldName : fName
	});
	if ($.isEmptyObject(facetObj)) {
		facetObj = {
			fieldName : fName,
			dispName : fName
		};
		if (typeof this._origSchema !== "undefined") {
			var schemaObj = cvSearchUtil.getObjectByKeyValue(this._origSchema, {
				fieldName : fName
			});
			if (!$.isEmptyObject(schemaObj)) {
				facetObj.schema = $.extend({}, schemaObj);
			}
		}
		facetObj = $.extend({}, FacetWidget.prototype.defaults, facetObj);
	}
	return facetObj;
};
FacetsView.prototype.onFacetRemoved = function(fName) {
	var fArr = this._config.facetConfig;
	var facetIndex = cvSearchUtil.getIndexByKeyValue(fArr, {
		fieldName : fName
	});
	for (var i = facetIndex + 1; i < fArr.length; i++)
		fArr[i].dispOrder = i - 1;
	this._config.facetConfig.splice(facetIndex, 1);
	delete this.facetReq[fName];
	delete this.widgetsMap[fName];
	this.clear();
	this.render();
	//when a facet is getting removed, if it had a selection then we need to refresh other views too. so passing true for isRefreshRequired
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			true ]);
};
FacetsView.prototype.onAllFacetRemoved = function() {
	this._config.facetConfig = [];
	this.widgetsMap = {};
	this.facetReq = {};
	this.clear();
	this.render();
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			true ]);
};

FacetsView.prototype.onEditFacetSettings = function() {

};
/*
 * if facetName is available, show reset for that widget based on hasSelection flag if facetName is not
 * passed, check all the widgets for hasSelection and show reset of facets pane if atleast one of the widget
 * has selection
 */
FacetsView.prototype.checkAndShowResetBtn = function(facetName) {
	var self = this;
	if (facetName) {
		var selector = "." + this.Constants.EACH_FACET_TOOLBAR_CLASS + "[data-fieldName=" + facetName + "] ." +
				this.Constants.RESET_BTN_CLASS;

		if (this.widgetsMap[facetName].data(this.Constants.cvFacetWidget_Name).fnHasSelection())
			this.$element.find(selector).show();
		else
			this.$element.find(selector).hide();
	}

	else {
		var selector = "." + this.Constants.FACET_TOOLBAR_CLASS + " ." + this.Constants.RESET_BTN_CLASS;
		var atleastOneFacetHasSelection = false;
		$.each(this.widgetsMap, function(i, eachWidget) {
			if (eachWidget.data(self.Constants.cvFacetWidget_Name).fnHasSelection()) {
				atleastOneFacetHasSelection = true;
				return;
			}
		});
		if (atleastOneFacetHasSelection)
			this.$element.find(selector).show();
		else
			this.$element.find(selector).hide();
	}

};
FacetsView.prototype.onAddFacetSettings = function(fieldsList) {
	var self = this;
	var loadCallback = function(dlg) {
		$(".modal-title", dlg).text(cvSearchMessages.AddFilter);
		$(".modal-footer .okBtn", dlg).text(cvSearchMessages.AddBtnText).off("click").on("click", function(e) {
			self.onFacetAdded(dlg, $("select#fieldName", dlg).val());
		});
		$("input#fieldName", dlg).hide();
		var fieldNameCombo = $("select#fieldName", dlg).show();
		var rendererCombo = $("select#rendererType", dlg);
		fieldNameCombo.empty();
		$.each(fieldsList, function(i, v) {
			var optHtml = "<option value=\"" + v + "\">" + v + "</option>";
			fieldNameCombo.append(optHtml);
		});
		fieldNameCombo.off("change").on("change", function(e) {
			var fObj = self.getDefaultFacetObjByFieldName($(this).val());
			self.setEachFacetSettings(dlg, fObj);
		});
		rendererCombo.off("change").on("change", function(e) {
			self.onRendererChosen($(this).val(), dlg);
		});

		//reset formatter to default
		$("#rendererType", dlg).val("");
		$(".modal", dlg).modal('show').off('shown.bs.modal').on('shown.bs.modal', function(e) {
			fieldNameCombo.focus();
			fieldNameCombo.change();
		});
	};
	uiControls.util.loadModal(this.Constants.FACETS_ID_PREFIX + "modal", this.facetSettingsTmplPath, loadCallback);
};
FacetsView.prototype.onEditEachFacetSettings = function(facetObj) {
	var self = this;
	var loadCallback = function(dlg) {
		$(".modal-title", dlg).text(cvSearchMessages.FacetSettingsTitle);
		$(".modal-footer .okBtn", dlg).text(cvSearchMessages.ApplyBtnText).off("click").on("click", function(e) {
			self.applyEachFacetSettings(dlg, facetObj);
		});
		$("select#fieldName", dlg).hide();
		$("input#fieldName", dlg).val(facetObj.fieldName).show();
		self.setEachFacetSettings(dlg, facetObj);
		$(".modal", dlg).modal('show').off('shown.bs.modal').on('shown.bs.modal', function(e) {
			$("#dispName", dlg).focus();
		});
	};
	uiControls.util.loadModal(this.Constants.FACETS_ID_PREFIX + "modal", this.facetSettingsTmplPath, loadCallback);
};
FacetsView.prototype.getFacetableFields = function() {
	var fieldsList = [];
	var self = this;
	$.each(this._origConfig.columnConfig, function(i, eachConfig) {
		if (qb.sv.isFacetingAllowed(eachConfig.schema.type))
			fieldsList.push(eachConfig.fieldName);
	});

	return fieldsList;
};
FacetsView.prototype.setEachFacetSettings = function(dlg, facetObj) {
	//$("#fieldType", dlg).val(facetObj.schema.type);
	var self = this;
	var handleRendererDropdown = function() {
		var dateOption = $("#rendererType option[value='date']", dlg);
		if (!qb.sv.isDateRangeAllowed(facetObj.schema.type)) {
			dateOption.prop({
				'disabled' : true,
				'title' : cvSearchMessages.notDateMsg
			});
		} else {
			if (dateOption.prop('disabled')) {
				dateOption.prop({
					'disabled' : false,
					'title' : ''
				});
			}
			$("#rendererType", dlg).val("date");
		}
	};

	$("#dispName", dlg).val(facetObj.dispName);
	$("#noOfValuesToShow", dlg).val(facetObj.noOfValuesToShow);
	$("#allowMultiple", dlg).attr("checked", facetObj.allowMultiple);
	$("input[name=sortValuesBy][value='" + facetObj.sortValuesBy + "']", dlg).attr("checked", true);
	$("input[name=listType][value='" + facetObj.listType + "']", dlg).attr("checked", true);
	if (facetObj.renderer) {
		$("#rendererType", dlg).val(facetObj.renderer.type);
		self.onRendererChosen(facetObj.renderer.type, dlg);
	} else
		$("#rendererType", dlg).val('');
	handleRendererDropdown();

};
FacetsView.prototype.getEachFacetSettings = function(dlg, oldSettings) {
	var newSettings = $.extend({}, oldSettings);
	newSettings.dispName = $("#dispName", dlg).val();
	newSettings.noOfValuesToShow = parseInt($("#noOfValuesToShow", dlg).val());
	newSettings.allowMultiple = $("#allowMultiple", dlg).is(":checked");
	newSettings.sortValuesBy = $("input[name=sortValuesBy]:checked").val();
	newSettings.listType = $("input[name=listType]:checked").val();
	if ($("#rendererType", dlg).val()) {
		newSettings.renderer = {
			type : $("#rendererType", dlg).val()
		};
	} else
		delete newSettings.renderer;
	return newSettings;
};
FacetsView.prototype.applyEachFacetSettings = function(dlg, oldSettings) {
	var newSettings = this.getEachFacetSettings(dlg, oldSettings);
	var index = cvSearchUtil.getIndexByKeyValue(this._config.facetConfig, {
		fieldName : oldSettings.fieldName
	});
	this._config.facetConfig[index] = newSettings;
	qb.sv.setDefaultRenderer(this._config.facetConfig[index]);
	this.clear();
	this.render();
	this.$element.trigger(cvSearchConstants.EventConstants.ON_FACET_REQUEST_CHANGE, [
			this._config.facetConfig,
			this.facetReq,
			false ]);
};

FacetsView.prototype.onRendererChosen = function(type, dlg) {
	var $sortValuesBy = $("input[name='sortValuesBy']", dlg);
	var $listType = $("input[name='listType']", dlg);

	$sortValuesBy.attr("disabled", false);
	$listType.attr("disabled", false);
	$sortValuesBy.parent().attr("disabled", false);
	$listType.parent().attr("disabled", false);

	switch (type) {
	case 'date':
		$sortValuesBy.attr("disabled", true);
		$listType.attr("disabled", true);
		$sortValuesBy.parent().attr("disabled", true);
		$listType.parent().attr("disabled", true);
		break;
	}
}