<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="https://github.com/d8bitr/packtag" prefix="cvpack"%>

<cvpack:script prefix="searchcomponents-module-libs" enabled="${cvConfig.isDevMode() eq 'false'}">
	<src>/searchcomponents/js/cvSearchConstants.js</src>
	<src>/searchcomponents/js/cvSearchMessages.js</src>
	<src>/searchcomponents/js/cvSearchUtil.js</src>
	<src>/common/js/cvFormatters.js</src>
	<src>/searchcomponents/js/qbBase.js</src>
	<c:choose>
		<c:when test="${param.isFromDataCube}">		
			<src>/common/js/table/jquery.dataTables-1.10.min.js</src>
			<src>/common/datatables/js/dataTables.bootstrap.js</src>
			<src>/common/datatables/js/dataTables.colReorder.min.js</src>
			<src>/common/datatables/js/dataTables.colResize.js</src>
			<src>/common/js/daterangepicker.js</src>
			<src>/common/js/jquery.textcomplete.min.js</src>
			<src>/common/js/jquery.highlighttextarea.min.js</src>
			<src>/searchcomponents/thirdparty/js/typeahead.bundle.min.js</src>
			<src>/searchcomponents/js/cvFacetWidget.js</src>
			<src>/searchcomponents/js/cvSearchBox.js</src>
			<src>/searchcomponents/js/cvSearchResultsView.js</src>
			<src>/searchcomponents/js/cvDataGrid.js</src>
			<src>/searchcomponents/js/cvDataViewer.js</src>
			<src>/searchcomponents/js/cvBreadCrumb.js</src>
			<!-- cvFacetsView.js and cvSearchView.js have been moved to sea/index.jsp for their bootstrap dependecy -->
		</c:when>
	</c:choose>
	<src>/searchcomponents/js/qbReportsView.js</src>
	<src>/searchcomponents/js/qbSearchView.js</src>
</cvpack:script>
<c:choose>
	<c:when test="${param.isFromDataCube}">	
		<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
			jQuery.extend( jQuery.fn.dataTableExt.oSort, {
					'date-time-asc' : function(a, b) {
					var x = Date.parse(a);
					var y = Date.parse(b);
					var z = ((x < y) ? -1 : ((x > y) ? 1 : 0));
					return z;
    				},
					'date-time-desc' : function(a, b) {
					var x = Date.parse(a);
					var y = Date.parse(b);
					var z = ((x < y) ? 1 : ((x > y) ? -1 : 0));
					return z;
					}
			});
		</script>
	</c:when>
</c:choose>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	/**
	 * $.parseParams - parse query string paramaters into an object.
	 */
	(function($) {
		var re = /([^&=]+)=?([^&]*)/g;
		var decode = function(str) {
			return decodeURIComponent(str.replace(/\+/g, ' '));
		};
		$.parseParams = function(query) {
			var params = {}, e;
			if (query) {
				if (query.substr(0, 1) == '?') {
					query = query.substr(1);
				}
				while (e = re.exec(query)) {
					var k = decode(e[1]);
					var v = decode(e[2]);
					if (params[k] !== undefined) {
						if (!$.isArray(params[k])) {
							params[k] = [ params[k] ];
						}
						params[k].push(v);
					} else {
						params[k] = v;
					}
				}
			}
			return params;
		};

	})(jQuery);
</script>
