<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<div data-templateId="tmpl_view_datasources_http"
		class="form-horizontal" style="display: none">
		<div class="form-group">
			<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
					key="AnalyticsEngine" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsEngine"></p>
			</div>
		</div>
		<div class='form-group'>
					<label for="dsUrl" class="col-lg-2 control-label"><fmt:message key="URL" /></label>
					<div class='col-lg-10'>
						<p class='form-control-static' id='dsUrl'> </p>
					</div>
				</div>
		<%@ include file="sourcecommontemplate.jsp"%>
	</div>

	<div data-templateId="wizard_http" class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-11'><jsp:include page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>2</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class='form-group' data-userinput="true">
					<label for="dsUrl" class="col-lg-3 control-label"><fmt:message key="URL" /></label>
					<div class='col-lg-5'>
						<div class="row">
							<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 no-padding-right">
								<select id="dsReqType" class="form-control">
	                				<option value="GET">GET</option>
	                				<option value="POST">POST</option>
	                			</select>
							</div>
							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 no-padding-left">
								<input id="dsUrl" class="form-control joint-input" data-original-title="" title="" data-required="true">
							</div>
						</div>
					</div>
				</div>
				<div class='form-group' style='display:none'>
					<label for="dsPayload" class="col-lg-3 control-label"><fmt:message key="HttpPayload" /></label>
					<div class='col-lg-5'>
						<textarea class='form-control' id='dsPayload'></textarea>
					</div>
				</div>
				<div class='form-group'>
					<label for="dsHeaders" class="col-lg-3 control-label"><fmt:message key="HttpHeaders" /></label>
					<div id='dsHeaders' class='col-lg-5 parentHeaderDiv'>
						<div class="http-header input-group">
							<input class="header-key form-control" placeholder="Key">
							<span class="input-group-addon">-</span>
							<input class="header-value form-control joint-input" placeholder="Value">
							<span class="glyphicon input-group-addon glyphicon-plus btn-add-header joint-input"></span>
					        <span class="glyphicon input-group-addon glyphicon-trash btn-remove-header"></span>
						</div>
					</div>
				</div>
				<div class = "httpAuthDiv">
					<%@ include file="authtemplate.jsp"%>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
				<div class='step-indicator col-lg-1'>
					<div class='number-circle'>3</div>
				</div>
				<div class='step-content col-lg-11'>
					<div data-userinput="true">
						<table class="display table table-bordered dataTable" id="table_data" style="width:100%;"></table>
					</div>
				</div>
				<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="4">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>4</div>
			</div>
			<div class='step-content col-lg-11'>
				<div class = "tableBottomMargin">
				<table class="table table-bordered dataTable" id="field_info_table" style="width:100%;"></table>
				</div>

			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="5">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>5</div>
			</div>
			<div class='step-content col-lg-11'>
					<div class="form-group">
						<label class="col-lg-3 control-label"><fmt:message
									key="Paginate" /></label>
						<div class="col-lg-5">
							<div class="input-group">
								<input id="dsPaginate" type="checkbox"
									class="cvToggle"><label
									for="dsPaginate"></label>
							</div>
						</div>
					</div>

					<div class='http-pagination-container' style='display:none;'>
						<div class='form-group'>
							<label for="dsPaginateStartParam" class="col-lg-3 control-label"><fmt:message key="DsPaginateStartParam" /></label>
						    <div class='col-lg-5'>
						    	<div class="input-group">
									<span class='input-group-addon'>Name</span>
									<input type='text' id='dsPaginateStartParam' class='form-control'>
									<span class='input-group-addon'>Value</span>
							        <input type='number' id='dsPaginateStartValue' class='form-control' min="0">
								</div>
							</div>
				        </div>
						<div class='form-group'>
							<label for="dsPaginateIncrementalParam" class="col-lg-3 control-label"><fmt:message key="DsPaginateIncrementalParam" /></label>
						    <div class='col-lg-5'>
							    <div class="input-group">
									<span class='input-group-addon'>Name</span>
									<input type='text' id='dsPaginateIncrementalParam' class='form-control'>
									<span class='input-group-addon'>Value</span>
							        <input type='number' id='dsPaginateIncrementalValue' class='form-control' min="0">
								</div>
							</div>
				        </div>
						<div class='form-group'>
							<label for="dsPaginateIncrementalType" class="col-lg-3 control-label"><fmt:message key="DsPaginateIncrementalType" /></label>
							<div class='col-lg-5'>
								<form>
									<label class='radio-inline'>
										<input type='radio' name='dsPaginateIncrementalType' checked="checked" value='Offset'>
										<fmt:message
										key="DsPaginateIncrementalOffset" />
									</label>
									<label class='radio-inline'>
										<input type='radio' name='dsPaginateIncrementalType' value='Page'>
										 <fmt:message key="DsPaginateIncrementalPage" />
									</label>
								</form>
							</div>
						</div>
						<div class = 'form-group'>
							<label for="dsPaginateTotalLoopValue" class="col-lg-3 control-label"><fmt:message key="DsPaginateTotalLoopValue" /></label>
							<div class='col-lg-6'>
								<form>
									<label class='radio-inline'>
										<input type='radio' name='dsPaginateLoopBasis' checked="checked" value='iteration'>
										<fmt:message key="DsPaginateTotalLoopValueCount" />
									</label>
									<label class='radio-inline'>
										<input type='radio' name='dsPaginateLoopBasis' value='record'>
										<fmt:message key="DsPaginateTotalLoopValueInlineCount" />
									</label>
								</form>
							</div>
						</div>
						<div class='form-group'>
							<div class='col-lg-3'></div>
							<div class='col-lg-5' id='dsPaginateLoopIterationParent'>
								<input type='number' class='form-control' id='dsPaginateTotalLoopValueIteration' min="0">
								<div class="help-block"><fmt:message key="DsPaginateLoopIterationHint" />
								</div>
							</div>

							<div class='col-lg-5' id='dsPaginateLoopRecordParent' style='display: none;'>
								<select class='form-control' id='dsPaginateTotalLoopValueRecords'></select>
								<div class="help-block"><fmt:message key="DsPaginateLoopRecordsHint" />
								</div>
							</div>
						</div>

					</div>
				</div>
				<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="6">
			<div class='step-indicator col-lg-1'><div class='number-circle'>6</div></div>
			<div class='step-content col-lg-11'>
				<div class="form-group">
					<label for="primaryKey" class="col-lg-3 control-label"><fmt:message key="PrimaryKey" /></label>
					<div class="col-lg-5 col-xl-2">
						<select id="primaryKey" data-userinput="true" class="form-control"></select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-lg-3 control-label"><fmt:message key="IncrementalCrawl" /></label>
					<div class="col-lg-5">
						<div class="input-group">
							<input id="httpIncrementalCrawl" type="checkbox" class="cvToggle switchHint"
							data-switch-hint-class="IncrementalCrawlHint">
							<label for="httpIncrementalCrawl"></label>
						</div>
						<span class="help-block IncrementalCrawlHint"><fmt:message key="IncrementalCrawlHintDisable" /></span>
					</div>
				</div>
				<div class="form-group">
					<label for="incrementalQuery" class="col-lg-3 control-label"><fmt:message key="IncrementalQuery" /></label>
					<div class="col-lg-5">
						<textarea id="incrementalQuery" class="form-control" rows="2" disabled></textarea>
					</div>
				</div>
				<div class="form-group">
					<label for="dsCrawl" class="col-lg-3 control-label">
						<fmt:message key="CrawlOption" />
					</label>
					<div class="col-lg-5">
						<div class="checkbox">
							<label>
								<input type="checkbox" id="dsCrawl">
								<fmt:message key="StartCrawlingNow" />
							</label>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		
		<div id='collapsedText'>
			<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
			<label class='step-content-header' data-step='2'><fmt:message key="URLOptions" /></label>
			<label class='step-content-header' data-step='3'><fmt:message key="Preview" /></label>
			<label class='step-content-header' data-step='4'><fmt:message key="FormatFields" /></label>
			<label class='step-content-header' data-step='5'><fmt:message key="Pagination" /></label>
			<label class='step-content-header' data-step='6'><fmt:message key="AdvancedOptions" /></label>
		</div>
	</div>

	<div data-templateId="tmpl_new_http_header" class="http-header input-group" style="display: none;">
		<input class="header-key form-control" placeholder="Key">
		<span class="input-group-addon">-</span>
		<input class="header-value form-control joint-input" placeholder="Value">
		<span class="glyphicon input-group-addon glyphicon-plus btn-add-header joint-input"></span>
		<span class="glyphicon input-group-addon glyphicon-trash btn-remove-header"></span>
	</div>
</fmt:bundle>
