<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- View FS info template, start -->
	<div data-templateId="tmpl_view_datasources_file"
		class="form-horizontal" style="display: none">
		<div class="form-group">
			<label for="dsType" class="col-lg-2 control-label"><fmt:message
					key="DSType" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsType"></p>
			</div>
		</div>
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		<div class="form-group">
			<label for="dirLoc" class="col-lg-2 control-label"><fmt:message
					key="DirPaths" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dirLoc"></p>
			</div>
		</div>

		<div class="form-group accessNodeElement" style="display: none">
			<label for="dsAccessNode" class="col-lg-2 control-label"><fmt:message
					key="AccessNode" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsAccessNode"></p>
			</div>
		</div>

		<div class="form-group includeFilterLabel" style="display: none">
			<label for="includeFilter" class="col-lg-2 control-label"><fmt:message
					key="IncludeFilter" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="includeFilter"></p>
			</div>
		</div>
		<div class="form-group excludeFilterLabel" style="display: none">
			<label for="excludeFilter" class="col-lg-2 control-label"><fmt:message
					key="ExcludeFilter" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="excludeFilter"></p>
			</div>
		</div>
		<div class="form-group">
			<label class="col-lg-2 control-label"><fmt:message
					key="Indexed" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" style="display: none"
					id="pushOnlyMetadataInfo_true">
					<fmt:message key="Metadata" />
				</p>
				<p class="form-control-static" style="display: none"
					id="pushOnlyMetadataInfo_false">
					<fmt:message key="Content" />,
					<fmt:message key="Metadata" />
				</p>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp" %>
	</div>

	<div data-templateId="include_filter" id="includeFilterWrapper" class="form-group display-none" data-userinput="true">
			<div>
				<label class="col-lg-3 control-label"> <fmt:message key="IncludeFilter" />
					<span class="glyphicon glyphicon-info-sign additional-info-icon"
					data-toggle="popover"
					data-content="<fmt:message key='IncludeFilterPlaceholder' />"
					aria-hidden="true"></span>
				</label> 
				<div class="fsFilterTypeDiv col-lg-7"
					id="fsFilterTypeDiv_include">
					<textarea data-required="true" class="form-control" rows="2" id="includeFilter"></textarea>
					<span class="help-block"><fmt:message key="IncludeFilterHintForArchiver" /></span>
				</div>
			</div>
	</div>
					
					
	<div data-templateId="content_search_options" id="ContentSearchOptions" class="display-none">
					
		<div class="file-size-options form-group" data-userinput="true">
			<label for="docSizeDiv" class="col-lg-3 control-label"><fmt:message key="FileSize" /></label>
			<div id="docSizeDiv" class="col-xl-5 col-lg-7">
				<div class="input-group">
					<span class="input-group-addon"><fmt:message
							key="Minimum" /></span> <input id="minDocSize" type="number"
						class="form-control" value="0" min="0"><span
						class="input-group-btn"> <select id="minDocSizeUnit"
						class="form-control sizeUnitSelect">
							
					</select>
					</span><span class="input-group-addon"><fmt:message
							key="Maximum" /></span> <input id="maxDocSize" type="number"
						class="form-control" value="50" min="0" step="10">
					<span class="input-group-btn"><select id="maxDocSizeUnit"
						class="form-control sizeUnitSelect"></select></span>
				</div>
			</div>
		</div>		
	</div>
	<div data-templateId="wizard_file" class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>1</div>
			</div>
			<div class='step-content col-lg-11'>
				<jsp:include page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="2">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>2</div>
			</div>

			<div class='step-content col-lg-11' id="sourceDetailsDiv">
				<div id="clientInfoHolder" class="form-group hidden">
					<label for="clientListCombo" class="col-lg-3 control-label"><fmt:message
							key="AccessNode" /><span class="glyphicon glyphicon-info-sign additional-info-icon"
								data-toggle="popover"
								data-content="<fmt:message key='AccessNodePlaceholder' />"
								aria-hidden="true"></span></label>
					<div class="col-lg-5">
						<select id="clientListCombo" class="form-control"></select>
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dirLoc" class="col-lg-3 control-label"><fmt:message
							key="DirPaths" /></label>
					<div class="col-lg-7">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<textarea class="form-control" rows="3" id="dirLoc"
							data-required="true" data-multivalued="true"
							data-multivaluedseparator="\s+"></textarea>
						<span class="help-block"><fmt:message
								key="MultipleDirPathHint" /></span>
					</div>
				</div>
				<div class="form-group">
					<label for="dsUserName" class="col-lg-3 control-label"><fmt:message
							key="Username" /></label>
					<div class="col-lg-5">
						<input type="text" id="dsUserName" class="form-control">
					</div>
				</div>
				<div class="form-group">
					<label for="dsPassword" class="col-lg-3 control-label"><fmt:message
							key="Password" /></label>
					<div class="col-lg-5">
						<input type="password" id="dsPassword" class="form-control">
					</div>
				</div>
				
				
				<div class="form-group">
					<label class="col-lg-3 control-label"><fmt:message
							key="IncrementalCrawl" /></label>
					<div class="col-lg-7">
						<div class="input-group">
							<input id="isFSIncrementalCrawl" type="checkbox"
								class="cvToggle switchHint"
								data-switch-hint-class="IncrementalCrawlHint" checked><label
								for="isFSIncrementalCrawl"></label>
						</div>
						<span class="help-block IncrementalCrawlHint"><fmt:message
								key="IncrementalCrawlHintEnable" /></span>
					</div>
				</div>

				<div class="form-group">
					<div>
						<label class="col-lg-3 control-label"> <fmt:message key="ExcludeFilter" />
							<span class="glyphicon glyphicon-info-sign additional-info-icon"
							data-toggle="popover"
							data-content="<fmt:message key='ExcludeFilterPlaceholder' />"
							aria-hidden="true"></span>
						</label>
						<div class="fsFilterTypeDiv col-lg-7"
							id="fsFilterTypeDiv_exclude">
							<textarea class="form-control" rows="2" id="excludeFilter"></textarea>
							<span class="help-block"><fmt:message key="ExcludeFilterHint" /></span>
						</div>
					</div>
				</div>

			</div>
			<div class='button-holder'></div>
		</div>
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="3">
			<div class='step-indicator col-lg-1'>
				<div class='number-circle'>3</div>
			</div>
			<div class='step-content col-lg-11'>
				<div>
					<div id="fsAdvanceOptionsPanel">
						<div class="advancedOptionsDiv">
							<div class="form-group">
								<label class="col-lg-3 control-label"><fmt:message
										key="EnableContentSearch" /></label>
								<div class="col-lg-7">
									<div class="input-group">
										<input id="isOnlyMetaData" type="checkbox"
											class="cvToggle switchHint"><label
											for="isOnlyMetaData"></label>
									</div>
									<span class="help-block EnableContentSearchHint"><fmt:message
											key="EnableContentSearchHintDisable" /></span>
								</div>
							</div>
							<div class="mt display-none" id="fsContentFilterDiv"></div>
							<div class="mt display-none" id="archiverContentFilterDiv"></div>
						</div>
					</div>
					<div class="form-group">
						<label for="dsCrawl" class="col-lg-3 control-label">
							<fmt:message key="CrawlOption" />
						</label>
						<div class="col-lg-7">
							<div class="checkbox">
								<label> 
									<input type="checkbox" id="dsCrawl"> 
									<fmt:message key="StartCrawlingNow" />
								</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		
		
		<div id='collapsedText'>
			<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
			<label class='step-content-header' data-step='2'><fmt:message key="DirPaths" /></label>
			<label class='step-content-header' data-step='3'><fmt:message key="ContentSearch" /></label>			
		</div>
	</div>
	<!-- View FS info template, end -->
</fmt:bundle>