<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<!-- New/Edit DB template, partials start -->
	<!-- New Split by template start -->
	<div class="splitColumnsInputDivTmpl splitColumnsInputDiv"
		style="display: none;">
		<div class="input-group">
			<span class="input-group-addon"><fmt:message key="Column" /></span>
			<input type="text" class="form-control splitByColumnName"> <span
				class="input-group-addon"><fmt:message key="SplitBy" /></span> <input
				type="text" class="form-control splitByChar"> <span
				class="input-group-addon glyphicon glyphicon-plus addSplitByBtn"></span>
			<span
				class="input-group-addon glyphicon glyphicon-trash delSplitByBtn"></span>
		</div>
	</div>
	<!-- New Split by template end -->
	<!-- Edit Split by template start -->
	<div class="splitColumnsInputDivTmplEdit splitColumnsInputDiv"
		style="display: none;">
		<div class="input-group">
			<span class="input-group-addon"><fmt:message key="Column" /></span>
			<span class="input-group-addon splitByCharLabel"><fmt:message
					key="SplitBy" /> </span> <input type="text"
				class="form-control splitByChar"> <span
				class="input-group-addon glyphicon glyphicon-plus addSplitByBtn"></span>
			<span
				class="input-group-addon glyphicon glyphicon-trash delSplitByBtn"></span>
		</div>
	</div>
	<!-- Edit Split by template end -->
	<!-- New/Edit DB template, partials end -->
	<!-- View DB info template, start -->
	<div data-templateId="tmpl_view_datasources_jdbc"
		class="form-horizontal" style="display: none">
		<c:if test="${not requestScope.useSeaServer}">
			<div class="form-group">
				<label for="dsEngine" class="col-lg-2 control-label"><fmt:message
						key="AnalyticsEngine" /></label>
				<div class="col-lg-10">
					<p class="form-control-static" id="dsEngine"></p>
				</div>
			</div>
		</c:if>
		
		<div class="form-group" id = "dsCommcellDiv">
			<label for="dsCommcell" class="col-lg-2 control-label"><fmt:message
					key="Commcell" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsCommcell"></p>
			</div>
		</div>
		<div class="form-group" id = "dsUrlDiv">
			<label for="dsUrl" class="col-lg-2 control-label"><fmt:message
					key="DatabaseURL" /></label>
			<div class="col-lg-10">
				<p class="form-control-static" id="dsUrl"></p>
			</div>
		</div>
		<div class="form-group" id= "dsUserPassDiv">
			<label for="dsUserPass" class="col-lg-2 control-label"><fmt:message
					key="Username" /></label>
			<div class="col-lg-6">
				<p class="form-control-static" id="dsUserPass"></p>
			</div>
		</div>
		<div class="form-group">
			<label for="dsSqlStmt" class="col-lg-2 control-label"><fmt:message
					key="SQLQuery" /></label>
			<div class="col-lg-10">
				<pre class="form-control-static" id="dsSqlStmt"></pre>
			</div>
		</div>
		<%@ include file="sourcecommontemplate.jsp" %>
	</div>
	<div data-templateId="wizard_jdbc" class="form-horizontal experimental-wizard" style="display: none">
		<div class="form-horizontal cvWizard-step col-lg-12" data-step="1">
			<div class='step-indicator col-lg-1'><div class='number-circle'>1</div></div>
			<div class='step-content col-lg-11'><jsp:include page="basedstemplate.jsp"></jsp:include></div>
			<div class='button-holder'></div>
		</div>
		<div class='form-horizontal cvWizard-step col-lg-12' data-step="2">
			<div class='step-indicator col-lg-1'><div class='number-circle'>2</div></div>
			<div class='step-content col-lg-11'>

				<div id="connectionRadioBtnPanel" class="form-group" style="display:none">
					<div class="col-lg-4">
						<input type="radio" id="commcellConnection" name="DBConnection" checked>
						<label id="commcellConnectionLabel" for="commcellConnection"><fmt:message key="CommcellConnection" /></label>
					</div>
					<div class="col-lg-4">
						<input type="radio" id="otherConnection" name="DBConnection">
						<label id="otherConnectionLabel" for="otherConnection"><fmt:message key="OtherConnection" /></label>
					</div>
				</div>
				<div id="otherConnectionPanel" style="display:none">
					<div class="form-group">
						<label for="dsDriverType" class="col-lg-3 control-label"><fmt:message
								key="Driver" /></label>
						<div class="col-lg-7">
							<select id="dsDriverType" class="form-control"></select>
						</div>
					</div>
					<div class="form-group" data-userinput="true">
						<label for="dsUrl" class="col-lg-3 control-label"><fmt:message
								key="DatabaseURL" /></label>
						<div class="col-lg-7">
							<div class="required-icon">
								<div class="text">*</div>
							</div>
							<input type="text" id="dsUrl" class="form-control"
								data-required="true" /><span class="help-block sampleDBUrl"
								id="com_microsoft_sqlserver_jdbc_SQLServerDriver"
								style="display: none"><fmt:message key="Example" />jdbc:sqlserver://{hostName};instanceName={instanceName};databaseName={databaseName}</span>
							<span class="help-block sampleDBUrl"
								id="sun_jdbc_odbc_JdbcOdbcDriver" style="display: none"><fmt:message
									key="Example" />jdbc:odbc:{databaseName}</span> <span
								class="help-block sampleDBUrl" id="oracle_jdbc_OracleDriver"
								style="display: none"><fmt:message key="Example" />jdbc:oracle:{drivertype}:@{database}</span>
								<span class="help-block sampleDBUrl" id="com_mysql_cj_jdbc_Driver"
								style="display: none"><fmt:message key="Example" />jdbc:mysql://{hostName}:{port}/{database}</span>
						</div>
					</div>

					<div class="form-group">
						<label for="dsUserName" class="col-lg-3 control-label"><fmt:message
								key="Username" /></label>
						<div class="col-lg-5">
							<input type="text" id="dsUserName" class="form-control">
						</div>
					</div>
					<div class="form-group">
						<label for="dsPassword" class="col-lg-3 control-label"><fmt:message
								key="Password" /></label>
						<div class="col-lg-5">
							<input type="password" id="dsPassword" class="form-control">
						</div>
					</div>
				</div>
				<div id="commcellConnectionPanel" style="display:none">
					<div class="form-group">
					<label for="commCells" class="col-lg-3 control-label"><fmt:message
							key="Commcell" /></label>
					<div class="col-lg-5">
						<select id="commCellsCombo" class="form-control"></select>
					</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		<div class='form-horizontal cvWizard-step col-lg-12' data-step="3">
			<div class='step-indicator col-lg-1'><div class='number-circle'>3</div></div>
			<div class='step-content col-lg-11'>
				<div class="form-group">
					<div class="col-lg-3 table-div-ele">
						<select id="dsTableViewCombo" class="form-control">
						   	<option value="Table"><fmt:message
							key="Table" /></option>
							<option value="View"><fmt:message
							key="View" /></option>
						</select>
					</div>
					<div class="col-lg-7 jdbcTableList">
						<select id="dsTableViewListCombo" data-userinput="true" class="form-control"></select>
					</div>
				</div>
				<div class="form-group" data-userinput="true">
					<label for="dsSqlStmt" class="col-lg-3 control-label"><fmt:message
							key="SQLQuery" /></label>
					<div class="col-lg-7">
						<div class="required-icon">
							<div class="text">*</div>
						</div>
						<textarea id="dsSqlStmt" class="form-control" rows="5"
							data-required="true"></textarea>
						<div id="preview-btn-div">
							<button id="sql-preview-btn" class="btn btn-default"><fmt:message
							key="Preview" /></button>
						</div>
					</div>
				</div>
				<div class="form-group summary">
					<div class="form-group">
						<div class="col-lg-10" id="dsSqlPreview">
						</div>
					</div>
				</div>
			</div>
			<div class='button-holder'></div>
		</div>
		
		<div class='form-horizontal  cvWizard-step col-lg-12' data-step="4">
			<div class='step-indicator col-lg-1'><div class='number-circle'>4</div></div>
			<div class='step-content col-lg-11'>
				<div id="dbAdvanceOptionsPanel">
					<div class="advancedOptionsDiv">
						<div class="form-group">
							<label for="btn_AddSplitByOptsOneTime"
								class="col-lg-3 control-label"><fmt:message key="SplitBy" /></label>
							<div id="splitByDiv" class="col-lg-7">
								<button id="btn_AddSplitByOptsOneTime" class="btn">
									<fmt:message key="Add" />
								</button>
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label"><fmt:message
									key="IncrementalCrawl" /></label>
							<div class="col-lg-7">
								<div class="input-group">
									<input id="dsDeltaCrawl" type="checkbox" class="cvToggle"><label
										for="dsDeltaCrawl"></label>
								</div>
							</div>
						</div>
						<div class="form-group" data-userinput="true">
							<label for="dsDeltaPrimaryKey" class="col-lg-3 control-label"><fmt:message
									key="PrimaryKey" /></label>
							<div class="col-lg-5">
								<input type="text" id="dsDeltaPrimaryKey" class="form-control"
									data-required-if="dsDeltaCrawl">
							</div>
						</div>
						<div class="form-group" data-userinput="true">
							<label for="dsDeltaSqlStmt" class="col-lg-3 control-label"><fmt:message
									key="DeltaSQLQuery" /></label>
							<div class="col-lg-7">
								<textarea id="dsDeltaSqlStmt" class="form-control" rows="5"
									data-required-if="dsDeltaCrawl"></textarea>

							</div>
					    </div>
						<div class="form-group" data-userinput="true">
							<label for="dsDeltaImportSqlStmt" class="col-lg-3 control-label"><fmt:message
									key="DeltaImportSQLQuery" /></label>
							<div class="col-lg-7">
								<textarea id="dsDeltaImportSqlStmt" class="form-control" rows="5"
									data-required-if="dsDeltaCrawl"></textarea>
							</div>
						</div>
						<div class="form-group">
							<label for="dsCrawl" class="col-lg-3 control-label">
								<fmt:message key="CrawlOption" />
							</label>
							<div class="col-lg-7">
								<div class="checkbox">
									<label> 
										<input type="checkbox" id="dsCrawl"> 
										<fmt:message key="StartCrawlingNow" />
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class='button-holder'></div>
		</div>
		
		<div id='collapsedText'>
				<label class='step-content-header' data-step='1'><fmt:message key="DataSourceName" /></label>
				<label class='step-content-header' data-step='2'><fmt:message key="DatabaseConnectionDetails" /></label>
				<label class='step-content-header' data-step='3'><fmt:message key="SQLQueryAndPreview" /></label>
				<label class='step-content-header' data-step='4'><fmt:message key="AdvancedOptions" /></label>
		</div>
	</div>
	<!-- View DB info template, end -->
</fmt:bundle>
