<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<c:if test="${not requestScope.useSeaServer}">
		<div class="form-group" data-userinput="true">
			<input type="hidden" id="clientId"></input> <label for="dsEngine"
				class="col-lg-3 control-label"><fmt:message
					key="AnalyticsEngine" /></label>
			<div class="col-lg-5">
				<select id="dsEngine" class="form-control" data-required="true"></select>
			</div>
		</div>
	</c:if>
	<div class="form-group" data-userinput="true">
		<input type="hidden" id="coreName"></input> <input type="hidden"
			id="dsId"></input> <label for="dsName" class="col-lg-3 control-label"><fmt:message
				key="DataSourceName" /></label>
		<div class="col-lg-5">
			<div class="required-icon">
				<div class="text">*</div>
			</div>
			<input type="text" id="dsName" class="form-control firstField"
				data-required="true" data-validate="true"
				data-validationtype="regex" data-regex="^[\w\- ]+$"
				data-regex-msg='<fmt:message key="DataSourceNameValidationMsg" />'>
			<span class="help-block"><fmt:message key="DataSourceNameValidationMsg" /></span>
		</div>
	</div>
	<div class="form-group" data-userinput="true">
		<label for="dsDescription" class="col-lg-3 control-label"><fmt:message
				key="DataSourceDescription" /></label>
		<div class="col-lg-5">
			<input type="text" id="dsDescription" class="form-control">
		</div>
	</div>
</fmt:bundle>