<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.SeaMessages">
	<fmt:message key="SEA_Header" var="SEA_Header" scope="request" />
	<jsp:include page="../common/header.jsp">
		<jsp:param value="${SEA_Header}" name="titleLocalized" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
		<jsp:param value="searchcomponents/includecss.jsp" name="jsp" />		
	</jsp:include>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/sea/css/seastyles.css?${applicationScope.BUILD_TS}" />
	<script nonce="${sessionScope.cspNonce}" >
		var sea = {};
		// do not use this variable in JS as "false" in conditions treated as 1. Use isUseSeaServer.
		sea.useSeaServer = "${requestScope.useSeaServer}";
		sea.BUILD_TS = "${applicationScope.BUILD_TS}";
		if (sea.useSeaServer && (sea.useSeaServer === "true" || sea.useSeaServer === true))
			sea.isUseSeaServer = true;
		else
			sea.isUseSeaServer = false;
	</script>
	<div class="page-content inset container-fluid">
		<div class="row">
			<div id="seaContainer" class="col-lg-12 col-md-12">
				
			</div>
		</div>
	</div>

	<h3 data-templateId="tmpl_Header" class="cvHeader"></h3>
	<div data-templateId="tmpl_Toolbar" class="cvToolbar"
		style="display: none">
		<div class="cvToolbarTitle pull-left"></div>
		<div class="cvToolbarButtonbar pull-right"></div>
		<div style="clear: both"></div>
	</div>
</fmt:bundle>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="../searchcomponents/includejs.jsp" name="jsp"></jsp:param>
	<jsp:param value="js/search.js" name="js" />
	<jsp:param value="js/constants.js" name="js" />
	<jsp:param value="js/services.js" name="js" />
	<jsp:param value="js/schemaController.js" name="js" />
	<jsp:param value="js/viewController.js" name="js" />
	<jsp:param value="js/uiControls.js" name="js" />
</jsp:include>
