function WebHandler() {
	this.type = sea.constants.DSTypes.WEB;
}

WebHandler.prototype.initializeStep = function(step, holder, isEdit) {
	//Hurray! No initializer required for Web data source!
	
};

WebHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit) {
	var reqObj = {};
	var self = this;
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}
	switch (step) {
		case 1:
			if (!isEdit) {
				this.isDatasourceNameExists(holder, callback);
			} else {
				callback(true);
			}
			break;
		case 2:
			reqObj = {
				type : self.type,
				name : self.name,
				coreName : "",
				engineId : parseInt(self.dsEngine),
				properties : {
					username : self.properties.username,
					domain : self.properties.domain,
					password : self.properties.password,
					urls : self.properties.urls,
					isFlatQuery : false
				},
				operationType : "CREATE"
			};
			sea.services.getMetaInfo(reqObj, function(resp) {
				if (resp.error.errorCode === 0) {
					callback(true);
				}
			}, null, holder);
			break;
		case 3:
			callback(true);
			break;
		default:
			callback(true);
	}
};

WebHandler.prototype.submit = function(isEdit, data, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, data, holder);
	}
};

WebHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	fnCallBack({
		"callBack" : true
	});
};

WebHandler.prototype.fetch = function(step, holder) {
	var fetchedData = null;
	var crawlDepth = null;
	var includePaths = null;
	var excludePaths = null;
	var urls = null;

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		urls = $("#dsUrl", holder).val();
		urls = urls.split(new RegExp($("#dsUrl", holder).data("multivaluedseparator")));

		//To remove an empty string due to trailing newline, if any
		if (urls[urls.length - 1].length === 0) {
			urls = urls.slice(0, urls.length - 1);
		}

		//since properties.urls is an array, this.updateProperties() would do a deep merge
		//and retain existing values. We do not want that. Hence delete the existing array
		if (this.properties && this.properties.urls) {
			delete this.properties.urls;
		}

		fetchedData = {
			properties : {
				urls : urls,
				username : $("#dsUserName", holder).val(),
				domain : $("#dsDomainName", holder).val(),
				password : Base64.encode($("#dsPassword", holder).val())
			}
		};
		break;
	case 3:
		crawlDepth = $("#dsCrawlDepth", holder).val();
		crawlDepth = (crawlDepth && crawlDepth.length > 0) ? crawlDepth : 5;
		includePaths = $("#dsIncludePath", holder).val();
		includePaths = includePaths.split(new RegExp($("#dsIncludePath", holder).data("multivaluedseparator")));
		includePaths = (includePaths && includePaths.length > 0) ? appendOrRemovePrefix("+^", includePaths, true) : [];
		excludePaths = $("#dsExcludePath", holder).val();
		excludePaths = excludePaths.split(new RegExp($("#dsExcludePath", holder).data("multivaluedseparator")));
		excludePaths = (excludePaths && excludePaths.length > 0) ? appendOrRemovePrefix("-^", excludePaths, true) : [];

		if (includePaths.length == 0) {
			includePaths.push("");
		}
		if (excludePaths.length == 0) {
			excludePaths.push("");
		}

		if (this.properties.includePaths) {
			delete this.properties.includePaths;
		}
		if (this.properties.excludePaths) {
			delete this.properties.excludePaths;
		}

		fetchedData = {
			properties : {
				crawlDepth : crawlDepth,
				includePaths : includePaths,
				excludePaths : excludePaths
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}
	this.updateProperties(fetchedData);
	return fetchedData;
};

WebHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	if (!$.isEmptyObject(props.excludePaths)) {
		props.excludePaths = appendOrRemovePrefix("-^", props.excludePaths, false);
	}
	if (!$.isEmptyObject(props.includePaths)) {
		props.includePaths = appendOrRemovePrefix("+^", props.includePaths, false);
	}
	if (onEdit) {
		$("#dsUrl", holder).html(props.urls.join("\n"));
		if (props.crawlDepth) {
			$("#dsCrawlDepth", holder).val(props.crawlDepth);
		}
		if (props.excludePaths) {
			$("#dsExcludePath", holder).html(props.excludePaths.join("\n"));
		}
		if (props.includePaths) {
			$("#dsIncludePath", holder).html(props.includePaths.join("\n"));
		}
		if (props.domain) {
			$("#dsDomainName", holder).val(props.domain);
		}
		if (props.username) {
			$("#dsUserName", holder).val(props.username);
		}

		$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));

		if (props.excludePaths || props.includePaths || props.domain || props.username || props.password) {
			$("#webAdvanceOptionsPanel", holder).collapse('show');
		}
		
	} else {
		$("#dsUrl", holder).text(props.urls.join(", "));
	}
};

function appendOrRemovePrefix(prefix, inputVal, isAppend) {
	var retArr = [];
	for (var i = 0; i < inputVal.length; i++) {
		if (inputVal[i].length > 0) {
			var ind = inputVal[i].indexOf(prefix);
			if (ind == -1 && isAppend) {
				retArr.push(prefix + inputVal[i]);
			} else if (ind > -1) {
				retArr.push(unescape(inputVal[i].substring(ind + prefix.length)));
			} else {
				retArr.push(inputVal[i]);
			}
		}
	}
	return retArr;
}

