var sea = sea || {};

sea.searchViewDefaults = (function() {
	var _defaultNoOfColumns = qb.base.getDefaultNoOfColumns();
	//For Web
	var setDefaultViewConfigForWeb = function(viewConfig) {
		var columnConfig = [];
		var customReport ;
		var reportScope;
		viewConfig.viewType = "list";
		viewConfig.fnItemTmpl = "sea.ColumnConfiguration.searchResultTmpl";
		columnConfig.push({
			fieldName : "title"
		});
		columnConfig.push({
			fieldName : "contentid"
		});
		columnConfig.push({
			fieldName : "body_stored"
		});
		viewConfig.columnConfig = columnConfig;
		//viewConfig.highlightKey = "contentid";
		//viewConfig.highlightParams = $.extend([], viewConfig.columnConfig);
		viewConfig.facetWidgetSettings = {
			hasTrash : false
		};
		viewConfig.facetConfig = [ {
			fieldName : "pushtype",
			dispName : "Status",
			dispOrder : 0,
			listType : "finite",
			facetWidgetSettings : {
				hasSettings : false,
				hasTrash : false
			},
			predefinedValues : {
				type : "fixedList",
				facets : {
					success : {
						value : "1",
						key : "pushtype:success",
						dispName : "Success"
					},
					failed : {
						value : [ "2", "3", "4" ],
						key : "pushtype:failed",
						dispName : "Failed",
					}
				}
			}
		} ];
	};

	//For FS
	var setDefaultViewConfigForFS = function(viewConfig, fields) {
		var columnConfigDef = {
			"VMName" : {
				fieldName : "VMName",
				dispName : "VM Name",
				visible : true
			},
			"FileName" : {
				fieldName : "FileName",
				dispName : "File Name",
				visible : true
			},
			"FolderName" : {
				fieldName : "FolderName",
				dispName : "File Path",
				visible : true
			},
			"Size" : {
				fieldName : "Size",
				dispName : "Size",
				visible : true,
				renderer : {
					type : "size"
				}
			},
			"ModifiedTime" : {
				fieldName : "ModifiedTime",
				dispName : "Modified Date",
				visible : true
			}
		};
		var columnConfig = [];
		if (!$.isEmptyObject(fields)) {
			var visibleColCount = 0;
			$.each(fields, function(i, eachField) {
				var fName = eachField.fieldName;
				if (columnConfigDef.hasOwnProperty(fName)) {
					columnConfig.push(columnConfigDef[fName]);
					visibleColCount++;
				} else {
					columnConfig.push({
						fieldName : eachField.fieldName,
						visible : false
					});
				}
			});

			/*
			 * By default we should show only 4 columns in FS search view. If the column list does not contain
			 * any of the 4 cols defined in columnConfigDef above, fetch one column that is not in that list
			 * and show it - so that total number of visible columns remains 4.
			 */
			for (var i = 0; i < columnConfig.length && visibleColCount < 4; i++) {
				//if 'content' is the only field, we need to show it.
				if (columnConfig[i].visible == false &&
						(columnConfig[i].fieldName != "content" || columnConfig.length == 1)) {
					columnConfig[i].visible = true;
					visibleColCount++;
				}
			}
		}
		viewConfig.columnConfig = columnConfig;
		// viewConfig.tableConfig = {
		// 	order : [ [ 10, 'desc' ] ]
		// };
		viewConfig.facetConfig = [ {
			fieldName : "FileExtension",
			dispName : "File Type",
			listType : "finite",
			dispOrder : 0
		}, {
			fieldName : "ModifiedTime",
			dispName : "Modified Date",
			dispOrder : 1
		}, {
			fieldName : "Size",
			dispName : "Size",
			dispOrder : 2,
			renderer : {
				type : "size"
			}
		} ];
	};
	//For VM
	var setDefaultViewConfigForVM = function(viewConfig, fields) {
		var columnConfigDef = {
			"FileName" : {
				fieldName : "FileName",
				dispName : "File Name",
				visible : true
			},
			"FilePath" : {
				fieldName : "FilePath",
				dispName : "File Path",
				visible : true
			},
			"Size" : {
				fieldName : "Size",
				dispName : "Size",
				visible : true,
				renderer : {
					type : "size"
				}
			},
			"ModifiedTime" : {
				fieldName : "ModifiedTime",
				dispName : "Modified Date",
				visible : true
			}
		};
		var columnConfig = [ {
			fieldName : "VMName",
			dispName : "VM Name",
			visible : true
		} ];//we want VM to come as first column so storing it initially
		if (!$.isEmptyObject(fields)) {
			var visibleColCount = 1;
			$.each(fields, function(i, eachField) {
				var fName = eachField.fieldName;
				if (fName !== "VMName") {
					if (columnConfigDef.hasOwnProperty(fName)) {
						columnConfig.push(columnConfigDef[fName]);
						visibleColCount++;
					} else {
						columnConfig.push({
							fieldName : eachField.fieldName,
							visible : false
						});
					}
				}

			});

			/*
			 * By default we should show only 5 columns in VM search view. If the column list does not contain
			 * any of the 5 cols defined in columnConfigDef above, fetch one column that is not in that list
			 * and show it - so that total number of visible columns remains 5.
			 */
			for (var i = 0; i < columnConfig.length && visibleColCount < 5; i++) {
				//if 'content' is the only field, we need to show it.
				if (columnConfig[i].visible == false &&
						(columnConfig[i].fieldName != "content" || columnConfig.length == 1)) {
					columnConfig[i].visible = true;
					visibleColCount++;
				}
			}
		}
		viewConfig.columnConfig = columnConfig;
		// viewConfig.tableConfig = {
		// 	order : [ [ 10, 'desc' ] ]
		// };

		viewConfig.facetConfig = [ {
			fieldName : "VMName",
			dispName : "VM Name",
			dispOrder : 0
		}, {
			fieldName : "FileExtension",
			dispName : "File Type",
			listType : "finite",
			dispOrder : 1
		}, {
			fieldName : "ModifiedTime",
			dispName : "Modified Date",
			dispOrder : 2
		}, {
			fieldName : "Size",
			dispName : "Size",
			dispOrder : 3,
			renderer : {
				type : "size"
			}
		} ];
	};

	var getDefaultViewConfigFromFields = function(dsType, fields, hObj, svReq) {
		var req = {};
		req.searchViewName = svReq ? svReq.searchViewName : localMsg.DefaultSearchView;
		req.attribute = svReq ? svReq.attribute : 0;
		var viewConfig = {};
		viewConfig.facetPanelTitle = localMsg.Filter;
		switch (dsType) {
		case sea.constants.DSTypes.WEB:
			setDefaultViewConfigForWeb(viewConfig);
			viewConfig.rawQuery = "bq=pushtype:1";
			break;
		case sea.constants.DSTypes.FS:
		case sea.constants.DSTypes.EDGE:
			setDefaultViewConfigForFS(viewConfig, fields);
			break;
		case sea.constants.DSTypes.VM:
			setDefaultViewConfigForVM(viewConfig, fields);
			break;
		default:
			var columnConfig = [];
			if (!$.isEmptyObject(fields)) {
				var noOfColsToShow = (fields.length > (_defaultNoOfColumns + 5)) ? _defaultNoOfColumns : fields.length;
				$.each(fields, function(i, eachField) {
					columnConfig.push({
						fieldName : eachField.fieldName,
						//show 15 columns by default. if at all there are only 20 columns in total, then show it as such
						visible : i < noOfColsToShow
					});
				});
				viewConfig.noOfColsToShow = noOfColsToShow;
			}
			viewConfig.columnConfig = columnConfig;
			break;
		}
		req.viewInfo = viewConfig;
		req.viewInfo.handlerInfo = hObj;
		return req;
	};
	return {
		getDefaultViewConfig : getDefaultViewConfigFromFields
	};
}());
sea.viewController = (function() {
	var containerId = sea.containerId;
	var searchViewsDTConfig = {
		"dom" : 'J<"pull-left"f><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">',
		"order" : [ [ 2, 'desc' ] ]
	};
	var ERROR_CONSTANTS = {
		VIEW_NAME_EXISTS : 10672
	};
	var VIEW_TYPES = {
		SEARCHVIEW : "sv",
		REPORTS : "rv"
	};
	var getValidDSNameForId = function(dsName) {
		if (dsName !== undefined) {
			dsName = dsName.replace(/\s+/g, '_');//replacing all spaces with '_' cz we are using dsName as Id for html elements
		}
		return dsName;
	}
	
	var getAllReports = function(dsId) {
		var deferred = $.Deferred();
		sea.services.getReportView(dsId, undefined, function(resp) {
			deferred.resolve(resp);
		});
		return deferred.promise();
	};
	var getAllSearchViews = function(dsId) {
		var deferred = $.Deferred();
		sea.services.getSearchView(dsId, undefined, function(resp) {
			deferred.resolve(resp);
		});
		return deferred.promise();
	};
	
	var getDefaultHandler = function(dsId) {
		var deferred = $.Deferred();
		sea.services.getDefaultHandler(dsId, function(resp) {
			var defaultHandler;
			if (resp && resp.handlerInfos && !$.isEmptyObject(resp.handlerInfos)) {
				defaultHandler = {
					handlerId : resp.handlerInfos[0].handlerId,
					handlerName : resp.handlerInfos[0].handlerName
				};
			}
			deferred.resolve(defaultHandler);
		});
		return deferred.promise();
	};

	var getSchemaAndDefaultViewConfig = function(hInfo, dsType, cb, elmToMask, svReq) {
		sea.services.getHandlerSchema(hInfo.handlerId, function(resp) {
			var fields = sea.schemaController.getSearchViewFields(resp.schemaFields, dsType);
			cb(sea.searchViewDefaults.getDefaultViewConfig(dsType, fields, hInfo, svReq));
		}, null, elmToMask);
	};
	var saveSearchView = function(dsId, dsType, hInfo, svReq, cb, errCb, elmToMask) {
		var saveFn = function(req) {
			sea.services.saveSearchView(dsId, req, function(resp) {
				cb(resp);
			}, errCb, elmToMask);
		};
		if (typeof svReq === 'undefined') {
			getSchemaAndDefaultViewConfig(hInfo, dsType, saveFn, elmToMask);
		} else if (typeof svReq.viewInfo === 'undefined') {
			getSchemaAndDefaultViewConfig(hInfo, dsType, saveFn, elmToMask, svReq);
		} else {
			saveFn(svReq);
		}
	};
	var getRVOrSVBaseReqObj = function(coreName, dsName, dsId, dsType, searchInfo,defaultHandler) {
		var reqObj = {}, isReport = searchInfo.status === 3;
		reqObj[sea.constants.HistoryParams.ACTION] = isReport ? sea.constants.Actions.REPORT_VIEW : sea.constants.Actions.EACH_SEARCH_VIEW;
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;		
		reqObj[sea.constants.HistoryParams.FULL_VIEW] = "1";
		if(isReport) {
			reqObj[sea.constants.ReportInputParams.NAME] = searchInfo.searchViewName;
			if (searchInfo.attribute === 2 || searchInfo.attribute === 16) { //default dashboard
			
				reqObj[sea.constants.ReportInputParams.DS_ID] = reqObj[sea.constants.HistoryParams.DS_ID];
				reqObj[sea.constants.ReportInputParams.DS_TYPE] = reqObj[sea.constants.HistoryParams.DS_TYPE];
				if (searchInfo.referenceId) {
					reqObj[sea.constants.ReportInputParams.HANDLER_ID] = searchInfo.referenceId;
					if (searchInfo.viewInfo) {
						viewInfo = JSON.parse(searchInfo.viewInfo);
						if (typeof viewInfo === "object") {
							reqObj[sea.constants.ReportInputParams.HANDLER_NAME] = viewInfo.handlerName;
						}
					}
				} else {
					reqObj[sea.constants.ReportInputParams.END_POINT] = "datacube";
					reqObj[sea.constants.HistoryParams.HANDLER_ID] = defaultHandler.handlerId;
					reqObj[sea.constants.HistoryParams.HANDLER_NAME] = defaultHandler.handlerName;
				}
			}
		} else 
			reqObj[sea.constants.HistoryParams.VIEW_ID] = searchInfo.searchViewId;	
			
		return reqObj;
	};
	var renderViewNameLink = function(coreName, dsName, dsId, dsType, tableId) {
		var reqObj = getSVBaseReqObj(coreName, dsName, dsId, dsType);
		$.each($(".viewNameLink", "#" + tableId), function(i, elm) {
			reqObj[sea.constants.HistoryParams.VIEW_ID] = $(this).data("viewid");
			$(elm).cvHyperlink(reqObj);
		});
	};
	var renderReportNameLink = function(coreName, dsName, dsId, dsType, tableId, defaultHandler) {
		var reqObj = getSVBaseReqObj(coreName, dsName, dsId, dsType);
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.REPORT_VIEW;
		$.each($(".reportNameLink", "#" + tableId), function(i, elm) {
			var row = $(this).data("row"), viewInfo;
			reqObj[sea.constants.ReportInputParams.NAME] = row.searchViewName;
			if (row.attribute === 2) { //default dashboard
				if (row.referenceId) {
					reqObj[sea.constants.ReportInputParams.DS_ID] = reqObj[sea.constants.HistoryParams.DS_ID];
					reqObj[sea.constants.ReportInputParams.DS_TYPE] = reqObj[sea.constants.HistoryParams.DS_TYPE];
					reqObj[sea.constants.ReportInputParams.HANDLER_ID] = row.referenceId;
					if (row.viewInfo) {
						viewInfo = JSON.parse(row.viewInfo);
						if (typeof viewInfo === "object") {
							reqObj[sea.constants.ReportInputParams.HANDLER_NAME] = viewInfo.handlerName;
						}
					}
				} else {
					reqObj[sea.constants.ReportInputParams.END_POINT] = "datacube";
					reqObj[sea.constants.HistoryParams.HANDLER_ID] = defaultHandler.handlerId;
					reqObj[sea.constants.HistoryParams.HANDLER_NAME] = defaultHandler.handlerName;
				}
			}
			$(elm).cvHyperlink(reqObj);
		});
	};
	var getSearchViewList = function(resp) {
		return resp ? ($.isArray(resp) ? resp
				: (resp.hasOwnProperty("searchViewList") ? resp.searchViewList : [ resp ])) : [];
	};
	var getSearchViewObject = function(resp) {
		var svObj = resp ? ($.isArray(resp) ? resp[0] : (resp.hasOwnProperty("searchViewList") ? resp.searchViewList[0]
				: resp)) : [];
		svObj.viewInfo = $.extend(true, {}, typeof svObj.viewInfo === "string" ? JSON.parse(svObj.viewInfo)
				: svObj.viewInfo);
		return svObj;
	};
	var isOnlyDefaultViewAvailable = function(svList) {
		return svList.length === 1 && svList[0].attribute === 0;
	};
	var onDeleteSearchViewBtnClicked = function(coreName, dsName, dsId, dsType, viewId, viewName) {
		var dlgId = "DeleteView_modal";
		$("#" + dlgId).remove();
		var dlg = $("<div id='" + dlgId + "'/>");
		dlg.appendTo("body").cvModal();
		$(".modal-title", dlg).text(localMsg.DeleteViewTitle);
		$(".modal-body", dlg).append(uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + "delete_view", "div"));
		$(".confirmDeleteMsg", dlg).html(cvFormatters.formatString(localMsg.ViewDeleteConfMsg, [ viewName ]));

		function okBtnHandler(ee) {
			sea.services.deleteSearchView(dsId, viewId, function() {
				cvUtil.toast(localMsg.SearchViewDeleted);
				// reload the search view table
				sea.services.getSearchView(dsId, undefined, function(resp) {
					var svList = getSearchViewList(resp);
					showSearchViewDataTable(coreName, dsName, dsId, dsType, svList, VIEW_TYPES.SEARCHVIEW);
				}, null, $(containerId));
			}, null, $(containerId));
		}
		$(".modal-footer .okBtn", dlg).text(localMsg.Delete).on("click", okBtnHandler);
		$(".modal", dlg).modal('show');
	};
	var getCreateNewViewButton = function(coreName, dsName, dsId, dsType, hList) {
		var btn = $("<button class='btn btn-primary'/>");
		var clickHander = function(e) {
			showSearchViewDialog(coreName, dsName, dsId, dsType, hList, false);
		};
		$(btn).text(localMsg.CreateNewView);
		$(btn).click(clickHander);
		return btn;
	};



	var getNewReportDropdown = function(dsId, dsType, hObj) {
		var $onClickElm;
		var $dropDown = $('<div class="dropdown subTypeMenu"> <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' +
				localMsg.GetReport + '<span class="caret margin-left-5"></span></button></div>');
		var $ul = $('<ul class="dropdown-menu dropdown-menu-right margin-top-2"></ul>');
		var $li = $('<li class="noPadding"><a target="_blank" href="'+sea.util.getVisulaizeLink(dsId, dsType, hObj) +'" id="createNewReport">' +
				localMsg.CreateNewReport + '</a></li>');
		$ul.append($li);
		$li = $('<li class="noPadding"><a href="javascript:void(0);" id="importReportLink">' +
				localMsg.ImportReport + '</a></li>');
		$ul.append($li);
		cvUtil.loadPageWithGET(cvUtil.getContextPath() + '/isStoreAccessible.do', null, function(result) {
			if (result === "true") {
				$li = $('<li class="noPadding"><a href="javascript:void(0);" id="appStoreLink">' +
						localMsg.InstallReport + '</a></li>');
				$ul.append($li);
			}
		});
		$dropDown.append($ul);
		$onClickElm = $("#importReportLink", $dropDown);

		$onClickElm.off("click").on("click", function(event) {
			var reqObj = {};
			$('#browseImportFile').click();
		});

		return $dropDown;
	};

	var populateHandlersCombo = function(hList, comboObj) {
		if (!hList || typeof comboObj === 'undefined' || comboObj == null) {
			return;
		}
		comboObj.empty();
		$.each(hList, function(i, v) {
			var optHtml = "<option value=\"" + v.handlerId + "\">" + v.handlerName + "</option>";
			comboObj.append(optHtml);
		});
	};

	var showSearchViewDialog = function(coreName, dsName, dsId, dsType, hList, isSaveAs, modifiedConfig) {
		var formData = {};
		var dlgId = "CreateNewView_modal";
		$("#" + dlgId).remove();
		var dlg = $("<div id='" + dlgId + "'/>");
		dlg.appendTo("body").cvModal();
		$(".modal-title", dlg).text(isSaveAs ? localMsg.SaveAs : localMsg.CreateNewView);
		$(".modal-body", dlg).append(uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + "create_view", "div"));
		populateHandlersCombo(hList, $("#handlerId", dlg));
		function saveBtnHandler(ee) {
			// do not hide the modal on click of save
			ee.stopPropagation();
			try {
				formData = sea.util.validateInputsAndGetData(dlg);
			} catch (ex) {
				console.log(ex);
				return;
			}
			var req = {
				searchViewName : formData.viewName,
				attribute : 1
			};
			if (modifiedConfig) {
				req.viewInfo = modifiedConfig;
			}
			if (formData.handlerId !== undefined) {
				var hInfo = {
					handlerId : formData.handlerId,
					handlerName : $("#handlerId option:selected", dlg).text()
				};
				if (req.viewInfo) {
					req.viewInfo.handlerInfo = hInfo;
				}
			}
			saveSearchView(dsId, dsType, hInfo, req, function(resp) {
				var svObj = getSearchViewObject(resp);
				if (!$.isEmptyObject(svObj)) {
					$(".modal", dlg).modal('hide')
					cvUtil.toast(localMsg.SearchViewSaved);
					// go to newly created view
					var reqObj = getSVBaseReqObj(coreName, dsName, dsId, dsType);
					reqObj[sea.constants.HistoryParams.VIEW_ID] = svObj.searchViewId;
					sea.history.pushState(reqObj, document.title, $.param(reqObj));
				} else {
					alert(localMsg.SearchViewFailed);
				}
			}, function(errResp, msg) {
				if (errResp.error && errResp.error.errorCode === ERROR_CONSTANTS.VIEW_NAME_EXISTS) {
					$("#viewNameExists", dlg).text(msg).show();
					$(".viewNameFormGroup", dlg).addClass("has-error");
				} else {
					alert(localMsg.SearchViewFailed);
				}
			}, dlg);
		}
		$("#viewName", dlg).off("keyup").on("keyup", function(key) {
			if (key && key.keyCode == 13) {
				$(".modal-footer .okBtn", dlg).trigger("click");
			}
		});
		$(".modal-footer .okBtn", dlg).text(localMsg.Save).on("click", saveBtnHandler);
		$(".modal", dlg).modal('show').on('shown.bs.modal', function(e) {
			$("#viewName", dlg).focus();
		});
	}

	var handleSaveAs = function(coreName, dsName, dsId, dsType, modifiedConfig, hList) {
		showSearchViewDialog(coreName, dsName, dsId, dsType, hList, true, modifiedConfig);
	};

	/* this method has been used by both search view and reports view */
	var showSearchViewDataTable = function(coreName, dsName, dsId, dsType, viewList, viewType, defaultHandler) {
		var dsNameForId = getValidDSNameForId(dsName);
		var viewTableId = dsNameForId + "_" + viewType + "_dt";
		if (viewType === VIEW_TYPES.SEARCHVIEW) {
			var defSVObj = {
				searchViewId : -1,
				searchViewName : localMsg.DefaultSearchView,
				attribute : 0,
				modifiedUTCTime : 0,
				createUTCTime : 0
			};
			if (dsType !== sea.constants.DSTypes.NAS) {
				/*
				 * if viewList contains a default search view(attribute=0), then update the viewId to -1. This
				 * is to make sure existing saved default search view config is up to date
				 */
				var exDefSVObj = cvSearchUtil.getObjectByKeyValue(viewList, {
					attribute : 0
				});
				if (exDefSVObj != null) {
					$.extend(exDefSVObj, defSVObj);
				} else {
					viewList = cvSearchUtil.prependArray(defSVObj, viewList);
				}
			}
		} else if (viewType === VIEW_TYPES.REPORTS) {
			//nothing as of now
		}
		if (!$.fn.DataTable.isDataTable("#" + viewTableId)) {
			var config = $.extend({}, searchViewsDTConfig);
			if (viewType === VIEW_TYPES.SEARCHVIEW) {
				config.drawCallback = function(settings, json) {
					renderViewNameLink(coreName, dsName, dsId, dsType, viewTableId);
				};
				config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.searchViewConfig);
				config.columnDefs = [ {
					sType : 'date-time',
					targets : [ 1, 2 ]
				} ];
			} else if (viewType === VIEW_TYPES.REPORTS) {
				//Since we don't update the modified time whenever the reports is edited, showing only created time and sorting on it by default
				config.drawCallback = function(settings, json) {
					renderReportNameLink(coreName, dsName, dsId, dsType, viewTableId, defaultHandler);
				};
				config.order = [ [ 1, "desc" ] ];
				config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.reportViewConfig);
			}
			config.data = viewList;
			$("#" + viewTableId).dataTable(config);
		} else {
			$("#" + viewTableId).DataTable().clear().rows.add(viewList).draw();
		}
	};

	/*
	 * Earlier it was getting schema from getSchema API using coreName Now, this method uses getHandlerSchema
	 * using handler ID. Also, searches are submitted to default|custom handler instead of select. For default
	 * search view, get the default handler info For saved search view, look into handlerInfo from the view
	 * config
	 */
	var onViewSearchView = function(coreName, dsName, dsId, dsType, viewId) {
		var idPrefix = coreName + "_searchView";
		var $wrapper = $("<div id='searchWrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", idPrefix + "_header").appendTo("#searchWrapper");
		$(containerId).mask("");
		
		var onHandlerInfoReceived = function(hObj, viewObj) {
			if (hObj && hObj.handlerId !== undefined) {
				sea.services.getHandlerSchema(hObj.handlerId, function(resp) {
					var fields = sea.schemaController.getSearchViewFields(resp.schemaFields, dsType);
					$(containerId).unmask();
					if (!$.isEmptyObject(viewObj)) {
						var breadCrumb = $(sea.containerId).find(".analyticsCrumb").data("cvBreadCrumb");
						breadCrumb.updateLevel(breadCrumb.tip.params.level, viewObj.searchViewName);
						initSearchView(coreName, dsName, dsId, dsType, viewObj, fields, []);

					} else {
						alert(localMsg.ViewNotExist);
					}
				});
			}
		};

		$(containerId).mask("");
		var combinedPromise = $.when(getAllSearchViews(dsId), getAllReports(dsId), getDefaultHandler(dsId));
		combinedPromise.done(function(svResp,rvResp, hResp) {
			$(containerId).unmask();
			var reportList = rvResp.searchViewList, svList = svResp.searchViewList, 
			selectedSearchObj = svList.filter(function(reportInfo) {
				return reportInfo.searchViewId === viewId
			});
			if(selectedSearchObj.length > 0) {
				selectedSearchObj = selectedSearchObj[0];
				selectedSearchObj.viewInfo = $.extend(true, {}, typeof selectedSearchObj.viewInfo === "string" ? JSON.parse(selectedSearchObj.viewInfo)
				: selectedSearchObj.viewInfo);
				reportList = reportList.concat(svList);
				var $svHeaderContainer = $('<div id="svHeaderContainer" class="col-sm-12 noPadding"></div>');
				$svHeaderContainer.append(getReportsDropdown(coreName, dsName, dsId, dsType, reportList , hResp,selectedSearchObj.searchViewName));		
				$wrapper.append($svHeaderContainer);
				if (selectedSearchObj && selectedSearchObj.viewInfo && selectedSearchObj.viewInfo.handlerInfo) {
					onHandlerInfoReceived(selectedSearchObj.viewInfo.handlerInfo, selectedSearchObj);
				} else {
					$.when(getDefaultHandler(dsId)).done(function(hResp) {
						selectedSearchObj.viewInfo.handlerInfo = hResp;
						onHandlerInfoReceived(hResp, selectedSearchObj);
					});
				}
			} else {
				alert(localMsg.ViewNotExist);
			}		
			
		});
		
		
	};

	var resetSystemConfig = function(config) {
		delete config.viewId;
		delete config.viewName;
		delete config.searchUrl;
		delete config.suggestUrl;
		delete config.searchReq;
		delete config.suggestReq;
		delete config.contextPath;
		delete config.isEditable;
		delete config.buildTs;
		delete config.disableAddFilter;
		delete config.noOfColsToShow;
	};

	var generateUUID = function() {
		var currentTime = new Date().getTime();
		var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(chr) {
			var randomNum = (currentTime + Math.random() * 16) % 16 | 0;
			currentTime = Math.floor(currentTime / 16);
			return (chr == 'x' ? randomNum : (randomNum & 0x7 | 0x8)).toString(16);
		});
		return uuid;
	};

	var initSearchView = function(coreName, dsName, dsId, dsType, viewResp, fields, hList) {
		var dsNameForId = getValidDSNameForId(dsName);
		var viewDivId = dsNameForId + "_" + sea.constants.DATA_SOURCES + "_searchView";
		$("<div id='" + viewDivId + "'></div>").appendTo(containerId);
		var viewConfig = viewResp.viewInfo;
		var hObj = viewConfig.handlerInfo;
		viewConfig.viewName = viewResp.searchViewName || viewResp.viewName;
		viewConfig.viewId = viewResp.searchViewId;

		viewConfig.contextPath = cvUtil.CONTEXT_PATH;
		viewConfig.buildTs = sea.BUILD_TS;
		viewConfig.isEditable = viewResp.attribute !== 0;
		if (dsType === sea.constants.DSTypes.WEB) {
			viewConfig.disableAddFilter = true;
			viewConfig.isEditable = false;
			viewConfig.tableConfig = {
				pageLength : 10
			};
		}
		/*
		 * Based on the view type decide the query Builder for Search view, it is qb.sv; for Kendo UI, it will
		 * be qb.tv. make sure to initialize it before passing to components, so that state will be reset
		 */
		qb.sv.init(hObj.handlerId, {
			schema : fields,
			searchUrl : cvFormatters.formatString(sea.services.searchViaHandlerUrl,
					[ hObj.handlerId, hObj.handlerName ]),
			suggestUrl : cvFormatters.formatString(sea.services.searchServerUrl, [
					dsId,
					qb.base.getDefaultSuggestHandler() ]),
			additionalParams : {
				useDCubeReq : true
			}
		});
		$("#" + viewDivId).cvSearchView(hObj.handlerId, viewConfig, fields);
		$("#" + viewDivId).on(cvSearchConstants.EventConstants.ON_SEARCH_SETTINGS_CHANGED,
				function(event, modifiedConfig, isEditable) {
					resetSystemConfig(modifiedConfig);
					if (isEditable) {
						var req = {
							viewId : viewConfig.viewId,
							searchViewName : viewResp.searchViewName,
							attribute : viewResp.attribute
						};
						req.viewInfo = modifiedConfig;
						saveSearchView(dsId, dsType, undefined, req, function(resp) {
							cvUtil.toast(localMsg.SearchViewSaved);
						}, function(errResp, msg) {
							alert(localMsg.SearchViewFailed);
						}, $(containerId));
					} 
				});
		$("#" + viewDivId).on(cvSearchConstants.EventConstants.ON_BUILD_MY_REPORT_CLICKED,
				function() {
					$(this).find(".newreport").attr("target", "_blank").attr("href",
							sea.util.getVisulaizeLink(dsId, dsType, hObj));
				});
	};

	var getFederatedSearchInfo = function(dsId,dsType) {
		var deferred = $.Deferred();
		if(dsType === sea.constants.DSTypes.FEDERATED) {
			sea.services.getFederatedSearch(dsId, function(resp) {
				deferred.resolve(resp.federatedSearchInfos[0]);			
			});
		}  else {
			deferred.resolve();
		}	
		return deferred.promise();
	}
	var onViewReport = function(coreName, dsName, dsId, dsType, rName) {
		var idPrefix = coreName + "_reportView";
		var $wrapper = $("<div id='reportWrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", idPrefix + "_header").appendTo("#reportWrapper");
		var breadCrumb = $(sea.containerId).find(".analyticsCrumb").data("cvBreadCrumb");
		$(containerId).mask("");
		var combinedPromise = $.when(getAllSearchViews(dsId), getAllReports(dsId), getDefaultHandler(dsId),getFederatedSearchInfo(dsId,dsType));
		combinedPromise.done(function(svResp,rvResp, hResp, federatedInfo) {
			$(containerId).unmask();
			var reportList = rvResp.searchViewList, svList = svResp.searchViewList, selectedReport,
			defaultReport = reportList.filter(function(reportInfo) {
				return reportInfo.attribute === 16;
			}),
			handlerName = "default";
			if(dsType === sea.constants.DSTypes.FEDERATED) {
				handlerName = federatedInfo.federateSearchName;
				hResp.handlerId = federatedInfo.federateSearchId;
				hResp.handlerName =  federatedInfo.federateSearchName;
			}
			if(defaultReport.length === 0) { //If User is adding new type and default report is not added in SEDSTemplate table then we will show 'Search' report as a default report					
				selectedReport = {
					"status" :  3,
					"attribute" : 16,
					"searchViewName" : "Search",
					"dataSourceId" : dsId,
					"dataSourceType" : dsType,
					"referenceId" : hResp.handlerId,
					"viewInfo" : JSON.stringify({'handlerName' : handlerName})
				};	
				reportList.push(selectedReport);
				if(!rName) 
					rName = 'Search';				
			}
			if(rName) {
				selectedReport = reportList.filter(function(reportInfo) {
					return reportInfo.searchViewName === rName;
				});
				if(selectedReport.length !== 0)
					selectedReport = selectedReport[0];
			} else if(defaultReport.length !== 0){				
				selectedReport = defaultReport[0];
				rName = selectedReport.searchViewName;				 									
			}
			breadCrumb.updateLevel(breadCrumb.tip.params.level, rName);	
			if(selectedReport) {
				reportList = reportList.concat(svList);
				var $reportHeaderContainer = $('<div id="reportHeaderContainer" class="row"></div>');
				$reportHeaderContainer.append(getReportsDropdown(coreName, dsName, dsId, dsType, reportList , hResp,rName));
				if(sea.isCustomReportsEnabled)		
					$reportHeaderContainer.append(getReportsActioBtns(dsId, dsType, hResp, selectedReport));			
				$wrapper.append($reportHeaderContainer);
			}
			
					
			var reportHtml = "<div id='reportArea'>" +
					"<div id='ng-app' data-ng-app='reports' data-ng-controller='reportsCtrl' data-ng-init='init(null,\"" +
					rName +
					"\",false)'>" +
					"<div id='pageDiv' data-ng-controller='pageController' class='maskLayer' data-ng-class='{isMasked:masked}' ></div></div></div>";
			$(reportHtml).appendTo("#reportWrapper");
			angular.element(angular.element("#reportArea")).ready(function() {
				// bootstrap the app manually
				angular.bootstrap(angular.element("#reportArea"), [ 'reports' ]);
				// angular.element("#reportArea").append(childDiv);
				var includestate = "<ng-include src=\"'" + cvUtil.CONTEXT_PATH +
						"/reportsplus/templates/reportComponents/viewerPage.jsp'\"></ng-include>";
				var div = $("<div>");
				div.html(includestate);
				var newScope = angular.element('#pageDiv').scope();
				angular.element('#pageDiv').injector().invoke([ '$compile', function($compile) {
					var newHtml = $compile(div)(newScope);
					newScope.$digest();
					reportScope = newScope;
					newScope.$watch("customReport",function(newVal,oldVal) {
						if(newVal !== undefined && (newVal !== oldVal)) {
							customReport = newVal;
						}
						
					});
					angular.element("#pageDiv").append(newHtml);
				} ]);
			});
		});
	};

	

	var cloneReportsView = function(reportInfo) {
		var viewInfo = JSON.parse(reportInfo.viewInfo);
		var dlgId = "NewReportName_modal";
		$("#" + dlgId).remove();
		var dlg = $("<div id='" + dlgId + "'/>");
		dlg.appendTo("body").cvModal();
		$(".modal-title", dlg).text(localMsg.CloneReport);
		$(".modal-body", dlg).append(uiControls.util
				.getTemplate(sea.constants.TMPL_PREFIX + "clone_report_view", "div"));
		$(".modal-footer .okBtn", dlg).text(localMsg.Clone).on("click", function() {

			var crObjToSave = reportScope.getCustomReportObjectToSave(customReport);
			var ajaxReq = {
				'reportName' : reportInfo.searchViewName,
				'newReportName' : $("#reportName", dlg).val(),
				'dsId' : reportInfo.dataSourceId,
				'dsType' : reportInfo.dataSourceType,
				'handlerId' : reportInfo.referenceId,
				'handlerName' : viewInfo.handlerName,
				'reportJson': JSON.stringify(crObjToSave)
			};
			$(containerId).mask("");
			cvUtil.loadPageWithPOST('cloneDefaultDashboard.do', ajaxReq, function(data) {
				var reportId = parseInt(data);
				if (!isNaN(reportId)) {
					window.open(cvUtil.getContextPath() + "/reportsplus/?reportId=" + data,"_blank");
				} else {
					cvUtil.errorToast(data);
				}
				$(containerId).unmask();
			});
		});
		$(".modal", dlg).modal('show').on('shown.bs.modal', function(e) {
			$("#reportName", dlg).focus();
		});
		$("#reportName", dlg).off("keyup").on("keyup", function(key) {
			if (key && key.keyCode == 13) {
				$(".modal-footer .okBtn", dlg).trigger("click");
			}
		});
	};

	var getCloneOrEditReportBtn = function(selectedReport) {
		var $link;
		if (selectedReport.attribute === 2 || selectedReport.attribute === 16) {
			$link =  $("<button class='clone-default-report btn btn-primary'>" + localMsg.Clone + "</button>");
			$link.off('click').on('click', function() {
				cloneReportsView(selectedReport);
			});
			return $link
		}
		return $("<a class='pull-right' href='" + cvUtil.getContextPath() + "/reportsplus/index.jsp?reportId=" + selectedReport.viewInfo +
				"'><button class='btn btn-primary'>" + localMsg.Edit + "</button></a>");
	}

	var getReportsActioBtns = function(dsId, dsType, defaultHandler, selectedReport) {
		var $actionBtnWrapper =  $('<div class="col-sm-6 actionBtnWrapper"></div>');
		$actionBtnWrapper.append(getNewReportDropdown(dsId, dsType, defaultHandler));
		$actionBtnWrapper.append(getCloneOrEditReportBtn(selectedReport));
				
		return $actionBtnWrapper;
	}


	var getReportsDropdown = function(coreName, dsName, dsId, dsType,reportsList,defaultHandler,selectedReportName) {
		var $li, $link, reqObj, $btnDropdown, $ul, $dropdownWrapper = $('<div class="col-sm-6"></div>');

		$btnDropdown = $('<div class="dropdown reportsDropdown"> <button type="button" class="btn btn-link noPadding dropdown-toggle" data-toggle="dropdown" uib-dropdown-toggle="uib-dropdown-toggle" aria-haspopup="true" aria-expanded="false">'+
			selectedReportName + '<span class="caret margin-left-5"></span></button></div>');
		$ul = $('<ul class="dropdown-menu" uib-dropdown-menu="uib-dropdown-menu"></ul>');
		if(reportsList !== []) {
			$.each(reportsList,function(index,reportInfo) {
			  	$li = $('<li class="noPadding"></li>');
			  	if(reportInfo.searchViewName === selectedReportName)
			  		$li.addClass("active");
			  	$link = $('<a>'+reportInfo.searchViewName+'</a>');
			  	reqObj = getRVOrSVBaseReqObj(coreName, dsName, dsId, dsType,reportInfo,defaultHandler);
			  	$link.cvHyperlink(reqObj);
			  	$li.append($link);
				$ul.append($li);
			});
		}
		$btnDropdown.append($ul);	
		$dropdownWrapper.append($btnDropdown);
		return $dropdownWrapper;
		
	}

	return {
		showSearchView : onViewSearchView,
		showReportView : onViewReport,
		showSearchViewDataTable : showSearchViewDataTable,
		getSearchViewList : getSearchViewList
	};
}());
