var uploadFile = {};
var uploader = null;
var within_enter = false;
var fileprogressMap = null;
var isNewUploaderSupported = false;
var uploadedFiles = [];
window.uploadAjaxRequests = new Array();

uploadFile = (function() {

	var onInit = function(config) {
		uploader = new Uploader({
			target : "seaUploadHandler.do",
			duplicateFile : true
		});
		uploader.config = config;

		isNewUploaderSupported = uploader.isSupported();
		if (isNewUploaderSupported) {
			uploader.assignBrowse($("#uploadLink"), false);
		}

		if ($(".fileProgressContainer").length == 0) {
			var contentDiv = document.createElement("DIV");
			$(contentDiv).load(cvUtil.getContextPath() + "/upload/fileprogress.jsp", function() {
				$("#progressContainer").append($(contentDiv).find(".fileProgressContainer"));
			});
		}
	};

	var uploadAction = function(dsId, event) {
		if (isNewUploaderSupported) {
			doReStartableUpload(dsId);
		}
		event.stopPropagation();
	};

	doReStartableUpload = function(dsId) {
		console.debug("Start Setting the Uploader...");
		var uploadHeaderParams = {};
		uploadHeaderParams["dsId"] = dsId;
		if (uploader != null) {
			console.debug("Upload Params: " + JSON.stringify(uploadHeaderParams));
			uploader.setOptions("query", uploadHeaderParams);
			attachDownloadProgressBar();
		}
		console.debug("Setting the Uploader Completed.");
	};

	attachDownloadProgressBar = function(fullPath) {
		attachDownloadProgressBarListeners(fullPath);
	};

	attachDownloadProgressBarListeners = function(fullPath) {
		if (uploader != null) {
			uploader.onEvent(uploader.EventEnum.UPLOAD_START, function() {
				onUploadStart();
			});

			uploader.onEvent(uploader.EventEnum.READY_FOR_UPLOAD, function() {
				onUploadReady();
			});

			uploader.onEvent(uploader.EventEnum.UPLOAD_PROGRESS, function(event, uploadProgress) {
				onUploadProgress(uploadProgress);
			});

			uploader.onEvent(uploader.EventEnum.FILE_ADDED, function(fileItem) {
				onUploadFileAdd(fileItem);
			});

			uploader.onEvent(uploader.EventEnum.FILE_ADD_ERROR, function(fileItem) {
				onUploadFileAddError(fileItem);
			});

			uploader.onEvent([
					uploader.EventEnum.FILE_UPLOAD_STARTING,
					uploader.EventEnum.FILE_UPLOAD_INPROGRESS,
					uploader.EventEnum.FILE_UPLOAD_CANCELED,
					uploader.EventEnum.FILE_UPLOAD_CANCEL_ERROR ], function(fileItem) {
				onProgress(fileItem);
			});

			uploader.onEvent(uploader.EventEnum.FILE_UPLOAD_COMPLETED, function(fileItem) {
				onUploadFileComplete(fileItem, fullPath);
			});

			uploader.onEvent(uploader.EventEnum.FILE_UPLOAD_ERROR, function(fileItem) {
				onUploadFileError(fileItem);
			});

			uploader.onEvent(uploader.EventEnum.UPLOAD_END, function() {
				onFileUploadComplete();
			});
		}
	};

	onUploadStart = function() {
		$("#uploadLink").addClass("disabledActions");
		fileProgress.initProgressDialog();

		if (uploader != null && typeof uploader.config.startCallback === "function") {
			uploader.config.startCallback();
		}
	};

	onUploadFileAdd = function(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			if (fileprogressMap.size() % 50 == 0) {
				fileProgress.updateProgress(fileprogressMap);
				fileprogressMap.clear();
				delete fileprogressMap;
				fileprogressMap = null;
			}
		}
	};

	onUploadFileAddError = function(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			fileProgress.updateProgress(fileprogressMap);
			fileprogressMap.clear();
			delete fileprogressMap;
			fileprogressMap = null;
		}
	};

	onUploadReady = function() {
		if (uploader != null) {
			console.debug("Ready for Upload");
			fileProgress.updateProgress(fileprogressMap);
			delete fileprogressMap;
			fileprogressMap = null;
			console.debug("Starting Upload...");
			uploader.startUpload();
		}
	};

	Uploader.prototype.onUploadSuccess = function(uploadFileInfo, serverResponse, range_from, range_to) {
		var returnedItems = JSON.parse(serverResponse);
		var returnCode = returnedItems.returnCode;
		if (returnCode == "Success") {
			if (range_to === uploadFileInfo.fileProgressItem.fileSize) {
				uploadFileInfo['fileGuid'] = returnedItems.fileGuid;
				this.onUploadComplete(range_to, uploadFileInfo);
			} else {
				// still have more to upload
				uploadFileInfo.fileProgressItem.updateProgress(returnedItems.chunkOffset, this.uploadProgress);
				this.fireEvent(this.EventEnum.FILE_UPLOAD_INPROGRESS, uploadFileInfo.fileProgressItem);
				delete serverResponse;
				if (uploadFileInfo.fileProgressItem.canFileContinue()) {
					this.uploadFile(uploadFileInfo);
				}
			}
		} else if (returnCode == "Error") {
			var errorMessage = returnedItems.returnErrorMessage;
			delete serverResponse;
			this.onUploadError(errorMessage, uploadFileInfo);
		} else if (returnCode == "Cancel") {
			uploadFileInfo.fileProgressItem.updateProgress(range_from, this.uploadProgress);
			uploadFileInfo.fileProgressItem.updateStatus(uploadFileInfo.fileProgressItem.Status.CANCELED);
			this.fireEvent(this.EventEnum.FILE_UPLOAD_CANCELED, uploadFileInfo.fileProgressItem);
			this.fileUploadMap.remove(uploadFileInfo.fileProgressItem.fileID);

			delete serverResponse;
			delete range_from;
			delete range_to;

			this.canUploadNextFile(uploadFileInfo);
		}
	};

	onProgress = function(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			fileProgress.updateRow(fileItem);
		}
	};

	onUploadProgress = function(uploadProgress) {
		if (typeof uploadProgress !== "undefined" && uploadProgress !== null) {
			fileProgress.updateHeader(uploadProgress);
		}
	};

	onUploadFileComplete = function(fileItem, uploadPath) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (uploader != null && uploader.isSameParentPath(fileItem.fileID, uploadPath)) {
				addUploadFilePlaceholder(fileItem);
			}
			fileProgress.updateRow(fileItem);
			refreshAfterUpload(fileItem);
		}

		if (uploader != null && typeof uploader.config.endCallback === "function")
			uploader.config.endCallback();

	};

	onUploadFileError = function(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			nh.addNotificationToHistory(nh.NOTIFICATION_ERROR,
					fileItem.fileName + " - " + fileItem.error.message,
					false);
		}
		fileProgress.updateRow(fileItem);
		if (uploader != null && typeof uploader.config.errorCallback === "function")
			uploader.config.errorCallback();
	};
	Uploader.prototype.onUploadComplete = function(range, uploadFileInfo) {
		uploadFileInfo.fileProgressItem.updateProgress(range, this.uploadProgress);
		uploadFileInfo.fileProgressItem.updateStatus(uploadFileInfo.fileProgressItem.Status.COMPLETED);
		if (typeof this.uploadProgress !== "undefined" && this.uploadProgress !== null) {
			this.uploadProgress.updateUploadFileCount(this.uploadProgress.Status.COMPLETED);
		}
		this.fireEvent(this.EventEnum.FILE_UPLOAD_COMPLETED, uploadFileInfo);
		this.fileUploadMap.remove(uploadFileInfo.fileProgressItem.fileID);
		var uploadPath = $("#dsCSVUploadPath", uploader.config.holder).val();
		if (uploadPath == null || uploadPath == "") {
			$("#dsCSVUploadPath", uploader.config.holder).val(uploadFileInfo.fileGuid);

		} else
			$("#dsCSVUploadPath", uploader.config.holder).val(uploadPath + "\n" + uploadFileInfo.fileGuid);

		delete range;

		this.canUploadNextFile(uploadFileInfo);
	};
	onFileUploadComplete = function() {
		$("#uploadLink").removeClass("disabledActions");

		var $newFiles = $.map(uploadedFiles, function(file, index) {
			return getAsDeleteableItem(file.fileName, file.fileGuid);
		});

		$.each($newFiles, function(index, $file) {
			$("#dsCsvLocation", uploader.config.holder).append($file);
		});

		uploadedFiles = [];
		setTimeout(function() {
			//If there are no ongoing uploads, remove the widget from DOM
			if (uploader.fileUploadMap.getKeys().length === 0)
				fileProgress.removeDialog();
		}, 6000);
		cleanUp();

	};

	pause = function(fileId) {
		if (isNewUploaderSupported) {
			uploader.pause(fileId);
		}
	};

	resume = function(fileId) {
		if (isNewUploaderSupported) {
			uploader.resume(fileId);
		}
	};

	cancel = function(fileId) {
		if (isNewUploaderSupported) {
			console.debug("Cancelling Upload Request for " + fileId + "...");
			uploader.cancel(fileId);
		}
	};

	cancelAll = function() {
		if (isNewUploaderSupported) {
			console.debug("Cancelling All Upload Request...");
			uploader.cancelAll();
		}
	};

	cleanUp = function() {
		within_enter = false;
	};

	refreshAfterUpload = function(fileItem) {
		uploadedFiles.push({
			fileName : fileItem.fileForUpload.fileName,
			fileGuid : fileItem.fileGuid
		});
	};

	return {
		init : onInit,
		uploadAction : uploadAction,
		cleanUp : cleanUp,
		cancel : cancel,
		cancelAll : cancelAll,
		pause : pause,
		resume : resume
	};
})();
