var uiControls = uiControls || {};
// Toolbar, start
function ToolBar(parentId, id, title) {
	this.title = title;
	this.toolBarId = id;
	this.parentDivId = parentId;
	if (this.parentDivId && this.parentDivId.charAt(0) !== '#')
		this.parentDivId = "#" + this.parentDivId;
	this.createToolBar();
}
ToolBar.prototype.createToolBar = function() {
	var toolbarElm = uiControls.util.getTemplate("tmpl_Toolbar", "div");
	toolbarElm.attr("id", this.toolBarId).appendTo(this.parentDivId);
	$(".cvToolbarTitle", $("#" + this.toolBarId)).text(this.title);
	$(".cvToolbarButtonbar", $("#" + this.toolBarId)).addClass("hidden-print");
};
ToolBar.prototype.addButtonToTitle = function(btnObj) {
	$(".cvToolbarTitle", $("#" + this.toolBarId)).append(btnObj);
};
ToolBar.prototype.addButton = function(btnObj) {
	$(".cvToolbarButtonbar", $("#" + this.toolBarId)).append(btnObj);
};
ToolBar.prototype.addClass = function(className) {
	this.className = className;
	$("#" + this.toolBarId).addClass(this.className);
};
ToolBar.prototype.setTitle = function(title) {
	this.title = title;
	$(".cvToolbarTitle", $("#" + this.toolBarId)).text(this.title);
};
// Toolbar, end
// cvHyperlink, start
(function(factory) {
	if (!jQuery) {
		throw 'cvHyperlink depends on jQuery and seems to be missing...';
	} else {
		factory(jQuery);
	}
}(function($) {
	"use strict";

	$.fn.cvHyperlink = function(reqObj) {
		return this.each(function() {
			var $this = $(this);
			var qs = $.isEmptyObject(reqObj) ? "" : $.param(reqObj);
			if(qs !== "") 
				$this.attr("href","?"+qs);
			$this.data("href-obj", $.extend({}, reqObj)).off('click').on('click', function(e) {
					if (e.which && e.which == 1) {
						e.preventDefault();
						sea.history.pushState($this.data("href-obj"), document.title, qs);
					}
				});
			
			
		});
	};

}));
// cvHyperlink, end
// cvModal, start
(function(factory) {
	if (!jQuery) {
		throw 'cvModal depends on jQuery and seems to be missing...';
	} else {
		factory(jQuery);
	}
}(function($) {
	"use strict";

	$.fn.cvModal = function(options) {

		return this.each(function() {
			var $this = $(this);
			$this.empty().append("<div class='modal fade' role='dialog' tabindex='-1'>" + "<div class='modal-dialog'>" +
					"<div class='modal-content'>" + "<div class='modal-header'>" +
					"<button type='button' class='close' data-dismiss='modal'>" +
					"<span aria-hidden='true'>&times;</span><span class='sr-only'>Close</span></button>" +
					"<h5 class='modal-title'></h5></div>" + "<div class='modal-body'></div>" +
					"<div class='modal-footer bottom-button-panel'>" +
					"<span class='progressMsg pull-left' style='display:none'>" + localMsg.PleaseWait + "</span>" +
					"<button type='button' data-dismiss='modal' class='btn btn-primary okBtn'>" + localMsg.Ok +
					"</button>" + "<button type='button' data-dismiss='modal' class='btn cancelBtn'>" +
					localMsg.Cancel + "</button>" + "</div></div></div></div>");
			$this.find(".modal-dialog").draggable();
		});
	};
}));

$(document).ready(function() {
	$(document).on('typeahead:opened', function(event, datum) {
		//as we have search icon, adjust the popup's width by subtracting.
		var width = $(event.target).outerWidth();
		$('.tt-dropdown-menu').outerWidth(width);
	});
});
// cvModal, end
// utility method to open modal with ajax content(template)
uiControls.util = (function() {

	var loadModal = function(dlgId, tmplPath, callback) {
		var dlg = $("#" + dlgId);
		if (dlg.length == 0) {
			dlg = $("<div id='" + dlgId + "'/>");
			dlg.appendTo("body").cvModal();
			$("body").mask();
			$(".modal-body", dlg).load(tmplPath, function() {
				$("body").unmask();
				callback(dlg);
			});
		} else
			callback(dlg);
	};
	var getTemplate = function(templateId, elmSelector) {
		var attrName = "data-templateId";
		var sel = elmSelector + "[" + attrName + "=" + templateId + "]";
		return $(sel).clone(false).removeAttr(attrName).show();
	};
	var getDataTableHtml = function(id, colConfig) {
		var headerTRHtml = "<tr>";
		$.each(colConfig, function(index, eachConfig) {
			headerTRHtml += "<th>" + (eachConfig.dispName ? eachConfig.dispName : eachConfig.fieldName) + "</th>";
		});
		headerTRHtml += "</tr>";
		var tableHtml = "<table id='" + id + "' class='table table-bordered' width='100%'>";
		tableHtml += "<thead>" + headerTRHtml + "</thead>";
		tableHtml += "</table>";
		return tableHtml;
	};
	var getDTResizeHandler = function(tableId) {
		var dtResizeHandler = function(e, settings) {
			// When autoWidth is set to true, there is an extra width in the table
			// which causes scroll bar even if the no. of columns are less. so
			// reduce the width by few px.
			var dtWrapper = $(("#" + tableId) + "_wrapper");
			var tw = $(".dataTables_scrollBody table", dtWrapper).width();
			$(".dataTables_scrollHead table,.dataTables_scrollBody table,.dataTables_scrollFoot table", dtWrapper)
					.css("width", tw + "px");
		};
		return dtResizeHandler;
	}
	return {
		loadModal : loadModal,
		getTemplate : getTemplate,
		getDataTableHtml : getDataTableHtml,
		getDTResizeHandler : getDTResizeHandler
	};
})();