var sea = sea || {};
sea.shareFiles = (function() {

	var containerId = sea.containerId;
	// default sharing permission
	var defaultShareValue = sea.constants.Permissions.VIEW;
	// supported types of entities for sharing
	var entityType = { HANDLER : "handler", DATASOURCE : "datasource"};
	// supported operations for sharing
	var operations = { ADD : "add", REMOVE : "remove" };

	// Gets the Sharing button for datasource sharing
	var getShareDSButton = function(dsId) {
		var btn = $("<button class='btn btn-primary'/>");
		var confirmModalElm = $("#shareDataSourceModal");
		$(btn).text(localMsg.Share);
		var holder = $("#shareDataSourceModal");
		$(btn).click(function() {
			confirmModalElm.modal('show').find(".modal-dialog").draggable();
			onModalInit(dsId,entityType.DATASOURCE,$("#shareDataSourceModal"));
			onDataSourceModalInit(dsId,$("#shareDataSourceModal"));
		});
		return btn;
	};

	// Gets the stop sharing button for datasource sharing
	var getStopShareButton = function(typeId,type) {
		var btn = $("<button class='btn btn-danger' id='stopShareDsButton' />");
		$(btn).text(localMsg.StopShare);
		$(btn).hide();
		var holder = $(containerId);
		$(btn).click(function() {
			stopSharing(typeId, type,holder);
		});
		return btn;
	};


	// function to return data for sharing datatable
	var getSharingData = function(typeId, type, holder, cb){
		sea.services.getDataSourceShareUsers(typeId, type, function(data) {
			var userList = JSON.parse(data.userList);
			var str="";
			if (userList) {
				var sharingList = [];
				var numUsers = userList.length;
				var nonOwnerUserExists = false;
				for	(var i = 0; i < numUsers; i++) {
					var permissions = userList[i].permission;
					str="";
					var sharingJson ={};
					var isOwner = userList[i].isOwner;
					sharingJson.userName = userList[i];
					sharingJson.capability = (isOwner ? "Owner, " : "") + userList[i].permission.join(', ');;
					if(!isOwner){
						nonOwnerUserExists = true;
                        str+='<div class="btn-group editUserPerm mr"><span class="glyphicon glyphicon-pencil cursor-pointer dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
                        str+='</span> <ul class="dropdown-menu">';
                        if(type===entityType.HANDLER)
                        {
                        	str+='<li><label class="checkbox-inline checkbox-click"><input type="checkbox" class="edit-mode mode-checkbox" disabled="disabled" checked="checked" value="'+sea.constants.Permissions.VIEW+'"> '+localMsg.View+'</label></li>';
                            str+='<li><label class="checkbox-inline checkbox-click"><input type="checkbox" class="edit-mode mode-checkbox" value="'+sea.constants.Permissions.EXECUTE+'"';
                            if(permissions.indexOf(sea.constants.Permissions.EXECUTE) !==-1)
                                str+=' checked ';
                            str+='> '+localMsg.Execute+'</label></li>';
                        }
                        else{
                        	str+='<li><label class="checkbox-inline checkbox-click"><input type="checkbox" class="edit-mode mode-checkbox" disabled="disabled" checked="checked" value="'+sea.constants.Permissions.VIEW+'"> '+localMsg.View+'</label></li>';
                        }
                        str+='<li><label class="checkbox-inline checkbox-click"><input type="checkbox" class="edit-mode mode-checkbox" value="'+sea.constants.Permissions.EDIT+'"';
                        if(permissions.indexOf(sea.constants.Permissions.EDIT) !==-1)
                            str+=' checked ';
                        str+='> '+localMsg.Edit+'</label></li>';
                        str+='<li><label class="checkbox-inline checkbox-click"><input type="checkbox" class="edit-mode mode-checkbox" value="'+sea.constants.Permissions.SHARE+'"';
                        if(permissions.indexOf(sea.constants.Permissions.SHARE) !==-1)
                            str+=' checked ';
                        str+='> '+localMsg.Share+'</label></li>';
                        str+='</ul>';
                        str+='</div>';
                        str+="<span class='glyphicon glyphicon-remove cursor-pointer removeUserPerm mr'></span>";
                    }
					sharingJson.action=str;
					sharingList.push(sharingJson);
				}
				if(nonOwnerUserExists) {
					$('#stopShareDsButton').show();
				}
				else {
					$('#stopShareDsButton').hide();
				}
				cb(sharingList);
			}
		}, null, $(holder));
	};

	// function to initialize the sharing datatable
	var onViewSharingInfo = function(coreName, typeId , type) {
		// Create toolbar with sharing options
		var idPrefix = coreName + "_sharingInfo";
		var sharingInfoContainerId = idPrefix + "_container";
		var sharingInfoTableId = idPrefix + type + "_DT";
		var holder = "#" + sharingInfoTableId;
		// options for sharing datatable
		var sharingInfoDTConfig = {
				"dom" : 'J<"pull-left"f><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">'
		};
		// if entity is Handler, then do not show the toolbar, search and limit, and put the datatable inside modal
		if(type==entityType.HANDLER){
			sharingInfoDTConfig={"bLengthChange": false,"bFilter": false};
			$("<div id='" + sharingInfoContainerId + "'></div>").appendTo("#handler-shared-users");
			onModalInit(typeId,type,$("#shareHandlerModal"));
			onHandlerModalInit(typeId,$("#shareHandlerModal"));
		}
		// for datasource, put toolbar and sharing table inside configuration
		else {
			var shareInfoToolBar = new ToolBar("#conf_wrapper", idPrefix + "_toolbar", localMsg.SharingDetails);
			shareInfoToolBar.addButton(getShareDSButton(typeId));
			shareInfoToolBar.addButton(getStopShareButton(typeId,type));
			shareInfoToolBar.addClass("extended-margin-top");
			$("<div id='" + sharingInfoContainerId + "'></div>").appendTo("#conf_wrapper");
		}
		$(uiControls.util.getDataTableHtml(sharingInfoTableId, sea.ColumnConfiguration.sharingInfoConfig)).appendTo("#" +
				sharingInfoContainerId);
		// get the sharing data
		getSharingData(typeId, type, holder, function(sharingList){
			var config = $.extend({}, sharingInfoDTConfig);
			config.data = sharingList;
			config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.sharingInfoConfig);
			sharingInfoTable = $("#" + sharingInfoTableId).DataTable(config);
			onSharingInit(typeId,type,"#"+sharingInfoTableId,"#"+sharingInfoContainerId);
		});
	};

	// this updates the sharing datatable with the latest sharing info
	var updateSharingInfo = function(typeId, type) {
		var holder = $(containerId);
		var sharingTable = this.sharingInfoTable;
		sharingTable.clear();
		getSharingData(typeId , type, holder, function(sharingList){
			sharingTable.rows.add(sharingList);
			sharingTable.draw();
		});
	};

	// Initializes the events on sharing modal show
	var onModalInit = function(typeId,type,holder) {

		$(".userSuggestions",holder).hide();

		//Share Button Click Event
		$("#shareDsButton",holder).off("click").on("click", function() {
			addSharedUser(typeId, type, holder);
		});
		var timeOutVar;
		// Key Events Listener on the User Text Field Where the user enters the Users/Groups to add
		$(".userfield",holder).off().keyup(function(event) {
			clearTimeout(timeOutVar);
			timeOutVar = setTimeout(function() {
					callKeyUpOperationForUserField(event,holder);
				}, 250);
			
		});

		$(".userfield",holder).off("input").on("input", function() {
			var value = $(this).val();
			inputFieldChange(value,holder);
		});

		// removing item selected from the suggestion list
		$(".modal-body",holder).off("click",".removeItem").on("click",".removeItem",  function() {
			$(this).parent(".inputItemUser").remove();
		});

		// Event for click on suggestion
		$(".modal-body",holder).off("click", ".suggestionsRow").on("click", ".suggestionsRow", function() {
			addNewItemBar($(this),holder);
		});

		// To hover the row the mouse is on
		$(".userSuggestionsTable",holder).off().on({
			mouseenter : function() {
				$(".hoverOnSuggestedUsersRow",holder).removeClass("hoverOnSuggestedUsersRow");
				$(this).addClass("hoverOnSuggestedUsersRow");
			},
			mouseleave : function() {
			}
		}, ".suggestionsRow");

		// click handler for permissions while selecting users to share
		$(".dropdown-menu li",holder).off("click").on("click" , function(e){
			var elm = $(this,holder).find('input:checkbox');
			ensurePermissionCoupling(type, elm, holder);
			var checkedValue = $('.modeCheckbox:checked',holder).map(function() {
				return this.value;
			}).get().join(', ');
			var shareDropdownBtn  = $(this).parents(".shareDropdown").find('.btn');
			shareDropdownBtn.html(checkedValue + ' <span class="caret"></span>').val(checkedValue);
			e.stopPropagation();
		});


	};

	// event handlers for Datasource sharing modal
	var onDataSourceModalInit = function(dsId,holder) {

		// reset the form fields on modal close
		$('#shareDataSourceModal').off('hidden.bs.modal').on('hidden.bs.modal', function(){
			onModalHidden($(this),holder);
		});

		// enable them as they might be disabled and checked if user selected Share option before.
		$('.modeCheckbox[value='+sea.constants.Permissions.EDIT+']',holder).attr('disabled', false).prop("checked", false);
	};

	// event handlers for Hanlders sharing modal
	var onHandlerModalInit = function(handlerId,holder) {
		// reset the form fields on modal close
		$('#shareHandlerModal').off('hidden.bs.modal').on('hidden.bs.modal', function(){
			onModalHidden($(this),holder);
		});
		//Stop sharing button click event - removes all permissions
		$("#stopShareDsButton",holder).off("click").on("click", function() {
			stopSharing(handlerId, entityType.HANDLER, holder);
		});

		// enable them as they might be disabled and checked if user selected Share option before.
		$('.modeCheckbox[value='+sea.constants.Permissions.EDIT+']',holder).attr('disabled', false).prop('checked', false);
		$('.modeCheckbox[value='+sea.constants.Permissions.EXECUTE+']',holder).attr('disabled', false).prop('checked', false);
	};

	// initializes the events for sharing datatable
	var onSharingInit = function(typeId,type,container,holder) {

		//Remove all permissions of a particular user
		$(container,holder).off('click', 'span.removeUserPerm').on('click', 'span.removeUserPerm', function() {
			removePermission(typeId,type, $(this).parent().parent(),holder);

		});
		// Edit the permission for the users
		$(container,holder).off('click', 'input.edit-mode').on('click', 'input.edit-mode', function() {
			var mode = $(this);
			editPermission(typeId,type, mode);
		});

	};

	// Events on hiding the sharing modal
	function onModalHidden(element,holder){
		element.find('input[type="text"],input[type="email"],textarea,select',holder).val('');
		element.find('.inputItemUser').remove();
		element.find('#handler-shared-users').empty('');
		var shareDropDown = $(".shareDropdown",holder).find('.btn');
		shareDropDown.html(defaultShareValue + ' <span class="caret"></span>');
		shareDropDown.val(defaultShareValue);
		$('.modeCheckbox:enabled',holder).prop('checked', false);
		$("#dropDownShareDiv",holder).hide();
	}

	/*
	 * Add shared user for Entity
	 */
	function addSharedUser(typeId, type, holder) {
		var userList = getUsersList(holder);
		if($(".inputTextContainer",holder).find(".inputItemUser").length>0){
			var reqObj = {};
			reqObj.userList = userList.addedUsers;
			reqObj.mode =$('.modeCheckbox:checked',holder).map(function() {
				return this.value;
			}).get().join(',');
			reqObj.operation = operations.ADD;
			if(type==entityType.HANDLER){
				reqObj.handlerId = [typeId];
				cvUtil.mask("#shareHandlerModal .modal-content");
			}
			else{
				reqObj.dsId = typeId;
				cvUtil.mask("#shareDataSourceModal .modal-content");
			}
			sea.services.addDataSourceShareUser(reqObj, function() {
				if(type==entityType.HANDLER)
				{
					$('#shareHandlerModal').modal('hide');
					cvUtil.unmask("#shareHandlerModal .modal-content");
					cvUtil.toast(localMsg.ShareHandlerSuccessMessage);
				}
				else{
					$('#shareDataSourceModal').modal('hide');
					cvUtil.unmask("#shareDataSourceModal .modal-content");
					updateSharingInfo(typeId,type);
					cvUtil.toast(localMsg.ShareDataSourceSuccessMessage);
				}
			}, function(err) {
				cvUtil.unmask("#shareDataSourceModal .modal-content");
				cvUtil.errorToast(err.errorMessage);
			});
		}
		else{
			cvUtil.errorToast(localMsg.EmptyShareInputContainer);
			cvUtil.unmask("#shareDataSourceModal .modal-content");
		}
	}

	/*
	 * Remove permission Button Click
	 */
	function removePermission(typeId,type,holder) {
		var userList = getUsersRemovalList(holder);
		var reqObj = {};
		reqObj.userList = userList.addedUsers;
		if(type==entityType.HANDLER)
			reqObj.handlerId = [typeId];
		else
			reqObj.dsId = typeId;
		reqObj.operation = operations.REMOVE;
		reqObj.mode = holder.find(".mode").text();
		sea.services.addDataSourceShareUser(reqObj, function() {
			updateSharingInfo(typeId,type);
			if(type==entityType.HANDLER){
				cvUtil.toast(localMsg.ShareHandlerRemoveMessage);
			}
			else{
				cvUtil.toast(localMsg.ShareDataSourceRemoveMessage);
			}
		}, function(err) {
			cvUtil.errorToast(err.errorMessage);
		},holder);
	}

	/*
	 * Edit permission dropdown option Click
	 */
	function editPermission(typeId, type, holder) {
		var mode = holder.val();
		var check = holder.prop('checked');
		var parentElement = holder.parents("tr");
		var userList = getUsersRemovalList(parentElement);
		var reqObj = {};
		reqObj.userList = userList.addedUsers;
		if(type==entityType.HANDLER){
			reqObj.handlerId = [typeId];
			if (mode === sea.constants.Permissions.SHARE && check)
				mode += "," + sea.constants.Permissions.VIEW + "," + sea.constants.Permissions.EDIT + "," + sea.constants.Permissions.EXECUTE;
			else if (mode !== sea.constants.Permissions.SHARE && !check)
				mode += "," + sea.constants.Permissions.SHARE;
		}
		else {
			reqObj.dsId = typeId;
			if(mode === sea.constants.Permissions.SHARE && check)
				mode += "," + sea.constants.Permissions.EDIT;
			else if (mode === sea.constants.Permissions.EDIT && !check)
				mode += "," + sea.constants.Permissions.SHARE;
		}
		if(check)
			reqObj.operation = operations.ADD;
		else
			reqObj.operation = operations.REMOVE;
		reqObj.mode = mode;
		sea.services.addDataSourceShareUser(reqObj, function() {
			updateSharingInfo(typeId,type);
		}, function(err) {
			cvUtil.errorToast(err.errorMessage);
		},parentElement);
	}

	/*
	 * Stop sharing Button Click
	 */
	function stopSharing(typeId,type,holder) {
		var addedUsers = [];
		$("td.user-sharing",holder).each(function () {
			var data = $(this).find(".user-sharing-info");
			addedUsers.push({
				"mode" : null,
				"type" : data.attr("datatype"),
				"userId" : data.attr("userId"),
				"loginName" : data.text()
			});

		});
		var reqObj = {};
		reqObj.userList = addedUsers;
		if(type==entityType.HANDLER)
			reqObj.handlerId = [typeId];
		else
			reqObj.dsId = typeId;
		reqObj.operation = operations.REMOVE;
		reqObj.mode = sea.constants.Permissions.VIEW+","+sea.constants.Permissions.EDIT+","+sea.constants.Permissions.DELETE+","+sea.constants.Permissions.EXECUTE+","+sea.constants.Permissions.SHARE;
		sea.services.addDataSourceShareUser(reqObj, function() {
			if(type==entityType.HANDLER){
				$('#shareHandlerModal').modal('hide');
				cvUtil.toast(localMsg.ShareHandlerRemoveMessage);
			}else{
				updateSharingInfo(typeId,type);
				cvUtil.toast(localMsg.ShareDataSourceRemoveMessage);
			}
		}, function(err) {
			cvUtil.errorToast(err.errorMessage);
		},holder);
	}

	/*
	 * Function to handle event of key press on Enter User name field.
	 */
	function callKeyUpOperationForUserField(event,holder) {
		var value = $(".userfield", holder).val();
		event=event||window.event;
		if (event.keyCode == 13 || event.keyCode == 186) {
			//On Enter Hit, to save.
			var hoverOnSuggestedUsersRow =$(".hoverOnSuggestedUsersRow", holder);
			if (hoverOnSuggestedUsersRow.length > 0 && $(".suggestionsRow", holder).length > 0 && $(".userSuggestions:visible", holder).length > 0) {
				addNewItemBar(hoverOnSuggestedUsersRow, holder);
			}
			if(validateEmail(value)) {
				value += ";";
				inputFieldChange(value,holder);
			}
			return;
		} else if (event.keyCode == 40) {
			//Mouse down event
			if ($(".hoverOnSuggestedUsersRow", holder).length == 0 && $(".suggestionsRow", holder).length > 0) {
				$($(".suggestionsRow", holder)[0]).addClass("hoverOnSuggestedUsersRow", holder);
			} else if ($(".hoverOnSuggestedUsersRow",holder).length != 0) {
				var item = $(".hoverOnSuggestedUsersRow", holder);
				$(".hoverOnSuggestedUsersRow", holder).removeClass("hoverOnSuggestedUsersRow");
				if (item.next() != null && item.next().hasClass("suggestionsRow"))
					item.next().addClass("hoverOnSuggestedUsersRow");
			}
			return;
		} else if (event.keyCode == 38) {
			//Mouse Up Event
			if ($(".hoverOnSuggestedUsersRow", holder).length == 0 && $(".suggestionsRow", holder).length > 0) {
				$($(".suggestionsRow",holder)[$(".suggestionsRow",holder).length - 1]).addClass("hoverOnSuggestedUsersRow");
			} else if ($(".hoverOnSuggestedUsersRow",holder).length != 0) {
				var item = $(".hoverOnSuggestedUsersRow",holder);
				$(".hoverOnSuggestedUsersRow",holder).removeClass("hoverOnSuggestedUsersRow");
				if (item.prev() != null && item.prev().hasClass("suggestionsRow"))
					item.prev().addClass("hoverOnSuggestedUsersRow");
			}
			return;
		}

		loadUserSuggestions(value, holder);
		//To make sure the next operation to clear is not fired as this takes time to complete
		if ($.trim(value) == "") {
			$(".userSuggestionsTable tbody", holder).empty();
			$(".userSuggestions", holder).hide();
			return;
		}
	}

	/*
	 * Load user drop down suggestions list
	 */
	function loadUserSuggestions(value, holder) {
		if(value)
		{	$(".progressIcon",holder).show();
			sea.services.getADUserSuggestion(value, function(returnVals) {
				setSuggestionList(returnVals, value, holder);
				$(".progressIcon",holder).hide();
			}, function() {

			});
		}
		else
			$(".progressIcon",holder).hide();
	}

	/*
	 * Set the user list that the server sent
	 */
	function setSuggestionList(returnVals, value, holder) {
		if (returnVals == null || returnVals == "") {
			$(".userSuggestions", holder).hide();
			$(".userSuggestionsTable tbody", holder).empty();
			return;
		}

		var uSuggsResult = returnVals;
		var initRequestVal = $(".userfield", holder).attr("value");
		var uSuggs =  JSON.parse(uSuggsResult.responseList);
		var htmlString = null;
		if (uSuggs === null || value != initRequestVal) {
			return;
		}
		$(".userSuggestionsTable tbody", holder).empty();

		for (var i = 0; i < uSuggs.length; i++) {
			var item = uSuggs[i];
			var uName = item.name;
			var loginName = item.loginName;
			var commonName = item.commonName;
			var userInfo = JSON.parse(item.userInfo);
			var hoverClassToAdd = "";
			if (i == 0) {
				hoverClassToAdd = "hoverOnSuggestedUsersRow";
			}

			htmlString = '<tr class="suggestionsRow ' + userInfo.userType + ' ' + hoverClassToAdd
			+ '"><td class="suggestionsData" dataType="' + userInfo.userType + '"';
			if(commonName)
				htmlString+='data-commonName="' + commonName +'"';
			htmlString += 'userId="'
			+ userInfo.userId + '" data-loginName="' + loginName + '">';
			var fullName = uName + ' (' + loginName + ')';

			htmlString += '<span class="suggestedText">'
				+ fullName.replace(new RegExp(value, 'ig'), '<span class="matchText">' + "$&" + '</span>') + '</span>';
			htmlString += '</td></tr>';
			$(".userSuggestionsTable tbody", holder).append(htmlString);
		}

		if ($(".suggestionsRow", holder).length > 0) {
			$(".userSuggestions", holder).show();
		} else {
			$(".userSuggestions", holder).hide();
		}
	}

	/*
	 * Function to get Users/Groups Info
	 */
	function getUsersList(holder) {
		var addedUsers = [];
		var list = $(".inputItemUser",holder);
		for (var i = 0; i < list.length; i++) {
			var jsonObj = {};
			var userList = $(list[i]);
			if (userList.attr("datatype") !== undefined) {
				jsonObj.type = userList.attr("datatype");
			}
			else
				jsonObj.type=null;
			if (userList.attr("groupId"))
				jsonObj.groupId = userList.attr("groupId");
			if (userList.attr("data-commonName"))
				jsonObj.commonName = userList.attr("data-commonName");
			jsonObj.loginName = userList.attr("data-loginName");
			jsonObj.userId = userList.attr("userId");
			addedUsers.push(jsonObj);
		}
		var selectedUsersList = {
				"addedUsers" : addedUsers
		};
		return selectedUsersList;
	}

	/*
	 * Function to get Users/Groups to be removed
	 */
	function getUsersRemovalList(holder) {
		var removedUsers = [];
		var data = holder.find(".user-sharing-info");
		var jsonObj = {};
		jsonObj.type = data.attr("datatype");
		jsonObj.userId = data.attr("userId");
		jsonObj.groupId = data.attr("groupId");
		jsonObj.loginName = data.text()
		removedUsers.push(jsonObj);
		var selectedUsersList = {
				"addedUsers" : removedUsers
		};
		return selectedUsersList;
	}

	/*
	 * Function to ensure view permission is selected by default if edit permission is selected in case of handlers
	 */
	var ensurePermissionCoupling = function(type, elm, holder){
		var editCheckbox=$('input[value="'+sea.constants.Permissions.EDIT+'"]',holder);
		var executeCheckbox=$('input[value="'+sea.constants.Permissions.EXECUTE+'"]',holder);
		var selectedEle = elm.val();
		var eleChecked = elm.attr("checked");

		if(selectedEle === sea.constants.Permissions.SHARE) {
			if(eleChecked){
				editCheckbox.attr('disabled', true).prop("checked", true);
				if(type == entityType.HANDLER) {
					executeCheckbox.attr('disabled', true).prop("checked", true);
				}
			}
			else {
				editCheckbox.attr('disabled', false);
				if(type == entityType.HANDLER) {
					executeCheckbox.attr('disabled', false);
				}
			}
		}
	}

	/*
	 * Function to validate email
	 */
	function validateEmail(email) {
		var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		return re.test(email);
	}

	var addNewItemBar = function(element,holder) {
		var elementData = element.find(".suggestionsData");
		var obj = {
				text: element.text(),
				dataType: elementData.attr("dataType"),
				loginName: elementData.attr("data-loginName"),
				userId: elementData.attr("userId")
		}
		var commonName = elementData.attr("data-commonName");
		if(commonName)
			obj.commonName = commonName;
		createBar(obj,holder);
	};

	var createBar = function(obj,holder) {
		var $div = $("<div>", {class: "inputItemUser"});
		var $innerSpan = $("<span>", {class: "removeItem"}).append("&times;");
		$div.attr("value", obj.text);
		$div.attr("dataType", obj.dataType);
		$div.attr("data-loginName", obj.loginName);
		$div.attr("userId", obj.userId);
		if(obj.commonName)
			$div.attr("data-commonName", obj.commonName);
		$div.append(obj.text).append($innerSpan);
		$div.insertBefore($(".inputRealContainer",holder));
		$(".userSuggestions",holder).hide();
		$(".userfield",holder).val("");
		$(".userfield",holder).focus();
		$(".inputTextContainer",holder).scrollTop($(".inputTextContainer",holder).height());
	};

	var inputFieldChange = function(value,holder) {
		if(value !== null && typeof value !== "undefined" && value.length > 0) {
			var re = new RegExp("\"", 'g');
			value = value.replace(re, '');

			if($.trim(value).substr(-1) === ">" || $.trim(value).substr(-1) === ")" ) {
				value += ";";
			}
			if(value.indexOf(";") > 0) {
				var emails = value.split(/[;]+/);
				for(var i=0; i<emails.length; i++) {
					if ($(".hoverOnSuggestedUsersRow",holder).length > 0 && $(".suggestionsRow",holder).length > 0
							&& $(".userSuggestions:visible",holder).length > 0) {
						addNewItemBar($(".hoverOnSuggestedUsersRow",holder));
						continue;
					}
					if($.trim(emails[i]) !== "") {
						var emailValue = $.trim(emails[i])
						if(emailValue.indexOf("<") >= 0 && emailValue.indexOf(">") >=1) {
							emailValue = emailValue.substring(emailValue.indexOf("<")+1, emailValue.indexOf(">"));
						}
						if(emailValue.indexOf("(") >= 0 && emailValue.indexOf(")") >=1) {
							emailValue = emailValue.substring(emailValue.indexOf("(")+1, emailValue.indexOf(")"));
						}

						var obj = {
								text: emails[i],
								dataType: "EMAIL",
								loginName:  emailValue,
						}
						createBar(obj,holder);
					}
				}
			}
		}
	};

	return {
		onViewSharingInfo: onViewSharingInfo
	};
})();