var sea = sea || {};
sea.isDebug = true;
sea.containerId = "#seaContainer";
sea.homePage = (function() {
	var handleHistoryChange = function(stateObj) {
		$(sea.containerId).empty();
		if (!$.isEmptyObject(stateObj)) {
			var coreName = stateObj[sea.constants.HistoryParams.CORE_NAME];
			var dsId = stateObj[sea.constants.HistoryParams.DS_ID];
			var dsName = stateObj[sea.constants.HistoryParams.DS_NAME];
			var viewId = stateObj[sea.constants.HistoryParams.VIEW_ID];
			sea.viewController.showSearchView(coreName, dsName, dsId, undefined, viewId);
		} else
			$(sea.containerId).html("<h4>Please specify Data source and search view information.</h4>");
	};

	var getQueryParamsObject = function() {
		var q = "";
		if (window.location.search)
			q = window.location.search.substring(1);
		return q;
	};

	var documentReadyHandler = function() {
		var reqObj = $.parseParams(getQueryParamsObject());
		handleHistoryChange(reqObj);
	};
	var onInit = function() {
		$(document).ready(documentReadyHandler);
	};

	// return only the methods that need to be exposed
	return {
		init : onInit
	};
}()); // IIFE as it is singleton and by default object has to be created

sea.homePage.init();