var sea = sea || {};

sea.restApiController = (function() {
	var containerId = sea.containerId;

	var getFieldsList = function(fieldsArr) {
		var fieldsList = [];
		if (!$.isEmptyObject(fieldsArr)) {
			$.each(fieldsArr, function(i, obj) {
				fieldsList.push(obj.fieldName);
			});
		}
		return fieldsList;
	};

	var onViewRestApiPage = function(coreName, dsName, dsId) {
		var $wrapper = $("<div id='api_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var idPrefix = coreName + "_restApiView";
		// Toolbar with submenu nav
		var restApiHeader = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		restApiHeader.attr("id", idPrefix + "_header").appendTo("#api_wrapper");
		var restApiToolBar = new ToolBar("#api_wrapper", idPrefix + "_toolbar", localMsg.RestApiTitle);
		var restApiList = cvSearchUtil.sortArrayByKey(sea.restApiConstants.restApiList, "dispOrder");
		var urlArgs = {
			"contextPath" : sea.util.getLocationOrigin() + cvUtil.CONTEXT_PATH,
			"dsId" : dsId
		};

		var onSuccessCallback = function(defaultHandler, schemaResp) {
			var fields = sea.schemaController.getDeleteableFields(schemaResp.schemaFields);
			var isMoreColumns = false;
			if (!$.isEmptyObject(fields) && fields.length > sea.restApiConstants.NO_OF_COLUMNS) {
				isMoreColumns = true;
				fields = fields.slice(0, sea.restApiConstants.NO_OF_COLUMNS);
			}
			if (defaultHandler) {
				urlArgs.handlerId = defaultHandler.handlerId;
				urlArgs.handlerName = defaultHandler.handlerName;
			}
			var fieldsList = getFieldsList(fields);
			$.each(restApiList, function(i, obj) {
				obj.url = cvFormatters.formatNamedArguments(obj.url, urlArgs);

			});

			var restApiListHtml = sea.util.getHandlebarHtml("restApiListTmpl", {
				restApiList : restApiList
			});
			$(restApiListHtml).appendTo("#api_wrapper");
			var onReqRespComboChange = function(parentName, reqFmt, respFmt) {
				var model = {};
				var reqRespObj = {
					"reqType" : reqFmt,
					"respType" : respFmt
				}
				var apiObj = cvSearchUtil.getObjectByKeyValue(restApiList, {
					name : parentName
				});
				model.isMoreColumns = isMoreColumns;
				model.type = apiObj.type;
				model.url = cvFormatters.formatNamedArguments(apiObj.url, reqRespObj);
				if (apiObj.sampleReqFn && typeof apiObj.sampleReqFn === "function") {
					model.sampleReq = apiObj.sampleReqFn.call(self, model.url, fieldsList);
				}
				if (model.type !== "GET") {
					var reqObj = cvSearchUtil.getObjectByKeyValue(apiObj.allowedReqTypes, {
						name : reqFmt
					});
					model.contentType = reqObj.contentType;
					if (reqObj.sampleReqFn && typeof reqObj.sampleReqFn === "function") {
						model.sampleReq = reqObj.sampleReqFn.call(self, fieldsList);
					}
				}

				var respObj = cvSearchUtil.getObjectByKeyValue(apiObj.allowedRespTypes, {
					name : respFmt
				});
				model.acceptHeader = respObj.acceptHeader;

				if (model.type == "GET") {
					var dataType = respObj.ajaxDataType || respObj.name
					$.ajax({
						url : model.sampleReq,
						type : "GET",
						dataType : dataType,
						success : function(resp) {
							var respStr = resp;
							if (dataType == "xml") {
								respStr = sea.util.getXmlAsString(resp);
							} else if (dataType == "json") {
								respStr = JSON.stringify(resp);
							}
							$("textarea.sampleResp", $("#" + parentName + "_restApiSnippetDiv")).val(respStr);
						},
						headers : {
							AuthToken : sea.authToken
						}
					});
					model.sampleResp = "Loading...";
				} else {
					if (respObj.sampleRespFn && typeof respObj.sampleRespFn === "function") {
						model.sampleResp = respObj.sampleRespFn.call(self);
					}
				}
				$("#" + parentName + "_restApiSnippetDiv").html($(sea.util.getHandlebarHtml("restApiItemTmpl", model)));
			};
			$("select.reqFormat").off("change").on("change", function(e) {
				var parentName = $(this).data("parentName");
				var respFmt = $("select.respFormat", $("#" + parentName + "_toolbar")).val();
				onReqRespComboChange($(this).data("parentName"), $(this).val(), respFmt);
			});
			$("select.respFormat").off("change").on("change", function(e) {
				var parentName = $(this).data("parentName");
				var reqFmt = $("select.reqFormat", $("#" + parentName + "_toolbar")).val();
				onReqRespComboChange($(this).data("parentName"), reqFmt, $(this).val());
			});
			// by default trigger change listener
			$("select.reqFormat,select.respFormat").change();
		};
		var getDefaultHandler = function() {
			var deferred = $.Deferred();
			sea.services.getDefaultHandler(dsId, function(resp) {
				var defaultHandler;
				if (resp && resp.handlerInfos && !$.isEmptyObject(resp.handlerInfos)) {
					defaultHandler = {
						handlerId : resp.handlerInfos[0].handlerId,
						handlerName : resp.handlerInfos[0].handlerName
					};
				}
				deferred.resolve(defaultHandler);
			});
			return deferred.promise();
		};
		var getSchema = function() {
			var deferred = $.Deferred();
			sea.services.getDSSchema(dsId, function(resp) {
				deferred.resolve(resp);
			}, null, $(containerId));
			return deferred.promise();
		};
		var deferreds = [ getDefaultHandler(), getSchema() ];
		$.when.apply($, deferreds).done(onSuccessCallback);
	};
	return {
		showRestApiPage : onViewRestApiPage
	};
}());
