var sea = sea || {};

sea.restApiConstants = (function() {
	var NO_OF_RECORDS = 5;
	var NO_OF_COLUMNS = 10;
	var _serviceBaseUrl = "/api/dcube/";
	var restApiList = [ {
		name : "getApi",
		dispName : _serviceBaseUrl + "handler/{handlerId}/{handlerName}",
		dispOrder : 1,
		type : "GET",
		url : "{contextPath}" + _serviceBaseUrl + "handler/{handlerId}/{handlerName}?wt={respType}",
		sampleReqFn : function(url, fields) {
			return url + "&q=*:*&rows=5&fl=" + fields.join(",");
		},
		allowedReqTypes : [],
		allowedRespTypes : [ {
			name : "xml",
			dispName : "XML",
			dispOrder : 1,
			acceptHeader : "application/xml",
			sampleResp : ""
		}, {
			name : "json",
			dispName : "JSON",
			dispOrder : 2,
			acceptHeader : "application/json",
			sampleResp : ""
		}, {
			name : "csv",
			ajaxDataType : "text",
			dispName : "CSV",
			dispOrder : 3,
			acceptHeader : "text/plain",
			sampleResp : ""
		} ]
	}, {
		name : "pushApi",
		dispName : _serviceBaseUrl + "post/{json|csv}/{dsId}",
		dispOrder : 2,
		type : "POST",
		url : "{contextPath}" + _serviceBaseUrl + "post/{reqType}/{dsId}",
		allowedReqTypes : [ {
			name : "csv",
			dispName : "CSV",
			contentType : "text/plain",
			message : "",
			sampleReqFn : function(fields) {
				var str = fields.join(",") + "\n";
				for (var i = 0; i < NO_OF_RECORDS; i++) {
					row = "";
					for (var j = 0; j < fields.length; j++) {row += "v_" + i + j + ",";}
					row = row.substring(0, row.length - 1);
					str += row + "\n";
				}
				return str;
			}
		}, {
			name : "json",
			dispName : "JSON",
			contentType : "application/json",
			message : "",
			sampleReqFn : function(fields) {
				// TODO: find out a better way
				var str = "[";
				for (var i = 0; i < NO_OF_RECORDS; i++) {
					row = "\n\t{";
					for (var j = 0; j < fields.length; j++) {row += "\n\t\t\"" + fields[j] + "\" : \"v_" + i + j + "\",";}
					row = row.substring(0, row.length - 1) + "\n\t},";
					str += row;
				}
				str = str.substring(0, str.length - 1) + "\n]";
				return str;
			}
		} ],
		allowedRespTypes : [ {
			name : "xml",
			dispName : "XML",
			acceptHeader : "application/xml",
			message : "",
			sampleRespFn : function() {
				return "<DM2ContentIndexing_Error errorCode=\"0\" />"
			}
		}, {
			name : "json",
			dispName : "JSON",
			acceptHeader : "application/json",
			message : "",
			sampleRespFn : function() {
				return "{\n\t\"DM2ContentIndexing_Error\": {\n\t\t\"@errorCode\": \"0\"\n\t}\n}";
			}
		} ]
	} ];
	function _getFederatedSearchRESTAPI(fsId, fsName) {
		return sea.util.getLocationOrigin() + cvUtil.CONTEXT_PATH + _serviceBaseUrl +
				cvFormatters.formatString("federated/{0}/{1}?wt=json", [ fsId, fsName ]);
	}
	return {
		NO_OF_COLUMNS : NO_OF_COLUMNS,
		restApiList : restApiList,
		getFederatedSearchRESTAPI : _getFederatedSearchRESTAPI
	};
})();