var sea = sea || {};

sea.lookup = (function() {

	var containerId = sea.containerId;

	// ID for the main Data Blending template
	var lookupId = "#lookupDSTemplate";
	var self = this;
	self.datasource = null;
	self.holder = null;
	self.isEdit = false;
	// supported types of entities for Lookup
	var entityType = {
		DATASOURCE : "datasource",
		HTTP : "http"
	};


	/*
	 * Show the Data Blending options, pass currentElm to append the options after that element
	 */
	var addLookupDS = function(holder, currentElm, cb) {
		$("#lookupBtnsWrapper",holder).removeClass("offLookupBtnCss").addClass("onLookupBtnCss");

		self.holder = holder;
		var dataBlendingDiv = $(lookupId).clone().removeAttr('id').show();
		dataBlendingDiv.find(".additional-lookup-info").hide();
		if (currentElm) {
			dataBlendingDiv.insertAfter(currentElm);
		} else {
			$('.data-blending-options', holder).append(dataBlendingDiv);
		}
		// on add data source link click
		$(".add-datablending-src", dataBlendingDiv).off("click").on("click", function(event) {
			addLookupDS(holder, dataBlendingDiv);
		});
		// on remove data source link click
		$(".remove-datablending-src", dataBlendingDiv).off("click").on("click", function(event) {
			$(this).parents('.lookup-ds-template').remove();
			var numDataBlending = $('.data-blending-options .lookup-ds-template', holder).length;
			if (numDataBlending == 1) {
				// hide the remove source link with the separator
				$(".remove-datablending-src", holder).hide();
			}
		});
		populateDSList(dataBlendingDiv, function() {
			// hide the remove source link with the separator
			var numDataBlending = $('.data-blending-options .lookup-ds-template', holder).length;
			if (numDataBlending > 1) {
				$(".remove-datablending-src", holder).show();
			} else {// hide the remove source link with the separator
				$(".remove-datablending-src", holder).hide();
			}
			if (cb) {
				cb(dataBlendingDiv);
			}
		});
	};

	// function to populate list of datasources
	var populateDSList = function(holder, cb) {
		var dsSelector = $(holder).find('#selectLookupDS');
		dsSelector.multiselect('destroy');
		sea.services.getDataSourcesBasicInfo(null,false,false, function(resp) {
			var data = null;
			if (resp.error) {
				data = [];
			} else {
				data = cvSearchUtil.sortArrayByKey(resp.datasources, 'dataSourceName');
				var currentDataSourceId = cvUtil.getParameterByName(sea.constants.HistoryParams.DS_ID);
				var dsSelectHtml = "";
				if(!currentDataSourceId)
					$("#sourceDSName",holder).text($("#dsName", $(containerId)).val());
				$.each(data, function(i, datasource) {
					if (datasource.dataSourceId != currentDataSourceId) {
						dsSelectHtml += "<option value='" + datasource.dataSourceId + "'>" + datasource.dataSourceName + "</option>";
					} else {
						$("#sourceDSName",holder).text(datasource.dataSourceName);
					}
				});
				dsSelector.html(dsSelectHtml).multiselect({
					enableFiltering : true,
					enableCaseInsensitiveFiltering : true,
					nonSelectedText : localMsg.SelectDataSource,
					buttonWidth : '100%',
					buttonClass : 'form-control',
					maxHeight : 200,
					templates : {
							filterClearBtn : ""
						},
					onChange : function(option, checked, select) {
						populateDSFields($(option).val(), holder)
					}
				});

				if (cb) {
					cb(true);
				}
			}
		}, null, self.holder);
	};

	var getSourceSchemaPromise = function() {
		var deferred = $.Deferred();
		var sourceDataSourceId = cvUtil.getParameterByName(sea.constants.HistoryParams.DS_ID);
		sea.services.getDSSchema(sourceDataSourceId, function(resp) {
			handleSchemaData(true,resp.schemaFields, undefined, function(columnsList, optionHtml, tableDataSet) {
				deferred.resolve(columnsList, optionHtml, tableDataSet);
			});
		});		
		return deferred.promise();
	};
	var getDestSchemaPromise = function(dataSourceId, selectedFields) {
		var deferred = $.Deferred();
		sea.services.getDSSchema(dataSourceId, function(resp) {
			handleSchemaData(false, resp.schemaFields, selectedFields, function(columnsList, optionHtml, tableDataSet) {
						deferred.resolve(columnsList, optionHtml, tableDataSet);
					});
		});
		return deferred.promise();
	};
	// function to populate fields for the selected datasource
	var populateDSFields = function(dataSourceId, holder, selectedFields, alias, cb) {
		// remove the error class if any, on selecting a DS 
		$("#selectLookupDS", holder).next().removeClass("has-error");
		$(".mapColumnsDiv", holder).remove();
		$("#btn_AddSplitByOptsOneTime", holder).show();
		holder.mask("");
		var combinedPromise = $.when(getSourceSchemaPromise(), getDestSchemaPromise(dataSourceId, selectedFields));
		combinedPromise.done(function(sourceSchemaInfo,destSchemaInfo) {
				var sourceDSColumnsList = sourceSchemaInfo[0];
				var sourceOptionHtml = sourceSchemaInfo[1];
				var sourceTableDataSet = sourceSchemaInfo[2];
				var destDSColumnsList = destSchemaInfo[0];
				var destOptionHtml = destSchemaInfo[1];
				var destTableDataSet = destSchemaInfo[2];
				holder.unmask();
				showJoinCriteria(sourceOptionHtml, destOptionHtml, holder);
				dataTableDSFields("source",sourceTableDataSet, holder);
				dataTableDSFields("dest",destTableDataSet, holder, selectedFields, alias);
				//below code is to disable selection for source datatable
				var sourceSchemaDT = $(".source-fields-table",holder);
				$("input, select",sourceSchemaDT).attr("disabled","disabled");
				if (cb) {
					cb(sourceDSColumnsList, destDSColumnsList);
				}
			});

	};

	function showJoinCriteria(sourceOptionHtml, destOptionHtml, holder) {
		$(".additional-lookup-info", holder).show();
		onAddMappingClick(sourceOptionHtml, destOptionHtml, holder, null, null, 'columnName');
		$(holder).off("click", "#btn_AddSplitByOptsOneTime").on("click", "#btn_AddSplitByOptsOneTime", function(event) {
			$(this).hide();
			onAddMappingClick(sourceOptionHtml, destOptionHtml, holder, null, null, 'columnName');
		});
	}

	// function to convert schema data into table and select html format
	function handleSchemaData(isSource ,resp, selectedFields, cb) {		
		var schemaFields, optionHtml = "", tableDataSet = [];	
		if (resp.error) {
			schemaFields = [];
		} else {
			var tableClass = isSource ? "sourceTableInputTextbox" : "destTableInputTextbox ";			
			schemaFields = sea.schemaController.getDeleteableFields(resp,undefined,true);
			if(selectedFields) {
				selectedFields = selectedFields.split(",");
				var tempFieldsArray = [];
				var tempSelectedFields = [];
				$.each(schemaFields,function(index, field) {
					$.inArray(field.fieldName,selectedFields) !== -1 ? tempSelectedFields.push(field) : tempFieldsArray.push(field);
				});
				schemaFields = tempSelectedFields.concat(tempFieldsArray);
			}
			$.each(schemaFields, function(i, field) {
				var tableData = [];
				optionHtml += '<option value="' + field.fieldName + '">' + field.fieldName + '</option>';
				tableData.push("<input type='checkbox' value='" + field.fieldName + "' " +
						(isSource ? "" : "data-schema='" + JSON.stringify(field) + "'") + "/>");
				tableData.push(field.fieldName);
				tableData.push('<input type="text" class="form-control ' + tableClass + '">');
				tableDataSet.push(tableData);
			});
		}
		cb(schemaFields, optionHtml, tableDataSet);
	}

	// function to create datatable of schema fields for selection
	// selectedFields is a comma separated sting of fields passed in edit mode
	var dataTableDSFields = function(type,data, holder, selectedFields, alias) {
		var selector = $("."+type+"-fields-table",holder);
		if(data === null) {
			$("#noSchemaMsg",holder).removeClass("display-none");
			selector.hide();
		} else {
			var tableId = 'table_data';
			var tableColumns = [];
			var tableInfoHtml = '<tbody>';
			var selectedFieldsArr = [];
			if (selectedFields) {
				selectedFieldsArr = selectedFields.split(',');
			}
			tableColumns.push({
				"title" : '<input id="'+type+'SelectAll" type="checkbox" />',
				"className" : "checkBoxWidth",
				"orderable" : false
			});
			tableColumns.push({
				"title" : localMsg.Columns
			}, {
				"title" : localMsg.Alias
			});
			var fieldTable = selector.DataTable({
				paging : true,
				pagingType : 'numbers',
				info : false,
				bSort : false,
				data : data,
				columns : tableColumns,
				createdRow : function(row, data) {
					if ($.inArray(data[1], selectedFieldsArr) !== -1) {
						$(row, selector).addClass('selected');
						$(row, selector).find('td input:checkbox').prop("checked", true);
						if (alias[data[1]]) {
							$(row, selector).find('.'+type+'TableInputTextbox').val(alias[data[1]]);
						}
					}
				},
				destroy : true
			}).draw();
			//when we will get support for source DS column selection then remove below if block
			if (type === "source") { // for source DS select all columns
				var allPages = fieldTable.rows().nodes();
				$("#"+type+"SelectAll",holder).prop("checked", true);
				$.each(allPages, function() {
						$(this).addClass('selected');
						$('input:checkbox', $(this)).prop("checked", true);
					});

			} else
				setTableEventHandlers(fieldTable,type);

		}

	};

	// Column Table event handlers for selecting all columns and individual column selection
	function setTableEventHandlers(holder,type) {
		holder.off("click", "#"+type+"SelectAll").on("click", "#"+type+"SelectAll", function() {
			// get all the rows of the table irrespective of pagination
			var allPages = holder.rows().nodes();
			if ($(this).prop("checked") == true) {
				$.each(allPages, function() {
					$(this).addClass('selected');
					$('input:checkbox', $(this)).prop("checked", true);
				});
			} else if ($(this, holder).prop("checked") == false) {
				$.each(allPages, function() {
					$(this).removeClass('selected');
					$('input:checkbox', $(this)).prop("checked", false);
				});
			}
		}).off("click", "tbody tr").on("click", "tbody tr", function() {
			if (event.target.type != "text") {
				if ($(this).hasClass('selected')) {
					$(this).removeClass('selected');
					$(this).find('td input:checkbox').prop("checked", false);
					$('#'+type+'SelectAll').prop("checked", false);
				} else {
					$(this).addClass('selected');
					$(this).find('td input:checkbox').prop("checked", true);
				}
			}
		});
	}

	//function to return the lookup data properties
	function getLookupInputData(holder) {
		var lookupData = [];
		if ($("#dsLookup", holder).is(":checked")) {
			$('.data-blending-options .lookup-ds-template', holder).each(function(i, obj) {
				var jsonObj = {};
				jsonObj.type = entityType.DATASOURCE;
				jsonObj.value = $("#selectLookupDS", obj).val();
				if (jsonObj.value) {
					var selectedTableColumns = $('.dest-fields-table', obj).DataTable().rows('.selected').nodes();
					if (selectedTableColumns.length > 0) {
						var selectedColumnsArr = [];
						var selectedAlias = {};
						var selectedSchema = {};
						$.each(selectedTableColumns, function() {
							var columnName = $(this).find("td:eq(0) input").val();
							var alias = $(this).find(".destTableInputTextbox").val();
							var schemaObj = $(this).find("td:eq(0) input").data("schema");
							selectedColumnsArr.push(columnName);
							if (alias) {
								selectedAlias[columnName] = alias;
							}
							if (schemaObj) {
								selectedSchema[columnName] = JSON.stringify(schemaObj);
							}
						});
						jsonObj.selectFields = selectedColumnsArr.join();
						jsonObj.alias = selectedAlias;
						jsonObj.schema = selectedSchema;
					} else {
						cvUtil.errorToast(localMsg.LookupColumnsMsg);
						throw new SeaException.RequiredFieldException($(".select-columns", obj));
					}
					jsonObj.primaryKeyMap = getColumnJoinOnData(obj);
					lookupData.push(jsonObj);
				} else {
					cvUtil.errorToast(localMsg.SelectDataSource);
					throw new SeaException.RequiredFieldException($("#selectLookupDS", obj).next());
				}
			});

		}
		return lookupData;
	}

	function getColumnJoinOnData(holder) {
		var getJoinData = {};
		$("#mapToDiv", holder).find(".mapColumnsDiv").each(function(idx, value) {
			var column1 = $(this).find(".sourceMapColumnName").val();
			var column2 = $(this).find(".destMapColumnName").val();
			getJoinData[column1] = column2;
			// eachRow.splitBy=$(this).find("select").find(":selected").val();
		});
		return getJoinData;
	}

	/*
	 * For adding the column mapping, module similar to splitby in DB
	 */
	function onAddMappingClick(sourceDSColumnsList, destDSColumnsList, holder, currentElm, valueToPopulate, key) {

		var mapColumnsTemplateId = "mapColumnsInputTmpl";
		var clsName = "destMapColumnName";
		var divToBeAdded = $("#" + mapColumnsTemplateId).clone().removeAttr('id').show();
		var selectCount = $("#mapToDiv > div").size() + 1;
		var colDropdownId = clsName + "_" + selectCount;
		var selectHtml = $("<select id='" + colDropdownId + "' class='form-control " + clsName + "'></select>");

		divToBeAdded.find(".dest-column-mapping-div").html(selectHtml);
		selectHtml.html(destDSColumnsList).multiselect({
			enableFiltering : true,
			enableCaseInsensitiveFiltering : true,
			buttonWidth : '100%',
			buttonClass : 'form-control',
			maxHeight : 200,
			templates : {
							filterClearBtn : ""
					}
		});
		if(sourceDSColumnsList === null) {
			selectHtml = $("<input class='sourceMapColumnName form-control input-height field_name_input' id='joinOnText'></input>");
			divToBeAdded.find(".source-column-mapping-div").html(selectHtml);
		} else {
			clsName = "sourceMapColumnName";
			colDropdownId = clsName + "_" + selectCount;
			selectHtml = $("<select id='" + colDropdownId + "' class='form-control " + clsName + "'></select>");
			divToBeAdded.find(".source-column-mapping-div").html(selectHtml);
			selectHtml.html(sourceDSColumnsList).multiselect({
				enableFiltering : true,
				enableCaseInsensitiveFiltering : true,
				buttonWidth : '100%',
				buttonClass : 'form-control',
				maxHeight : 200,
				templates : {
							filterClearBtn : ""
						}
			});
		}
		
		if (valueToPopulate) {
			selectHtml.multiselect('select', valueToPopulate.column2);
			$("option:selected",selectHtml).prependTo(selectHtml);//This code is to get all the selected columns at the top in the dropdown, On Edit handler.
			selectHtml.multiselect('rebuild');
			selectHtml = divToBeAdded.find("#destMapColumnName_"+selectCount);
			selectHtml.multiselect('select', valueToPopulate.column1);
			$("option:selected",selectHtml).prependTo(selectHtml);//This code is to get all the selected columns at the top in the dropdown, On Edit handler.
			selectHtml.multiselect('rebuild');

		}

		if (currentElm) {
			divToBeAdded.insertAfter(currentElm);
		} else {
			divToBeAdded.appendTo($("#mapToDiv", holder));
			$("#btn_AddSplitByOptsOneTime", holder).hide();
		}

		$(".addMappingBtn", divToBeAdded).off("click").on("click", function(event) {
			onAddMappingClick(sourceDSColumnsList, destDSColumnsList, holder, $(this).parent().parent(), null, key);
		});

		$(".delMappingBtn", divToBeAdded).off("click").on("click", function(event) {
			$(this).parent().parent().remove();
			if ($("#mapToDiv", holder).find(".mapColumnsDiv").length == 0) {
				$("#btn_AddSplitByOptsOneTime", holder).show();
			}
		});
	}

	// this function populates the joining on fields in the edit mode
	function populateJoinOnFields(respArray, sourceDSColumnList, destDSColumnList, holder) {
		//Removing everything other than the one time 'add' button
		$("#mapToDiv", holder).find(".mapColumnsDiv").remove();
		var sourceDSOptionHtml = "";
		var destDSOptionHtml = "";
		$.each(sourceDSColumnList, function(i, field) {
			sourceDSOptionHtml += '<option value="'+field.fieldName+'">' + field.fieldName + '</option>';
		});
		$.each(destDSColumnList, function(i, field) {
			destDSOptionHtml += '<option value="'+field.fieldName+'">' + field.fieldName + '</option>';
		});
		for ( var key in respArray) {
			var entity = {};
			entity.column1 = respArray[key];
			entity.column2 = key;
			onAddMappingClick(sourceDSOptionHtml,destDSOptionHtml, holder, null, entity, 'fieldName');
		}
	}

	function attachActionBtnListeners ($lookupBtnsHolder) {
		$("#saveLookupDetails",$lookupBtnsHolder).off("click").on("click", function (event) {
			var dsProperties =  self.datasource.properties;
			dsProperties.lookupparams = getLookupInputData(self.holder);
			var reqObj =  {
				name : self.datasource.displayName,
				type : self.datasource.dataSourceType,
				corename : self.datasource.coreId,
				engineId : self.datasource.engineId,
				dscrawl : false,
				description : self.datasource.description,
				properties : dsProperties,
				id : self.datasource.datasourceId,
				operationType : "MODIFY"
			};
			sea.services.createDataSource(reqObj,true,function() {
				cvUtil.toast(localMsg.lookupSaveSuccess);
				sea.crawlController.showCrawlPrompt(self.datasource.datasourceId,localMsg.PromptCrawlMsgForChanges);
			},function(resp, msg) {
				alert(msg);
				alert(localMsg.lookupSaveFailed);
			},self.holder);
		});
		$("#cancelLookupDetails",$lookupBtnsHolder).off("click").on("click", function (event) {
			sea.homePage.goToConfigPage();
		});
	}

	function viewLookupDetails(dsId,coreName) {
		self.isEdit = true;
		var $dataBlendingElm = (uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW + "_data_blending" , "div"))[0];
		var	$wrapper = $("<div id='lookupToolWrapper' class='wrapper_class'></div>");
		var $holder = $(containerId);
		$holder.append($wrapper);
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", sea.constants.DATA_SOURCES + "_dsName").appendTo("#lookupToolWrapper");
		//data blending toolbar
		var dataBlendingToolBar = new ToolBar("#lookupToolWrapper", "dataBlending", localMsg.DataBlending);
		$wrapper.append($dataBlendingElm);
		var $lookupBtnsHolder = $("#lookupBtnsWrapper",$wrapper);
		attachActionBtnListeners($lookupBtnsHolder);
		sea.services.getDataSource(coreName, dsId, self.isEdit , function(datasource) {
			self.datasource = datasource;
			var lookupparams = datasource.properties.lookupparams;
			if(lookupparams !== undefined)
				showSavedLookupData($.parseJSON(lookupparams),$holder);
		}, null , $holder);


	}
	/*
	 * For showing the saved lookup config in edit mode
	 */
	function showSavedLookupData(lookupparams, holder) {

		var numLookups = lookupparams.length;
		if (numLookups > 0) {
			$("#dsLookup", holder).prop('checked', true);
		} else {
			$("#dsLookup", holder).prop('checked', false);
			$("#lookupBtnsWrapper",holder).removeClass("onLookupBtnCss").addClass("offLookupBtnCss");			
		}
		for (var i = 0; i < numLookups; i++) {
			// IIFE anonymous function that is executed right after it's created
			(function(index) {
				addLookupDS(holder, null, function(holderDiv) {
					var lookupData = lookupparams[index];
					var currentDataSourceId = cvUtil.getParameterByName(sea.constants.HistoryParams.DS_ID);
					// id of selected datasource on the right side to lookup
					var value = lookupData.value;
					var selectFields = lookupData.selectFields;
					var alias = lookupData.alias;
					var primaryKeyMap = lookupData.primaryKeyMap;
					var selectDsElement = $('#selectLookupDS', holderDiv);
					selectDsElement.multiselect('select', value);
					$("option:selected",selectDsElement).prependTo(selectDsElement);//This code is to get all the selected columns at the top in the dropdown, On Edit handler.
					selectDsElement.multiselect('rebuild');
					var dsId = selectDsElement.find(":selected").val();
					populateDSFields(dsId, holderDiv, selectFields, alias, function(sourceDSColumnList, destDSColumnList) {
						populateJoinOnFields(primaryKeyMap, sourceDSColumnList, destDSColumnList, holderDiv);
					});
				});
			})(i);

		}
	}

	return {
		addLookupDS : addLookupDS,
		viewLookupDetails: viewLookupDetails
	};

})();

$(sea.containerId).on("change", "#dsLookup", function(e) {
		var holder = $("#dataBlendingWrapper",$(sea.containerId));
		// checks if the lookup checkbox is selected
		if (this.checked) {
			sea.lookup.addLookupDS(holder);
		} else {
			$(".lookup-details", holder).hide();
			$('.data-blending-options', holder).empty();
			$("#lookupBtnsWrapper",holder).removeClass("onLookupBtnCss").addClass("offLookupBtnCss");					
		}
});