function JdbcHandler() {
	this.type = sea.constants.DSTypes.JDBC;
	this.clientProperties = {isCommcellConnection:true};
	this.deletedSplitByFields = [];
}
function hideCommcellConnectionElements(holder) {
	$("#connectionRadioBtnPanel",holder).hide();
	$("#otherConnectionPanel",holder).show();
	$("#commcellConnectionPanel",holder).hide();
	$("#otherConnection",holder).prop("checked", true);

}
JdbcHandler.prototype.initializeStep = function(step, holder, isEdit) {
	switch (step) {
	case 2:
		if (!isEdit && this.clientProperties.isCommcellConnection == true) {
			sea.services.getCommcells(null, function(resp) {
					$("#connectionRadioBtnPanel",holder).show();
					$("#commcellConnection",holder).prop("checked", true);
					$("#otherConnectionPanel",holder).hide();
					$("#commcellConnectionPanel",holder).show();
					populateCommcellCombo($("#commCellsCombo",holder), resp.commcellList);
				}, function(resp) {
					hideCommcellConnectionElements(holder);
			});
		}
		break;
	case 3:
		var $select = $("#dsTableViewListCombo", holder);
		var TableViewVariable = "Table";
		if (!isEdit)
			this.populateTableComboAndInitAutocompleteAndTextcomplete(this.clientProperties.collections, holder);
		if (this.properties.isDBView != undefined) {

			if (this.properties.isDBView == true || this.properties.isDBView === "true") {
				TableViewVariable = "View";
			}
			$select.multiselect('select', this.properties.tablename);
			$("#dsSqlStmt", holder).val(this.properties.sql_select_statement);
		}
		else
			$("#dsTableViewListCombo",holder).change();
	
		$("#dsTableViewCombo", holder).val(TableViewVariable);
		$("#jdbcPreviewTable_wrapper", holder).remove();
		break;
	case 4:
		if(this.deletedSplitByFields !== undefined && this.deletedSplitByFields.length > 0) {
			var args = [this.deletedSplitByFields.join()];
			var msg = cvFormatters.formatString(localMsg.DeletedSplitByFields, args);
			cvUtil.toast(msg);
		}
	}
	

};

/*
 * userInput - Input of the user in the current step aggregatedInput - All inputs so far.
 * 
 * We really do not need userInput nor aggregatedInput in the below function because we store the properties
 * in the 'this' variable. However, cvWizard passes userInput and aggregatedInput to the validator function so
 * that the wizard can be used with code that does not maintain state on its own.
 */
JdbcHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, isPreview) {

	var self = this;
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);

		} else {
			callback(true);
		}
		break;
	case 2:
		var isDBView = false;
		if (this.properties.isDBView != undefined) {

			if (this.properties.isDBView == true || this.properties.isDBView === "true") {
				isDBView = true;
			}

		}
		reqObj = {
			type : sea.constants.DSTypes.JDBC,
			coreName : "",
			engineId : parseInt(this.dsEngine),
			properties : {
				isFlatQuery : false
			},
			isDBView : isDBView,
			operationType : "CREATE"
		};
		if (self.clientProperties.isCommcellConnection !== true) {
			reqObj.properties = $.extend(true, reqObj.properties, {
				url : this.properties.url,
				driver : this.properties.driver,
				username : this.properties.username,
				password : this.properties.password,
				commcellId : 0
			});
		} else {
			reqObj.properties = $.extend(true, reqObj.properties, {
				commcellId : this.properties.commcellId
			});

		}
		sea.services.getMetaInfo(reqObj, function(resp) {
			self.clientProperties.collections = resp.schemaInfo.tablesInfo;
			
			callback(true);
		}, function(resp) {
			cvUtil.errorToast(resp.error.errLogMessage);
			callback(false);
		}, holder);
		break;

	case 3:
		var rows = 1;
		if (isPreview == true) {
			rows = 5;
		}
		reqObj = {
			type : sea.constants.DSTypes.JDBC,
			engineId : parseInt(self.dsEngine),
			properties : {
				isFlatQuery : true,
				requestType : $("#dsTableViewCombo", holder).val() === "Table" ? "fetchDBTables" : "fetchDBViews",
				schemaInfo : null,
				queryInfo : {
					query : $("#dsSqlStmt", holder).val(),
					outputInfos : {
						rowsCnt : rows
					}
				}
			},
			operationType : sea.constants.Operations.CREATE
		};
		if (self.clientProperties.isCommcellConnection === true) {
			reqObj.properties = $.extend(true, reqObj.properties, {
				commcellId : self.properties.commcellId
			});
		} else {
			reqObj.properties = $.extend(true, reqObj.properties, {
				url : self.properties.url,
				driver : self.properties.driver,
				username : self.properties.username,
				password : self.properties.password,
				commcellId : 0
			});

		}

		sea.services.getMetaInfo(reqObj, function(resp, data) {
			if (isPreview == true) {
				callback(true, resp, data);
			} else {
				self.clientProperties.dsSqlColumns = resp.queryInfo.columnNames;
				callback(true);
			}
		}, function(resp, msg) {
			alert(msg);
		}, holder);

		break;
	case 4:
		callback(true);
		break;
	

	}
};

JdbcHandler.prototype.submit = function(isEdit, dsObj, holder) {
	var checkConditions = true;
	var self = this;

	//Server error occurs if these unwanted properties are present in the request
	//It's easier to delete 4 properties than create a new object and copy ALL other properties except these one by one

	if (!isEdit) {
		this.create(null, holder);
	} else {
		if (dsObj) {
			checkConditions = checkForPrimaryKeyChange(dsObj.properties.primary_key,
				this.properties.primary_key,
				dsObj.datasourceId,
				holder,
				function() {
					self.update(null, dsObj, holder);
				}
			);
		}
	}
};

JdbcHandler.prototype.fetch = function(step, holder) {
	var fetchedData = null;
	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		if (!$("#commcellConnection", holder).is(':checked')) {
			fetchedData = {
				properties : {
					driver : $("#dsDriverType", holder).val(),
					url : $("#dsUrl", holder).val(),
					username : $("#dsUserName").val(),
					password : Base64.encode($("#dsPassword").val()),
					commcellId : 0

				}
			};
			this.clientProperties.isCommcellConnection = false;
		} else {
			if (this.properties != undefined) {
				delete this.properties.driver;
				delete this.properties.url;
				delete this.properties.username;
				delete this.properties.password;
			}
			fetchedData = {
				properties : {
					commcellId : $("#commCellsCombo", holder).val()
				}
			};
			this.clientProperties.isCommcellConnection = true;
		}

		break;
	case 3:
		fetchedData = {
			properties : {
				sql_select_statement : $("#dsSqlStmt", holder).val(),
				tablename : $("#dsTableViewListCombo", holder).val(),
				isDBView : $("#dsTableViewCombo", holder).val() === "Table" ? false : true
			}
		};
		break;
	case 4:
		var columnSplitByData = getColumnSplitByData(holder);
		var deltaQueryData = getDeltaQueryData(holder);
		fetchedData = {
			properties : {
				root_entity_fields : columnSplitByData,
				always_incremental : $("#dsDeltaCrawl", holder).is(":checked"),
				delta_sql_query : deltaQueryData.sqlQuery,
				primary_key : deltaQueryData.primaryKey,
				delta_import_sql_query : deltaQueryData.importSqlQuery
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}
	this.updateProperties(fetchedData);
	return fetchedData;
};
JdbcHandler.prototype.populateTableComboAndInitAutocompleteAndTextcomplete = function(tableInfo, holder) {
	var $select = $("#dsTableViewListCombo", holder);
	this.populateTableCombo($select, tableInfo);
	this.initMultiSelect($select);
	var tables = this.getTableListForTextComplete(tableInfo);
	this.initTextComplete($("#dsSqlStmt", holder), tables);
}

JdbcHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	var coreName = this.coreName;
	var self = this;
	self.dsEngine = this.engineId;
	// Get the list of jdbc drivers
	self.populateDriversCombo(holder, coreName, this.type, function(data) {
		fnCallBack({
			"callBack" : true
		});
	});
	//Getting the list of commcells and caching it in session storage, we are doing it in initialisation itself cz
	//If we do it on next button click of first step then jummping effect will be there for hiding/showing commcell connection elements.
	sea.services.getCommcells(null, function(resp) {}, function(resp) {			
		}, holder);
	holder.off("click", "#commcellConnection").on("click", "#commcellConnection", function(event) {
		$("#otherConnectionPanel", holder).hide();
		$("#commcellConnectionPanel", holder).show();
		sea.services.getCommcells(null, function(resp) {
			populateCommcellCombo($("#commCellsCombo", holder), resp.commcellList);
			if (isEdit == true && self.properties.commcellId != undefined && self.properties.commcellId != 0) {
				$("#commCellsCombo", holder).val(self.properties.commcellId);
			}
		}, function(resp) {
			if (isEdit == true) {
				cvUtil.errorToast(resp.error.errLogMessage);
				$("#connectionRadioBtnPanel", holder).hide();
				$("#otherConnectionPanel", holder).show();
				$("#commcellConnectionPanel", holder).hide();
				$("#otherConnection", holder).prop("checked", true);
			}
		}, holder);
	});

	holder.off("click", "#otherConnection").on("click", "#otherConnection", function(event) {
		$("#commcellConnectionPanel", holder).hide();

		$("#otherConnectionPanel", holder).show();

	});
	holder.off("click", "#sql-preview-btn").on("click", "#sql-preview-btn", function(event) {
		self.fetch(3, holder);
		self.validateStep(3, holder, null, function(valid, resp, data) {
			if (valid === true) {
				var rows = !$.isEmptyObject(resp.queryInfo.outputInfos) ? resp.queryInfo.outputInfos.rows : [];
				var jdbcConfig = [];
				var tableId = "jdbcPreviewTable";
				var sqlColumns = resp.queryInfo.columnNames;
				for (var i = 0; i < sqlColumns.length; i++) {
					jdbcConfig.push({
						fieldName : "row." + i,
						dispName : sqlColumns[i].columnName,
						renderer : function(data, type, row, meta) {
							return SearchResultsView.prototype.getCellDisplayValue(data);
						}
					});
				}
				$("#jdbcPreviewTable_wrapper", holder).remove();
				$(uiControls.util.getDataTableHtml(tableId, jdbcConfig)).appendTo("#dsSqlPreview");

				$("#" + tableId).addClass("table-data-ellipsis");
				var tableElm = $("#" + tableId, holder);
				var config = {
					dom : 'Jt',
					data : rows,
					scrollX : true,
					autoWidth : true
				}
				config.columns = sea.ColumnConfiguration.getConfigInDTFormat(jdbcConfig);
				tableElm.off("column-sizing.dt").on("column-sizing.dt", uiControls.util.getDTResizeHandler(tableId));
				tableElm.DataTable(config);
			}
		}, null, true);

	});
	holder.off("change", "#dsTableViewCombo").on("change", "#dsTableViewCombo", function(event) {
		reqObj = {
			type : sea.constants.DSTypes.JDBC,
			engineId : parseInt(self.dsEngine),
			properties : {
				requestType : $("#dsTableViewCombo", holder).val() === "Table" ? "fetchDBTables" : "fetchDBViews",
				isFlatQuery : false,
			},
			operationType : "CREATE"
		};
		if (self.clientProperties.isCommcellConnection !== true) {
			reqObj.properties = $.extend(true, reqObj.properties, {
				url : self.properties.url,
				driver : self.properties.driver,
				username : self.properties.username,
				password : self.properties.password,
				commcellId : 0
			});
		} else {
			reqObj.properties = $.extend(true, reqObj.properties, {
				commcellId : self.properties.commcellId
			});

		}
		sea.services.getMetaInfo(reqObj, function(resp) {
			var $select = $("#dsTableViewListCombo", holder);
			self.populateTableComboAndInitAutocompleteAndTextcomplete(resp.schemaInfo.tablesInfo, holder);
			if (isEdit == true ) {
				$select.multiselect('select', self.properties.tablename);
			}

		}, function(resp) {
			cvUtil.errorToast(resp.error.errLogMessage);
		}, holder);

	});
	holder.off("change", "#dsTableViewListCombo").on("change", "#dsTableViewListCombo", function(event) {
		var selectedTable = $("#dsTableViewListCombo", holder).val();
		var selectQuery = $("#dsSqlStmt", holder).val();
		var pattern = new RegExp('^(\\s*(select)*\\s*\\**\\s*(from)*\\s*[\\w\\.]*)$', 'gi');
		if (selectedTable !== "" &&(selectQuery === "" || selectQuery.match(pattern) !== null)) {
			$("#dsSqlStmt", holder).val("select * from " + selectedTable);
		}

	});

	holder.off("click", "#btn_AddSplitByOptsOneTime").on("click", "#btn_AddSplitByOptsOneTime", function(event) {
		$(this).hide();
		onAddSplitByBtnClick(self.clientProperties.dsSqlColumns, holder, null, null, true, 'columnName');
	});

	holder.off("change", "#dsEngine").on("change", "#dsEngine", function() {

		self.engineId = $(this).val();
		self.populateDriversCombo(holder, coreName, self.type, function(data) {
		});
	});
};
JdbcHandler.prototype.getTableListForTextComplete = function(tablesInfo) {
	var tablesList = $.map(tablesInfo, function(v) {
		return v["tableName"];

	});
	return tablesList;
};

JdbcHandler.prototype.initTextComplete = function($textElm, tableList) {
	$textElm.textcomplete([ {
		match : /[\w.]+$/,
		splitOn: ',',
		index : 0,
		search : function(term, callback) {
			// columnList is populated through possibleValues() function
			// in defaultRequiredParams{}. See the entry for 'fl' in
			// defaultRequiredParams
			callback($.map(tableList, function(word) {
				return word.toLowerCase().indexOf(term.toLowerCase()) === 0 ? word : null;
			}));
		},
		replace : function(word) {
			return word;
		}
	} ]);
};
JdbcHandler.prototype.setCommcellName = function(commcellId, holder) {
	var commcellName;
	sea.services.getCommcells(null, function(data) {
		$.each(data.commcellList, function(itr, value) {
			if (commcellId == value.id) {

				$("#dsCommcell", holder).text(value.aliasName);
			}
		});
	}, null, holder);

};

JdbcHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	var isAdvanced = false, self = this;
	try {
		if (onEdit) {
			if (props.commcellId != undefined && props.commcellId != 0) {
				$("#connectionRadioBtnPanel",holder).show();
				this.clientProperties.isCommcellConnection = true;
				$("#commcellConnection", holder).prop("checked", true).trigger("click");

			} else {
				this.clientProperties.isCommcellConnection = false;
				sea.services.getCommcells(null, function(resp) {
					$("#connectionRadioBtnPanel",holder).show();
					$("#otherConnection", holder).prop("checked", true).trigger("click");
				}, function(resp) {
					hideCommcellConnectionElements(holder);
					
				});

				$("#dsUrl", holder).val(props.url);
				$("#dsUserName", holder).val(props.username);
				$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));

				this.populateDriversCombo(holder, this.coreName, this.type, function() {
					$("#dsDriverType", holder).val(props.driver).change();
				});
			}

			$("#dsSqlStmt", holder).val(props.sql_select_statement);

			if (props.isDBView == true) {
				$("#dsTableViewCombo", holder).val("View").change();
			} else {
				$("#dsTableViewCombo", holder).val("Table").change();
			}

			if (props.root_entity_fields && props.root_entity_fields.length > 0) {
				self.populateSplitFields(this.datasourceId, props.root_entity_fields, holder);
				isAdvanced = true;
			}

			if (props.always_incremental) {
				isAdvanced = true;
			}
			$("#dsDeltaCrawl", holder).attr("checked", props.always_incremental);
			$("#dsDeltaPrimaryKey", holder).val(props.primary_key);
			$("#dsDeltaSqlStmt", holder).val(props.delta_sql_query);
			$("#dsDeltaImportSqlStmt", holder).val(props.delta_import_sql_query);
			if (isAdvanced) {
				$("#dbAdvanceOptionsPanel", holder).collapse('show');
			}
		} else {
			if (props.commcellId != undefined && props.commcellId != 0) {
				$("#dsUserPassDiv", holder).hide();
				$("#dsUrlDiv", holder).hide();
				$("#dsCommcellDiv", holder).show();
				this.setCommcellName(props.commcellId, holder);
			} else {
				$("#dsUserPassDiv", holder).show();
				$("#dsUrlDiv", holder).show();
				$("#dsCommcellDiv", holder).hide();
				$("#dsUserPass", holder).text(props.username);
				$("#dsUrl", holder).text(props.url);
			}
			$("#dsSqlStmt", holder).text(props.sql_select_statement);
		}
	} catch (e) {
		console.error(e);
	}
};
JdbcHandler.prototype.initMultiSelect = function($select) {
	if ($.isEmptyObject($select.data('multiselect'))) {
		$select
				.multiselect({
					onDropdownHide : function() {
						//To clear previous search
						$("input.multiselect-search").val("").trigger("keydown");

					},
					maxHeight : 300,
					enableFiltering : true,
					enableCaseInsensitiveFiltering : true,
					templates : {
						filterClearBtn : "",
						button : '<button type="button" class="multiselect dropdown-toggle btn btn-default form-control" data-toggle="dropdown" title="None selected">'
								+ '<span class="multiselect-selected-text"></span><div class="pull-right"><b class="caret"></b></div></button>'
					}
				});
	} else {
		$select.multiselect('rebuild');
	}

};
JdbcHandler.prototype.populateTableCombo = function(comboObj, tablesList) {
	if (typeof comboObj === 'undefined' || comboObj == null) {
		return;
	}
	comboObj.empty();
	var optHtml = "<option disabled='disabled' selected='selected' data-selectoption='true'>" + localMsg.Select + "</option>";
	comboObj.append(optHtml);
	$.each(tablesList, function(i, v) {
		var optHtml = "<option value=\"" + v["tableName"] + "\">" + v["tableName"] + "</option>";
		comboObj.append(optHtml);

	});

};
function populateCommcellCombo(comboObj, commcellList) {
	if (typeof comboObj === 'undefined' || comboObj == null) {
		return;
	}
	comboObj.empty();
	$.each(commcellList, function(i, v) {
		var optHtml = "<option value=\"" + v["id"] + "\">" + v["aliasName"] + "</option>";
		comboObj.append(optHtml);

	});
};

JdbcHandler.prototype.populateDriversCombo = function(holder, coreName, dsType, successCallBack) {

	// Get the list of jdbc drivers
	var populateCombo = function(typesList, comboObj) {
		if (typeof comboObj === 'undefined' || comboObj == null) {
			return;
		}
		comboObj.empty();
		$.each(typesList, function(i, v) {
			var flag = dsType != null && (dsType === sea.constants.DSTypes.JDBC ? true : v.indexOf(dsType) > -1);
			if (flag) {
				var optHtml = "<option value=\"" + v + "\">" + v + "</option>";
				comboObj.append(optHtml);
			}
		});
	};
	if (this.engineId == null) {
		return;
	}
	sea.services.getDBDrivers(this.engineId, coreName, function(data) {
		var typesList = cvUtil.parseJSON(data);
		if (!$.isEmptyObject(typesList)) {
			populateCombo(typesList, $("#dsDriverType", holder));

			$("#dsDriverType", holder).off("change").on("change", function() {
				$(".sampleDBUrl").hide();
				if ($(this).val()) {
					var spanId = $(this).val().replace(/\./g, "_");
					$(".sampleDBUrl#" + spanId).show();
				}
			});
			$("#dsDriverType", holder).trigger("change");
		}
		successCallBack(data);
	});
}

/*
 * holder - parent table currentElm - element after which the new controls have to be inserted; if null, it
 * will get appended valueToPoupate - values for populating the input controls for edit; null in case of
 * creation key - the key which will be passsed to poulateColumnCombo.
 */
function onAddSplitByBtnClick(columnsList, holder, currentElm, valueToPopulate, isEdit, key) {
	//during creation of datasource, split by will be text box as we are not aware of fields
	//in case of edit, it will be combo
	var templClass = "splitColumnsInputDivTmpl";
	if (isEdit) {
		templClass = "splitColumnsInputDivTmplEdit";
	}
	var clsName = "splitByColumnName";

	var divToBeAdded = $("." + templClass).clone().removeClass(templClass).show();

	if (isEdit) {
		var colDropdownId = clsName + "_" + ($("#splitByDiv > div").size() + 1);
		var selectHtml = $("<select id='" + colDropdownId + "' class='form-control " + clsName + "'></select>");
		selectHtml.insertBefore(divToBeAdded.find(".splitByCharLabel"));
		populateColumnCombo(columnsList, selectHtml, key);
		if (valueToPopulate) {
			divToBeAdded.find(".splitByChar").val(valueToPopulate.splitBy);
			selectHtml.val(valueToPopulate.column);
		}
	}

	if (currentElm) {
		divToBeAdded.insertAfter(currentElm);
	} else {
		divToBeAdded.appendTo($("#splitByDiv", holder));
		$("#btn_AddSplitByOptsOneTime").hide();
	}

	$(".addSplitByBtn", divToBeAdded).off("click").on("click", function(event) {
		onAddSplitByBtnClick(columnsList, holder, $(this).parent().parent(), null, isEdit, key);
	});

	$("select.splitByColumnName", divToBeAdded).off("click").on("change", function() {
		removeDuplicatesFromSplitByDropdown(holder, ".splitByColumnName");
	});

	$(".delSplitByBtn", divToBeAdded).off("click").on("click", function(event) {
		$(this).parent().parent().remove();
		if ($("#splitByDiv", holder).find(".splitColumnsInputDiv").length == 0) {
			$("#btn_AddSplitByOptsOneTime").show();
		}
	});
}

/*
 * The key in which column name is stored inside columnList. getMetaInfo() returns key value pairs as
 * 'columnName': 'name' while sea.services.getSchema() returns as 'fieldName': 'name'. Easier to change
 * populateColumnCombo to accept a generic key than to change the server response.
 */
var populateColumnCombo = function(columnsList, comboObj, key) {
	if (typeof comboObj === 'undefined' || comboObj == null) {
		return;
	}

	var selected = {};
	$(".splitByColumnName option:selected").each(function() {
		var val = $(this).val();
		if (val !== undefined) {
			selected[val] = 1;
		}
	});
	columnsList.sort(function(a, b) {
		var nameA = a[key].toLowerCase(), nameB = b[key].toLowerCase()
		if (nameA < nameB) {
			return -1

		}
		if (nameA > nameB) {
			return 1

		}
		return 0 //default return value (no sorting)
	});
	comboObj.empty();
	$.each(columnsList, function(i, v) {
		var optHtml = $("<option value=\"" + v[key] + "\">" + v[key] + "</option>");
		if (selected[v[key]] == 1) {
			optHtml.prop('disabled', true);
		}
		comboObj.append(optHtml);
	});
};

var removeDuplicatesFromSplitByDropdown = function(holder, selector) {
	var selected = {};
	$(selector + " option:selected", holder).each(function() {
		var val = $(this).val();
		if (val !== undefined) {
			selected[val] = 1;
		}
	});

	$(selector + " option", holder).each(function() {
		var val = $(this).val();
		if (!$(this).is(':selected')) {
			if (selected[val] == 1) {
				$(this).prop('disabled', true);
			} else {
				$(this).prop('disabled', false);
			}
		}
	});
};

function getColumnSplitByData(holder) {
	var reqArray = [];
	$("#splitByDiv", holder).find(".splitColumnsInputDiv").each(function(idx, value) {
		var eachRow = {};
		eachRow.column = $(this).find(".splitByColumnName").val();
		// eachRow.splitBy=$(this).find("select").find(":selected").val();
		eachRow.splitBy = $.trim($(this).find(".splitByChar").val());
		if (eachRow.splitBy) {
			eachRow.splitBy = eachRow.splitBy;
			reqArray.push(eachRow);
		}
	});
	return reqArray;
}

function getDeltaQueryData(holder) {
	var deltaQueryData = {};
	deltaQueryData.primaryKey = $("#dsDeltaPrimaryKey", holder).val();
	deltaQueryData.sqlQuery = $("#dsDeltaSqlStmt", holder).val();
	deltaQueryData.importSqlQuery = $("#dsDeltaImportSqlStmt", holder).val();
	return deltaQueryData;
}

JdbcHandler.prototype.populateSplitFields = function(dsId, respArray, holder) {
	var len = respArray.length, self = this;
	self.deletedSplitByFields = [];
	if (len > 0) {
		sea.services.getDSSchema(dsId, function(response) {
			//Removing everything other than the one time 'add' button
			$("#splitByDiv", holder).find(".splitColumnsInputDiv").remove();
			var columnList = sea.schemaController.getDeleteableFields(response.schemaFields, false);
			var fieldNames = $.map(columnList, function(obj) {
				return obj.fieldName
			});


			for (var i = 0; i < len; i++) {
				var entity = respArray[i];
				if(fieldNames.includes(entity.column)) {
					onAddSplitByBtnClick(columnList, holder, null, entity, true, 'fieldName');
				} else {
					self.deletedSplitByFields.push(entity.column);
				}
			}
		});
	}
};

function checkForPrimaryKeyChange(oldKey, newKey, dsId, holder, callback) {
	var flag = true;
	if ((oldKey == null && newKey != "") || (oldKey != null && oldKey != newKey)) {
		flag = false;
		var jobId = 0;
		sea.services.getCrawlStatus(dsId, jobId, function(res) {
			if (res && res.status && res.status.totalcount > 0) {
				sea.dsController.deleteCrawledData(dsId, null, function(resp) {
					if (resp) {
						callback();
					}
				});
			} else {
				callback();
			}
		}, function(err) {
			console.log(err);
		}, holder);
	} else {
		callback();
	}
	return flag;
}
