function HttpHandler() {
	this.type = sea.constants.DSTypes.HTTP;
	this.schemaFields = [];
	this.metaData = null;
	this.previewTable = null;
	this.loopingBasis = null;
	this.selectedFieldTable = null;
	// applicable only on edit
	this.selectedFields = null;
	this.selectedFieldsHash = {};
	this.primaryKeySelected = null;
	this.callbackUrl = sea.util.getLocationOrigin() + cvUtil.getContextPath() + "/authcallback.do";
	this.authResponseProps = {};
	this.authInputs = {};
}

HttpHandler.prototype.constants = {
	paginationType : {
		PAGE : "Page",
		OFFSET : "Offset"
	},
	loopType : {
		COUNT : "Count",
		INLINE_COUNT : "InlineCount"
	}
};
HttpHandler.prototype.populateFieldsTypesCombo = function(comboObj) {
	comboObj.empty();
	$.each(sea.constants.schemaAllowedDataTypes, function(itr, value) {
		comboObj.append("<option value=\"" + value.fieldName + "\">" + value.dispName + "</option>");
	});

};
HttpHandler.prototype.initializeStep = function(step, holder, isEdit) {
	var previewJsonData = null;
	var $tableData = null;
	var metaDataMap = null;
	var self = this;
	switch (step) {
	case 2:
		$("#dsUrl", holder).tooltip({
			title : 'The response should be in json format',
			container : 'body'
		});

		if (isEdit) {
			if ($("#dsReqType", holder).val() === "POST") {
				$("#dsPayload", holder).parents(".form-group").show();
			}
		}
		break;
	case 3:
		previewJsonData = this.getPreviewData();
		//because datatables expect data as an array
		if (!$.isArray(previewJsonData)) {
			previewJsonData = [ previewJsonData ];
		}

		// #table_data is inserted in httpdstemplate.jsp
		$tableData = $("#table_data", holder);
		if ($.fn.dataTable.isDataTable($tableData)) {
			$tableData.DataTable().destroy();
		}
		$tableData.empty();
		this.previewTable = $tableData.DataTable({
			data : previewJsonData,
			dom : "t",
			ordering : false,
			columns : $.fn.dataTable.cvVisualizer.cvGetColumnsFromData(previewJsonData),
			metaData : this.metaData,
			selectedFields : this.selectedFields,
			selectedSplits : this.selectedSplits
		});

		this.previewTable.cvVisualizer();
		break;
	case 4:

		var row_data = $.map(self.selectedFieldsHash, function(val, itr) {
			var schemaTypeObj = sea.constants.schemaAllowedDataTypes[val.dataType];
			return [ [ val.fieldName, schemaTypeObj !== undefined ? schemaTypeObj.dispName : val.dataType, itr ] ];
		});

		$fieldInfoTable = $("#field_info_table", holder);
		if ($.fn.dataTable.isDataTable($fieldInfoTable)) {
			$fieldInfoTable.DataTable().destroy();
		}
		this.selectedFieldTable = $fieldInfoTable
				.DataTable({
					dom : '<"pull-left"f>rt<"data-table-info-pagination-wrapper"<"pull-left"i><"pull-right"p>>',
					data : row_data,
					columns : [
							{
								title : localMsg.FieldName,
								className : "field-name-td",
								render : function(data) {

									return "<div data-userinput='true' class='form-group field-name-div'><a class='field-name' data-value='" +
											data + "'>" + data + "</a></div>";
								}
							},
							{
								title : localMsg.FieldType,
								render : function(data) {
									return "<a class='field-type' data-value='" + data + "'>" + data + "</a>";
								}
							},
							{
								title : localMsg.JSONPath,
								className : "json-path",
								render : function(data) {
									return "<div class='json-path-value'>" + data + "</div>";
								}
							},

					]

				});
		$fieldInfoTable.off("focusout", "input.field_name_input").on("focusout", "input.field_name_input", function() {
			var jsonPath = $(this).parent().parent().siblings(".json-path").find(".json-path-value").html();
			if ($(this).val() !== "") {
				var fieldName = $(this).val().trim();
				if (fieldName.match(/^\d.*$/g)) {
					fieldName = "a_" + fieldName;
				}
				if (fieldName.startsWith("_")) {
					fieldName = "a" + fieldName;
				}
				self.selectedFieldsHash[jsonPath].fieldName = fieldName;
			}

		});
		$fieldInfoTable.off("change", "select.field_type_combo").on("change", "select.field_type_combo", function() {
			var jsonPath = $(this).parent().siblings(".json-path").find(".json-path-value").html();
			self.selectedFieldsHash[jsonPath].dataType = $("option:selected", $(this)).val();

		});
		$fieldInfoTable
				.off("click", "a.field-name")
				.on("click",
						"a.field-name",
						function() {
							var $parent = $(this).parent();
							var data = $(this).data("value");
							//$parent.data("value", data);

							$input = $("<input type='text' class='field_name_input form-control' data-required='true' data-validate='true' data-validationtype='regex' data-regex='^[\\w\\-]+$' data-regex-msg='Field name cannot have special characters.'>");
							$input.val(data);
							$(this).hide();
							$parent.append($input);
							$input.focus();
						});

		$fieldInfoTable.off("click", "a.field-type").on("click", "a.field-type", function() {
			var $parent = $(this).parent();
			var data = $(this).data("value");
			var $select = $("<select class='field_type_combo form-control'></select>");
			//saving the data to the parent so that we can get it from the parent on resetting.
			//$parent.data("value", data);
			$(this).hide();
			$parent.append($select);
			self.populateFieldsTypesCombo($select);
			$select.focus();

		});

		break;
	case 5:
		var $pathListHolder = $("#dsPaginateTotalLoopValueRecords", holder);
		metaDataMap = this.previewTable.getMetaDataMap();
		for ( var jsonPath in metaDataMap) {
			if (metaDataMap.hasOwnProperty(jsonPath)) {
				$pathListHolder.append("<option value='" + jsonPath + "'>" + jsonPath + "</jsonPath>");
			}
		}

		/*
		 * The below code is not in populateDSSpecificProperties() because they can be populated only after
		 * the preview step - preview step is needed to populate the jsonpath dropdown
		 */
		if (isEdit) {
			if (this.properties.totalLoopType === this.constants.loopType.COUNT) {
				$("#dsPaginateTotalLoopValueIteration", holder).val(this.properties.totalLoopValue);
				$("input[name='dsPaginateLoopBasis'][value='iteration']", holder).attr("checked", "checked");
			} else if (this.properties.totalLoopType === this.constants.loopType.INLINE_COUNT) {
				$("input[name='dsPaginateLoopBasis'][value='record']", holder).attr("checked", "checked")
						.trigger("click");
				$("#dsPaginateTotalLoopValueRecords", holder).val(this.properties.totalLoopValue);
			}
		}
		break;
	case 6:
		var $select = $("#primaryKey", holder);
		if (typeof $select !== 'undefined' && $select !== null) {
			var selectedField = $select.val();
			$select.empty();
			var optionHtml = "<option value=\"None\">None</option>";
			$select.append(optionHtml);
			$.each(self.selectedFieldsHash, function(key, value) {
				optionHtml = "<option value=\"" + value.fieldName + "\">" + value.fieldName + "</option>";
				$select.append(optionHtml);
			});
			if (selectedField !== undefined && selectedField !== "") {
				$select.val(selectedField);
			} else if (self.primaryKeySelected !== null) {
				$select.val(self.primaryKeySelected);
			}
		}
		var $incrementalQuery = $("#incrementalQuery", holder);
		$incrementalQuery.textcomplete([ {
			match : /(\$\{\w+$)/,
			index : 0,
			search : function(term, callback) {
				var match = term.slice(2);
				callback($.map(self.selectedFieldsHash, function(word) {
					return word.fieldName.startsWith(match) ? word.fieldName : null;
				}));
			},
			replace : function(word) {
				return "${" + word + "}";
			}
		} ]);
		break;
	}
};

HttpHandler.prototype.getPreviewData = function() {
	var nameValues = this.metaData.nameValueMaps.nameValues;
	for ( var i in nameValues) {
		if (nameValues[i].name === "completeJsonData") {
			return JSON.parse(nameValues[i].value);
		}
	}

	return null;
};

HttpHandler.prototype.getAccessTokens = function(authType, reqData, callback, holder) {
	var self = this;
	window.open(self.authResponseProps.authUrl, "_blank", "top=300,left=700,width=600,height=300");
	$(window).off("message").on("message",
			function(event) {
				var originUrl = event.originalEvent.origin + cvUtil.getContextPath() + "/authcallback.do";
				if (originUrl === self.callbackUrl) {

					reqData.properties.authProps.oauthRequestType = "authTokenRequest";
					if (authType === "OAUTH1") {
						reqData.properties.authProps.requestToken = self.authResponseProps.token;
						reqData.properties.authProps.requestTokenSecret = self.authResponseProps.tokenSecret;
						reqData.properties.authProps.oauthVerifier = event.originalEvent.data.oauthVerifier;
					} else if (authType === "OAUTH2") {
						reqData.properties.authProps.requestToken = sea.auth.getAuthPropertyInChunks(event.originalEvent.data.code);
					}
					sea.services.getMetaInfo(reqData, function(resp) {
						if (resp !== undefined && resp.additionalInfos !== undefined &&
								resp.additionalInfos.nameValues !== undefined) {
							self.PopulateAuthEntitiesFromResponse(resp.additionalInfos.nameValues);
							self.metaData = resp;
							callback(true);
						} else {
							callback(false);
						}
					}, null, holder);
				} else {
					callback(false);
				}
			});
};

HttpHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var reqData = null;
	var self = this;

	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		reqData = {
			type : self.type,
			name : self.name,
			coreName : "",
			engineId : parseInt(self.dsEngine),
			properties : {
				webUrl : self.properties.webUrl,
				reqType : self.properties.reqType,
				acceptType : self.properties.acceptType,
				headers : self.properties.headers,
				payload : self.properties.payload
			}
		};

		var authType = $("#authType").val();
		var authRequest = sea.auth.getData($(".httpAuthDiv", holder), self.properties.webUrl);
		self.authInputs = authRequest;
		reqData.properties.authProps = authRequest;

		if ((authType === "OAUTH1") || (authType === "OAUTH2" && $("#oauth2GrantType").val() === "authorization_code")) {
			reqData.properties.authProps.oauthRequestType = "authUrlRequest";
			sea.services.getMetaInfo(reqData, function(resp) {
				if (resp !== undefined && resp.additionalInfos !== undefined &&
						resp.additionalInfos.nameValues !== undefined) {
					self.PopulateAuthEntitiesFromResponse(resp.additionalInfos.nameValues);
					if (self.authResponseProps.authUrl !== undefined) {
						self.getAccessTokens(authType, reqData, callback, holder);
					} else {
						callback(false);
					}
				} else {
					callback(false);
				}
			}, null, holder);
		} else {
			sea.services.getMetaInfo(reqData, function(resp) {
				if ((resp !== undefined) || (authType !== "NONE" && resp.additionalInfos !== undefined && resp.additionalInfos.nameValues !== undefined)) {
					if (authType !== "NONE") {
						self.PopulateAuthEntitiesFromResponse(resp.additionalInfos.nameValues);
					}
					self.metaData = resp;
					callback(true);
				} else {
					callback(false);
				}
			}, null, holder);
		}
		break;
	case 4:
		if (self.selectedFields.length > 300) {
			cvUtil.toast(localMsg.FieldsLimit);
			callback(false);
		} else {
			callback(true);
		}
		break;
	case 5:
		var hasPaginationError = false;
		var hasNegativeValueError = false;
		var hasError = false;

		var paginateStartValue = $("#dsPaginateStartValue", holder).val();
		var paginateIncrementalValue = $("#dsPaginateIncrementalValue", holder).val();

		var $paginateStartParamParent = $("#dsPaginateStartParam", holder).parent();
		var $paginateIncrementalParamParent = $("#dsPaginateIncrementalParam", holder).parent();

		if (this.properties.isPaginate) {
			if (!$("#dsPaginateStartParam", holder).val() || !paginateStartValue.length) {
				hasPaginationError = true;
				$paginateStartParamParent.addClass("has-error");
			} else if ($("#dsPaginateStartValue", holder).val() < 0) {
				hasNegativeValueError = true;
				$paginateStartParamParent.addClass("has-error");
			} else {
				$paginateStartParamParent.removeClass("has-error");
			}

			if (!$("#dsPaginateIncrementalParam", holder).val() || !paginateIncrementalValue.length) {
				hasPaginationError = true;
				$paginateIncrementalParamParent.addClass("has-error");
			} else if ($("#dsPaginateIncrementalValue", holder).val() < 0) {
				hasNegativeValueError = true;
				$paginateIncrementalParamParent.addClass("has-error");
			} else {
				$paginateIncrementalParamParent.removeClass("has-error");
			}

			if (hasPaginationError) {
				hasError = true;
				cvUtil.errorToast(localMsg.EmptyPaginationParamsError);
			}

			if (hasNegativeValueError) {
				hasError = true;
				cvUtil.errorToast(localMsg.NegativePaginationParamsError);
			}

			if (this.properties.totalLoopValue === undefined || !this.properties.totalLoopValue.length) {
				hasError = true;
				$("#dsPaginateLoopIterationParent", holder).addClass("has-error");
				$("#dsPaginateLoopRecordParent", holder).addClass("has-error");
			} else {
				$("#dsPaginateLoopIterationParent", holder).removeClass("has-error");
				$("#dsPaginateLoopRecordParent", holder).removeClass("has-error");
			}

			var $totalIter = $("#dsPaginateTotalLoopValueIteration", holder);
			if ($totalIter.val() < 0) {
				hasError = true;
				$totalIter.parent().addClass("has-error");
				cvUtil.errorToast(localMsg.NegativePaginationParamsError);
			} else {
				$totalIter.parent().removeClass("has-error");
			}
			if (hasError) {
				callback(false);
				break;
			}
		}
		callback(true);
		break;
	default:
		callback(true);
		break;
	}
};

HttpHandler.prototype.submit = function(isEdit, dsObj, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, dsObj, holder);
	}
};

HttpHandler.prototype.fetch = function(step, holder) {
	var fetchedData = {};
	var countInput = null;
	var totalLoopType;
	var fields;
	var self = this;
	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		fetchedData.properties = {};
		break;
	case 2:
		var reqType = $("#dsReqType", holder).val();
		var payload = "";
		if (reqType === 'POST') {
			payload = $("#dsPayload", holder).val().replace(/\r?\n|\r|\t/g, "");
		}

		fetchedData = {
			properties : {
				webUrl : encodeURI(decodeURI($("#dsUrl", holder).val())),
				reqType : reqType,
				acceptType : 'JSON',
				headers : sea.auth.getHeaders($("#dsHeaders", holder)),
				payload : payload,
			}
		};
		break;
	case 3:
		if (!this.previewTable) {
			return;
		}
		var metaData = this.previewTable.getMetaData();
		fields = [];
		for (var i = 0; i < metaData.dynamicInfo.length; i++) {
			fields.push(metaData.dynamicInfo[i].nameValues);
		}

		/*
		 * These properties should be populated as the user clicks on the table. split and fields are arrays
		 * and hence their existing values are not cleared in this.updateProperties(). This will cause
		 * problems since any changes would be appened to split and field arrays (as opposed to replacing the
		 * content of the array entirely)
		 */
		delete this.properties.split;
		delete this.properties.fields;

		this.selectedFields = fields;
		var tempArr = [];
		//creating hash map for field info having key on feild's json path
		$.each(this.selectedFields, function(itr, val) {
			var jsonPath = val[2].value;
			var fieldName = val[0].value;
			var fieldType = val[1].value;
			tempArr.push(jsonPath);
			obj = {};
			//assigning field name obj["fieldName"] = name of the field
			obj[val[0].name] = fieldName;
			//assigning field type
			obj[val[1].name] = fieldType;
			if (self.selectedFieldsHash[jsonPath] === undefined) {
				self.selectedFieldsHash[jsonPath] = obj;
			}

		});
		//we are creating hashmap for selected fields,if user selects some field in preview step then go to the next(Edit Fields Information) step,
		//then come back to preview step and does some deselection of previously selected fields,then that fields should also get deleted 
		//from selectedFieldsHash.following code does this deletion
		$.each(this.selectedFieldsHash, function(itr, val) {
			if ($.inArray(itr, tempArr) === -1) {
				delete self.selectedFieldsHash[itr];
			}

		});
		this.selectedSplits = this.previewTable.getSplitvalues();
		var authConfig = this.authInputs;
		$.each(self.authResponseProps, function(key, val) {
			if (val !== undefined) {
				authConfig[key] = val;
			}
		});

		fetchedData = {
			properties : {
				split : this.selectedSplits,
				fields : fields,
				httpAuthConfig : JSON.stringify(authConfig)
			}
		};
		break;
	case 4:
		$.each(this.selectedFields, function(itr, val) {
			var jsonPath = val[2].value;
			var obj = self.selectedFieldsHash[jsonPath];
			//setting field name atrribute
			val[0].value = obj.fieldName;
			//setting field type attribute
			val[1].value = obj.dataType;

		});
		fetchedData = {
			properties : {
				fields : this.selectedFields
			}
		};
		break;
	case 5:
		this.loopingBasis = $("input[name='dsPaginateLoopBasis']:checked", holder).val();
		if (this.loopingBasis === "iteration") {
			countInput = $("#dsPaginateTotalLoopValueIteration", holder).val();
			totalLoopType = this.constants.loopType.COUNT;
		} else if (this.loopingBasis === "record") {
			countInput = $("#dsPaginateTotalLoopValueRecords", holder).val();
			totalLoopType = this.constants.loopType.INLINE_COUNT;
		}

		fetchedData = {
			properties : {
				isPaginate : $("#dsPaginate", holder).is(":checked"),
				startParamName : $("#dsPaginateStartParam", holder).val(),
				startParamValue : $("#dsPaginateStartValue", holder).val(),
				incrementalParamName : $("#dsPaginateIncrementalParam", holder).val(),
				incrementalParamValue : $("#dsPaginateIncrementalValue", holder).val(),
				incrementalType : $("input[name=dsPaginateIncrementalType]:checked", holder).val(),
				totalLoopType : totalLoopType,
				totalLoopValue : countInput
			}
		};
		break;
	case 6:
		fetchedData = {
			properties : {
				primary_key : $("#primaryKey", holder).val(),
				delta_sql_query : $("#incrementalQuery", holder).val(),
				always_incremental : $("#httpIncrementalCrawl", holder).is(":checked")
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}

	this.updateProperties(fetchedData);
	return fetchedData;
};

HttpHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	holder.off("click", ".btn-add-header").on("click", ".btn-add-header", function() {
		sea.auth.addHeader($(this).closest(".parentHeaderDiv"));
	});

	holder.off("click", ".btn-remove-header").on("click", ".btn-remove-header", function() {
		sea.auth.removeHeader($(this), $(this).closest(".parentHeaderDiv"));
	});

	holder.off("change", "#httpIncrementalCrawl").on("change", "#httpIncrementalCrawl", function() {
		$('#incrementalQuery',holder).prop('disabled',!$(this).is(":checked"));
	});
	
	holder.off("click", "#dsPaginate").on("click",
			"#dsPaginate",
			function() {
				var $stepHolder = $(this).parents(".step-content");
				var paginationContainer = $stepHolder.find(".http-pagination-container");
				if (!$(this).is(":checked")) {
					paginationContainer.hide();
				} else if (paginationContainer.length > 0) {
					paginationContainer.show();
				} else {
					$(this).parents(".form-group:first").after(uiControls.util.getTemplate(sea.constants.TMPL_PREFIX +
							sea.constants.DSTypes.HTTP + "_pagination", "div"));
				}
			});

	holder.off("change", "#dsReqType").on("change", "#dsReqType", function() {
		var $payLoad = $("#dsPayload", holder).parents(".form-group");
		if ($(this).val() === "POST") {
			$payLoad.show();
		} else {
			$payLoad.hide();
		}
	});

	holder.off("click", "input[name='dsPaginateLoopBasis']").on("click",
			"input[name='dsPaginateLoopBasis']",
			function() {
				var loopingBasis = $("input[name='dsPaginateLoopBasis']:checked", holder).val();
				if (loopingBasis === "iteration") {
					$("#dsPaginateLoopIterationParent", holder).show();
					$("#dsPaginateLoopRecordParent", holder).hide();
				} else if (loopingBasis === "record") {
					$("#dsPaginateLoopIterationParent", holder).hide();
					$("#dsPaginateLoopRecordParent", holder).show();
				}
			});

	sea.auth.init($(".httpAuthDiv", holder));
	fnCallBack({
		"callBack" : true
	});
};

HttpHandler.prototype.PopulateAuthEntitiesFromResponse = function(nameValuesArray) {
	var self = this;
	for ( var i in nameValuesArray) {
		var map = nameValuesArray[i];
		if (map.value) {
			self.authResponseProps[map.name] = map.value;
		}
	}
};

HttpHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	var self = this;
	if (onEdit) {
		$("#dsUrl", holder).val(decodeURI(props.webUrl.replace(/\+/g, ' ')));
		$("#dsReqType", holder).val(props.reqType);
		try {
			if (typeof props.payload === 'object') {
				$("#dsPayload", holder).val(JSON.stringify(props.payload));
			} else {
				$("#dsPayload", holder).val(props.payload);
			}

			if (props.isPaginate) {
				//trigger a click will call attach the pagination params to the DOM
				$("#dsPaginate", holder).trigger("click");
				$("#dsPaginateStartParam", holder).val(props.startParamName);
				$("#dsPaginateStartValue", holder).val(props.startParamValue);
				$("#dsPaginateIncrementalParam", holder).val(props.incrementalParamName);
				$("#dsPaginateIncrementalValue", holder).val(props.incrementalParamValue);
				$("input[name=dsPaginateIncrementalType][value=" + props.incrementalType + "]", holder)
						.trigger("click");

			}
		} catch (e) {
			console.error(e);
		}
		sea.auth.populateHeaders(props.headers, $("#dsHeaders", holder));
		this.selectedFields = props.fields;
		$.each(this.selectedFields, function(itr, val) {
			obj = {};
			var fieldName = val[0].value;
			var fieldType = val[1].value;
			var jsonPath = val[2].value;
			//assigning field name obj["fieldName"] = name of the field
			obj[val[0].name] = fieldName;
			//assigning field's type
			obj[val[1].name] = fieldType;
			//here val[2].value is the field's json path
			self.selectedFieldsHash[jsonPath] = obj;
		});
		self.mergeFieldTypes();
		self.selectedSplits = props.split;
		if (props.primary_key) {
			self.primaryKeySelected = props.primary_key;
		}
		if (props.delta_sql_query) {
			$("#incrementalQuery", holder).val(props.delta_sql_query);
		}
		$("#httpIncrementalCrawl", holder).attr("checked", props.always_incremental).change();
		if (props.httpAuthConfig) {
			sea.auth.populateData(props.httpAuthConfig, $(".httpAuthDiv", holder));
		}
	} else {
		var url = props.reqType + " " + decodeURI(props.webUrl.replace(/\+/g, ' '));
		$("#dsUrl", holder).text(url);
	}
};

HttpHandler.prototype.mergeFieldTypes = function() {
	var self = this;
	sea.services.getDSSchema(self.datasourceId, function(resp) {
		var fields = {};
		$.each(resp.schemaFields, function(index, val) {
			fields[val.fieldName] = val.type;
		});

		$.each(self.selectedFieldsHash, function(key, value) {
			if (fields[value.fieldName] !== undefined) {
				value.dataType = fields[value.fieldName];
			}
		});
	});
};

