function FsHandler() {
	this.type = sea.constants.DSTypes.FS;
	this.subtype = null;
}

FsHandler.prototype.initializeStep = function(step, holder, isEdit) {
	var self = this;
	$('[data-toggle="popover"]').popover({
		html : true,
		placement : "top",
		trigger : "hover"
	});
	switch (step) {

	case 2:
		if (this.subtype !== "noClient") {
			$("#clientInfoHolder", holder).removeClass("hidden");
			//below condition is if user goes to 3rd step and again come back to 2nd then we should not populate client list again
			if (!isEdit && this.properties !== undefined && this.properties.accessnodeclientid === undefined) {
				this.populateClientCombo(holder, isEdit);
			}
		}
		break;
	}
};

FsHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit) {
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 3:
		var minDocSize = $("#minDocSize", holder).val();
		var maxDocSize = $("#maxDocSize", holder).val();
		var minDocSizeInBytes = cvFormatters.getSizeInBytes(parseInt(minDocSize), $("#minDocSizeUnit", holder).val());
		var maxDocSizeInBytes = cvFormatters.getSizeInBytes(parseInt(maxDocSize), $("#maxDocSizeUnit", holder).val());
		if (minDocSizeInBytes > maxDocSizeInBytes) {
			cvUtil.errorToast(localMsg.FileSizeError);
			callback(false);
		}
		callback(true);
		break;
	default:
		callback(true);
	}
};

FsHandler.prototype.fetch = function(step, holder, isEdit) {
	var dirLoc = null;
	//var fsFilterType = null;
	var includeFilters = null;
	var excludeFilters = null;
	var includedirectoriespath = null;
	var minDocSize = null;
	var maxDocSize = null;
	var accessNode = null;

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		dirLoc = $("#dirLoc", holder).val();
		accessNode = $("#clientListCombo", holder).val();
		excludeFilters = $("#excludeFilter", holder).val();
		if (dirLoc) {
			includedirectoriespath = dirLoc.split("\n").join();
			includedirectoriespath = includedirectoriespath.replace(/,$/, "").replace(/^,/, "");
		}
		// fsFilterType = $("input[name=fsFilterType]:checked", holder).val();

		fetchedData = {
			properties : {
				includedirectoriespath : includedirectoriespath,
				doincrementalscan : $("#isFSIncrementalCrawl", holder).is(":checked"),
				username : $("#dsUserName", holder).val(),
				password : Base64.encode($("#dsPassword", holder).val()),
				excludefilters : excludeFilters
			}
		};

		if (this.subtype !== "noClient") {
			fetchedData.properties.accessnodeclientid = accessNode;
			fetchedData.properties.createclient = "archiverClient";
			//TODO: For SP11, we are making a temporary fix. this has to be taken care in server side
			//When windows local path is given, we shouldn't create a new client
			if (new RegExp(/^[a-zA-Z]:(.*)/).test(includedirectoriespath)) {
				fetchedData.properties.pseudoclientid = accessNode;
			}
		} else {
			includeFilters = $("#includeFilter", holder).val();
			fetchedData.properties.includefilters = includeFilters;
		}
		break;

	case 3:
		minDocSize = $("#minDocSize", holder).val();
		maxDocSize = $("#maxDocSize", holder).val();
		fetchedData = {
			properties : {
				pushonlymetadata : !$("#isOnlyMetaData", holder).is(":checked"),
				minumumdocumentsize : minDocSize ? cvFormatters.getSizeInBytes(parseInt(minDocSize),
						$("#minDocSizeUnit", holder).val()) : 0,
				maximumdocumentsize : maxDocSize ? cvFormatters.getSizeInBytes(parseInt(maxDocSize),
						$("#maxDocSizeUnit", holder).val()) : 0
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};

		var $CSBtn = $("#isOnlyMetaData", holder);
		if ($CSBtn.is(":checked")) {
			if (this.subtype !== "noClient") {
				includeFilters = $("#includeFilter", holder).val();
				fetchedData.properties.includefilters = includeFilters;
			}

		}
		break;

	}
	this.updateProperties(fetchedData);

	return fetchedData;
};

FsHandler.prototype.submit = function(isEdit, data, holder) {
	if (!isEdit) {
		this.create(null, holder);
	} else {
		this.update(null, data, holder);
	}
};

FsHandler.prototype.getAllClients = function(indexServerId,callBack) {
	sea.services.getAllClients(indexServerId, this.type, function(resp) {
		callBack(resp);
	}, function(resp) {

	}, holder);
}


FsHandler.prototype.populateClientCombo = function(holder, isEdit, callback) {
	var indexServerId = $("#dsEngine", holder).find(":selected").data("clientId");
	this.getAllClients(indexServerId, function(resp) {
		var comboObj = $("#clientListCombo", holder);
		var clientList = [];
		$.each(resp, function(i, val) {
			clientList.push(val.entityInfo);
		});
		clientList = cvSearchUtil.sortArrayByKey(clientList, "name");
		comboObj.empty();
		$.each(clientList, function(i, val) {
			var optHtml = "<option value=\"" + val["id"] + "\">" + val["name"] + "</option>";
			comboObj.append(optHtml);

		});
		if (isEdit === true) {
			callback();//to set clientid in case of edit
		}
	});
};

FsHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack, subtype) {
	/*
	 * Bug: IE sets placeholder value as the text value in textareas There is something in .text(), but no
	 * value exists! IE bug!
	 */
	var self = this;
	this.subtype = subtype;
	$(holder).find('textarea[placeholder]').each(function(index, element) {
		if ($(element).text() !== $(element).val()) {
			$(element).text("");
		}
	});

	$("#isOnlyMetaData").change(function() {
		var $contentFilterDiv;
		if (self.subtype !== "noClient") {
			$contentFilterDiv = $("#archiverContentFilterDiv", holder);
		} else {
			$contentFilterDiv = $("#fsContentFilterDiv", holder)
		}
		if (this.checked) {
			$(".EnableContentSearchHint", holder).hide();
			$contentFilterDiv.slideDown();
		} else {
			$(".EnableContentSearchHint", holder).show();
			$contentFilterDiv.slideUp();
		}

	});

	var $includeFilterDiv = uiControls.util.getTemplate("include_filter", "div");
	var $contentSearchOptions = uiControls.util.getTemplate("content_search_options", "div");
	var $sourceDetailsDiv = $("#sourceDetailsDiv", holder);
	var $includeFilter = $("#includeFilter", $includeFilterDiv);
	var $contentFilterDiv;

	if (subtype !== "noClient") {
		$contentFilterDiv = $("#archiverContentFilterDiv", holder);
		$includeFilter.data("required", true);
		$contentFilterDiv.append($includeFilterDiv);
		$contentFilterDiv.append($contentSearchOptions);
	} else {
		$contentFilterDiv = $("#fsContentFilterDiv", holder);
		$includeFilter.data("required", false);
		$(".help-block", $includeFilterDiv).html(localMsg["IncludeFilterHintForFS"]);
		$sourceDetailsDiv.append($includeFilterDiv);
		$contentFilterDiv.append($contentSearchOptions);
	}

	if (subtype === "seismic") {
		$includeFilter.val("*.segy");
	} else {
		sea.services.getFSIncludeFilters(function(includeFilters) {
			$includeFilter.val(includeFilters.name);
		}, null, holder);
	}

	var sizeUnits = subtype === "seismic" ? ["KB","MB", "GB"] : ["KB","MB"];
	var $minDocSize = $("#minDocSizeUnit", holder);
	var $maxDocSize = $("#maxDocSizeUnit", holder);
	$.each(sizeUnits, function(i,sizeUnit) {
		$minDocSize.append("<option value='"+sizeUnit+"'>"+sizeUnit+"</option>");
		$maxDocSize.append("<option value='"+sizeUnit+"'>"+sizeUnit+"</option>");
	});
	if(!isEdit) {
		$minDocSize.val(sizeUnits[0]);	
		$maxDocSize.val(sizeUnits[sizeUnits.length - 1]);
	}

	fnCallBack({
		"callBack" : true
	});

};

FsHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit, engineId) {
	if (onEdit) {
		var str = "";
		if (props.includedirectoriespath) {
			str = props.includedirectoriespath;
			str = str.split(",").join("\n");
			$("#dirLoc", holder).val(str);
		}

		if (props.createclient === "archiverClient") {
			if (props.literalproperties) {
				this.properties.literalproperties = encodeURIComponent(props.literalproperties);
			}
			this.populateClientCombo(holder, onEdit, function() {
				$("#clientListCombo", holder).val(props.accessnodeclientid);
			});
		}

		if (props.includefilters) {
			$("#includeFilter", holder).val(props.includefilters);
		}
		if (props.excludefilters) {
			$("#excludeFilter", holder).val(props.excludefilters);
		}
		$("#isFSIncrementalCrawl", holder).attr("checked", props.doincrementalscan).change();
		if (props.username) {
			$("#dsUserName", holder).val(props.username);
		}
		$("#dsPassword", holder).val(cvUtil.base64Decode(props.password));

		$("#isOnlyMetaData", holder).attr("checked", !props.pushonlymetadata).change();

		
		//$("#isRetainVersions", holder).attr("checked", props.retainallversions).change();
		renderer = {};
		renderer.source = 'BYTES';
		renderer.tofixed = 0;
		if (props.minumumdocumentsize && props.minumumdocumentsize != 0) {
			if (props.minumumdocumentsize < 1048576) {
				renderer.target = 'KB';
			} else if (props.minumumdocumentsize < 1073741824 ) {
				renderer.target = 'MB';
			} else {
				renderer.target = 'GB';
			}
			var fmtVal = cvFormatters.formatSize(props.minumumdocumentsize, renderer).split(" ");
			$("#minDocSize", holder).val(fmtVal[0]);
			$("#minDocSizeUnit", holder).val(fmtVal[1]);
		}
		if (props.maximumdocumentsize) {
			if (props.maximumdocumentsize < 1048576) {
				renderer.target = 'KB';
			} else if (props.maximumdocumentsize < 1073741824 ) {
				renderer.target = 'MB';
			} else {
				renderer.target = 'GB';
			}
			var fmtVal = cvFormatters.formatSize(props.maximumdocumentsize, renderer).split(" ");
			$("#maxDocSize", holder).val(fmtVal[0]);
			$("#maxDocSizeUnit", holder).val(fmtVal[1]);
		}
		// if (props.retainallversions || (props.minumumdocumentsize && props.minumumdocumentsize != 0) ||
		// 		(props.maximumdocumentsize && props.maximumdocumentsize != sea.constants.MAX_DOCUMENT_SIZE))
		// 	$("#fsAdvanceOptionsPanel", holder).collapse('show');
		/*
		 * if (props.maxindexingthreads) $("#maxThreads", holder).val(props.maxindexingthreads);
		 */
	} else {
		var subtype = props.datasourceSubType ? props.datasourceSubType : props.createclient;
		$("#dsType", holder).html(localMsg[subtype]);
		
		if (props.includedirectoriespath) {
			var paths = props.includedirectoriespath.replace(/,/g, "</br>");
			$("#dirLoc", holder).html(paths);
		}

		this.getAllClients(engineId, function(resp) {
			var accessNode = resp.find(function(val) {
				return val.entityInfo.id === props.accessnodeclientid;
			});
			if(accessNode !== undefined) {
				$("#dsAccessNode", holder).text(accessNode.entityInfo.name);
				$(".accessNodeElement", holder).show();
			}
		});

		if (props.includefilters) {
			$("#includeFilter", holder).html(props.includefilters);
			$(".includeFilterLabel", holder).show();
		}
		if (props.excludefilters) {
			$("#excludeFilter", holder).html(props.excludefilters);
			$(".excludeFilterLabel", holder).show();
		}
		$("#pushOnlyMetadataInfo_" + props.pushonlymetadata).show();
	}
};


