function FederatedHandler() {
	this.type = sea.constants.DSTypes.FEDERATED;
	this.dataSourceList = {};
	this.handlerList = {};
}

FederatedHandler.prototype.initializeStep = function() {

};

FederatedHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit) {
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		if (this.handlerInfos.length == 0) {
			cvUtil.errorToast(localMsg.NoHandlersSpecified);
			callback(false);
		} else {
			callback(true);
		}
		break;
	}

};

FederatedHandler.prototype.submit = function() {

};

FederatedHandler.prototype.getDataSourceGroupingById = function(handlers) {
	var self = this;
	var handlerInfo = handlers.handlerInfos;
	if (handlerInfo != undefined) {

		$.each(handlerInfo, function(indx, val) {
			var dsId = val.dataSourceId;
			if (dsId in self.dataSourceList) {
				self.dataSourceList[dsId]["handlerInfos"].push({
					"handlerId" : val.handlerId,
					"handlerName" : val.handlerName
				});
			} else {
				self.dataSourceList[dsId] = {
					"handlerInfos" : [ {
						"handlerId" : val.handlerId,
						"handlerName" : val.handlerName
					} ],
					"dsName" : val.dataSourceName
				};
			}
		});

	}

};
FederatedHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	var self = this;
	sea.services.getHandlersBasicInfo(null, null, function(handlers) {
		var $dsSelectList = null;

		self.getDataSourceGroupingById(handlers);
		holder.off("click", ".btn-add-handler").on("click", ".btn-add-handler", function() {
			addHandler($(this), self.dataSourceList);
		});
		self.attachFederatedHandlerListeners(holder);
		$dsSelectList = $("." + this.constants.DATA_SOURCE_LIST, holder);
		populateDSCombo(self.dataSourceList, $dsSelectList);
		initMultiselect($dsSelectList, null, isEdit);
		fnCallBack({
			"callBack" : true
		});
	}, null, holder);
};

FederatedHandler.prototype.fetch = function(step, holder) {
	var fetchedData = {};

	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		fetchedData.properties = {};
		break;
	case 2:
		fetchedData.handlerInfos = getHandlerInfosForFederated($(".handler-list", holder));
		break;
	}

	this.updateProperties(fetchedData);
	return fetchedData;
};

//Overriding the create() and update() functions in datasourcehandler.js
FederatedHandler.prototype.create = function(holder, isEdit) {
	var reqData = null;
	var self = this;

	/*
	 * Though we are not using cvWizard for federated, following the pattern to make things easier in the
	 * future
	 */
	this.fetch(1, holder);
	reqData = this.getRequestObject();
	reqData.operationtype = sea.constants.Operations.CREATE;
	reqData.engineId = "";
	self.fetch(2, holder);

	this.validateStep(1, holder, null, function(isValid) {
		if (isValid) {
			self.validateStep(2, holder, null, function(isValid) {
				if (isValid) {
					sea.services.createDataSource(reqData, isEdit, function(resp) {
						var reqFederated = {};
						reqFederated.federateSearchName = resp.displayName;
						reqFederated.dataSourceId = resp.datasourceId;
						reqFederated.handlerInfos = self.handlerInfos;
						sea.services.createFederatedSearch(reqFederated, isEdit, function(data) {
							/*
							 * We are sending datasourceId as first argument instead of core name. Since a
							 * federated search is not a real data source, there is no core name
							 */
							sea.dsController.goToDSConfigPage(resp.datasourceId,
									self.name,
									resp.datasourceId,
									self.type);
						}, null, holder);
					}, null, holder);
				}
			});
		}
	});
};

FederatedHandler.prototype.update = function(holder, dsObj) {
	var reqData = null;
	var self = this;

	/*
	 * Though we are not using cvWizard for federated, following the pattern to make things easier in the
	 * future
	 */
	this.fetch(1, holder);
	reqData = this.getRequestObject();
	reqData.operationtype = sea.constants.Operations.MODIFY;
	reqData.engineId = "";

	this.validateStep(1, holder, null, function(isValid) {
		if (isValid) {
			self.fetch(2, holder);
			self.validateStep(2, holder, null, function(isValid) {
				if (isValid) {
					reqData.datasourceId = dsObj.datasourceId;
					reqData.federateSearchName = dsObj.federatedSearchInfos[0].federateSearchName;
					reqData.federateSearchId = dsObj.federatedSearchInfos[0].federateSearchId;
					reqData.handlerInfos = self.handlerInfos;
					sea.services.createFederatedSearch(reqData, true, function(res) {
						sea.dsController.goToDSConfigPage(dsObj.corename,
								reqData.name,
								reqData.datasourceId,
								reqData.type);
					}, null, holder);
				}
			});
		}
	}, true);

};

//overrriding implementation in datasourcehandler.js
FederatedHandler.prototype.populateDataSourceProps = function(dsObj, holder, onEdit) {
	$("#federateSearchId").val(dsObj.federatedSearchInfos[0].federateSearchId);
	$("#dsName", holder).val(dsObj.federatedSearchInfos[0].federateSearchName);
	this.populateDSSpecificProperties(dsObj, holder, onEdit);
};

FederatedHandler.prototype.populateDSSpecificProperties = function(dsObj, holder, onEdit) {
	var handlerInfos = dsObj.federatedSearchInfos[0].handlerInfos;
	var self = this;
	var handler = null;

	var getHandler = function(i) {
		return handlerInfos[i].handlerId;
	};

	if (onEdit) {
		for (var i = 0; i < handlerInfos.length; i++) {
			handler = handlerInfos[i];
			var dList = $("." + this.constants.DATA_SOURCE_LIST + ":last", holder);
			var hList = $("." + this.constants.HANDLER_LIST + ":last", holder);

			initMultiselect(dList, handler.dataSourceId);
			(function() {
				var ii = i;
				hList.on("loaded", function() {
					initMultiselect($(this), getHandler(ii));
				});
			})();
			dList.trigger("change");
			if (i != handlerInfos.length - 1) {
				$(".btn-add-handler:last", holder).trigger("click");
			}
		}
	} else {
		showFederatedTable(dsObj, holder);
		
	}
}

function addHandler(holder, dataSources) {
	var datasourceHtml = $(uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
			sea.constants.DSTypes.FEDERATED + "_source", "div"));
	var parent = holder.parents("." + this.constants.DATA_SOURCE);
	var $dsList = datasourceHtml.find("." + this.constants.DATA_SOURCE_LIST);
	parent.after(datasourceHtml);
	populateDSCombo(dataSources, $dsList);
	initMultiselect($dsList);
	removeDuplicateDS(parent.parents("." + this.constants.DATA_SOURCE_CONTAINER));
};

FederatedHandler.prototype.attachFederatedHandlerListeners = function(holder) {
	var self = this;
	$(holder).off("change", "." + this.constants.DATA_SOURCE_LIST).on("change",
			"." + this.constants.DATA_SOURCE_LIST,
			function(e) {
				var dsId = $(this).val();
				var oldds = $(this).data("oldds");
				var context = $(this);
				var $handlerList = context.parents("." + self.constants.DATA_SOURCE).find(".handler-list");
				populateHandlersCombo(dsId, self.dataSourceList[dsId].handlerInfos, $handlerList);
				initMultiselect($handlerList);

				//The placeholder 'select' is no longer needed
				$(this).find("option[data-selectoption=true]").remove();
				if(oldds !== undefined)
					removeDuplicateHandlers(oldds,holder);
				removeDuplicateHandlers(dsId,holder);
				removeDuplicateDS(holder);
				$(this).data("oldds",dsId)
			});

	$(holder).off("change", "." + this.constants.HANDLER_LIST).on("change",
			"." + this.constants.HANDLER_LIST,
			function(e) {
				var dsId = $($("option",$(this))[0]).data("dsid");
				removeDuplicateHandlers(dsId,holder);
				removeDuplicateDS(holder);
			});

	$(holder).off("click", ".btn-remove-handler").on("click", ".btn-remove-handler", function(e) {
		var parentDataSource = $(this).parents("." + self.constants.DATA_SOURCE);
		var dataSourcesContainer = parentDataSource.parents("." + self.constants.DATA_SOURCE_CONTAINER);
		var dsId = $("."+self.constants.DATA_SOURCE_LIST,parentDataSource).val();
		if (dataSourcesContainer.find("." + self.constants.DATA_SOURCE).length > 1) {
			parentDataSource.remove();
			removeDuplicateHandlers(dsId,holder);
			removeDuplicateDS(holder);
		} else {
			parentDataSource.empty();
			var addButton = $("<button class='btn btn-default'>" + localMsg.Add + "</button>");
			addButton.on("click", function() {
			addHandler($(this), self.dataSourceList);
				$(this).parent().remove();
			});
			parentDataSource.append(addButton);
		}
	});
}

function populateDSCombo(dsList, dsHolder) {
	dsHolder.append("<option disabled='disabled' selected='selected' data-selectoption='true'>Select</option>");
	$.each(dsList, function(key, value) {
		dsHolder.append("<option value='" + key + "'>" + value.dsName + "</option>");
	});
	var options = $("option", dsHolder).not(":first"); //to remove first i.e select element and getting only all options.
	options.detach().sort(function(a, b) {
		var text1 = $(a).text().toLowerCase();
		var text2 = $(b).text().toLowerCase();
		return (text1 > text2) ? 1 : ((text1 < text2) ? -1 : 0);
	});
	options.appendTo(dsHolder);
	$("option:eq(0)", dsHolder).prop("selected", true);
}

function initMultiselect($select, val, isEdit) {
	if ($.isEmptyObject($select.data('multiselect'))) {
		var dropUp = false;
		var maxHeight = 300;
		if ($select.offset().top + maxHeight > $(document).height()) {
			dropUp = true;
		}
		$select
				.multiselect({
					enableFiltering : true,
					enableCaseInsensitiveFiltering : true,
					maxHeight : maxHeight,
					buttonContainer : self.constants.MULTISELECT_BUTTON_CONTAINER,
					buttonClass : self.constants.MULTISELECT_BUTTON_CLASS,
					dropUp : dropUp,
					onInitialized : function($select, $container) {
						if (isEdit) {
							$container.find(".multiselect").focus();
						}

					},
					onDropdownShown : function() {

						var $search = this.$filter.find("div.multiselect-button");
						/*
						 * Jquery multiselect is doing something that takes away the focus from the search box
						 * as soon as we focus it. Using a setTimeout makes sure that the current execution
						 * queue is done before focusing. Reference:
						 * http://stackoverflow.com/questions/9596419/what-are-some-reasons-for-jquery-focus-not-working
						 */
						setTimeout(function() {
							$search.focus();
						});
					},
					templates : {
						filterClearBtn : "",
						button : '<button type="button" class="multiselect dropdown-toggle btn btn-default form-control" data-toggle="dropdown" title="None selected">'
								+ '<span class="multiselect-selected-text"></span><div class="pull-right"><b class="caret"></b></div></button>'
					}
				});
	} else {
		$select.multiselect('rebuild');
	}

	if (val != undefined) {
		$select.multiselect('select', val);
	}
}

var removeDuplicateHandlers = function(dsId,holder) {
	var handlerSel = "."+ self.constants.HANDLER_LIST;
	var selected = {};
	$(handlerSel + ' option:selected[data-dsId="'+dsId+'"]', holder).each(function() {
		var val = $(this).val();
		if (val !== undefined) {
			selected[val] = 1;
		}
	});

	$(handlerSel + ' option[data-dsId="'+dsId+'"]', holder).each(function() {
		var val = $(this).val();
		if (!$(this).is(':selected')) {
			if (selected[val] !== undefined && selected[val] == 1) {
				$(this).prop('disabled', true);
			} else {
				$(this).prop('disabled', false);
			}
		}
	});

	initMultiselect($(handlerSel, holder).has("option"));
}


var removeDuplicateDS = function(holder) {
	var self = this;
	var selected = {};
	var dsSelector = "."+ self.constants.DATA_SOURCE_LIST;
	$(dsSelector + " option:selected", holder).each(function() {
		var val = $(this).val();
		if (val !== undefined) {
			var nonSelHandlers = $("."+ self.constants.HANDLER_LIST + ' option:not(:selected):not([disabled])[data-dsId="'+val+'"]', holder);
			var nonSelHandlerCnt = $.unique(nonSelHandlers).length;
			selected[val] = nonSelHandlerCnt;
		}
	});

	$(dsSelector + " option:not([data-selectoption])", holder).each(function() {
		var val = $(this).val();
		if (!$(this).is(':selected')) {
			if (selected[val] !== undefined && selected[val] === 0) {
				$(this).prop('disabled', true);
			} else {
				$(this).prop('disabled', false);
			}
		}
	});

	initMultiselect($(dsSelector, holder));
}



function populateHandlersCombo(dsId, handlerInfos, handlerHolder) {
	handlerHolder.empty();
	if ($.isEmptyObject(handlerInfos)) {
		handlerHolder.append("<option disabled='disabled'>None</option>");
	} else {
		var handlerSel = "."+ self.constants.HANDLER_LIST;
		var selected = {};
		$(handlerSel + ' option:selected[data-dsId="'+dsId+'"]', holder).each(function() {
			var val = $(this).val();
			if (val !== undefined) {
				selected[val] = 1;
			}
		});
		for (var i = 0; i < handlerInfos.length; i++) {
			var handlerId = handlerInfos[i].handlerId;
			var handlerName = handlerInfos[i].handlerName;
			if(selected[handlerId] === 1)
				handlerHolder.append("<option data-dsId='"+dsId+"' value='" + handlerId + "' disabled>" + handlerName +
					"</option>");
			else
				handlerHolder.append("<option data-dsId='"+dsId+"' value='" + handlerId + "'>" + handlerName +
					"</option>");
		}
		handlerHolder.trigger("loaded");
	}
}

function getHandlerInfosForFederated($handlers) {
	var handlerInfos = [];
	$.each($handlers, function(i, handler) {
		var val = $(handler).val();
		if (val != undefined) {
			handlerInfos.push({
				handlerId : val
			});
		}
	});

	return handlerInfos;
}
function showFederatedTable(federated, holder) {
	var config = {};
	var federateTableId = "federatedTable";
	config.columns = sea.ColumnConfiguration.getConfigInDTFormat(sea.ColumnConfiguration.federatedViewConfig);
	//There can be only one element in federatedSearchInfos since we are passing a dsId
	config.data = federated.federatedSearchInfos[0].handlerInfos;
	config.dom = 'J<"pull-left"f><"pull-right"l><"clearfix">t<"pull-left"i><"pull-right"p><"clearfix">';
	var configTable = $(uiControls.util.getDataTableHtml(federateTableId, sea.ColumnConfiguration.federatedViewConfig));
	holder.find("#datasources_config").after(configTable);
	// $(containerId).append(federatedTable);
	$("#" + federateTableId, holder).dataTable(config);
}

FederatedHandler.prototype.showFederatedRestAPI = function(federated, holder) {
	var RestAPIToolBar = new ToolBar(
			holder.attr("id"),
			sea.constants.DSTypes.FEDERATED + "_" + "RESTAPI",
			localMsg.RESTAPI);
	var fsUrl = sea.restApiConstants.getFederatedSearchRESTAPI(federated.federatedSearchInfos[0].federateSearchId,
			federated.federatedSearchInfos[0].federateSearchName);
	RestAPIToolBar.addButton(function() {
		var executeBtn = $("<button class='btn btn-success btn-execute'>" + localMsg.Execute + "</button>");
		executeBtn.on("click", function() {
			var newWindow = window.open(fsUrl, "_blank");
			newWindow.focus();
		});
		return executeBtn;
	});
	RestAPIToolBar.addClass("extended-margin-top");
	holder.append(fsUrl);
}