function FacebookHandler() {
	this.type = sea.constants.DSTypes.FACEBOOK;
	this.displayName = sea.DSTypeConstants.getDSObject(this.type).dsDispName;
	this.appId = null;
	this.appSecret = null;
	this.accessToken = null;
	this.accessTokenPoll = false;
	this.loginPopup = null;
	this.fieldNames = null;
	this.newlyAddedFieldNames = null;
}

FacebookHandler.prototype.initializeStep = function(step, holder, isEdit) {
	var self = this;
	switch (step) {
	case 2:
		if (isEdit) {
			if (self.newlyAddedFieldNames === null) {
				self.getSchemaFieldNames(holder, isEdit, function(fieldNames) {
					sea.services.getDSSchema(self.datasourceId, function(resp) {
						var dsFields = sea.schemaController.getDeleteableFields(resp.schemaFields,false,false,true);
						self.newlyAddedFieldNames = dsFields.filter(function(val) {
							return fieldNames.indexOf(val) === -1;
						});
					});
				});
			}
		}
		break;
	
	}
};

FacebookHandler.prototype.loadSDK = function(appId, holder) {
	var self = this;

	self.getAppId(function(appId) {
		if (!appId) {
			cvUtil.errorToast(localMsg.AppIdNotFoundFacebook);
			return;
		}
		window.fbAsyncInit = function() {
			FB.init({
				appId : appId,
				xfbml : true,
				version : 'v2.6'
			});
		};

		(function(d, s, id) {
			var js, fjs = d.getElementsByTagName(s)[0];
			if (d.getElementById(id)) {
				return;
			}
			js = d.createElement(s);
			js.id = id;
			js.src = "//connect.facebook.net/en_US/sdk.js"; //URL to point the facebook sdk
			fjs.parentNode.insertBefore(js, fjs);
		}(document, 'script', 'facebook-jssdk'));
	});
};

FacebookHandler.prototype.validateStep = function(step, holder, aggregatedInput, callback, isEdit, dsObj) {
	var reqData = null;
	var self = this;
	var wizard = aggregatedInput.wizard;
	try {
		sea.util.validateInputsAndGetData(holder);
	} catch (e) {
		callback(false);
		return;
	}

	switch (step) {
	case 1:
		$('#fbCrawlSelections').multiselect({
			includeSelectAllOption : true
		});
		if (!isEdit) {
			this.isDatasourceNameExists(holder, callback);
		} else {
			callback(true);
		}
		break;
	case 2:
		if (FB != undefined) {
			FB.login(function(response) {
				if (response.status === 'connected') {
					var authToken = Base64.encode(response.authResponse.accessToken);
					sea.services.getAccessTokenFB(self.appId, self.appSecret, authToken, function(resp) {
						if (resp) {
							try {
								self.accessToken = resp.access_token;
								callback(true);
							} catch (e) {
								console.error(e);
								cvUtil.errorToast(localMsg.AppIdNotFoundFacebook);
								callback(false);
							}
						} else {
							cvUtil.errorToast(localMsg.AppIdNotFoundFacebook);
						}
					}, null, holder);
				} else if (response.status === 'not_authorized') {
					cvUtil.errorToast(localMsg.NotAuthorizedApplication)
					callback(false);
				} else {
					cvUtil.errorToast(localMsg.SocialLoginFailed);
					callback(false);
				}
			});
		} else {
			cvUtil.errorToast(localMsg.AppNotInitialized);
			callback(false);
		}
		break;
	case 3:
		if ($("#crawlPage", holder).is(":checked")) {
			var fbId = $("#fbId", holder).val();
			if (fbId != null && fbId != undefined && fbId != "") {
				callback(true);
			} else {
				cvUtil.errorToast(localMsg.NotValidFacebookPageUrl);
				callback(false);
			}
		} else if ($("#crawlUser", holder).is(":checked")) {
			callback(true);
		}
		break;
	default:
		callback(true);
	}
};

FacebookHandler.prototype.getAppId = function(callback, holder) {
	var self = this;
	sea.services.getAppDetails(self.type, function(resp) {
		if (resp) {
			try {
				//0 is appId and 1 is appSecret. Waiting for API change
				self.appId = resp.properties[0].propertyValue;
				self.appSecret = resp.properties[1].propertyValue;
				callback(self.appId);
			} catch (e) {
				console.error(e);
				cvUtil.errorToast(localMsg.AppIdNotFoundFacebook);
			}
		} else {
			cvUtil.errorToast(localMsg.AppIdNotFoundFacebook);
		}
	}, null, holder);
};

FacebookHandler.prototype.getFBId = function(holder) {
	var self = this;
	if ($("#crawlPage", holder).is(":checked")) {
		self.resolveProfile(holder);
		return $("#fbId", holder).val();
	} else {
		return "";
	}
};

FacebookHandler.prototype.fetch = function(step, holder) {
	var fetchedData = {};
	switch (step) {
	case 1:
		fetchedData = this.fetchBasicDetails(holder);
		break;
	case 2:
		fetchedData = {
			properties : {
				appId : this.appId,
				appSecret : this.appSecret
			}
		};
		break;
	case 3:
		fetchedData = {
			properties : {
				appId : this.appId,
				appSecret : this.appSecret,
				accessToken : this.accessToken,
				fbId : this.getFBId(holder),
				fbCrawlSelections : $("#fbCrawlSelections", holder).val()
			},
			dsCrawl : $("#dsCrawl", holder).is(":checked")
		};
		break;
	}
	this.updateProperties(fetchedData);
	return fetchedData;
};

FacebookHandler.prototype.resolveProfile = function(holder) {
	var self = this;
	var profileId = $("#fbId", holder).val().split("#")[0];
	if (profileId != undefined && profileId != "" && profileId.indexOf("facebook.com") > -1) { //obtains the numeric id from the given facebook page url
		var decodedToken = sea.auth.getAuthPropertyFromChunks(self.accessToken);
		$.ajax({
			url : "https://graph.facebook.com/?id=" + profileId + "&access_token=" + decodedToken,
			success : function(result) {
				if (result.hasOwnProperty("name")) {
					$("#fbId", holder).val(result.id);
				} else {
					$("#fbId", holder).val("");
				}
			},
			async : false
		});
	}
};

FacebookHandler.prototype.initDSSpecificComponents = function(holder, isEdit, fnCallBack) {
	var self = this;
	fnCallBack({
		"callBack" : true
	});

	self.loadSDK();
	if (!isEdit) {
		$("#crawlUser", holder).prop('checked', true);
	}
};

FacebookHandler.prototype.populateDSSpecificProperties = function(props, holder, onEdit) {
	if (onEdit) {
		if (props["fbId"] != undefined) {
			var fbId = props["fbId"];
			$("#fbId", holder).val(fbId);
			$("#crawlPage", holder).prop('checked', true);
			$("#fbId", holder).prop('disabled', false);
		} else {
			$("#crawlUser", holder).prop('checked', true);
			$("#fbId", holder).prop('disabled', true);
		}
		if (props["fbCrawlSelections"] != undefined) {
			//passing 3 values by default to show that they will be crawled by default.
			var crawlSelection = ("user,page,post," + props["fbCrawlSelections"]).split(",");
			$("#fbCrawlSelections", holder).val(crawlSelection);
		}
		if (props["accessToken"] != undefined) {
			this.accessToken = props["accessToken"];
		}
		
	} else {
		if (props["fbId"] != undefined) {
			$("#crawlType", holder).text(localMsg.page);
			$("#crawlfbIdDiv", holder).show();
			$("#crawlfbId", holder).text(props["fbId"]);
		} else {
			$("#crawlType", holder).text(localMsg.LoggedInUser);
		}
		var crawlSelection = localMsg.user + "," + localMsg.page + "," + localMsg.post; //passing 3 values by default to show that they will be crawled by default.
		if (props["fbCrawlSelections"] != undefined) {
			var crawlList = props["fbCrawlSelections"].split(",");
			for (var i = 0; i < crawlList.length; i++) {
				crawlSelection += "," + localMsg[crawlList[i]];
			}
		}
		$("#crawlEntities", holder).text(crawlSelection);
	}
};



