var sea = sea || {};

sea.dsController = (function() {
	var containerId = sea.containerId;
	// Private methods, start
	var getCreateDataSourceButton = function(dsType, btnTitle, subTypes) {
		var $onClickElm;
		var $returnElm;
		var subTypeKeys = subTypes === undefined ? [] : Object.keys(subTypes);
		if (subTypes === undefined || subTypeKeys.length == 1) {
			var btn = $("<button data-subtype='"+subTypeKeys[0]+"' class='btn btn-primary'/>");
			$(btn).text(btnTitle);
			$returnElm = $onClickElm = $(btn);
		} else {
			var $dropDown = $('<div class="dropdown subTypeMenu"> <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'+
			localMsg.AddNew + '<span class="caret margin-left-5"></span></button></div>');
			var $ul = $('<ul class="dropdown-menu dropdown-menu-right margin-top-2"></ul>');
			$.each(subTypes,function(subType,dispName) {
				$li = $('<li class="noPadding"><a href="javascript:void(0);" data-subtype="'+subType+'">'+dispName+'</a></li>');
								$ul.append($li);
							});
			$dropDown.append($ul);
			$onClickElm = $("li a", $dropDown);
			$returnElm = $dropDown;
		}
		$onClickElm.off("click").on("click", function(event) {
				var reqObj = {};
				var subtype = $(this).data("subtype");
				if(subtype !== "undefined")
					reqObj[sea.constants.HistoryParams.SUBTYPE] = subtype;
				reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.NEW;
				reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
				sea.history.pushState(reqObj, document.title, $.param(reqObj));
						});
		return $returnElm;
	};


	var getViewAllDSButton = function(btnTitle) {
		var btn = $("<button class='btn btn-primary btn-view-all'/>");
		$(btn).text(btnTitle);
		$(btn).click(function() {
							var reqObj = {};
							reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW_ALL;
			sea.history.pushState(reqObj, document.title, $.param(reqObj));
						});
		return btn;
	};
	var goHomePageButton = function(btnTitle) {
		var btn = $("<button class='btn btn-primary'/>");
		$(btn).text(btnTitle);
		$(btn).click(function() {
							var reqObj = {};
							reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.HOME;
			sea.history.pushState(reqObj, document.title, $.param(reqObj));
						});
		return btn;
	};
	var getEditDataSourceButton = function(coreName, dsName, dsId, dsType) {
		var btn = $("<button class='btn btn-primary btn-edit'/>");
		$(btn).text(localMsg.Edit);
		$(btn).click(function() {
			var oDataSourceHandler = DataSourceHandler.factory(dsType);
							var reqObj = {};
							reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
							reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.EDIT;
							reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
							reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
							reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
			sea.history.pushState(reqObj, document.title, $.param(reqObj));
						});
		return btn;
	};

	// checks permissions for data source
	var checkPermissions = function(dsId, cb) {
		sea.services
				.getUserPermissions(
						dsId,
						"datasource",
						function(data) {
							if (data) {
								var permissionList = data.permissionList;
								if (permissionList) {
									// check if view permission is present
									if (permissionList
											.indexOf(sea.constants.Permissions.VIEW) !== -1) {
										cb(true, permissionList);
									} else {
										cvUtil
												.errorToast(localMsg.PermissionDenied);
										cb(false);
									}
								}
							}
						}, null, $(containerId));
	};

	// Disables button according to the permissions
	var disableButtons = function(permissionList) {
		var disabled = true;
		$('.cvToolbarButtonbar :input').prop("disabled", disabled);
		if (permissionList.indexOf(sea.constants.Permissions.EDIT) !== -1) {
			$(".btn-edit").prop("disabled", false);
			// enable crawl and schedule button if user has edit permission
			disabled = false;
			// if user is has delete permission enable Delete button
			if (permissionList.indexOf(sea.constants.Permissions.DELETE) !== -1) {
				$(".btn-delete").prop("disabled", false);
			}
		}
		$('.btn-crawl').prop({"disabled":disabled, "securityDisabled":disabled});// Make use of this additional property as it gets enabled after loading the history table.
		$('.btn-scheduler').prop("disabled", disabled);
	};

	var getDeleteDataSourceButton = function(coreName, dsName, dsId, dsType, appName, canDelete) {
		var btn = $("<button class='btn btn-danger btn-delete'/>");
		var hardDelete = false;
		var confirmModalElm = $("#confirmDelete");
		var onDeleteBtnClickHandler = function(e) {
			var reqData = {};
			reqData.corename = coreName;
			reqData.id = "" + dsId;
			reqData.operationtype = sea.constants.Operations.DELETE;
			reqData.type = dsType;
			reqData.hardDelete = $("#permDeleteChk", container).is(':checked') || hardDelete;
			if (reqData.hardDelete) {
				sea.services.deleteDataSource(reqData, function(resp) {
					confirmModalElm.modal('hide');
					goToListingPageByType(dsType);
					cvUtil.toast(localMsg.DataSourceDeleted);
				}, null, $(containerId));
			} else {
				reqData.deletequery = "*:*";
				sea.services.deleteCrawledData(reqData, function(resp) {
					confirmModalElm.modal('hide');
					cvUtil.toast(localMsg.CrawledDataDeleted);
				}, function(errResp) {
					console.log(errResp);
				}, $(containerId));
			}
		};
		$(btn).text(localMsg.Delete);
		$(btn).click(function() {
			if(canDelete !== undefined && canDelete.toUpperCase() === "FALSE") {
				cvUtil.errorToast(cvFormatters.formatString(localMsg.nonDeletableDS, [ appName ]));
						return;
					}
					if (!dsName) {
						dsName = coreName;
					}
			var msg = cvFormatters.formatString(localMsg.DeleteDataSourceConfMsg, [ dsName ]);
					if (dsType === sea.constants.DSTypes.FEDERATED) {
						confirmModalElm = $("#deleteOnlyDS");
				msg = cvFormatters.formatString(localMsg.DeleteFederatedSearchConfMsg, [ dsName ]);
						hardDelete = true;
					}
					$(".confirmDeleteMsg", confirmModalElm).html(msg);
					$('#crawlDeleteChk').attr('checked', true);
			confirmModalElm.modal('show').find(".modal-dialog").draggable().off("click", ".deleteBtn").on("click",
					".deleteBtn",
					onDeleteBtnClickHandler);
				});
		return btn;
	};

	var deleteCrawledData = function(dsId, deletequery, cb, cancelCb) {
		var confirmModalElm = $("#deleteCrawledData");
		var onDeleteBtnClickHandler = function(e) {
			var reqData = {};
			reqData.id = "" + dsId;
			if (deletequery != null && deletequery != "") {
				reqData.deletequery = deletequery;
			} else {
				reqData.deletequery = "*:*";
			}
			sea.services.deleteCrawledData(reqData, function(resp) {
				cvUtil.toast(localMsg.CrawledDataDeleted);
				cb(true);
			}, function(errResp) {
				cb(false);
			}, $(containerId));
		};
		confirmModalElm.modal('show').find(".modal-dialog").draggable().off("click", ".deleteBtn").on("click",
				".deleteBtn",
				onDeleteBtnClickHandler);

		if (typeof cancelCb === "function") {
			confirmModalElm.off("click", ".cancelBtn").on("click", ".cancelBtn", cancelCb);
		}
	};
	var handleNewDataSource = function(type, id, subtype) {
		var caption = localMsg.NewDataSource;
		var $wrapper = $("<div id='new_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var dsObj = sea.DSTypeConstants.getDSObject(type);
		var captionText = dsObj.dsDispName;
		if(subtype && subtype !== "archiverClient")
			captionText = sea.DSTypeConstants.listOfDS[type]["subTypes"][subtype];
		if (!$.isEmptyObject(dsObj)) {
			caption = cvFormatters.formatString(localMsg.NewDataSourceOfType, [ captionText ]);
		} else {
			throw new SeaException.DataSourceNotFoundException(type);
		}
		var toolBar = new ToolBar("#new_wrapper", sea.constants.DATA_SOURCES + "_new", caption);
		toolBar.addClass("header-toolbar");
		var dsConfigTableElm = null;
		var tableId = sea.constants.DATA_SOURCES + "_newTable";
		var oDataSourceHandler = DataSourceHandler.factory(type);
		if (type != sea.constants.DSTypes.FEDERATED) {
			initWizard(oDataSourceHandler, type, tableId, false, subtype);
		} else {
			dsConfigTableElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.NEW + "_" +
					sea.constants.DATA_SOURCES + "_" + type, "div");
			dsConfigTableElm.attr("id", tableId).appendTo(containerId);
			var holder = $("#" + tableId);
			$(".firstField", holder).focus();

			if (!sea.isUseSeaServer) {
				oDataSourceHandler.getEngines(holder, type, false, function(serverData) {
					oDataSourceHandler.setEngineId(serverData.engineId);

					oDataSourceHandler.initComponents(holder, false, function(serverData) {
						// no action required for new DS case; only needed
						// for edit case
					});
				});
			} else {
				oDataSourceHandler.initComponents(holder, false, function(serverData) {
					// no action required for new DS case; only needed for
					// edit case
				});
			}
			$("#btn_ok", holder).click(function() {
				coreName = $("#coreName", holder).val();
				engineId = $("#dsEngine", holder).val();
				oDataSourceHandler.setCoreName(coreName);

				if (coreName) {
					oDataSourceHandler.create(holder, true);
				} else {
					oDataSourceHandler.create(holder);
				}
			});
			$("#btn_cancel", holder).click(function() {
				sea.homePage.goBack();
			});
		}
	};

	var initWizard = function(oDataSourceHandler, type, tableId, isEdit, subtype, data) {

		dsConfigTableElm = uiControls.util.getTemplate("wizard_" + type, "div");

		$(containerId).cvWizard({
			theme : 1
		});
		var wizard = $(containerId).data("cvWizard");
		var $steps = dsConfigTableElm.find(".form-horizontal[data-step]");
		var config = null;
		for (var i = 1; i <= $steps.length; i++) {
			// the holder DOM will be passed to validateInputsAndGetData from
			// cvWizard.js
			config = {
				id : i,
				form : dsConfigTableElm.find(".form-horizontal[data-step='" + i + "']"),
				alternateForm : dsConfigTableElm.find("#collapsedText [data-step='" + i + "']"),
				validator : function(step, holder, aggregatedInput, callback) {
					oDataSourceHandler.validateStep(step, holder, aggregatedInput, callback, isEdit, data);
				},
				initializer : function(step, holder) {
					oDataSourceHandler.initializeStep(step, holder, isEdit);
				},
				fetcher : function(step, holder) {
					return oDataSourceHandler.fetch(step, holder, isEdit);
				}
			};
			wizard.step(config);
		}

		// Specifying which function to call when the user presses the 'submit'
		// button in the last step
		wizard.setSubmit(function() {
			oDataSourceHandler.submit(isEdit, data, wizard.$formWrapper);
		});

		// What happens when user presses cancel
		wizard.setCancel(sea.homePage.goBack);

		// overwriting the initializer function of the first step
		wizard.addInitializer(1, function() {
							var isAll = false;
							if (isEdit) {
								isAll = true;
							}
			oDataSourceHandler.getEngines(wizard.$formWrapper, type, isAll, function(serverData) {
												if (isEdit && data) {
					oDataSourceHandler.setEngineId(data.engineId);
					$("#dsName", wizard.$formWrapper).attr("disabled", "disabled").val(data.displayName);
					$("#dsEngine", wizard.$formWrapper).attr("disabled", "disabled").val(data.engineId);
												} else if (wizard.aggregatedInput.dsEngine != undefined) {
					oDataSourceHandler.setEngineId(serverData.engineId);
					wizard.$formWrapper.find("#dsEngine").val(wizard.aggregatedInput.dsEngine).trigger("change");
												}
											});
						});

		wizard.draw(1);
		oDataSourceHandler.initComponents(wizard.$formWrapper, isEdit, function(serverData) {
				}, type, subtype);

		wizard.$wrapper.attr("id", tableId);
		if (isEdit) {
			oDataSourceHandler.populateDataSourceProps(data, wizard.$formWrapper, true);
		}
		return wizard;
	};

	var handleEditDataSource = function(type, id, coreName, dsName) {
		var $wrapper = $("<div id='edit_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		// Toolbar with submenu nav
		var headerToolBar = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerToolBar.attr("id", sea.constants.DATA_SOURCES + "_header").appendTo("#edit_wrapper");
		var toolBar = new ToolBar("#edit_wrapper", sea.constants.DATA_SOURCES + "_edit", localMsg.EditDataSource);
		// var dsConfigTableElm = uiControls.util.
		var tableId = sea.constants.DATA_SOURCES + "_editTable";
		// dsConfigTableElm.attr("id", tableId).appendTo(containerId);
		// var holder = $("#" + tableId);

		var oDataSourceHandler = DataSourceHandler.factory(type);
		oDataSourceHandler.setCoreName(coreName);
		if (!sea.isUseSeaServer) {
			oDataSourceHandler.getEngines($(containerId), type, true, function(serverData) {

			});
		}
		sea.services.getDataSource(coreName, id, true, function(dsObj) {
			var $template = $("div[data-templateId=wizard_" + type + "]");
							var holder = null;
							var federatedDsObj = null;
							if (dsObj) {
								$("#dsId", $template).val(id);
								if (!sea.isUseSeaServer) {
					oDataSourceHandler.setEngineId(dsObj.engineId);
									$("#coreName", $template).val(dsObj.coreId);
					$("#clientId", $template).val(dsObj.clientId);
				}
				if (type !== sea.constants.DSTypes.FEDERATED) {
					var subtype = dsObj.properties.datasourceSubType ?  dsObj.properties.datasourceSubType : dsObj.properties.createclient;
					var wizard = initWizard(oDataSourceHandler, type, tableId, true, subtype, dsObj);
				} else {
						
					var dsConfigTableElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX +
							sea.constants.Actions.NEW + "_" + sea.constants.DATA_SOURCES + "_" + type, "div");
					dsConfigTableElm.attr("id", tableId).appendTo(containerId);
									holder = $("#" + tableId);
									$("#dsId", holder).val(id);
					$("#dsName", holder).attr("disabled", "disabled");
					$("#dsEngine", holder).attr("disabled", "disabled");
					$("#btn_ok", holder).click(function() {
						oDataSourceHandler.update(holder, federatedDsObj);
													});
									$("#btn_cancel", holder).click(function() {
										sea.homePage.goBack();
									});
								}
								if (type == sea.constants.DSTypes.FEDERATED) {
									holder = $("#" + tableId);
					oDataSourceHandler.initComponents(holder, true, function(serverData) {
														if (serverData.callBack) {
							sea.services.getFederatedSearch(id, function(data) {
																				federatedDsObj = data;
																				federatedDsObj.datasourceId = dsObj.datasourceId;
																				federatedDsObj.corename = dsObj.coreId;
																				data.displayName = data.federateSearchName;
								oDataSourceHandler.populateDataSourceProps(data, holder, true);
							}, null, holder);
														}
													});
								}
							}
						}, null, $(containerId));
	};
	// private methods, end
	var onNewOrEditDataSource = function(isEdit, type, subtype, id, coreName, dsName) {
		if (!isEdit) {
			handleNewDataSource(type, id, subtype);
		} else {
			handleEditDataSource(type, id, coreName, dsName);
		}
		$(".lookup-details").hide();
	};

	var viewHome = function() {
		var caption = localMsg.Home;
		var showIcon = true;
		var $wrapper = $("<div id='main_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var toolBar = new ToolBar("#main_wrapper", sea.constants.DATA_SOURCES + "_listTB", caption);
		toolBar.addClass("header-toolbar");
		toolBar.addButton(getViewAllDSButton(localMsg.ViewAll));
		// Display information tiles on home page
		var infoTilesElmId = sea.constants.LandingPage.DASHBOARD_INFO_TILES + "Id";
		var infoTilesElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW + "_" +
				sea.constants.LandingPage.DASHBOARD_INFO_TILES, "div");
		infoTilesElm.attr("id", infoTilesElmId).appendTo(containerId);
		// Display all types of data source
		var configTableId = "config_" + dsId;
		var configTableElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW + "_" +
				sea.constants.LandingPage.DASHBOARD, "div");
		configTableElm.attr("id", configTableId).appendTo(containerId);
		sea.analyticsHome.init(function(enableAnalyticsEngineSelection) {
			sea.analyticsHome.getAllAnalyticsEngines(enableAnalyticsEngineSelection, function(status) {
										switch (status) {
				case "done": //this can be exception based too!
											if (sea.showDataConnectors) {
						sea.analyticsHome.getEngineDetailsById("-1", function(serverCallBack) {
																});
											} else {
						var infoTilesId = sea.constants.LandingPage.DASHBOARD_INFO_TILES + "Id";
						sea.analyticsHome.mapDataToDashboardInfoTiles();
						$('.data-connectors-heading', $(containerId)).hide();
						$('.btn-view-all', $(containerId)).hide();
						$('#' + infoTilesId, $(containerId)).hide();
											}
											break;
										case "nodata":
											break;
										case "error":
											break;
										}
									});
				});
	};

	var onViewAllDataSources = function(dsType) {
		var dsListElm = $("<div></div>");
		var $wrapper = $("<div id='main_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		var caption = localMsg.DataSources;
		var showIcon = true;
		var dsObj = sea.DSTypeConstants.getDSObject(dsType);
		var toolBar = new ToolBar("#main_wrapper", sea.constants.DATA_SOURCES + "_listTB", caption);
		toolBar.addClass("header-toolbar");
		toolBar.addButton(goHomePageButton(localMsg.Home));
		// Display information tiles on data source view
		if (dsType !== undefined) {
			type = dsType;
		}
		if (type !== sea.constants.DSTypes.FEDERATED) {
			var infoTilesElmId = sea.constants.LandingPage.DASHBOARD_INFO_TILES + type;
			var infoTilesElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW +
					"_" + sea.constants.LandingPage.DASHBOARD_INFO_TILES, "div");
			infoTilesElm.attr("id", infoTilesElmId).appendTo(containerId);
		}

		if (!$.isEmptyObject(dsObj)) {
			caption = cvFormatters.formatString(localMsg.DataSourcesOfType, [ dsObj.dsDispName ]);
			btnTitle = localMsg.Add + " " + dsObj.dsDispName; // localize
			// showIcon = false;
			toolBar.setTitle(caption);
			var oDataSourceHandler = DataSourceHandler.factory(dsType);
			if (oDataSourceHandler !== undefined) {
				toolBar.addButton(getCreateDataSourceButton(dsType, btnTitle, dsObj.subTypes));
			}
		}
		$(containerId).append(dsListElm);
		var getIcon = function(type) {
			return type + "-tile";
		};
		var initGrid = function() {
			var data = null;

			var SEARCHABLE_CLASS = "searchable"

			var createDataSourceTile = function(model) {
				var dsObj = sea.DSTypeConstants.getDSObject(model.dsType);
				var isSearchOnly = typeof (dsObj) !== "undefined"
						&& typeof (dsObj.searchOnly) !== "undefined"
						&& dsObj.searchOnly;
				var holderElm = $("<div class='itemDiv col-xs-12 col-sm-12 col-md-6 col-lg-4 row-no-padding'><div class='thumbnail crawlStatusDiv'></div></div>");
				var properties = model.properties !== undefined ? model.properties
						: {};
				var canDelete = "true", appName = "DATACUBE";
				$.map(properties, function(property) {
					if (property.propertyName === "candelete") {
						canDelete = property.propertyValue;
					} else if (property.propertyName === "appname") {
						appName = property.propertyValue;
					}
				});
				var detailsElmHtml = "";
				var reqObj = {};
				reqObj[sea.constants.HistoryParams.CORE_NAME] = model.collectionName;
				reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW;
				reqObj[sea.constants.HistoryParams.DS_ID] = model.dsId;
				reqObj[sea.constants.HistoryParams.DS_TYPE] = model.dsType;
				reqObj[sea.constants.HistoryParams.DS_NAME] = model.dsName;
				detailsElmHtml += "<div class='col-xs-10'><div class='cvTileLinkDiv'><a class='group inner list-group-item-heading  "
						+ SEARCHABLE_CLASS
						+ " searchLink'>"
						+ model.dsName + "</a></div></div>";
				if (showIcon) {
					detailsElmHtml += "<div class='col-xs-2 text-right'>";
					detailsElmHtml += "<span class='padding-base-top "
							+ getIcon(model.dsType) + "'></span>";
					detailsElmHtml += "</div>";
				}				
					
				if (model.dsType === sea.constants.DSTypes.FEDERATED) {
					detailsElmHtml += "<div class='col-xs-12 col-sm-12 col-md-12 col-lg-12'>";
					// description div start
					detailsElmHtml += "<div class='cvTileDescDiv'>";

					// docsCount
					detailsElmHtml += "<p class='group inner list-group-item-text'>"
							+ "<span class='cvTileDescLabel'>"
							+ localMsg.NumberOfHandlers
							+ ": </span><span class='cvTileDescValue  "
							+ SEARCHABLE_CLASS
							+ " '>"
							+ cvFormatters.formatNumber(model.handlerCount)
							+ "<span></p>";
					detailsElmHtml += "</div>";
					detailsElmHtml += "<div class='cvTileButtonBar col-xs-12 col-sm-12 col-md-12 col-lg-12'>";
					detailsElmHtml += "<a class='dsLink pull-right'>"
								+ localMsg.Configuration + "</a>";
					detailsElmHtml += "</div></div>";
					detailsElm = $(detailsElmHtml);
					$("a.dsLink", detailsElm).cvHyperlink(reqObj);

				} else {
					detailsElmHtml += "<div class='col-xs-12 col-sm-12 col-md-12 col-lg-12'>";
					// description div start
					detailsElmHtml += "<div class='cvTileDescDiv'>";

					// docsCount
					detailsElmHtml += "<p class='group inner list-group-item-text'>"
							+ "<span class='cvTileDescLabel'>"
							+ localMsg.NumberOfDocs
							+ ": </span><span class='cvTileDescValue  "
							+ SEARCHABLE_CLASS
							+ " '>"
							+ cvFormatters.formatNumber(model.docsCount)
							+ "<span></p>";
					// crawled at
					detailsElmHtml += "<p class='group inner list-group-item-text'><span class='cvTileDescLabel'>"
							+ localMsg.RecentlyCrawledAt
							+ ": </span><span class='cvTileDescValue  "
							+ SEARCHABLE_CLASS
							+ " '>"
							+ cvFormatters.formatFromNow(model.lastCrawledAt)
							+ "</span></p>";
					// crawled status
					detailsElmHtml += "<p class='group inner list-group-item-text'><span class='cvTileDescLabel'>"
							+ localMsg.CrawlStatus
							+ ": </span><span class='cvTileDescValue  "
							+ SEARCHABLE_CLASS
							+ " '>"
							+ sea.CrawlStatesConstants
									.getDispHtmlOfCrawlState(model.crawlStatus)
							+ "</span></p>";
					// description div end
					detailsElmHtml += "</div></div>";
					// button bar
					detailsElmHtml += "<div class='cvTileButtonBar col-xs-12 col-sm-12 col-md-12 col-lg-12'>";
					if (!sea.isUseSeaServer) {
						var analyticsEngine = DataSourceHandler.prototype
								.getHostName(model.cloudId);
						if (analyticsEngine === null) {
							analyticsEngine = localMsg.NotApplicable;
						}

						detailsElmHtml += "<label class='infoLabel pull-left  "
								+ SEARCHABLE_CLASS
								+ " '><span class='cvTileDescLabel'>"
								+ localMsg.AnalyticsEngine + ": </span>"
								+ analyticsEngine + "</label>";
					}
					if (model.dsType !== sea.constants.DSTypes.WEB
							&& model.dsType !== sea.constants.DSTypes.FEDERATED
							&& !isSearchOnly) {
						detailsElmHtml += "<a class='schemaLink pull-right'>"
								+ localMsg.ViewSchema + "</a>";
					}
					if (!isSearchOnly) {
						detailsElmHtml += "<a class='dsLink pull-right'>"
								+ localMsg.Configuration + "</a>";
					}
					detailsElmHtml += "</div>";
					if (canDelete.toUpperCase() === "FALSE") {
						detailsElmHtml += "<span class='red-triangle' title='"
								+ cvFormatters.formatString(
										localMsg.nonDeletableDS, [ appName ])
								+ "'></span>";
					}
					detailsElmHtml += "</div>";
					detailsElm = $(detailsElmHtml);
					$(".crawlStatusDiv", holderElm)
							.addClass(
									sea.CrawlStatesConstants
											.getClassNameByCrawlState(model.crawlStatus));
					if (!isSearchOnly) {
						$("a.dsLink", detailsElm).cvHyperlink(reqObj);
						reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW_SCHEMA;
						$("a.schemaLink", detailsElm).cvHyperlink(reqObj);
					}
					
				}
				reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.REPORT_VIEW;
				reqObj[sea.constants.ReportInputParams.DS_ID] = model.dsId;
				reqObj[sea.constants.ReportInputParams.DS_TYPE] = model.dsType;
				reqObj[sea.constants.HistoryParams.FULL_VIEW] = "1";
				$("a.searchLink", detailsElm).cvHyperlink(reqObj);
				$(".thumbnail", holderElm).append(detailsElm);
				return holderElm;
			};
			var columnDef = [];
			var order = [ [ 0, 'asc' ] ];
			if (dsType !== sea.constants.DSTypes.FEDERATED) {
				columnDef = [ {
					sType : 'date-time',
					targets : [ 2, 3 ]
				} ];
				order = [ [ 2, 'desc' ] ];

			}
			var grid = dsListElm
					.cvDataViewer({
						dom : "<'gridTools panel-heading'<'pull-left'f><'pull-right'<'cvDataViewerSwitch'>><'pull-right'o><'clearfix'>>t<'pull-left'i><'pull-right'p><'clearfix'>",
						serverSide : false,
						ajax : function(data, fn, settings) {
							var toMask = dsListElm;
							if (data.mask == false && data.mask != undefined) {
								toMask = null;
							}

							if (type === sea.constants.DSTypes.FEDERATED) {

								sea.services.getFederatedBasicInfo(function(resp) {
													var data = null;
									if (resp.error || !resp.federatedSearchInfos) {
														data = [];
													} else {
														data = resp.federatedSearchInfos;
										$.each(data, function(i, datasource) {
																			var dsObj = sea.DSTypeConstants
																					.getDSObject(sea.constants.DSTypes.FEDERATED);
																			if (dsObj) {
																				datasource.dsDispName = dsObj.dsDispName;
																			} else {
																				datasource.dsDispName = datasource.dsType;
																			}
																			datasource.collectionName = datasource.dataSourceId;
																			datasource.dsId = datasource.dataSourceId;
																			datasource.dsName = datasource.dataSourceName;
																			datasource.dsType = sea.constants.DSTypes.FEDERATED;
																		});
													}
													fn({
														data : data,
														recordsTotal : data.length
													});
												}, null, toMask);

							} else {
								if (sea.showDataConnectors) {
									sea.services.getEngineDetails(-1, dsType, function(engineDetails) {
										sea.analyticsHome.mapDataToDashboardInfoTiles(engineDetails.typesStats,
																		type,
																		$(containerId));
													});
								} else {
									sea.analyticsHome.mapDataToDashboardInfoTiles();
									cvUtil.errorToast(localMsg.PermissionDenied);
								}
								sea.services.getAllDataSources(dsType, false, function(resp) {
													var data = null;
													if (resp.error) {
														data = [];
													} else {
														data = resp;
														/*
										 * Creating a new property dsDispName on the received data. We should
										 * do sorting based on dsDispName instead of dsType
														 */
										$.each(data, function(i, datasource) {
											var dsObj = sea.DSTypeConstants.getDSObject(datasource.dsType);
																			if (dsObj) {
																				datasource.dsDispName = dsObj.dsDispName;
																			} else {
																				datasource.dsDispName = datasource.dsType;
																			}
																		});
													}
													fn({
														data : data,
														recordsTotal : data.length
													});
												}, null, toMask);
							}

						},
						autoRefresh : true,
						refreshInterval : 60000,
						pageLength : 8,
						paging : true,
						searchableClass : "searchable",
						paginationType : "more",
						pagingOptions : {
							lessButton : true,
							showAllButton : true
						},
						columns : sea.ColumnConfiguration.getDataViewerConfig(dsType),
						columnDefs : columnDef,
						language : {
							search : "Search: "
						},
						dataTableOptions : {
							dom : "<'gridTools  panel-heading'<'pull-left'f><'pull-right'<'cvDataViewerSwitch'>><'pull-right'o><'clearfix'>>t<'pull-left'i><'clearfix'>",
							pagingType : "simple_numbers",
							pageLength : -1,
							order : order,
							drawCallback : function(settings) {

								var handleHistory = function(e) {
									if (e.which && e.which == 1) {
										var qs = $(this).attr('href');

										//We had called cvHyperlink() on these elements before. That will set the href attribute starting with a "?
										// Stripping off that starting ?
										qs = qs.substr(1);
										var reqObj = $.parseParams(qs);
										e.preventDefault();
										sea.history.pushState(reqObj, document.title, qs);
									}
								};

								$(settings.nTable).find("a.dsLink").off("click").on("click", handleHistory);

								$(settings.nTable).find("a.schemaLink").off("click").on("click", handleHistory);

								$(settings.nTable).find("a.searchLink").off("click").on("click", handleHistory);

							},
						},
						fnItemTmpl : createDataSourceTile,
					});
		};

		if (!sea.isUseSeaServer) {
			sea.services.getEngines(true, function() {
				initGrid();
			});
		} else {
			initGrid();
		}
	};

	var attachListnersForDataGrid = function(grid) {
		grid.on("click", ".cvGroupLinkDiv a", function() {
			var val = $(this).data('value');
			grid.trigger("cvDataGridGroupExpand", val);
		});
	};

	var getDataSource = function(coreName, dsId, dsType, dsName, permissionList) {
		sea.services.getDataSource(coreName, dsId, false, function(dsObj) {
							var appName;
							var canDelete;
							if (dsObj.properties) {
								appName = dsObj.properties.appname;
								canDelete = dsObj.properties.candelete;
							}
							// Configuration toolbar
		var oDataSourceHandler = DataSourceHandler.factory(dsType);
		var configToolBar = new ToolBar("#conf_wrapper", sea.constants.DATA_SOURCES + "_config", localMsg.Configuration);
		if(oDataSourceHandler !== undefined)
			configToolBar.addButton(getEditDataSourceButton(coreName, dsName, dsId, dsType));
		configToolBar.addButton(getDeleteDataSourceButton(coreName, dsName, dsId, dsType, appName, canDelete));
							// Display basic properties of the data source
			var configTableElm = uiControls.util.getTemplate(sea.constants.TMPL_PREFIX + sea.constants.Actions.VIEW +
					"_" + sea.constants.DATA_SOURCES + "_" + dsType, "div");

							var configTableId = "config_" + dsId;
			configTableElm.attr("id", configTableId).appendTo("#conf_wrapper");
							var holder = $("#" + configTableId);
			var oDataSourceHandler = DataSourceHandler.factory(dsType);
							if (dsObj.description) {
				$(".dsViewDescription", $("#conf_wrapper")).text(dsObj.description).attr("title",dsObj.description).tooltip();
							}
			if (!sea.isUseSeaServer && oDataSourceHandler !== undefined) {
								oDataSourceHandler.setEngineId(dsObj.engineId);
							}
							if (dsType == sea.constants.DSTypes.FEDERATED) {
								sea.services.getFederatedSearch(dsId, function(resp) {
									//To bypass the check for properties in populateDataSourceProps()
									 var $conf_wrapper = $("#conf_wrapper");
									 resp.properties = {};
									 oDataSourceHandler.populateDataSourceProps(resp, $(containerId));
									 oDataSourceHandler.showFederatedRestAPI(resp,$conf_wrapper);
									}, null, $(containerId));


							} else if (dsType == sea.constants.DSTypes.BLANK) {
				$(containerId).append("<span class='help-block'>" + localMsg.UseSchemaToEdit + "</span>");
							} else {
								if (oDataSourceHandler !== undefined) {
					oDataSourceHandler.populateDataSourceProps(dsObj, holder);
								}
				var dsObjByType = sea.DSTypeConstants.getDSObject(dsType);
				if (dsObjByType.isCrawlable !== false) {
					sea.crawlController.showCrawlScheduleInfo(coreName, dsId, dsType, dsObj.schedule);
					sea.crawlController.showCrawlHistoryInfo(coreName, dsId, dsType);
				}
							}
							// sea.viewController.showAllSearchViews(coreName,
							// dsId);
							disableButtons(permissionList);
			if (permissionList.indexOf(sea.constants.Permissions.SHARE) !== -1) {
				sea.shareFiles.onViewSharingInfo(coreName, dsId, "datasource");
							}
						}, null, $(containerId));

	};

	var onViewDataSource = function(coreName, dsName, dsId, dsType) {
		if (!coreName) {
			console.log("Selected core empty.");
			return;
		}
		var $wrapper = $("<div id='conf_wrapper' class='wrapper_class'></div>");
		$(containerId).append($wrapper);
		// Toolbar with submenu nav
		var headerElm = uiControls.util.getTemplate("tmpl_SubMenuToolbar", "div");
		headerElm.attr("id", sea.constants.DATA_SOURCES + "_dsName").appendTo("#conf_wrapper");

		checkPermissions(dsId, function(canView, permissionList) {
			if (canView) {
				if (!sea.isUseSeaServer) {
					sea.services.getEngines(true, function(serverData) {
						getDataSource(coreName, dsId, dsType, dsName, permissionList);
					});
				} else {
					getDataSource(coreName, dsId, dsType, dsName, permissionList);
				}
			}
		});
	};

	var goToDSConfigPage = function(coreName, dsName, dsId, dsType) {
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.CORE_NAME] = coreName;
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		reqObj[sea.constants.HistoryParams.DS_ID] = dsId;
		reqObj[sea.constants.HistoryParams.DS_NAME] = dsName;
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};

	var goToListingPageByType = function(dsType) {
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.DS_TYPE] = dsType;
		sea.history.pushState(reqObj, document.title, $.param(reqObj));
	};

	// Check if it is required to delete the crawled data
	function checkForDeleteRequirement(data) {
		var oldKey = data.oldKey;
		var newKey = data.newKey;
		var dsId = data.dsId;
		var holder = data.holder;
		var callback = data.callback;
		var errCb = data.errCb;

		if (data.changeType === sea.MiscConstants.deleteCrawledDataChangeType.PRIMARY_KEY) {
			var flag = true;
			if (oldKey != newKey) {
				flag = false;
				var jobId = 0;
				sea.services.getCrawlStatus(dsId, jobId, function(res) {
					if (res && res.status && res.status.totalcount > 0) {
						sea.dsController.deleteCrawledData(dsId, null, function(status) {
									if (status) {
										callback();
									} else if (typeof errCb === "function") {
										errCb();
									}

								}, errCb);
					} else {
						callback();
					}
				}, function(err) {
					if (typeof errCb === "function") {
						errCb(err);
					} else {
						cvUtil.errorToast(err.error.errLogMessage);
					}
				}, holder);
			} else {
				callback();
			}
			return flag;
		} else if (data.changeType === sea.MiscConstants.deleteCrawledDataChangeType.FIELD) {
			var promptModalElm = $("#deleteCrawledData");
			$(".deleteCrawledDataMsg", promptModalElm).text(localMsg.PromptFieldChangeDeleteMsg);
			var jobId = 0;
			sea.services.getCrawlStatus(data.dsId, jobId, function(res) {
				if (res && res.status && res.status.totalcount > 0) {
					sea.dsController.deleteCrawledData(data.dsId, null, function(resp) {
								if (resp === true) {
									callback();
								}
							}, errCb);
				} else {
					callback();
				}
			}, null, holder);
		}
	}
	;

	return {
		handleViewAllDataSource : onViewAllDataSources,
		handleViewDataSource : onViewDataSource,
		handleCreateDataSource : onNewOrEditDataSource,
		handleViewHome : viewHome,
		goToDSConfigPage : goToDSConfigPage,
		deleteCrawledData : deleteCrawledData,
		checkForDeleteRequirement : checkForDeleteRequirement

	};
})();
