$.fn.dataTable.cvVisualizerSingleton = (function(){
	var instance;

	return{
		getInstance: function(settings){
			if(!instance){
				instance = new $.fn.dataTable.cvVisualizer(settings);
				return instance;
			}
			else
				return instance;
		},
		deleteInstance: function(){
			if(instance)
				delete instance;
			instance = null;
		},
		setInstance: function(inst_){
			instance = inst_;
		}
	};
	
})();
initializer = function($table) {
	$table.on('destroy.dt', function(e, settings){
		$.fn.dataTable.cvVisualizerSingleton.deleteInstance();
	});
} 
$.fn.dataTable.cvVisualizer = function(settings){
	var $table = settings.oInstance.dataTable();
	initializer($table);
	var self = this;
	this.metaData = settings.oInit.metaData;
	this.metaDataMap = null;
	this.selectedFields = settings.oInit.selectedFields;
	this.selectedSplits = settings.oInit.selectedSplits;
	this.fieldDataMap = null;
	this.splitvaluesMap = null;
	
	this.mapSplitvalues();
	this.fieldDataMap = {};
	if(this.selectedFields && this.selectedFields.length)
		this.mapFieldData();

	if($.isEmptyObject(this.metaData)){
		console.error("No metadata supplied");
		return;
	}

	this.mapMetaData();
	this.paintSelection($table);

	$table.off("click", "." + this.constants.EXPANDABLE).
	on("click", "." + this.constants.EXPANDABLE, function(e){

		/*We create datatables inside datatables. On a click event, we should get an instance
		of the closes datatable, i.e, the datatable to which the cell immediately belongs*/
		var closestTable = $(this).closest(".dataTable").DataTable();
		var $td = $(this).closest('td');
		var $th = $(this).closest('table').find('th').eq($(this).parent().index());
		var $tr = $(this).closest('tr');
		var row = closestTable.row($tr);
		var cell = closestTable.cell($td);

		var path = self.constructJsonPath($th);

		if(cell.child.isShown())
			cell.child.hide();
		else{
			var $childTable = $("<table class='cvVisualizer-childTable table table-bordered " + $.fn.dataTable.cvVisualizer.prototype.constants.EXPANDED_WRAPPER + "' style='display: none'></table>");
			var cellData = cell.data();
			var childData = cellData;

			/*Datatables expect data as an array. If the cell.data() is a
			single json object, contian it in an array*/
			if(!$.isArray(childData) || isSimpleArray(childData))
				childData = [childData];

			$childTable.DataTable({
				data: childData,
				ordering: false,
				columns: $.fn.dataTable.cvVisualizer.cvGetColumnsFromData(childData)
			});
			cell.child($childTable).show();
			self.paintSelection($childTable);
		}
		e.preventDefault();
		e.stopPropagation();

	});

	$table.off("click", "th").on("click", "th", function(e){
		var $th = $(this).closest('table').find('th').eq($(this).index());
		var $btn = $(this).find(".btn-circular");

		self.makeSelection($btn);
		//So that event won't trigger a click on our expandable buttons
		e.preventDefault();
		e.stopPropagation();
	});
};

$.fn.dataTable.Api.register('cell().child()', function(element){
	if(!element instanceof jQuery)
		element = $(element);

	//No support for multiple datatable instances as of now
	var resultSet = this[0];

	for(var i=0; i<resultSet.length; i++){

		var row = resultSet[i].row;
		var col = resultSet[i].column;
		resultSet[i].element = element;
		var $cell = $(this.cell(row, col).node());
		$cell.append(element);
	}

	return element;
});

$.fn.dataTable.Api.register('cell().child.isShown()', function(){
	var resultSet = this[0];
	var children = [];

	for(var i=0; i<resultSet.length; i++){

		var row = resultSet[i].row;
		var col = resultSet[i].column;
		var $cell = $(this.cell(row, col).node());
		var $table = $("." + $.fn.dataTable.cvVisualizer.prototype.constants.EXPANDED_WRAPPER, $cell);
		if(!$table.is(":visible"))
			return false;
		else
			children.push($table);
	}
	return $(children);
});

$.fn.dataTable.Api.register('cell().child.hide()', function(){
	var resultSet = this[0];
	var children = [];

	for(var i=0; i<resultSet.length; i++){

		var row = resultSet[i].row;
		var col = resultSet[i].column;
		var $cell = $(this.cell(row, col).node());
		$("." + $.fn.dataTable.cvVisualizer.prototype.constants.EXPANDED_WRAPPER, $cell).hide();
	}
});

$.fn.dataTable.Api.register('cell().child.show()', function(){
	var resultSet = this[0];
	var children = [];

	for(var i=0; i<resultSet.length; i++){

		var row = resultSet[i].row;
		var col = resultSet[i].column;
		var $cell = $(this.cell(row, col).node());
		$("." + $.fn.dataTable.cvVisualizer.prototype.constants.EXPANDED_WRAPPER, $cell).show();
	}
});

$.fn.dataTable.Api.register('getMetaData()', function(element){
	return $.fn.dataTable.cvVisualizerSingleton.getInstance().getMetaData();
});

$.fn.dataTable.Api.register('getMetaDataMap()', function(element){
	return $.fn.dataTable.cvVisualizerSingleton.getInstance().getMetaDataMap();
});


$.fn.dataTable.Api.register('getSplitvalues()', function(element){
	return $.fn.dataTable.cvVisualizerSingleton.getInstance().getSplitvalues();
});

$.fn.dataTable.Api.register('cvVisualizer()', function(element){
	//this.settings() returns an array and we do not support mutliple tables as of now
	// return $.fn.dataTable.cvVisualizerSingleton.getInstance(this.settings()[0]);

	/*Create a new instance and store a reference to it in the singleton.
	We are not creating through the singleton because there's no proper way to
	destroy a created instance. For example, if we create a cvVisualizer() and refresh the page,
	the singleton will still have a reference. Hence the next time we initialize cvVisualizer through the 
	singleton it will return the old reference rather than creating a new one. So we 
	are forcing the creation of an instance every time the user call 'cvVisualizer()'.

	We still need the singleton to allow the user to do $dataTableElement.getMetaData().
	See the definition of 'getMetaData' API call to see how the singleton is used.*/

	var instance = new $.fn.dataTable.cvVisualizer(this.settings()[0]);
	$.fn.dataTable.cvVisualizerSingleton.setInstance(instance);
	return instance;
});

$.fn.DataTable.cvVisualizer = $.fn.dataTable.cvVisualizer;
$.fn.DataTable.cvGetColumnsFromData = $.fn.dataTable.cvGetColumnsFromData;


$.fn.dataTable.cvVisualizer.prototype.constants = {
	EXPANDABLE: "cvVisualizer-expandable",
	EXPANDED_CELL: "cvVisualizer-expanded-cell",
	EXPANDED_WRAPPER: "cvVisualizer-expanded-wrapper",
	BTN_CIRCULAR: "btn-circular"
};

//through the dom string 'V'
$.fn.dataTable.ext.feature.push({
	fnInit: function(settings){
		var visualizer = new $.fn.dataTable.cvVisualizer(settings);
	},
	cFeature: 'V'
});


/*
	Not attaching to the cvVisualizer prototype since it is a general helper 
	function and should be availabe even without cvVisualizer initialized

	Input: A sample of the data
	Output: columns parameter to be used with DT initialization
*/


$.fn.dataTable.cvVisualizer.cvGetColumnsFromData = function(data){
	var columns = [];
	var sampleData = null;

	if($.isArray(data) && !isSimpleArray(data))
		/*If data is an array of json objects, then the column headings should
		be the properties in those objects*/
		sampleData = data[0];
	else
		/*If data not an array of object (i.e, it is a simple array),
		then the column headers should be indices of the array. If data
		is not an array at all then the headers should be its properties (keys)*/
		sampleData = data;

	//if sampleData is a simple array
	if($.isArray(sampleData)){
		for(var i=0; i<sampleData.length; i++){
			(function(key){
				columns.push({
					/*Passing a 'true' because we do not want to allow users to
					 deselect a single element in a simple array*/
					title: createTableTitle(i+1, true),
					orderable: false,
					render: function(data){
						return $.fn.dataTable.cvVisualizer.cvGenericRender(data, key);
					}
				});
			})(key);
		}
	}
	/*If data is an array of objects, we assign sampleData as data[0]*/
	else if(typeof sampleData === 'object'){
		for(var key in sampleData){
			if(sampleData.hasOwnProperty(key)){
				(function(key){
					columns.push({
						"title": createTableTitle(key),
						//datatable uses '.' to parse nested data. Escaping them since our keys can actually contain a period
						"data": key.replace(/\./g, "\\."),
						orderable: false,
						"render": function(data){
							if(data == null || data.length === 0)
								return "<span></span>";
							else
								return $.fn.dataTable.cvVisualizer.cvGenericRender(data, key);
						}
					});
				})(key);
			}
		}
	}
	return columns;
};


/*
	Not attaching to the cvVisualizer prototype since it is a general helper 
	function and should be availabe even without cvVisualizer initialized
*/
$.fn.dataTable.cvVisualizer.cvGenericRender = function(data, key){
	var self = this;
	key = cvHtmlEncode(key);
	data = cvHtmlEncode(data);
	var createExpandableObjectEntry = function(key) {
		return "<span class='" + $.fn.dataTable.cvVisualizer.prototype.constants.EXPANDABLE + "'data-key='" + key +
				"'>[object]</span>";
	};
	
	if((typeof data === 'object' || $.isArray(data)) && !$.isEmptyObject(data)){
		return createExpandableObjectEntry(key);
	}
	else if(typeof data === 'object' && $.isEmptyObject(data))
		return "<div>N/A</div>";
	else if(data !== null && data !== undefined)
		return "<div class='cvGenericRender'>" + data + "</div>";
	else
		console.error("data is null or undefined");
}; 

/*
	Determine whether each split value should be included or not
	based on the metaDataMap
*/
$.fn.dataTable.cvVisualizer.prototype.syncSplitvalues = function(){
	var allKeys = Object.keys(this.metaDataMap);
	for(var i=0; i<allKeys.length; i++){
		for(var splitField in this.splitvaluesMap){
			if(this.metaDataMap[allKeys[i]].isSelected == 1 && allKeys[i].indexOf(splitField) != -1)
				this.splitvaluesMap[splitField] = 1;
		}
	}
};

$.fn.dataTable.cvVisualizer.prototype.mapSplitvalues = function(){
	this.splitvaluesMap = {};
	var nameValues = this.metaData.nameValueMaps.nameValues;
	var splitvalues = null;
	for(var i=0; i<nameValues.length; i++){
		if(nameValues[i].name === "jsonArray"){
			splitvalues = nameValues[i].values;
			break;
		}
	}
	
	for(var i=0; i<splitvalues.length; i++){
		/*
			Deselecting all split values by default. 
		*/
		if(this.selectedSplits != undefined && this.selectedSplits.indexOf(splitvalues[i]) == -1)
			this.splitvaluesMap[splitvalues[i]] = 0;
		else
			this.splitvaluesMap[splitvalues[i]] = 1;
	}
};

$.fn.dataTable.cvVisualizer.prototype.mapMetaData = function(){
	this.metaDataMap = {};
	var dynamicInfos = this.metaData.dynamicInfo;
	var jsonPath, fieldName, dataType, isArray;
	var isSelected = 1;

	for(var i=0; i<dynamicInfos.length; i++){
		var nameValues = dynamicInfos[i].nameValues;
		var properties = {};

		for(var j=0; j<nameValues.length; j++){
			var name = nameValues[j].name;
			var value = nameValues[j].value;
			if(name === "fieldName")
				fieldName = value;
			else if(name === "dataType")
				dataType = value;
			else if(name === "jsonPath")
				jsonPath = value;
			else if(name === "isArray")
				isArray = parseInt(value);
		}

		/*If 'selectedFields' option is not passed to datatable,
		we assume that all fields are selected by default.
		If this option is passed, then only those fields that appear in
		that option have the 'isSelected' attribute as 1*/
		if(this.selectedFields){
			if($.isEmptyObject(this.fieldDataMap[jsonPath]))
				isSelected = 0;			
			else
				isSelected = 1;
		}

		this.metaDataMap[jsonPath] = {
			fieldName: fieldName,
			dataType: dataType,
			isArray: isArray,
			isSelected: isSelected,
			jsonPath: jsonPath
		};
	}
};

/*
	Helper function. Converts nameValueMaps json
*/
$.fn.dataTable.cvVisualizer.prototype.mapFieldData = function(){
	
	var jsonPath, fieldName, dataType, isArray;

	for(var i=0; i<this.selectedFields.length; i++){
		var nameValues = this.selectedFields[i];
		for(var j=0; j<nameValues.length; j++){
			var name = nameValues[j].name;
			var value = nameValues[j].value;
			if(name === "fieldName")
				fieldName = value;
			else if(name === "dataType")
				dataType = value;
			else if(name === "jsonPath")
				jsonPath = value;
			else if(name === "isArray")
				isArray = parseInt(value);
		}

		this.fieldDataMap[jsonPath] = {
			fieldName: fieldName,
			dataType: dataType,
			isArray: isArray,
			jsonPath: jsonPath
		};
	}
};


function isSimpleArray(data){
	if(!$.isArray(data))
		return false;

	if(typeof data[0] === 'object')
		return false;
	else
		return true;
}

/*
	Handles user clicks.
*/
$.fn.dataTable.cvVisualizer.prototype.makeSelection = function($btn){
	var index  = $btn.parent("th").index() + 1;
	var self = this;
	var $table = $btn.closest("table");
	var $immediateChildRows = $table.children("tbody").children("tr");
	var $childTables = $immediateChildRows.children("td:nth-child(" + index + ")").find("table");
	var pathInReverse = [];
	var path = "";

	pathInReverse.push($btn.attr("data-key"));

	if($btn.hasClass("true")){
		$btn.removeClass("partial").switchClass("true", "false", 0);
		$("." + this.constants.BTN_CIRCULAR, $childTables).removeClass("partial").switchClass("true", "false", 0);
		var $parentTd =  $btn.parents("td");
		$.each($parentTd, function(i, td){
			var $td = $(td);
			var $parentBtn = $td.closest("table").find("th").eq($td.index()).children("." + self.constants.BTN_CIRCULAR); 
	
			pathInReverse.push($parentBtn.attr("data-key"));

			if(isPartialSelection($parentBtn))
				$parentBtn.removeClass("false").removeClass("true").addClass("partial");
		
			if(hasNoSelections($parentBtn))
				$parentBtn.removeClass("partial").removeClass("true").addClass("false");
		
		});

		path = getPath(pathInReverse);
		this.selectPath(path, 0);

		if(this.splitvaluesMap.hasOwnProperty(path))
			this.splitvaluesMap[path] = 0;
	}
	else{
		$btn.removeClass("partial").switchClass("false", "true", 0);
		$("." + this.constants.BTN_CIRCULAR, $childTables).removeClass("partial").switchClass("false", "true", 0);

		var $parentTd =  $btn.parents("td");
		$.each($parentTd, function(i, td){
			var $td = $(td);
			var $parentBtn = $td.closest("table").find("th").eq($td.index()).children("." + self.constants.BTN_CIRCULAR); 

			pathInReverse.push($parentBtn.attr("data-key"));

			if(!$parentBtn.hasClass("true")){
				if(isPartialSelection($parentBtn))
					$parentBtn.removeClass("false").addClass("partial");
				else
					$parentBtn.switchClass("false", "true", 0).removeClass("partial");
			}
		});

		path = getPath(pathInReverse);
		this.selectPath(path, 1);
		if(this.splitvaluesMap.hasOwnProperty(path))
			this.splitvaluesMap[path] = 1;
	}
};

/*
	Translates the UI selection/deselection of a column to internal data structures.
*/
$.fn.dataTable.cvVisualizer.prototype.selectPath = function(path, isSelected){
	var allKeys = Object.keys(this.metaDataMap);
	var re = new RegExp("^" + encodePath(path) + "(/|$)");
	for (var i = 0; i < allKeys.length; i++) {
		if (allKeys[i].search(re) != -1)
			this.metaDataMap[allKeys[i]].isSelected = isSelected;
	}

	/*Reflecting the user's selection on the UI in this.fieldDataMap so that checkSelection will
	return the latest selection info rather than the one stored in fieldDataMap*/

	if(this.selectedFields){
		allKeys = Object.keys(this.fieldDataMap);
		for(var i=0; i<allKeys.length; i++){
			if(allKeys[i].search(re) != -1)
				delete this.fieldDataMap[allKeys[i]];
		}
	}

	/*If user clicked on a split value header directly, selecting/deselecting it*/
	var allSplitKeys = Object.keys(this.splitvaluesMap);
	for(var i=0; i<allSplitKeys.length; i++){
		if(allSplitKeys[i].search(re) != -1){
			this.splitvaluesMap[allSplitKeys[i]] = isSelected;
		}
	}

};

/*
	Checks if a jsonPath is selected or not based on this.fieldDataMap.

	this.fieldDataMap is created from this.selectedFields option which is
	passed to datatables.
	If descendants of a jsonPath are
		completely unselected : return -1
		partially selected : return 0
		completely selected: return 1
*/
$.fn.dataTable.cvVisualizer.prototype.checkSelection = function(jsonPath){
	if(!this.fieldDataMap)
		return;

	var allKeys = Object.keys(this.metaDataMap);
	var allSplitKeys = Object.keys(this.splitvaluesMap);
	var descendants = [];
	var re = new RegExp("^" + encodePath(jsonPath) + "/");
	var unselectedCount = 0;

	for(var i=0; i<allKeys.length; i++){
		if(allKeys[i].search(re) != -1){
			descendants.push(allKeys[i]);
			if(!this.fieldDataMap[allKeys[i]])
				unselectedCount++;
		}
	}

	var splitRe = new RegExp("^" + encodePath(jsonPath) + "(/|$)");
	for(var i=0; i<allSplitKeys.length; i++){
		if(allSplitKeys[i].search(splitRe) != -1){
			descendants.push(allSplitKeys[i]);
			if(!this.splitvaluesMap[allSplitKeys[i]])
				unselectedCount++;
		}
	}

	if(unselectedCount == descendants.length){
		/*
			This can happen in case of empty arrays.
			Eg: Let A/B/C be a jsonPath. A is an object, B is an Object, and C is an array of objects.
			But in the preview, C does not have any data - C is empty.
			This means that metaData.dynamicInfos (and hence the metaDataMap too) will not have any entries that
			contain the path 'A/B/C' because C is not a leaf node and C does not have any children - only paths
			to leaf nodes are present in metaData.dynamicInfos.
			So in that case, a call to checkSelection() should look at this.splitValuesMap to see if the 
			corresponding non-leaf empty node 'C' is selected or not
		*/
		// if(descendants.length === 0){
		// 	if(this.splitvaluesMap[jsonPath] == 1){

		// 	}
		// }
		return -1;
	}
	else if(unselectedCount > 0)
		return 0;
	else if(!unselectedCount)
		return 1;
};


/*
	When an object is expanded to a table of its own, this function is called
	to determine whether a column should be selected or not
*/
$.fn.dataTable.cvVisualizer.prototype.paintSelection = function($table){
	var $headers = $("th", $table.children("thead"));
	var self = this;
	var selectionStatus;
	var $parentTd = $table.closest("td");
	var $parentBtn = null;

	if($parentTd.length)
		$parentBtn = $parentTd.closest("table").find("th").eq($parentTd.index()).children("." + this.constants.BTN_CIRCULAR);

	/*
		So that in case of edit, splitValuesMap will know which split values should be painted.
		This step is required because in mapSplitValues() we are deselecting all split values by default
	*/
	this.syncSplitvalues();

	$.each($headers, function(i, th){
		var $th = $(th);
		var jsonPath = self.constructJsonPath($th);
		var $btn = $("." + self.constants.BTN_CIRCULAR, $th);


		/*
			Use case:

			selectedFields option is passed to datatables
			Assume A->B->C is the column heirarchy
			'selectedFields' option indicates that 'C' is selected
			That means A and B and C are fully selected (because B is the only child
			A and C is the only child of B).

			Suppose the user expanded A, B has the green circle indicating it's selected.
			User clicks B to 'deselect' it.
			Even though C is not expanded yet, C has to be seen as 'deselected' when
			the user expands it because the user explicitly deselected C's parent B.

			How do we do that?

			If self.selectedFields is null, then it means there is no 'previous' selection. 
			In this case if the parent of a column is selected, that means it's children too
			should be shown as selected when we expand them.

			If self.selectedFields is not null, then we use checkSelection() to see whether
			a column should be displayed as selected.

			The funtion selectPath() that is eventually invoked when user performs a click 
			makes sure that this.fieldDataMap is updated to reflect the user's UI interactions.
		*/

		if(self.selectedFields){
			if(self.fieldDataMap[jsonPath]){
				$btn.addClass("true");
			}
			else{
				selectionStatus = self.checkSelection(jsonPath);
				if(selectionStatus == -1){
					/*If checkSelection() says this button is not selected, then its
					parent header button will either be unselected or partially selected. If not,
					that means the parent button was selected by the user from the UI. Hence, that 
					selection must be reflected on $btn*/
					if($parentBtn){
						if($parentBtn.hasClass("true"))
							$btn.addClass("true");
						else
							$btn.addClass("false");
					}
					else
						$btn.addClass("false");

				}
				else if(selectionStatus === 0)
					$btn.addClass("partial");
				else if(selectionStatus === 1)
					$btn.addClass("true");
			}
		}
		else{
			/*No 'selectedFields' option has been passed to datatables. So decide whether a header
			is selected or not based on whether it's parent header is selected or not*/
			if($parentBtn){
				if($parentBtn.hasClass("true"))
					$btn.addClass("true");
				else
					$btn.addClass("false");
			}
			else
				//select by default
				$btn.addClass("true");
		}
	});
};

$.fn.dataTable.cvVisualizer.prototype.getSplitvalues = function(){
	var split = [];

	this.syncSplitvalues();
	for(var value in this.splitvaluesMap){
		if(this.splitvaluesMap[value] == 1)
			split.push(value);
	}

	return split;
};

$.fn.dataTable.cvVisualizer.prototype.getMetaData = function(){
	var dynamicInfos = [];
	for(var jsonPath in this.metaDataMap){
		if(this.metaDataMap.hasOwnProperty(jsonPath)){
			var nameValue = this.metaDataMap[jsonPath];
			if(nameValue.isSelected == 1){
				dynamicInfos.push({
					nameValues: [{
						name: "fieldName",
						value: nameValue.fieldName
					},
					{
						name: "dataType",
						value: nameValue.dataType
					},
					{
						name: "jsonPath",
						value: nameValue.jsonPath
					},
					{
						name: "isArray",
						value: nameValue.isArray
					}]
				});
			}
		}
	}

	var  metaData = $.extend({}, this.metaData);
	metaData.dynamicInfo = dynamicInfos;
	return metaData;
};

$.fn.dataTable.cvVisualizer.prototype.getMetaDataMap = function(){
		return this.metaDataMap;
}

$.fn.dataTable.cvVisualizer.prototype.constructJsonPath = function($th){

	var $parentTable = $th.closest("table");
	var $parentTd = $parentTable.parent();
	$parentTh = $parentTd.closest("table").find("th").eq($parentTd.index());
	if(!$parentTh.length)
		return "/" + $th.children("." + this.constants.BTN_CIRCULAR).attr("data-key");
	return this.constructJsonPath($parentTh) + "/" + $th.children("." + this.constants.BTN_CIRCULAR).attr("data-key");
};

function getPath(pathInReverse){
	var path = "";
	for(var i=pathInReverse.length-1; i>=0; i--){
		path += "/" + pathInReverse[i];
	}

	return path;
}

function isPartialSelection($btn){
	var $th = $btn.parent();
	var index = $th.index() + 1;
	var $table = $th.closest("table");
	var $cellsInColumn = $table.children("tbody").children("tr").children("td:nth-child(" + index + ")");
	var $deselectedCells = $("." + $.fn.dataTable.cvVisualizer.prototype.constants.BTN_CIRCULAR + ".false", $cellsInColumn);


	/*If there is at least a single header that is deselected among
	the descendants of the current header, then we can say that the current
	header is only partially selected*/

	if($deselectedCells.length > 0)
		return true;
	else
		return false;

}

/*Returns true if none of the child headers of a header ($btn) are selected*/
function hasNoSelections($btn){
	var $th = $btn.parent();
	var index = $th.index() + 1;
	var $table = $th.closest("table");
	var $cellsInColumn = $table.children("tbody").children("tr").children("td:nth-child(" + index + ")");
	var $selectedCells = $("." + $.fn.dataTable.cvVisualizer.prototype.constants.BTN_CIRCULAR + ".true", $cellsInColumn);


	/*If there is at least a single header that is deselected among
	the descendants of the current header, then we can say that the current
	header is only partially selected*/

	if($selectedCells.length > 0)
		return false;
	else
		return true;
}

function createTableTitle(title, disableButton) {
	title = cvHtmlEncode(title);
	if (disableButton) {
		return "<span>" + title + "</span>";
	} else {
		return "<span>" + title + "</span><span data-key='" + title + "' class='glyphicon glyphicon-ok " +
				$.fn.dataTable.cvVisualizer.prototype.constants.BTN_CIRCULAR + "'></span>";
	}
}

function cvHtmlEncode(data) {
	return typeof data === 'string' ? data.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;') : data;
}

function encodePath(path) {
	return path.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
}