var sea = sea || {};
sea.crawlController = (function() {
	var containerId = sea.containerId;
	var crawlHistoryDTConfig = {
		// "dom" : '<"pull-left"f><"pull-right"l>t<"pull-left"i>p',
		"dom" : 'Jt',
		"pageLength" : 15,
		"lengthMenu" : [ [ 15, 25, 50, -1 ], [ 15, 25, 50, "All" ] ],
		"order" : []
	};
	var pollMap = {};
	var pollInterval = 10000; // 10 secs
	var showCrawlPrompt = function(dsId, msg) {
		var promptModalElm = $("#promptCrawl");
		$(".promptCrawlMsg", promptModalElm).text(msg);
		var crawlModal = promptModalElm.modal('show').find(".modal-dialog").draggable();
		crawlModal.off("click", ".yesBtn").on("click",
				".yesBtn",
				function(e) {
					sea.services.crawl(dsId, sea.constants.Actions.START_CRAWL, function(resp) {
						cvUtil.toast(cvFormatters.formatString(localMsg.CrawlRequestSubmitted, [ sea.crawlController
								.getCrawlStatusDispText(resp) ]));
						sea.homePage.goToConfigPage();
					}, function(errResp, msg) {
						alert(localMsg.CrawlRequestSubmitFailed);
					});
				});
		crawlModal.off("click", "#notNowBtn").on("click", "#notNowBtn", function(e) {
			sea.homePage.goToConfigPage();
		});
	};
	var populateMinList = function(selector, parent) {
		var selElm = $(selector, parent);
		for (i = 0; i < 60; i += 5) {
			var opt = $("<option/>");
			opt.attr("value", i).text(sea.util.prependZeroForSingleDigit(i));
			if (i == 0) {
				$(selector + "[data-allow-zero='true']", parent).append(opt);
			} else {
				selElm.append(opt);
			}
		}
	};
	var populateHourList = function(selector, parent) {
		var selElm = $(selector, parent);
		for (i = 0; i < 24; i++) {
			var opt = $("<option/>");
			opt.attr("value", i).text(sea.util.prependZeroForSingleDigit(i));
			selElm.append(opt);
		}
	};
	var populateDayList = function(selector, parent) {
		var selElm = $(selector, parent);
		$(sea.ScheduleConstants.repeatDayObjects).each(function(i, e) {
			var opt = $("<option/>");
			opt.attr("value", e.value).text(e.dispVal);
			selElm.append(opt);
		});
	};
	var normalizeScheduleInfo = function(schInfo) {
		schInfo.repeatUnits = typeof (schInfo.repeatUnits) !== "undefined" ? schInfo.repeatUnits : schInfo.repeatUnit;
		schInfo.minutes = typeof (schInfo.minutes) !== "undefined" ? schInfo.minutes : schInfo.minute;// TODO: change once WS and SEA uses same
		// key
		schInfo.isActive = typeof (schInfo.isActive) !== "undefined" ? schInfo.isActive : schInfo.active; // TODO: change once WS and SEA uses same
		// key
		return schInfo;
	};
	var getScheduleButton = function(coreName, dsId, dsType, schInfo, schInfoContainerId) {
		if (schInfoContainerId && schInfoContainerId.charAt(0) !== '#') {
			schInfoContainerId = "#" + schInfoContainerId;
		}

		var btn = $("<button class='btn btn-primary btn-scheduler'/>");
		var schTitle = localMsg.Schedule;
		var schAction = "new";
		if (schInfo != null) {
			schTitle = localMsg.EditSchedule;
			schAction = "edit";
		}
		$(btn).text(schTitle);

		var prePopulateEntries = function() {
			schInfo = normalizeScheduleInfo(schInfo); // TODO: remove this
			// logic once WS and SEA
			// uses same key
			var container = $(schInfoContainerId);
			var optId = "#sch" + schInfo.repeatUnits;
			$(".schOption " + optId, container).click();
			$(".schOption #isActive", container).attr("checked", schInfo.isActive);
			var schDivId = optId + "Div";
			var schElm = $(schDivId);
			$(".minList", schElm).val(schInfo.minutes);
			if (schInfo.repeatUnits == sea.ScheduleConstants.repeatUnits.daily) {
				$(".hrList", schElm).val(schInfo.hour);
			} else if (schInfo.repeatUnits == sea.ScheduleConstants.repeatUnits.weekly) {
				$(".hrList", schElm).val(schInfo.hour);
				$(".dayList", schElm).val(schInfo.day);
			}
		};
		var saveBtnHandler = function(e) {
			btn.addClass("btn-primary");
			var $selElm = $("input[name=schOptions]:radio:checked", container);
			var repeat = $selElm.val();
			var selDiv = $("#" + $selElm.attr("id") + "Div");
			var min = $(".minList", selDiv).val();
			var hr = $(".hrList", selDiv).val();
			var day = $(".dayList", selDiv).val();
			var isActive = $("#isActive", container).is(":checked");

			var reqObj = {};
			reqObj.corename = coreName;
			reqObj.dsId = "" + dsId;
			var schDetails = {};
			schDetails.repeatUnits = repeat;
			schDetails.repeat_unit = repeat
			schDetails.active = isActive;
			schDetails.isActive = isActive;
			schDetails.minutes = min;
			schDetails.minute = min;
			if (repeat == sea.ScheduleConstants.repeatUnits.daily && hr) {
				schDetails.hour = hr;
			} else if (repeat == sea.ScheduleConstants.repeatUnits.weekly && hr && day) {
				schDetails.hour = hr;
				schDetails.day = day;
			}
			reqObj.schedule = schDetails;
			sea.services.scheduleDataSource(reqObj, function(data) {
				schInfo = data.schedule;
				if (schInfo != null) {
					schTitle = localMsg.EditSchedule;
					schAction = "edit";
				}
				$(btn).text(schTitle);
				showScheduleInfo(schInfo, schInfoContainerId);
			}, null, container);
		};
		var schBtnClickHandler = function(e) {
			var schDiv = uiControls.util.getTemplate("tmpl_new_schedule", "div");
			var container = $(schInfoContainerId);
			container.empty().append(schDiv);
			btn.removeClass("btn-primary");
			$("#btnSchSave", container).addClass("btn-primary").click(saveBtnHandler);
			$("#btnSchCancel", container).click(function() {
				btn.addClass("btn-primary");
				showScheduleInfo(schInfo, schInfoContainerId);
			});
			$(".schOption input[type=radio]", container).click(function() {
				var divId = "#" + $(this).attr("id") + "Div";
				$(".schOptionsDiv").hide();
				$(divId).show();
			});
			if (schAction == "edit") {
				prePopulateEntries();
			} else {
				$(".schOption:first-child input[type=radio]", container).click();
			}
		}
		$(btn).click(schBtnClickHandler);
		return btn;
	};
	showScheduleInfo = function(schInfo, schInfoContainerId) {
		var schDiv = uiControls.util.getTemplate("tmpl_view_schedule", "div");
		if (schInfoContainerId && schInfoContainerId.charAt(0) !== '#') {
			schInfoContainerId = "#" + schInfoContainerId;
		}
		$(schInfoContainerId).empty().append(schDiv);
		var dispText = "";
		if (schInfo != null) {
			// TODO: remove normalize logic once WS and SEA uses same key
			schInfo = normalizeScheduleInfo(schInfo);
			var repeat = schInfo.repeatUnits;
			if (repeat == sea.ScheduleConstants.repeatUnits.minute) {
				dispText = cvFormatters.formatString(localMsg.SchCrawlMins, [ sea.util
						.prependZeroForSingleDigit(schInfo.minutes) ])
			}
			if (repeat == sea.ScheduleConstants.repeatUnits.hourly) {
				dispText = cvFormatters.formatString(localMsg.SchCrawlHourly, [ sea.util
						.prependZeroForSingleDigit(schInfo.minutes) ])
			} else if (repeat == sea.ScheduleConstants.repeatUnits.daily) {
				dispText = cvFormatters.formatString(localMsg.SchCrawlDaily, [
						sea.util.prependZeroForSingleDigit(schInfo.hour),
						sea.util.prependZeroForSingleDigit(schInfo.minutes) ]);
			} else if (repeat == sea.ScheduleConstants.repeatUnits.weekly) {
				dispText = cvFormatters.formatString(localMsg.SchCrawlWeekly, [
						sea.util.prependZeroForSingleDigit(schInfo.hour),
						sea.util.prependZeroForSingleDigit(schInfo.minutes),
						sea.ScheduleConstants.getDisplayValueOfRepeatDay(schInfo.day) ]);
			}
			$("#schInfo", schDiv).html(dispText);
			if (!schInfo.isActive) {
				var warnText = localMsg.ScheduleWarnTxt;
				$("#schActiveStatus", schDiv).html(warnText);
			}
		}
	};
	var onInit = function() {
		// invoked from homepage init, one time
		var parent = $("#schForm");
		populateMinList(".minList", parent);
		populateHourList(".hrList", parent);
		populateDayList(".dayList", parent);
	};
	var clearAllTimers = function() {
		if (!$.isEmptyObject(pollMap)) {
			$.each(pollMap, function(i, obj) {
				clearInterval(pollMap[i]);
			});
		}
		pollMap = {};
	};
	var onViewCrawlScheduleInfo = function(coreName, dsId, dsType, schInfo) {
		// Crawl Schedule toolbar
		var idPrefix = coreName + "_crawlSchedule";
		var schContainerId = idPrefix + "_container";
		var schToolBar = new ToolBar("#conf_wrapper", idPrefix + "_toolbar", localMsg.CrawlSchedule);
		var schBtn = getScheduleButton(coreName, dsId, dsType, schInfo, schContainerId);
		schToolBar.addButton(schBtn);
		$("<div id='" + schContainerId + "'></div>").appendTo("#conf_wrapper");
		showScheduleInfo(schInfo, schContainerId);
	};

	var getCrawlButton = function(action, dsId, dsType, crawlHistTable) {
		var startCap = localMsg.StartCrawl;
		var stopCap = localMsg.StopCrawl;
		var title = "";
		var btn = $("<button class='btn btn-primary btn-crawl' disabled='disabled'/>");
		if (action == sea.constants.Actions.START_CRAWL) {
			title = startCap;
		} else {
			title = stopCap;
		}
		$(btn).attr("action", action);
		$(btn).text(title);
		$(btn).click(function() {
			var action = $(this).attr("action");
			var btnObj = $(this);
			btnObj.attr("disabled", "disabled");
			if (action == sea.constants.Actions.START_CRAWL) {
				sea.services.crawl(dsId, sea.constants.Actions.START_CRAWL, function(resp) {
					btnObj.removeAttr("disabled");
					updateCrawlHistoryTable(dsId, btn, crawlHistTable, resp, true);
					updateButtonAction(btnObj, resp);
				}, function(errResp, msg) {
					alert(msg);
					btnObj.removeAttr("disabled");
				});
			} else {
				sea.services.crawl(dsId, sea.constants.Actions.STOP_CRAWL, function(resp) {
					btnObj.removeAttr("disabled");
					updateCrawlHistoryTable(dsId, btn, crawlHistTable, resp, false);
					updateButtonAction(btnObj, resp);
					// polling is required to get the count,
					// discuss and decide if we need to kill the
					// time on stopCrawl
				}, function(errResp, msg) {
					alert(msg);
					btnObj.removeAttr("disabled");
				});
			}

		});
		return btn;
	};
	var getNormalizedCrawlStatus = function(resp) {
		var crawlStatus = resp.crawlState;// for SEA
		if (resp.status) {
			crawlStatus = resp.status.state;
		}

		return crawlStatus;
	};
	var getCrawlStatusDispText = function(resp) {
		return sea.CrawlStatesConstants.getDispTextForCrawlState(getNormalizedCrawlStatus(resp));
	}
	var updateButtonAction = function(btn, resp) {
		var action = sea.constants.Actions.START_CRAWL;
		var title = localMsg.StartCrawl;
		if ($.inArray(getNormalizedCrawlStatus(resp), sea.CrawlStatesConstants.statesToStopCrawl) > -1) {
			action = sea.constants.Actions.STOP_CRAWL;
			title = localMsg.StopCrawl;
		}
		btn.attr("action", action).text(title);
	};

	var startPollForCrawlStatus = function(dsId,jobId,pollCallback) {
		if (!pollMap[dsId]) {
			pollMap[dsId] = setInterval(function() {
				sea.services.getCrawlStatus(dsId, jobId, function(resp) {
					if ($.inArray(getNormalizedCrawlStatus(resp), sea.CrawlStatesConstants.statesToStopPoll) > -1) {
						clearInterval(pollMap[dsId]);
						delete pollMap[dsId];
					}
					pollCallback(resp);
				});

			}, pollInterval);
		}
	};
	function enableCrawlBtn() {
		var $container = $(containerId);
		var $crawlBtn = $(".btn-crawl", $container);
		if ($crawlBtn.prop('securityDisabled') === false) {
			$crawlBtn.removeAttr("disabled");
		}
	}
	var getCrawlHistoryPromise = function(dsId) {
		var deferred = $.Deferred();
		sea.services.getCrawlHistory(dsId, function(resp) {
			deferred.resolve(resp);
		},function(errResp, msg) {
			alert(msg);
			enableCrawlBtn();
		});
		return deferred.promise();
	};
	var getCrawlStatusPromise = function(dsId) {
		var deferred = $.Deferred();
		var jobId = 0;
		sea.services.getCrawlStatus(dsId, jobId, function(resp) {
			deferred.resolve(resp);
		},function(errResp, msg) {
			alert(msg);
			enableCrawlBtn();
		});
		return deferred.promise();
	};
	var loadCrawlHistory = function(dsId, dsType, btnObj, crawlHistTable) {
		// make asynchronous calls to get history and current crawl status
		var combinedPromise = $.when(getCrawlHistoryPromise(dsId), getCrawlStatusPromise(dsId));
		combinedPromise
				.done(function(historyResp, currentStatusResp) {
					var historyData = [];
					if (!$.isEmptyObject(historyResp)) {
						if (!$.isEmptyObject(historyResp.status)) {
							historyData = historyResp.status;
						} else if ($.isArray(historyResp)) {
							historyData = historyResp;
						}
					}
					crawlHistTable.clear().rows.add(historyData).draw();
					if (!$.isEmptyObject(currentStatusResp) && !$.isEmptyObject(currentStatusResp.status)) {
							updateCrawlHistoryTable(dsId, btnObj, crawlHistTable, currentStatusResp, true);
							updateButtonAction(btnObj, currentStatusResp);

					}
					enableCrawlBtn();
				});
	};

	function doStatusStartPollIfRequired(dsId, jobId, state, btnObj, crawlHistTable) {
		if($.inArray(state,
                        sea.CrawlStatesConstants.statesToStopPoll) === -1) {
			startPollForCrawlStatus(dsId, jobId, function(resp) {
				updateCrawlHistoryTable(dsId, btnObj, crawlHistTable, resp, false);
				updateButtonAction(btnObj, resp);
			});
	  }
	}
	
	var updateCrawlHistoryTable = function(dsId, btnObj, crawlHistTable, currentStatusData, isPrepend) {
		if (currentStatusData && currentStatusData.status) {
			currentStatusData = currentStatusData.status;
		}
		var historyData = crawlHistTable.data();
		var jobId = currentStatusData.jobId ? currentStatusData.jobId : 0;
		if (typeof isPrepend !== "undefined" && isPrepend && !pollMap[dsId] &&
			(!historyData[0] || (historyData[0] && historyData[0].startUTCTime !== currentStatusData.startUTCTime))) {						
			// insert the current status at 0 only if not empty status response
			if(currentStatusData.state && currentStatusData.state !== "IDLE") { //we get IDLE state only when there are no crawl ran at all so this check is to avoid unnecessarily adding idle state entry. 
				historyData.splice(0, 0, currentStatusData);
				crawlHistTable.clear().rows.add(historyData).draw();
				doStatusStartPollIfRequired(dsId, jobId, currentStatusData.state, btnObj, crawlHistTable);				
		    }
		} else {
			crawlHistTable.row(0).data(currentStatusData).draw();
			doStatusStartPollIfRequired(dsId, jobId, currentStatusData.state, btnObj, crawlHistTable);		
		}
	};
	var onViewCrawlHistoryInfo = function(coreName, dsId, dsType) {
		// Crawl History toolbar
		var idPrefix = coreName + "_crawlHistory";
		var crawlHistContainerId = idPrefix + "_container";
		var crawlHistTableId = idPrefix + "_DT";
		var crawlHistToolBar = new ToolBar("#conf_wrapper", idPrefix + "_toolbar", localMsg.CrawlHistory);
		$("<div id='" + crawlHistContainerId + "'></div>").appendTo("#conf_wrapper");
		$(uiControls.util.getDataTableHtml(crawlHistTableId, sea.ColumnConfiguration.crawlHistoryConfig)).appendTo("#" +
				crawlHistContainerId);
		var config = $.extend({}, crawlHistoryDTConfig);
		config.data = [];

		// hide "Access denied" column for database data source crawl history
		var columnConfig = $.extend(true, {}, sea.ColumnConfiguration.crawlHistoryConfig);

		$.each(columnConfig, function(i, v) {
			if (v.fieldName === "numAccessDenied" && dsType !== sea.constants.DSTypes.WEB) {
				v.visible = false;
			}
			if (v.fieldName == "jobId" && dsType !== sea.constants.DSTypes.FS) {
				v.visible = false;
			}
		});

		config.columns = sea.ColumnConfiguration.getConfigInDTFormat(columnConfig);
		//Time taken column is sort based on hiddenTimeTaken column, which is of course hidden
		config.columnDefs = [ {
			targets : [ 3 ],
			iDataSort : 7
		}, {
			sType : 'date-time',
			targets : [ 1, 2 ]
		} ];

		var crawlHistTable = $("#" + crawlHistTableId).DataTable(config);
		var crawlHistBtn = getCrawlButton(sea.constants.Actions.START_CRAWL, dsId, dsType, crawlHistTable);
		crawlHistToolBar.addButton(crawlHistBtn);
		loadCrawlHistory(dsId, dsType, crawlHistBtn, crawlHistTable);
		$("#" + crawlHistTableId).on('remove', function(e, settings) {
			clearAllTimers();
		});

	};
	return {
		init : onInit,
		showCrawlScheduleInfo : onViewCrawlScheduleInfo,
		showCrawlHistoryInfo : onViewCrawlHistoryInfo,
		getCrawlStatusDispText : getCrawlStatusDispText,
		showCrawlPrompt : showCrawlPrompt
	};
})();